/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.ReentrantMutex;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConnection;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsMessageReference;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsSession;
import com.ibm.msg.client.jms.JmsTopic;
import com.ibm.msg.client.jms.admin.JmsDestinationImpl;
import com.ibm.msg.client.jms.internal.JmsBytesMessageImpl;
import com.ibm.msg.client.jms.internal.JmsConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsDestinationImplProxy;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsMapMessageImpl;
import com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsMessageProducerImpl;
import com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl;
import com.ibm.msg.client.jms.internal.JmsObjectMessageImpl;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl;
import com.ibm.msg.client.jms.internal.JmsQueueReceiverImpl;
import com.ibm.msg.client.jms.internal.JmsQueueSenderImpl;
import com.ibm.msg.client.jms.internal.JmsStreamMessageImpl;
import com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl;
import com.ibm.msg.client.jms.internal.JmsTemporaryTopicImpl;
import com.ibm.msg.client.jms.internal.JmsTextMessageImpl;
import com.ibm.msg.client.jms.internal.JmsTopicPublisherImpl;
import com.ibm.msg.client.jms.internal.JmsTopicSubscriberImpl;
import com.ibm.msg.client.jms.internal.State;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderFactoryFactory;
import com.ibm.msg.client.provider.ProviderJmsFactory;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.provider.ProviderMessageFactory;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.provider.ProviderMessageReference;
import com.ibm.msg.client.provider.ProviderQueueBrowser;
import com.ibm.msg.client.provider.ProviderSession;
import com.ibm.msg.client.provider.ProviderXASession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XAQueueSession;
import javax.jms.XATopicSession;

public class JmsSessionImpl
extends JmsPropertyContextImpl
implements JmsSession {
    private static final long serialVersionUID = -270784834968901154L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsSessionImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.99.2.23 12/12/13 15:30:34";
    private boolean transacted;
    private boolean clearUpProviderXASession = false;
    private int acknowledgeMode;
    private ProviderSession providerSession;
    private JmsConnectionImpl connection;
    private MessageListener messageListener;
    private ProviderFactoryFactory providerFactory;
    private String connectionTypeName;
    private int uncommittedReceiveCount = 0;
    private final int dupsCommitThreshold;
    private State state = new State(2);
    private final ReentrantMutex onMessageMutex = new ReentrantMutex();
    private final ReentrantMutex sessionSyncMutex = new ReentrantMutex();
    private final Set producers;
    private final Set syncConsumers;
    private final Set asyncConsumers;
    private final Object consumerListsLock = new Object();
    private final List browsers;
    private List messageReferences;
    Thread messageListenerThread = null;
    private boolean onMessageHasThrownException = false;
    private boolean nullMsgOnDelivery = false;
    public static final String SUPPRESS_BROWSE_MARK_MSG = "com.ibm.msg.client.wmq.suppressBrowseMarkMessageWarning";
    private boolean suppressBrowseWithMarkMsg = false;
    public static final String asyncMethodsAllowedPropName = "com.ibm.msg.client.wmq.jmssession.asyncMethodsAllowed";

    protected JmsSessionImpl(boolean transacted, int acknowledgeMode, JmsConnectionImpl connection) throws JMSException {
        super(connection, true);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "<init>(boolean,int,JmsConnectionImpl)", new Object[]{transacted, new Integer(acknowledgeMode), connection});
        }
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.connection = connection;
        this.providerFactory = connection.getProviderFactory();
        this.connectionTypeName = connection.getConnectionTypeName();
        this.dupsCommitThreshold = JmsConnectionImpl.DEFAULT_DUPS_THRESHOLD;
        this.producers = Collections.synchronizedSet(new HashSet());
        this.syncConsumers = Collections.synchronizedSet(new HashSet());
        this.asyncConsumers = Collections.synchronizedSet(new HashSet());
        this.browsers = Collections.synchronizedList(new ArrayList());
        this.setIntProperty("XMSC_ACKNOWLEDGE_MODE", acknowledgeMode);
        this.setBooleanProperty("XMSC_TRANSACTED", transacted);
        try {
            this.setLongProperty("OBJECT_IDENTITY", System.identityHashCode(this));
        }
        catch (JMSException e) {
            // empty catch block
        }
        PropertyStore.register(SUPPRESS_BROWSE_MARK_MSG, false);
        this.suppressBrowseWithMarkMsg = PropertyStore.getBooleanPropertyObject(SUPPRESS_BROWSE_MARK_MSG);
        if (Trace.isOn) {
            Trace.data(this, "<init>", "com.ibm.msg.client.wmq.suppressBrowseMarkMessageWarning = " + this.suppressBrowseWithMarkMsg, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "<init>(boolean,int,JmsConnectionImpl)");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close()");
        }
        this.close(false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean closingFromConnection) throws JMSException {
        JMSException firstException;
        block60: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", new Object[]{closingFromConnection});
            }
            this.connection.removeSession(this);
            firstException = null;
            try {
                this.stop(false);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", je, 1);
                }
                if (firstException != null) break block60;
                firstException = je;
            }
        }
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            int i;
            Object[] cons;
            Collection je;
            block61: {
                if (this.state.close()) {
                    if (this.clearUpProviderXASession && !((ProviderXASession)this.providerSession).isXASessionActive()) {
                        Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", "Clearing up ProviderXASession", this.providerSession);
                        this.providerSession.close(closingFromConnection);
                        this.clearUpProviderXASession = false;
                    }
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", 1);
                    }
                    return;
                }
                je = this.syncConsumers;
                synchronized (je) {
                    cons = this.syncConsumers.toArray();
                    for (i = 0; i < cons.length; ++i) {
                        try {
                            ((JmsMessageConsumerImpl)cons[i]).close(true);
                            continue;
                        }
                        catch (JMSException je2) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", je2, 2);
                            }
                            if (firstException != null) continue;
                            firstException = je2;
                        }
                    }
                    this.syncConsumers.clear();
                }
                if (!(this.providerSession instanceof ProviderXASession)) {
                    try {
                        switch (this.acknowledgeMode) {
                            case 0: {
                                this.rollbackTransaction();
                                break;
                            }
                            case 2: {
                                this.rollbackTransaction();
                                break;
                            }
                            case 3: {
                                this.commitTransaction();
                                break;
                            }
                            case 1: {
                                break;
                            }
                            default: {
                                HashMap<String, Integer> data = new HashMap<String, Integer>();
                                data.put("ackmode", new Integer(this.acknowledgeMode));
                                Trace.ffst(this, "close()", "XJ003002", data, JMSException.class);
                                break;
                            }
                        }
                    }
                    catch (JMSException je3) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", je3, 3);
                        }
                        if (firstException != null) break block61;
                        firstException = je3;
                    }
                }
            }
            je = this.producers;
            synchronized (je) {
                Object[] prods = this.producers.toArray();
                for (i = 0; i < prods.length; ++i) {
                    try {
                        ((JmsMessageProducerImpl)prods[i]).close(true);
                        continue;
                    }
                    catch (JMSException je4) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", je4, 4);
                        }
                        if (firstException != null) continue;
                        firstException = je4;
                    }
                }
                this.producers.clear();
            }
            je = this.asyncConsumers;
            synchronized (je) {
                cons = this.asyncConsumers.toArray();
                for (i = 0; i < cons.length; ++i) {
                    try {
                        ((JmsMessageConsumerImpl)cons[i]).close(true);
                        continue;
                    }
                    catch (JMSException je5) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", je5, 5);
                        }
                        if (firstException != null) continue;
                        firstException = je5;
                    }
                }
                this.asyncConsumers.clear();
            }
            je = this.browsers;
            synchronized (je) {
                Object[] brow = this.browsers.toArray();
                for (i = 0; i < brow.length; ++i) {
                    try {
                        ((JmsQueueBrowserImpl)brow[i]).close(true);
                        continue;
                    }
                    catch (JMSException je6) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", je6, 6);
                        }
                        if (firstException != null) continue;
                        firstException = je6;
                    }
                }
                this.browsers.clear();
            }
            if (!(this.providerSession instanceof ProviderXASession) || !((ProviderXASession)this.providerSession).isXASessionActive()) {
                try {
                    this.providerSession.close(closingFromConnection);
                }
                catch (JMSException je7) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", je7, 7);
                    }
                    if (firstException == null) {
                        firstException = je7;
                    }
                }
            } else {
                Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", "Keeping ProviderXASession open", this.providerSession);
                this.clearUpProviderXASession = true;
            }
            if (firstException != null) {
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", firstException);
                }
                throw firstException;
            }
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "close(boolean)", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "commit()");
        }
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            this.checkSynchronousUsage("commit");
            if (this.acknowledgeMode != 0) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "commit");
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0014", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "commit()", je);
                }
                throw je;
            }
            this.commitTransaction();
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "commit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createBrowser(Queue,String)", new Object[]{queue, selector});
        }
        this.checkSynchronousUsage("createBrowser");
        this.checkQueueDomain("createBrowser");
        JmsQueueBrowserImpl jmsBrowser = null;
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            if (!(queue instanceof JmsDestinationImpl)) {
                HashMap<String, Queue> inserts = new HashMap<String, Queue>();
                inserts.put("XMSC_DESTINATION_NAME", queue);
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0099", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createBrowser(Queue,String)", je, 1);
                }
                throw je;
            }
            if (queue instanceof JmsTemporaryQueueImpl && ((JmsTemporaryQueueImpl)queue).getConnection() != this.connection) {
                HashMap<String, Queue> inserts = new HashMap<String, Queue>();
                inserts.put("XMSC_DESTINATION_NAME", queue);
                JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3003", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createBrowser(Queue,String)", je2, 2);
                }
                throw je2;
            }
            jmsBrowser = new JmsQueueBrowserImpl(this, (JmsQueue)queue, selector);
            ProviderDestination providerDestination = JmsDestinationImplProxy.getProviderDestination((JmsDestinationImpl)queue);
            ProviderQueueBrowser browser = this.providerSession.createBrowser(providerDestination, selector, jmsBrowser);
            jmsBrowser.setProviderBrowser(browser);
            JmsDestinationImplProxy.incrementUseCount((JmsDestinationImpl)queue);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createBrowser(Queue,String)", jmsBrowser);
        }
        return jmsBrowser;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createBrowser(Queue)", new Object[]{queue});
        }
        this.checkSynchronousUsage("createBrowser");
        this.checkQueueDomain("createBrowser");
        QueueBrowser traceRet1 = this.createBrowser(queue, null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createBrowser(Queue)", traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesMessage createBytesMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createBytesMessage()");
        }
        this.checkSynchronousUsage("createBytesMessage");
        JmsBytesMessageImpl msg = null;
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            msg = new JmsBytesMessageImpl(this);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createBytesMessage()", msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public MessageConsumer createConsumer(Destination dest, String selector, boolean noLocal) throws JMSException {
        void var4_12;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createConsumer(Destination,String,boolean)", new Object[]{dest, selector, noLocal});
        }
        this.checkSynchronousUsage("createConsumer");
        this.checkNotMixedDomain(dest, "createConsumer");
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            if (!(dest instanceof JmsDestinationImpl)) {
                HashMap<String, Destination> inserts = new HashMap<String, Destination>();
                inserts.put("XMSC_DESTINATION_NAME", dest);
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0099", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createConsumer(Destination,String,boolean)", je, 1);
                }
                throw je;
            }
            if (!((JmsDestinationImpl)dest).getStringProperty("XMSC_CONNECTION_TYPE_NAME").equals(this.connectionTypeName)) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_CONNECTION_TYPE_NAME", this.connectionTypeName);
                inserts.put("XMSC_CONNECTION_TYPE", ((JmsDestinationImpl)dest).getStringProperty("XMSC_CONNECTION_TYPE_NAME"));
                JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0092", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createConsumer(Destination,String,boolean)", je2, 2);
                }
                throw je2;
            }
            if (dest instanceof JmsTemporaryQueueImpl && ((JmsTemporaryQueueImpl)dest).getConnection() != this.connection || dest instanceof JmsTemporaryTopicImpl && ((JmsTemporaryTopicImpl)dest).getConnection() != this.connection) {
                HashMap<String, Destination> inserts = new HashMap<String, Destination>();
                inserts.put("XMSC_DESTINATION_NAME", dest);
                JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3003", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createConsumer(Destination,String,boolean)", je2, 3);
                }
                throw je2;
            }
            State state = this.state;
            synchronized (state) {
                JmsMessageConsumerImpl jmsConsumer = dest instanceof Queue ? new JmsQueueReceiverImpl(this, (Queue)dest, selector, noLocal) : (dest instanceof Topic ? new JmsTopicSubscriberImpl(this, (Topic)dest, selector, noLocal) : new JmsMessageConsumerImpl(this, dest, selector, noLocal));
                ProviderDestination providerDestination = JmsDestinationImplProxy.getProviderDestination((JmsDestinationImpl)dest);
                ProviderMessageConsumer consumer = this.providerSession.createConsumer(providerDestination, selector, noLocal, jmsConsumer);
                jmsConsumer.setProviderConsumer(consumer);
                if (this.getState() == 1) {
                    jmsConsumer.start();
                } else {
                    jmsConsumer.stop();
                }
                this.syncConsumers.add(jmsConsumer);
                JmsDestinationImplProxy.incrementUseCount((JmsDestinationImpl)dest);
            }
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createConsumer(Destination,String,boolean)", var4_12);
        }
        return var4_12;
    }

    public MessageConsumer createConsumer(Destination dest, String selector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createConsumer(Destination,String)", new Object[]{dest, selector});
        }
        this.checkSynchronousUsage("createConsumer");
        this.checkNotMixedDomain(dest, "createConsumer");
        MessageConsumer traceRet1 = this.createConsumer(dest, selector, false);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createConsumer(Destination,String)", traceRet1);
        }
        return traceRet1;
    }

    public MessageConsumer createConsumer(Destination dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createConsumer(Destination)", new Object[]{dest});
        }
        this.checkSynchronousUsage("createConsumer");
        this.checkNotMixedDomain(dest, "createConsumer");
        MessageConsumer traceRet1 = this.createConsumer(dest, null, false);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createConsumer(Destination)", traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String subscriptionName, String selector, boolean noLocal) throws JMSException {
        void var5_17;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createDurableSubscriber(Topic,String,String,boolean)", new Object[]{topic, subscriptionName, selector, noLocal});
        }
        this.checkSynchronousUsage("createDurableSubscriber");
        this.checkTopicDomain("createDurableSubscriber");
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            if (!(topic instanceof JmsDestinationImpl)) {
                HashMap<String, Topic> inserts = new HashMap<String, Topic>();
                inserts.put("XMSC_DESTINATION_NAME", topic);
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0099", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createDurableSubscriber(Topic,String,String,boolean)", je, 1);
                }
                throw je;
            }
            JmsDestinationImpl jmsTopic = (JmsDestinationImpl)topic;
            if (!jmsTopic.getStringProperty("XMSC_CONNECTION_TYPE_NAME").equals(this.connectionTypeName)) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_CONNECTION_TYPE_NAME", this.connectionTypeName);
                inserts.put("XMSC_CONNECTION_TYPE", jmsTopic.getStringProperty("XMSC_CONNECTION_TYPE_NAME"));
                JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0092", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createDurableSubscriber(Topic,String,String,boolean)", je2, 2);
                }
                throw je2;
            }
            ProviderDestination providerDestination = JmsDestinationImplProxy.getProviderDestination(jmsTopic);
            if (providerDestination.isTemporary()) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_TYPE", "Topic");
                inserts.put("XMSC_DESTINATION_NAME", topic.getTopicName());
                JMSException je3 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0093", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createDurableSubscriber(Topic,String,String,boolean)", je3, 3);
                }
                throw je3;
            }
            if (subscriptionName == null || "".equals(subscriptionName)) {
                JMSException je4 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0100", null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createDurableSubscriber(Topic,String,String,boolean)", je4, 4);
                }
                throw je4;
            }
            String clientID = this.connection.getClientID();
            if (clientID == null || "".equals(clientID)) {
                JMSException je5 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0101", null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createDurableSubscriber(Topic,String,String,boolean)", je5, 5);
                }
                throw je5;
            }
            JmsTopicSubscriberImpl jmsSubscriber = new JmsTopicSubscriberImpl(this, topic, selector, noLocal, subscriptionName);
            ProviderMessageConsumer consumer = this.providerSession.createDurableSubscriber(JmsDestinationImplProxy.getProviderDestination((JmsDestinationImpl)topic), subscriptionName, selector, noLocal, jmsSubscriber);
            jmsSubscriber.setProviderConsumer(consumer);
            this.syncConsumers.add(jmsSubscriber);
            JmsDestinationImplProxy.incrementUseCount((JmsDestinationImpl)topic);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createDurableSubscriber(Topic,String,String,boolean)", var5_17);
        }
        return var5_17;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subscriptionName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createDurableSubscriber(Topic,String)", new Object[]{topic, subscriptionName});
        }
        this.checkSynchronousUsage("createDurableSubscriber");
        this.checkTopicDomain("createDurableSubscriber");
        TopicSubscriber traceRet1 = this.createDurableSubscriber(topic, subscriptionName, null, false);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createDurableSubscriber(Topic,String)", traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapMessage createMapMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createMapMessage()");
        }
        this.checkSynchronousUsage("createMapMessage");
        JmsMapMessageImpl msg = null;
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            msg = new JmsMapMessageImpl(this);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createMapMessage()", msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message createMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createMessage()");
        }
        this.checkSynchronousUsage("createMessage");
        JmsMessageImpl msg = null;
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            msg = new JmsMessageImpl(this);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createMessage()", msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMessage createObjectMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createObjectMessage()");
        }
        this.checkSynchronousUsage("createObjectMessage");
        JmsObjectMessageImpl msg = null;
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            msg = new JmsObjectMessageImpl(this);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createObjectMessage()", msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMessage createObjectMessage(Serializable obj) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createObjectMessage(Serializable)", new Object[]{obj});
        }
        this.checkSynchronousUsage("createObjectMessage");
        JmsObjectMessageImpl msg = null;
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            msg = new JmsObjectMessageImpl(this, obj);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createObjectMessage(Serializable)", msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public MessageProducer createProducer(Destination dest) throws JMSException {
        void var2_7;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createProducer(Destination)", new Object[]{dest});
        }
        this.checkSynchronousUsage("createProducer");
        this.checkNotMixedDomain(dest, "createProducer");
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            if (dest != null) {
                if (!(dest instanceof JmsDestinationImpl)) {
                    JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0099", null));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createProducer(Destination)", je, 1);
                    }
                    throw je;
                }
                if (!((JmsDestinationImpl)dest).getStringProperty("XMSC_CONNECTION_TYPE_NAME").equals(this.connectionTypeName)) {
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_CONNECTION_TYPE_NAME", this.connectionTypeName);
                    inserts.put("XMSC_CONNECTION_TYPE", ((JmsDestinationImpl)dest).getStringProperty("XMSC_CONNECTION_TYPE_NAME"));
                    JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0092", inserts));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createProducer(Destination)", je2, 2);
                    }
                    throw je2;
                }
            }
            JmsMessageProducerImpl jmsProducer = dest instanceof Queue || this instanceof QueueSession || this instanceof XAQueueSession ? new JmsQueueSenderImpl((Queue)dest, this) : (dest instanceof Topic || this instanceof TopicSession || this instanceof XATopicSession ? new JmsTopicPublisherImpl((Topic)dest, this) : new JmsMessageProducerImpl(dest, this));
            ProviderDestination providerDest = dest == null ? null : JmsDestinationImplProxy.getProviderDestination((JmsDestinationImpl)dest);
            ProviderMessageProducer producer = this.providerSession.createProducer(providerDest, jmsProducer);
            jmsProducer.setProviderProducer(producer);
            this.producers.add(jmsProducer);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createProducer(Destination)", var2_7);
        }
        return var2_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue createQueue(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createQueue(String)", new Object[]{name});
        }
        this.checkSynchronousUsage("createQueue");
        this.checkQueueDomain("createQueue");
        JmsQueue jmsQueue = null;
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            if (null == name || 0 == name.length()) {
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0085", null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createQueue(String)", je);
                }
                throw je;
            }
            jmsQueue = this.providerFactory.getJmsFactory().createQueue(name, this);
            JmsDestinationImplProxy.setProviderDestination((JmsDestinationImpl)((Object)jmsQueue));
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createQueue(String)", jmsQueue);
        }
        return jmsQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamMessage createStreamMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createStreamMessage()");
        }
        this.checkSynchronousUsage("createStreamMessage");
        JmsStreamMessageImpl msg = null;
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            msg = new JmsStreamMessageImpl(this);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createStreamMessage()", msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTemporaryQueue()");
        }
        this.checkSynchronousUsage("createTemporaryQueue");
        this.checkQueueDomain("createTemporaryQueue");
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            State state = this.state;
            synchronized (state) {
                JmsTemporaryQueueImpl temporaryQueue = new JmsTemporaryQueueImpl(this.connection, this.providerSession);
                this.connection.addTemporaryDestination(temporaryQueue);
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTemporaryQueue()", temporaryQueue);
                }
                JmsTemporaryQueueImpl jmsTemporaryQueueImpl = temporaryQueue;
                return jmsTemporaryQueueImpl;
            }
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTemporaryTopic()");
        }
        this.checkSynchronousUsage("createTemporaryTopic");
        this.checkTopicDomain("createTemporaryTopic");
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            State state = this.state;
            synchronized (state) {
                JmsTemporaryTopicImpl temporaryTopic = new JmsTemporaryTopicImpl(this.connection, this.providerSession);
                this.connection.addTemporaryDestination(temporaryTopic);
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTemporaryTopic()", temporaryTopic);
                }
                JmsTemporaryTopicImpl jmsTemporaryTopicImpl = temporaryTopic;
                return jmsTemporaryTopicImpl;
            }
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTextMessage()");
        }
        this.checkSynchronousUsage("createTextMessage");
        JmsTextMessageImpl msg = null;
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            msg = new JmsTextMessageImpl(this);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTextMessage()", msg);
        }
        return msg;
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTextMessage(String)", new Object[]{text});
        }
        this.checkSynchronousUsage("createTextMessage");
        TextMessage message = this.createTextMessage();
        message.setText(text);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTextMessage(String)", message);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic createTopic(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTopic(String)", new Object[]{name});
        }
        this.checkSynchronousUsage("createTopic");
        this.checkTopicDomain("createTopic");
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            if (null == name || 0 == name.length()) {
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0085", null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTopic(String)", je);
                }
                throw je;
            }
            JmsTopic jmsTopic = this.providerFactory.getJmsFactory().createTopic(name, this);
            JmsDestinationImplProxy.setProviderDestination((JmsDestinationImpl)((Object)jmsTopic));
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "createTopic(String)", jmsTopic);
            }
            JmsTopic jmsTopic2 = jmsTopic;
            return jmsTopic2;
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getAcknowledgeMode()");
        }
        this.checkSynchronousUsage("getAcknowledgeMode");
        this.checkNotClosed();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getAcknowledgeMode()", new Integer(this.acknowledgeMode));
        }
        return this.acknowledgeMode;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getMessageListener()");
        }
        this.checkSynchronousUsage("getMessageListener");
        this.checkNotClosed();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getMessageListener()", this.messageListener);
        }
        return this.messageListener;
    }

    public boolean getTransacted() throws JMSException {
        boolean asyncCheckOverriden;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getTransacted()");
        }
        if (!(asyncCheckOverriden = this.isAsyncCheckOverriden("getTransacted"))) {
            this.checkSynchronousUsage("getTransacted");
        }
        this.checkNotClosed();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getTransacted()", this.transacted);
        }
        return this.transacted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void recover() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "recover()");
        }
        this.checkSynchronousUsage("recover");
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            switch (this.acknowledgeMode) {
                case 1: 
                case 3: {
                    asyncConsumerIterator = this.asyncConsumers.iterator();
                    while (asyncConsumerIterator.hasNext()) {
                        msgConsumer = asyncConsumerIterator.next();
                        if (!(msgConsumer instanceof JmsMessageConsumerImpl)) continue;
                        ((JmsMessageConsumerImpl)msgConsumer).recoverAsyncMessage();
                    }
                }
                case 2: {
                    if (this.uncommittedReceiveCount <= 0) ** break;
                    this.rollbackTransaction();
                    ** break;
lbl21:
                    // 1 sources

                    break;
                }
                case 0: {
                    inserts = new HashMap<String, String>();
                    inserts.put("XMSC_INSERT_METHOD", "recover");
                    je = (JMSException)JmsErrorUtils.createException("JMSCC0021", inserts);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "recover()", je);
                    }
                    throw je;
                }
                ** default:
lbl31:
                // 1 sources

                break;
            }
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "recover()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "rollback()");
        }
        this.checkSynchronousUsage("rollback");
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            if (this.acknowledgeMode != 0) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "rollback");
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0014", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "rollback()", je);
                }
                throw je;
            }
            this.rollbackTransaction();
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "rollback()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "setMessageListener(MessageListener)", new Object[]{listener});
        }
        this.checkSynchronousUsage("setMessageListener");
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            this.messageListener = listener;
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "setMessageListener(MessageListener)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String subscriptionName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "unsubscribe(String)", new Object[]{subscriptionName});
        }
        this.checkSynchronousUsage("unsubscribe");
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            if (this instanceof QueueSession) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "unsubscribe(String)");
                inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1112", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "unsubscribe(String)", je, 1);
                }
                throw je;
            }
            if (subscriptionName == null || "".equals(subscriptionName)) {
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0100", null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "unsubscribe(String)", je, 2);
                }
                throw je;
            }
            String clientID = this.connection.getClientID();
            if (clientID == null || "".equals(clientID)) {
                JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0101", null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "unsubscribe(String)", je2, 3);
                }
                throw je2;
            }
            this.providerSession.deleteDurableSubscriber(subscriptionName);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "unsubscribe(String)");
        }
    }

    public ProviderSession getProviderSession() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getProviderSession()", "getter", this.providerSession);
        }
        return this.providerSession;
    }

    public void setProviderSession(ProviderSession providerSession) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "setProviderSession(ProviderSession)", "setter", providerSession);
        }
        this.providerSession = providerSession;
    }

    protected String getConnectionTypeName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getConnectionTypeName()", "getter", this.connectionTypeName);
        }
        return this.connectionTypeName;
    }

    protected int getState() {
        int traceRet1 = this.state.getState();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getState()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    protected ReentrantMutex getOnMessageMutex() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getAsyncDeliveryLock()", "getter", this.onMessageMutex);
        }
        return this.onMessageMutex;
    }

    protected JmsConnection getConnection() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getConnection()", "getter", this.connection);
        }
        return this.connection;
    }

    protected ProviderJmsFactory getJmsFactory() {
        ProviderJmsFactory traceRet1 = this.connection.getJmsFactory();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getJmsFactory()", "getter", traceRet1);
        }
        return traceRet1;
    }

    protected ProviderMessageFactory getMessageFactory() {
        ProviderMessageFactory traceRet1 = this.connection.getMessageFactory();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getMessageFactory()", "getter", traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "start()");
        }
        State state = this.state;
        synchronized (state) {
            JmsMessageConsumerImpl consImpl;
            this.providerSession.start();
            JMSException firstException = null;
            Object[] syncList = this.syncConsumers.toArray();
            for (int i = 0; i < syncList.length; ++i) {
                try {
                    consImpl = (JmsMessageConsumerImpl)syncList[i];
                    consImpl.start();
                    continue;
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "start()", e, 1);
                    }
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            Iterator asyncList = this.asyncConsumers.iterator();
            while (asyncList.hasNext()) {
                try {
                    consImpl = (JmsMessageConsumerImpl)asyncList.next();
                    consImpl.start();
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "start()", e, 2);
                    }
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            if (firstException != null) {
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "start()", firstException);
                }
                throw firstException;
            }
            this.state.setState(1);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "start()");
        }
    }

    void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "stop()");
        }
        this.stop(true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "stop()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(boolean changeState) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "stop(boolean)", new Object[]{changeState});
        }
        this.providerSession.stop();
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            Object[] cons;
            if (changeState) {
                this.state.setState(2);
            }
            JMSException firstException = null;
            Object object = this.consumerListsLock;
            synchronized (object) {
                Set set = this.syncConsumers;
                synchronized (set) {
                    Iterator i = this.syncConsumers.iterator();
                    while (i.hasNext()) {
                        try {
                            ((JmsMessageConsumerImpl)i.next()).stopUnconditional();
                        }
                        catch (JMSException e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "stop(boolean)", e, 1);
                            }
                            if (firstException != null) continue;
                            firstException = e;
                        }
                    }
                }
                cons = this.asyncConsumers.toArray();
            }
            for (int i = 0; i < cons.length; ++i) {
                try {
                    ((JmsMessageConsumerImpl)cons[i]).stopUnconditional();
                    continue;
                }
                catch (JMSException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "stop(boolean)", e, 2);
                    }
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            if (firstException != null) {
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "stop(boolean)", firstException);
                }
                throw firstException;
            }
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "stop(boolean)");
        }
    }

    public int getProducerCount() {
        int traceRet1 = this.producers.size();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getProducerCount()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getConsumerCount() {
        int consumerCount = this.syncConsumers.size();
        consumerCount += this.asyncConsumers.size();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getConsumerCount()", "getter", new Integer(consumerCount));
        }
        return consumerCount;
    }

    void removeProducer(JmsMessageProducerImpl producer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "removeProducer(JmsMessageProducerImpl)", new Object[]{producer});
        }
        this.producers.remove(producer);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "removeProducer(JmsMessageProducerImpl)");
        }
    }

    void removeConsumer(JmsMessageConsumerImpl consumer) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "removeConsumer(JmsMessageConsumerImpl)", new Object[]{consumer});
        }
        if (this.acknowledgeMode == 3 && this.uncommittedReceiveCount > 0) {
            this.providerSession.commit();
        }
        this.syncConsumers.remove(consumer);
        this.asyncConsumers.remove(consumer);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "removeConsumer(JmsMessageConsumerImpl)");
        }
    }

    void removeBrowser(JmsQueueBrowserImpl browser) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "removeBrowser(JmsQueueBrowserImpl)", new Object[]{browser});
        }
        this.browsers.remove(browser);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "removeBrowser(JmsQueueBrowserImpl)");
        }
    }

    void notifyMessagePreConsume(boolean isTransacted) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "notifyMessagePreConsume(boolean)", new Object[]{isTransacted});
        }
        if (!isTransacted) {
            ++this.uncommittedReceiveCount;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "notifyMessagePreConsume(boolean)");
        }
    }

    void notifyMessagePostConsume() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "notifyMessagePostConsume()");
        }
        if (!this.providerSession.isInGlobalTransaction() && (this.acknowledgeMode == 3 && this.uncommittedReceiveCount >= this.dupsCommitThreshold || this.acknowledgeMode == 1)) {
            this.providerSession.commit();
            this.uncommittedReceiveCount = 0;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "notifyMessagePostConsume()");
        }
    }

    void notifyMessageConsumed(boolean isXA) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "notifyMessageConsumed(boolean)", new Object[]{isXA});
        }
        this.notifyMessagePreConsume(isXA);
        this.notifyMessagePostConsume();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "notifyMessageConsumed(boolean)");
        }
    }

    int getAndResetCommitCount() {
        int currentUncommittedReceiveCount = this.uncommittedReceiveCount;
        this.uncommittedReceiveCount = 0;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getAndResetCommitCount()", "getter", new Integer(currentUncommittedReceiveCount));
        }
        return currentUncommittedReceiveCount;
    }

    void commitTransaction() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "commitTransaction()");
        }
        this.providerSession.commit();
        this.uncommittedReceiveCount = 0;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "commitTransaction()");
        }
    }

    void rollbackTransaction() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "rollbackTransaction()");
        }
        this.providerSession.rollback();
        this.uncommittedReceiveCount = 0;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "rollbackTransaction()");
        }
    }

    boolean isAsync() {
        boolean traceRet1;
        boolean bl = traceRet1 = !this.asyncConsumers.isEmpty() && this.state.getState() == 1;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "isAsync()", "getter", traceRet1);
        }
        return traceRet1;
    }

    void checkSynchronousUsage(String methodName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkSynchronousUsage(String)", new Object[]{methodName});
        }
        if (this.isAsync() && !this.onMessageMutex.isHeldByCurrentThread()) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", methodName);
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0033", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkSynchronousUsage(String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkSynchronousUsage(String)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSyncConsumer(MessageConsumer consumer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "registerSyncConsumer(MessageConsumer)", new Object[]{consumer});
        }
        Object object = this.consumerListsLock;
        synchronized (object) {
            this.asyncConsumers.remove(consumer);
            if (!this.syncConsumers.contains(consumer)) {
                this.syncConsumers.add(consumer);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "registerSyncConsumer(MessageConsumer)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAsyncConsumer(MessageConsumer consumer) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "registerAsyncConsumer(MessageConsumer)", new Object[]{consumer});
        }
        Object object = this.consumerListsLock;
        synchronized (object) {
            this.syncConsumers.remove(consumer);
            if (!this.asyncConsumers.contains(consumer)) {
                this.asyncConsumers.add(consumer);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "registerAsyncConsumer(MessageConsumer)");
        }
    }

    ReentrantMutex getSessionSyncMutex() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "getSessionSyncLock()", "getter", this.sessionSyncMutex);
        }
        return this.sessionSyncMutex;
    }

    protected void checkNotClosed() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkNotClosed()");
        }
        this.state.checkNotClosed("JMSCC0020");
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkNotClosed()");
        }
    }

    private void checkNotMixedDomain(Destination dest, String method) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkNotMixedDomain(Destination,String)", new Object[]{dest, method});
        }
        boolean topicDomainOnly = this instanceof TopicSession;
        boolean queueDomainOnly = this instanceof QueueSession;
        if (topicDomainOnly && dest instanceof Queue || queueDomainOnly && dest instanceof Topic) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            if ("createConsumer".equals(method) && this instanceof TopicSession) {
                method = "createSubscriber";
            } else if ("createConsumer".equals(method) && this instanceof QueueSession) {
                method = "createReceiver";
            }
            if ("createProducer".equals(method) && this instanceof TopicSession) {
                method = "createPublisher";
            }
            if ("createProducer".equals(method) && this instanceof QueueSession) {
                method = "createSender";
            }
            inserts.put("XMSC_INSERT_METHOD", method);
            inserts.put("XMSC_INSERT_TYPE", dest.getClass().getName());
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkNotMixedDomain(Destination,String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkNotMixedDomain(Destination,String)");
        }
    }

    private void checkQueueDomain(String method) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkQueueDomain(String)", new Object[]{method});
        }
        if (this instanceof TopicSession || this instanceof XATopicSession) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", method);
            inserts.put("XMSC_INSERT_TYPE", "TopicSession");
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkQueueDomain(String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkQueueDomain(String)");
        }
    }

    private void checkTopicDomain(String method) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkTopicDomain(String)", new Object[]{method});
        }
        if (this instanceof QueueSession || this instanceof XAQueueSession) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", method);
            inserts.put("XMSC_INSERT_TYPE", "QueueSession");
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkTopicDomain(String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "checkTopicDomain(String)");
        }
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(List messageReferences2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "deliver(List)", new Object[]{messageReferences2});
        }
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            if (this.messageReferences != null) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_METHOD", "deliver");
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0034", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "deliver(List)", je);
                }
                throw je;
            }
            this.messageReferences = messageReferences2;
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "deliver(List)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmsMessageReference recreateMessageReference(byte[] flatMR) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "recreateMessageReference(byte [ ])", new Object[]{flatMR});
        }
        if (null == flatMR || 0 == flatMR.length) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1096", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "recreateMessageReference(byte [ ])", je);
            }
            throw je;
        }
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            String destURI = this.providerSession.getDestinationURI(flatMR);
            ProviderDestination provdest = null;
            if (destURI != null) {
                JmsDestination dest = this.providerFactory.getJmsFactory().createDestination(destURI, this);
                JmsDestinationImpl destimpl = (JmsDestinationImpl)dest;
                JmsDestinationImplProxy.setProviderDestination(destimpl);
                provdest = JmsDestinationImplProxy.getProviderDestination(destimpl);
            }
            ProviderMessageReference pmr = this.providerSession.recreateMessageReference(flatMR, provdest);
            JmsMessageReferenceImpl jmr = new JmsMessageReferenceImpl(this.connectionTypeName, pmr);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "recreateMessageReference(byte [ ])", jmr);
            }
            JmsMessageReferenceImpl jmsMessageReferenceImpl = jmr;
            return jmsMessageReferenceImpl;
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
    }

    private Message consume(JmsMessageReference msgRef) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "consume(JmsMessageReference)", new Object[]{msgRef});
        }
        if (null == msgRef || !(msgRef instanceof JmsMessageReferenceImpl)) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1096", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "consume(JmsMessageReference)", je);
            }
            throw je;
        }
        JmsMessageReferenceImpl jmsMsgRef = (JmsMessageReferenceImpl)msgRef;
        ProviderMessageReference provMsgRef = jmsMsgRef.getDelegate();
        String destURI = provMsgRef.getDestinationAsString();
        if (null != destURI) {
            JmsDestination dest = this.providerFactory.getJmsFactory().createDestination(destURI, this);
            JmsDestinationImpl destimpl = (JmsDestinationImpl)dest;
            JmsDestinationImplProxy.setProviderDestination(destimpl);
            ProviderDestination provdest = JmsDestinationImplProxy.getProviderDestination(destimpl);
            provMsgRef.setDestination(provdest);
        }
        this.providerSession.loadMessageReference(jmsMsgRef.getDelegate());
        Message message = jmsMsgRef.getMessage(this);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "consume(JmsMessageReference)", message);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message consume(byte[] flatMR) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "consume(byte [ ])", new Object[]{flatMR});
        }
        if (null == flatMR || flatMR.length == 0) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1096", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "consume(byte [ ])", je);
            }
            throw je;
        }
        Message message = null;
        if (!this.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            this.checkNotClosed();
            JmsMessageReference msgRef = this.recreateMessageReference(flatMR);
            message = this.consume(msgRef);
            this.notifyMessageConsumed(false);
        }
        finally {
            if (!this.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "consume(byte [ ])", message);
        }
        return message;
    }

    public boolean equals(Object obj) {
        boolean traceRet1 = this == obj;
        return traceRet1;
    }

    private boolean isAsyncCheckOverriden(String methodName) {
        String methodnames;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "isAsyncCheckOverriden()", new Object[]{methodName});
        }
        boolean asyncCheckOverriden = false;
        PropertyStore.register(asyncMethodsAllowedPropName, "");
        if (PropertyStore.wasOverridden(asyncMethodsAllowedPropName, null) && (methodnames = PropertyStore.getStringProperty(asyncMethodsAllowedPropName)) != null) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "isAsyncCheckOverriden()", asyncMethodsAllowedPropName, new Object[]{methodnames});
            }
            String[] methods = methodnames.split(",", -1);
            for (int i = 0; i < methods.length; ++i) {
                if (!methodName.equalsIgnoreCase(methods[i])) continue;
                asyncCheckOverriden = true;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsSessionImpl", "isAsyncCheckOverriden()", new Object[]{asyncCheckOverriden});
        }
        return asyncCheckOverriden;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsSessionImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsSessionImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.99.2.23 12/12/13 15:30:34");
        }
    }
}

