/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.TableBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsReadablePropertyContext;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;

public abstract class JmsReadablePropertyContextImpl
implements JmsReadablePropertyContext {
    private static final long serialVersionUID = 1485713687468941354L;
    static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsReadablePropertyContextImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.38.1.8 10/04/22 16:11:05";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map properties;

    public JmsReadablePropertyContextImpl() {
        this.properties = Collections.synchronizedMap(new HashMap());
    }

    public JmsReadablePropertyContextImpl(Map propsTable, boolean doCopy) {
        if (Trace.isOn) {
            if (propsTable.containsKey("XMSC_PASSWORD")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(propsTable);
                propsNotPasswd.put("XMSC_PASSWORD", "********");
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "<init>(Map,boolean)", new Object[]{propsNotPasswd, doCopy});
            } else {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "<init>(Map,boolean)", new Object[]{propsTable, doCopy});
            }
        }
        if (doCopy) {
            HashMap newPropsTable = new HashMap(propsTable);
            this.properties = Collections.synchronizedMap(newPropsTable);
        } else {
            this.properties = propsTable;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "<init>(Map,boolean)");
        }
    }

    public JmsReadablePropertyContextImpl(JmsReadablePropertyContextImpl other, boolean doCopy) {
        this(other.properties, doCopy);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "<init>(JmsReadablePropertyContextImpl,boolean)", new Object[]{other, doCopy});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "<init>(JmsReadablePropertyContextImpl,boolean)");
        }
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        boolean result = JmsReadablePropertyContextImpl.parseBoolean(value, name, JMSException.class);
        return result;
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        byte result = JmsReadablePropertyContextImpl.parseByte(value, name, JMSException.class);
        return result;
    }

    public byte[] getBytesProperty(String name) throws JMSException {
        Object objVal = this.getObjectProperty(name);
        byte[] copyOfValue = null;
        if (objVal instanceof byte[]) {
            byte[] value = (byte[])objVal;
            copyOfValue = new byte[value.length];
            System.arraycopy(value, 0, copyOfValue, 0, value.length);
        } else if (objVal == null) {
            copyOfValue = null;
        } else {
            JmsReadablePropertyContextImpl.throwBadConvertException(objVal, name, "Byte[]", JMSException.class);
        }
        return copyOfValue;
    }

    public char getCharProperty(String name) throws JMSException {
        Object objVal = this.getObjectProperty(name);
        char value = '\u0000';
        if (objVal instanceof Character) {
            value = ((Character)objVal).charValue();
        } else {
            if (objVal == null) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_FIELD", name);
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0042", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "getCharProperty(String)", je);
                }
                throw je;
            }
            JmsReadablePropertyContextImpl.throwBadConvertException(objVal, name, "Character", JMSException.class);
        }
        return value;
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        double result = JmsReadablePropertyContextImpl.parseDouble(value, name, JMSException.class);
        return result;
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        float result = JmsReadablePropertyContextImpl.parseFloat(value, name, JMSException.class);
        return result;
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        int result = JmsReadablePropertyContextImpl.parseInt(value, name, JMSException.class);
        return result;
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        long result = JmsReadablePropertyContextImpl.parseLong(value, name, JMSException.class);
        return result;
    }

    public Object getObjectProperty(String name) throws JMSException {
        Object result = this.properties.get(name);
        return result;
    }

    public Enumeration getPropertyNames() throws JMSException {
        final Iterator iterator = this.properties.keySet().iterator();
        Enumeration e = new Enumeration(){

            public boolean hasMoreElements() {
                boolean b = iterator.hasNext();
                return b;
            }

            public Object nextElement() {
                Object o = iterator.next();
                return o;
            }
        };
        return e;
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.getObjectProperty(name);
        short result = JmsReadablePropertyContextImpl.parseShort(value, name, JMSException.class);
        return result;
    }

    public String getStringProperty(String name) throws JMSException {
        Object obj = this.getObjectProperty(name);
        String value = null;
        value = obj instanceof String || obj == null ? (String)obj : (obj instanceof byte[] ? this.arrayToHexString((byte[])obj) : obj.toString());
        return value;
    }

    public boolean propertyExists(String name) throws JMSException {
        boolean result = this.properties.containsKey(name);
        if (Trace.isOn) {
            Trace.data(this, "propertyExists(String)", "via JmsReadablePropertyContextImpl", (Object)result);
        }
        return result;
    }

    static void throwBadConvertException(Object obj, String propName, String dType, Class exceptionClass) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "throwBadConvertException(Object,String,String,Class)", new Object[]{obj, propName, dType, exceptionClass});
        }
        String clsName = null;
        if (!(obj instanceof byte[])) {
            clsName = obj.getClass().getName();
            int index = 0;
            index = clsName.lastIndexOf(46);
            if (index != 0) {
                clsName = clsName.substring(index + 1);
            }
        } else {
            clsName = "Byte[]";
        }
        String msgId = "JMSCC0041";
        if (JMSException.class == exceptionClass) {
            msgId = "JMSCC0041";
        } else if (MessageFormatException.class == exceptionClass) {
            msgId = "JMSCC0105";
        } else {
            HashMap<String, Class> info = new HashMap<String, Class>();
            info.put("class", exceptionClass);
            Trace.ffst("JmsReadablePropertyContextImpl", "throwBadConvertException", "XJ002001", info, JMSException.class);
        }
        HashMap<String, String> inserts = new HashMap<String, String>();
        inserts.put("XMSC_INSERT_PROPERTY", propName);
        inserts.put("XMSC_INSERT_TYPE", clsName);
        inserts.put("XMSC_INSERT_OTHER_TYPE", dType);
        JMSException ex = (JMSException)((Object)JmsErrorUtils.createException(msgId, inserts));
        if (Trace.isOn) {
            Trace.throwing("com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "throwBadConvertException(Object,String,String,Class)", ex);
        }
        throw ex;
    }

    protected static boolean parseBoolean(Object obj, String name, Class exceptionClass) throws JMSException {
        boolean value = false;
        if (obj instanceof Boolean) {
            value = (Boolean)obj;
        } else if (obj instanceof String) {
            value = Boolean.valueOf((String)obj);
        } else if (obj == null) {
            value = Boolean.valueOf(null);
        } else {
            JmsReadablePropertyContextImpl.throwBadConvertException(obj, name, "Boolean", exceptionClass);
        }
        return value;
    }

    protected static byte parseByte(Object obj, String name, Class exceptionClass) throws JMSException {
        byte value = 0;
        if (obj instanceof Byte) {
            value = (Byte)obj;
        } else if (obj instanceof String) {
            value = Byte.parseByte((String)obj);
        } else if (obj == null) {
            value = Byte.valueOf(null);
        } else {
            JmsReadablePropertyContextImpl.throwBadConvertException(obj, name, "Byte", exceptionClass);
        }
        return value;
    }

    protected static double parseDouble(Object obj, String name, Class exceptionClass) throws JMSException {
        double value = 0.0;
        if (obj instanceof Double) {
            value = (Double)obj;
        } else if (obj instanceof String) {
            value = Double.parseDouble((String)obj);
        } else if (obj instanceof Float) {
            value = ((Float)obj).doubleValue();
        } else if (obj == null) {
            value = Double.valueOf(null);
        } else {
            JmsReadablePropertyContextImpl.throwBadConvertException(obj, name, "Double", exceptionClass);
        }
        return value;
    }

    protected static float parseFloat(Object obj, String name, Class exceptionClass) throws JMSException {
        float value = 0.0f;
        if (obj instanceof Float) {
            value = ((Float)obj).floatValue();
        } else if (obj instanceof String) {
            value = Float.parseFloat((String)obj);
        } else if (obj == null) {
            value = Float.valueOf(null).floatValue();
        } else {
            JmsReadablePropertyContextImpl.throwBadConvertException(obj, name, "Float", exceptionClass);
        }
        return value;
    }

    protected static int parseInt(Object obj, String name, Class exceptionClass) throws JMSException {
        int value = 0;
        if (obj instanceof Integer) {
            value = (Integer)obj;
        } else if (obj instanceof String) {
            value = Integer.parseInt((String)obj);
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).intValue();
        } else if (obj instanceof Short) {
            value = ((Short)obj).intValue();
        } else if (obj == null) {
            value = Integer.valueOf(null);
        } else {
            JmsReadablePropertyContextImpl.throwBadConvertException(obj, name, "Integer", exceptionClass);
        }
        return value;
    }

    protected static long parseLong(Object obj, String name, Class exceptionClass) throws JMSException {
        long value = 0L;
        if (obj instanceof Long) {
            value = (Long)obj;
        } else if (obj instanceof String) {
            value = Long.parseLong((String)obj);
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).longValue();
        } else if (obj instanceof Short) {
            value = ((Short)obj).longValue();
        } else if (obj instanceof Integer) {
            value = ((Integer)obj).longValue();
        } else if (obj == null) {
            value = Long.valueOf(null);
        } else {
            JmsReadablePropertyContextImpl.throwBadConvertException(obj, name, "Long", exceptionClass);
        }
        return value;
    }

    protected static short parseShort(Object obj, String name, Class exceptionClass) throws JMSException {
        short value = 0;
        if (obj instanceof Short) {
            value = (Short)obj;
        } else if (obj instanceof String) {
            value = Short.parseShort((String)obj);
        } else if (obj instanceof Byte) {
            value = ((Byte)obj).shortValue();
        } else if (obj == null) {
            value = Short.valueOf(null);
        } else {
            JmsReadablePropertyContextImpl.throwBadConvertException(obj, name, "Short", exceptionClass);
        }
        return value;
    }

    protected Map getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compareContexts(JmsReadablePropertyContextImpl a, JmsReadablePropertyContextImpl b) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "compareContexts(JmsReadablePropertyContextImpl,JmsReadablePropertyContextImpl)", new Object[]{a, b});
        }
        try {
            if (b == a) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "compareContexts(JmsReadablePropertyContextImpl,JmsReadablePropertyContextImpl)", true, 1);
                }
                boolean bl = true;
                return bl;
            }
            Map mapA = a.getProperties();
            Map mapB = b.getProperties();
            if (mapA.size() != mapB.size()) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "compareContexts(JmsReadablePropertyContextImpl,JmsReadablePropertyContextImpl)", false, 2);
                }
                boolean bl = false;
                return bl;
            }
            Iterator i = mapA.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Object key = e.getKey();
                String value = a.getStringProperty((String)key);
                if (value == null) {
                    if (b.getStringProperty((String)key) != null || !mapB.containsKey(key)) {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "compareContexts(JmsReadablePropertyContextImpl,JmsReadablePropertyContextImpl)", false, 3);
                        }
                        boolean bl = false;
                        return bl;
                    }
                } else if (!value.equals(b.getStringProperty((String)key))) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "compareContexts(JmsReadablePropertyContextImpl,JmsReadablePropertyContextImpl)", false, 4);
                    }
                    boolean bl = false;
                    return bl;
                }
                try {
                }
                catch (NullPointerException unused) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "compareContexts(JmsReadablePropertyContextImpl,JmsReadablePropertyContextImpl)", unused);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "compareContexts(JmsReadablePropertyContextImpl,JmsReadablePropertyContextImpl)", false, 5);
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "compareContexts(JmsReadablePropertyContextImpl,JmsReadablePropertyContextImpl)", true, 6);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (Trace.isOn) {
                Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "compareContexts(JmsReadablePropertyContextImpl,JmsReadablePropertyContextImpl)");
            }
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "readObjectNoData()");
        }
        this.properties = Collections.synchronizedMap(new HashMap());
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "readObjectNoData()");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "writeObject(ObjectOutputStream)", new Object[]{out});
        }
        this.flushPendingPropertyUpdates();
        out.defaultWriteObject();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "writeObject(ObjectOutputStream)");
        }
    }

    protected void flushPendingPropertyUpdates() {
    }

    public String toString() {
        TableBuilder builder = new TableBuilder();
        if (this.properties.containsKey("XMSC_PASSWORD")) {
            HashMap<String, String> propsNotPasswd = new HashMap<String, String>(this.properties);
            propsNotPasswd.put("XMSC_PASSWORD", "********");
            builder.append(this.getClass().getName(), propsNotPasswd);
        } else {
            builder.append(this.getClass().getName(), this.properties);
        }
        String result = builder.toString();
        return result;
    }

    private String arrayToHexString(byte[] array) {
        String retVal;
        if (array != null) {
            StringBuffer hexString = new StringBuffer(array.length);
            for (int i = 0; i < array.length; ++i) {
                int hexVal = (array[i] & 0xF0) >> 4;
                char hexChar = (char)(hexVal > 9 ? 65 + (hexVal - 10) : 48 + hexVal);
                hexString.append(hexChar);
                hexVal = array[i] & 0xF;
                hexChar = (char)(hexVal > 9 ? 65 + (hexVal - 10) : 48 + hexVal);
                hexString.append(hexChar);
            }
            retVal = hexString.toString();
        } else {
            retVal = "<null>";
        }
        return retVal;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsReadablePropertyContextImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.38.1.8 10/04/22 16:11:05");
        }
    }
}

