/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.ReentrantMutex;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsQueueBrowser;
import com.ibm.msg.client.jms.admin.JmsDestinationImpl;
import com.ibm.msg.client.jms.internal.JmsDestinationImplProxy;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.jms.internal.State;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderQueueBrowser;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;

public class JmsQueueBrowserImpl
extends JmsPropertyContextImpl
implements JmsQueueBrowser {
    private static final long serialVersionUID = -2524264664543657143L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private JmsQueue queue;
    private String selector;
    private ProviderQueueBrowser providerQueueBrowser;
    private JmsSessionImpl session;
    private State state = new State(1);
    private ReentrantMutex sessionSyncMutex;
    private Vector enums = new Vector();

    JmsQueueBrowserImpl(JmsSessionImpl session, JmsQueue queue, String selector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "<init>(JmsSessionImpl,JmsQueue,String)", new Object[]{session, queue, selector});
        }
        try {
            this.setLongProperty("OBJECT_IDENTITY", System.identityHashCode(this));
        }
        catch (JMSException e) {
            // empty catch block
        }
        this.queue = queue;
        this.selector = selector;
        this.session = session;
        this.sessionSyncMutex = session.getSessionSyncMutex();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "<init>(JmsSessionImpl,JmsQueue,String)");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "close()");
        }
        this.close(false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean closingFromSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "close(boolean)", new Object[]{closingFromSession});
        }
        if (!this.session.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            if (this.state.close()) {
                if (Trace.isOn) {
                    Trace.data(this, "close(boolean)", "browser already closed", null);
                }
            } else {
                JmsDestinationImplProxy.decrementUseCount((JmsDestinationImpl)((Object)this.queue));
                for (int i = 0; i < this.enums.size(); ++i) {
                    JmsEnumImpl jmsEnum = (JmsEnumImpl)this.enums.get(i);
                    jmsEnum.close();
                }
                this.enums.clear();
                this.session.removeBrowser(this);
                this.providerQueueBrowser.close(closingFromSession);
            }
            Object var5_4 = null;
            if (!this.session.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!this.session.isAsync()) {
                this.sessionSyncMutex.release();
            }
            throw throwable;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "close(boolean)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getEnumeration() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "getEnumeration()");
        }
        JmsEnumImpl jmsEnum = null;
        this.sessionSyncMutex.acquire(-1);
        try {
            this.state.checkNotClosed("JMSCC0055");
            Enumeration providerEnum = this.providerQueueBrowser.getEnumeration();
            jmsEnum = new JmsEnumImpl(providerEnum);
            this.enums.add(jmsEnum);
        }
        finally {
            this.sessionSyncMutex.release();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "getEnumeration()", jmsEnum);
        }
        return jmsEnum;
    }

    public String getMessageSelector() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "getMessageSelector()", "getter", this.selector);
        }
        return this.selector;
    }

    public Queue getQueue() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "getQueue()", "getter", this.queue);
        }
        return this.queue;
    }

    public ProviderQueueBrowser getProviderBrowser() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "getProviderBrowser()", "getter", this.providerQueueBrowser);
        }
        return this.providerQueueBrowser;
    }

    public void setProviderBrowser(ProviderQueueBrowser providerQueueBrowser) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "setProviderBrowser(ProviderQueueBrowser)", "setter", providerQueueBrowser);
        }
        this.providerQueueBrowser = providerQueueBrowser;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JmsQueueBrowserImpl)) {
            return false;
        }
        JmsQueueBrowserImpl other = (JmsQueueBrowserImpl)obj;
        if (!this.queue.equals(other.queue)) {
            return false;
        }
        if (this.selector == null && other.selector == null) {
            return true;
        }
        return this.selector != null && this.selector.equals(other.selector);
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsQueueBrowserImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.32.1.6 11/09/07 15:24:30");
        }
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "static()");
        }
        if (Trace.isOn) {
            Trace.data("c.i.m.c.jms.internal.JmsQueueBrowserImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsQueueBrowserImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.32.1.6 11/09/07 15:24:30");
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.internal.JmsQueueBrowserImpl", "static()");
        }
    }

    class MessageConversionFailed
    extends RuntimeException {
        private static final long serialVersionUID = 5625335485005971594L;

        public MessageConversionFailed(String message, Throwable cause) {
            super(message, cause);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.MessageConversionFailed", "<init>(String,Throwable)", new Object[]{message, cause});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.MessageConversionFailed", "<init>(String,Throwable)");
            }
        }

        public MessageConversionFailed(Throwable cause) {
            super(cause);
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.MessageConversionFailed", "<init>(Throwable)", new Object[]{cause});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.MessageConversionFailed", "<init>(Throwable)");
            }
        }
    }

    class JmsEnumImpl
    implements Enumeration {
        private Enumeration providerEnum;
        private State state = new State(1);

        JmsEnumImpl(Enumeration providerEnum) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "<init>(Enumeration)", new Object[]{providerEnum});
            }
            this.providerEnum = providerEnum;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "<init>(Enumeration)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreElements() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "hasMoreElements()");
            }
            boolean more = false;
            JmsQueueBrowserImpl.this.sessionSyncMutex.acquire(-1);
            try {
                if (this.state.getState() == 3 || this.state.getState() == 4) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "hasMoreElements()", false, 1);
                    }
                    boolean bl = false;
                    return bl;
                }
                more = this.providerEnum.hasMoreElements();
            }
            finally {
                JmsQueueBrowserImpl.this.sessionSyncMutex.release();
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "hasMoreElements()", more, 2);
            }
            return more;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "nextElement()");
            }
            JmsQueueBrowserImpl.this.sessionSyncMutex.acquire(-1);
            try {
                Message jmsMessage = null;
                if (this.state.getState() == 3) {
                    IllegalStateException ise = (IllegalStateException)JmsErrorUtils.createException("JMSCC0055", null);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "nextElement()", ise, 1);
                    }
                    throw ise;
                }
                if (this.hasMoreElements()) {
                    ProviderMessage nextProviderMessage = (ProviderMessage)this.providerEnum.nextElement();
                    try {
                        jmsMessage = JmsMessageImpl.inboundJmsInstance(nextProviderMessage, null, JmsQueueBrowserImpl.this.session.getConnectionTypeName());
                    }
                    catch (JMSException jmse) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "nextElement()", jmse);
                        }
                        HashMap<String, JMSException> inserts = new HashMap<String, JMSException>();
                        inserts.put("XMSC_INSERT_EXCEPTION", jmse);
                        MessageConversionFailed mcf = (MessageConversionFailed)JmsErrorUtils.createException("JMSCC0040", inserts);
                        if (Trace.isOn) {
                            Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "nextElement()", mcf, 2);
                        }
                        throw mcf;
                    }
                }
                if (jmsMessage == null) {
                    NoSuchElementException nsee = (NoSuchElementException)JmsErrorUtils.createException("JMSCC0054", null);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "nextElement()", nsee, 3);
                    }
                    throw nsee;
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "nextElement()", jmsMessage);
                }
                Message message = jmsMessage;
                return message;
            }
            finally {
                JmsQueueBrowserImpl.this.sessionSyncMutex.release();
            }
        }

        public void close() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "close()");
            }
            this.state.close();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsEnumImpl", "close()");
            }
        }
    }
}

