/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueManager;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.provider.ProviderExceptionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

class JmsProviderExceptionListener
implements ProviderExceptionListener,
Runnable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsProviderExceptionListener.java, jmscc.jms.internal, k701, k701-112-140304 1.13.1.3 11/10/28 15:57:43";
    static final int STATE_IDLE = 0;
    static final int STATE_DELIVERYINPROGRESS = 1;
    static final int STATE_DELIVERYPAUSING = 2;
    static final int STATE_DELIVERYPAUSED = 3;
    private int state = 0;
    private volatile boolean connectionBrokenExReceived = false;
    private Thread activeDeliveryThread = null;
    private ExceptionListener eListener = null;
    private Vector exceptions = null;
    private Object lock = null;
    private int asyncExceptionFlags = -1;

    public JmsProviderExceptionListener(int asyncExceptionFlags) {
        this(asyncExceptionFlags, null);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "<init>(int)", new Object[]{new Integer(asyncExceptionFlags)});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "<init>(int)");
        }
    }

    public JmsProviderExceptionListener(int asyncExceptionFlags, ExceptionListener listener) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "<init>(int,ExceptionListener)", new Object[]{new Integer(asyncExceptionFlags), listener});
        }
        this.asyncExceptionFlags = asyncExceptionFlags;
        this.eListener = listener;
        this.lock = new Object();
        this.exceptions = new Vector();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "<init>(int,ExceptionListener)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionListener(ExceptionListener listener) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "setExceptionListener(ExceptionListener)", new Object[]{listener});
        }
        if (listener == this.eListener && !this.connectionBrokenExReceived) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "setExceptionListener(ExceptionListener)", 1);
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.state != 0 && this.state != 1) {
                if (Trace.isOn) {
                    Trace.traceData(this, "setExceptionListener(ExceptionListener)", "Concurrent use - ignored", null);
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "setExceptionListener(ExceptionListener)", 2);
                }
                return;
            }
            if (this.state == 1 && this.activeDeliveryThread != Thread.currentThread()) {
                block20: {
                    if (Trace.isOn) {
                        Trace.traceData(this, "setExceptionListener(ExceptionListener)", "Pausing exception delivery", null);
                    }
                    this.state = 2;
                    try {
                        this.lock.wait(10000L);
                    }
                    catch (InterruptedException ie) {
                        if (!Trace.isOn) break block20;
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "setExceptionListener(ExceptionListener)", ie);
                    }
                }
                if (this.state == 2) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "setExceptionListener(ExceptionListener)", "Pause failed - continuing", null);
                    }
                    this.state = 1;
                }
            }
            this.eListener = listener;
            this.connectionBrokenExReceived = false;
            if (this.state != 1) {
                if (this.exceptions.size() > 0) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "setExceptionListener(ExceptionListener)", "Creating new work item to re-start delivery of remaining exceptions", null);
                    }
                    this.queueWorkItem();
                    this.state = 1;
                } else {
                    this.state = 0;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "setExceptionListener(ExceptionListener)", 3);
        }
    }

    public ExceptionListener getExceptionListener() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "getExceptionListener()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "getExceptionListener()", this.eListener);
        }
        return this.eListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException exception, boolean connectionBroken) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "onException(JMSException,boolean)", new Object[]{exception, connectionBroken});
        }
        Object object = this.lock;
        synchronized (object) {
            if (exception == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "onException(JMSException, boolean)", "Null Exception", null);
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "onException(JMSException,boolean)", 1);
                }
                return;
            }
            if (this.eListener == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "onException(JMSException, boolean)", "No listener  - Exception ignored", (Object)exception);
                }
                HashMap<String, JMSException> inserts = new HashMap<String, JMSException>();
                inserts.put("XMSC_INSERT_EXCEPTION", exception);
                JmsErrorUtils.log(this, "onException(JMSException, boolean)", "JMSCC3034", inserts);
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "onException(JMSException,boolean)", 2);
                }
                return;
            }
            if (this.connectionBrokenExReceived) {
                if (Trace.isOn) {
                    Trace.traceData(this, "onException(JMSException, boolean)", "connection already broken - Exception ignored", (Object)exception);
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "onException(JMSException,boolean)", 3);
                }
                return;
            }
            if (connectionBroken) {
                if (Trace.isOn) {
                    Trace.traceData(this, "onException(JMSException, boolean)", "Connection broken exception received", null);
                }
                this.connectionBrokenExReceived = true;
            }
            int exTypeFlags = -1;
            if (!connectionBroken) {
                exTypeFlags ^= 1;
            }
            if ((exTypeFlags & this.asyncExceptionFlags) == 0) {
                if (Trace.isOn) {
                    Trace.traceData(this, "onException(JMSException, boolean)", "Exception type not required for listener - ignored", (Object)exception);
                }
                HashMap<String, JMSException> inserts = new HashMap<String, JMSException>();
                inserts.put("XMSC_INSERT_EXCEPTION", exception);
                JmsErrorUtils.log(this, "onException(JMSException, boolean)", "JMSCC3035", inserts);
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "onException(JMSException,boolean)", 4);
                }
                return;
            }
            HashMap<String, JMSException> inserts = new HashMap<String, JMSException>();
            inserts.put("XMSC_INSERT_EXCEPTION", exception);
            JmsErrorUtils.log(this, "onException(JMSException, boolean)", "JMSCC3036", inserts);
            this.exceptions.add(exception);
            if (this.state == 0) {
                if (Trace.isOn) {
                    Trace.traceData(this, "onException(JMSException, boolean)", "Starting new work item to deliver exception", null);
                }
                this.queueWorkItem();
                this.state = 1;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "onException(JMSException,boolean)", 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "run()");
        }
        while (true) {
            JMSException userException;
            Object object = this.lock;
            synchronized (object) {
                if (this.state == 2) {
                    this.state = 3;
                    this.lock.notify();
                    this.activeDeliveryThread = null;
                    break;
                }
                if (this.exceptions.size() == 0) {
                    this.activeDeliveryThread = null;
                    this.state = 0;
                    break;
                }
                userException = (JMSException)((Object)this.exceptions.remove(0));
                if (this.activeDeliveryThread == null) {
                    this.activeDeliveryThread = Thread.currentThread();
                }
            }
            ExceptionListener el = this.eListener;
            if (el == null) continue;
            try {
                if (Trace.isOn) {
                    Trace.traceData(this, "run()", "Delivering Exception to listener", (Object)new Object[]{el});
                }
                el.onException(userException);
                if (!Trace.isOn) continue;
                Trace.traceData(this, "run()", "Delivered Exception to listener", null);
            }
            catch (Throwable e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "run()", e);
                }
                HashMap<String, Object> ffstData = new HashMap<String, Object>();
                ffstData.put("Exception", e);
                ffstData.put("Message", "JMSCC1026");
                Trace.ffst(this, "run()", "XJ008001", ffstData, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "run()");
        }
    }

    private void queueWorkItem() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "queueWorkItem()");
        }
        try {
            WorkQueueManager.enqueue(this);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "queueWorkItem()", e);
            }
            HashMap<String, Object> ffstData = new HashMap<String, Object>();
            ffstData.put("Exception", e);
            ffstData.put("Message", "JMSCC1027");
            Trace.ffst(this, "onException(JMSException)", "XJ008002", ffstData, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "queueWorkItem()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsProviderExceptionListener", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsProviderExceptionListener.java, jmscc.jms.internal, k701, k701-112-140304  1.13.1.3 11/10/28 15:57:43");
        }
    }
}

