/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsPropertyCacheInterface;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.jms.JmsValidationInterface;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl;
import com.ibm.msg.client.provider.ProviderConnectionFactory;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.provider.ProviderPropertyContextCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.jms.JMSException;

public class JmsPropertyContextImpl
extends JmsReadablePropertyContextImpl
implements JmsPropertyContext,
ProviderPropertyContextCallback,
Map {
    protected boolean settingDefaults = false;
    private static final long serialVersionUID = 5430741298380246575L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsPropertyContextImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.54.1.2 09/11/17 10:52:14";
    private transient JmsPropertyContext providerPropertyContext;
    private transient boolean providerCacheSynched;

    public JmsPropertyContextImpl() {
    }

    public JmsPropertyContextImpl(Map propsTable, boolean doCopy) {
        super(propsTable, doCopy);
        if (Trace.isOn) {
            if (propsTable.containsKey("XMSC_PASSWORD")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(propsTable);
                propsNotPasswd.put("XMSC_PASSWORD", "********");
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "<init>(Map,boolean)", new Object[]{propsNotPasswd, doCopy});
            } else {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "<init>(Map,boolean)", new Object[]{propsTable, doCopy});
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "<init>(Map,boolean)");
        }
    }

    public void setProviderPropertyContext(JmsPropertyContext providerPropertyContext) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setProviderPropertyContext(JmsPropertyContext)", "setter", providerPropertyContext);
        }
        this.providerPropertyContext = providerPropertyContext;
        if (this.isProviderCachingEnabled()) {
            this.initCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBatchProperties(Map properties) throws JMSException {
        if (Trace.isOn) {
            if (properties.containsKey("XMSC_PASSWORD")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(properties);
                propsNotPasswd.put("XMSC_PASSWORD", "********");
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setBatchProperties(Map)", new Object[]{propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setBatchProperties(Map)", new Object[]{properties});
            }
        }
        Map map = super.getProperties();
        synchronized (map) {
            Object oldObject;
            Map oldProperties = Collections.synchronizedMap(new HashMap());
            Iterator keys = properties.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                Object oldObject2 = this.getObjectProperty((String)key);
                oldProperties.put(key, oldObject2);
                this.setObjectPropertyInternal((String)key, properties.get(key), false);
            }
            boolean validationSuccessful = true;
            Vector<String> failedValidations = new Vector<String>();
            keys = properties.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                if (this.providerPropertyContext instanceof ProviderDestination || this.providerPropertyContext instanceof ProviderConnectionFactory) {
                    boolean newStyleVal = true;
                    try {
                        newStyleVal = ((JmsValidationInterface)((Object)this.providerPropertyContext)).validate(key, properties.get(key));
                    }
                    catch (JMSException j) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setBatchProperties(Map)", j, 1);
                        }
                        newStyleVal = false;
                    }
                    if (newStyleVal) continue;
                    validationSuccessful = false;
                    failedValidations.add(key + " (" + properties.get(key) + ")");
                    continue;
                }
                try {
                    this.validateProperty((String)key, properties.get(key));
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setBatchProperties(Map)", je, 2);
                    }
                    validationSuccessful = false;
                    failedValidations.add(key + " (" + properties.get(key) + ")");
                }
            }
            String crossPropertyValidationSuccessful = null;
            if (this.providerPropertyContext instanceof ProviderDestination || this.providerPropertyContext instanceof ProviderConnectionFactory) {
                crossPropertyValidationSuccessful = ((JmsValidationInterface)((Object)this.providerPropertyContext)).crossPropertyValidate();
            }
            if (!validationSuccessful) {
                keys = oldProperties.keySet().iterator();
                while (keys.hasNext()) {
                    Object key = keys.next();
                    oldObject = oldProperties.get(key);
                    this.setObjectPropertyInternal((String)key, oldObject, false);
                }
                if (failedValidations.size() > 0) {
                    String error = "";
                    for (int i = 0; i < failedValidations.size(); ++i) {
                        error = error + failedValidations.get(i);
                        if (i + 1 >= failedValidations.size()) continue;
                        error = error + ", ";
                    }
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_INSERT_PROPERTY", error);
                    JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3041", inserts));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setBatchProperties(Map)", je, 1);
                    }
                    throw je;
                }
            }
            if (crossPropertyValidationSuccessful != null) {
                keys = oldProperties.keySet().iterator();
                while (keys.hasNext()) {
                    Object key = keys.next();
                    oldObject = oldProperties.get(key);
                    this.setObjectPropertyInternal((String)key, oldObject, false);
                }
                String error = "Cross-property validation failed for " + crossPropertyValidationSuccessful;
                JMSException je = new JMSException(error);
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setBatchProperties(Map)", je, 2);
                }
                throw je;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setBatchProperties(Map)");
        }
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setObjectProperty(name, new Boolean(value));
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, new Byte(value));
    }

    public void setBytesProperty(String name, byte[] value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setCharProperty(String name, char value) throws JMSException {
        this.setObjectProperty(name, new Character(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, new Double(value));
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, new Float(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, new Long(value));
    }

    private void setObjectPropertyInternal(String name, Object value, boolean validationEnabled) throws JMSException {
        boolean validationSuccessful;
        boolean useCommonValidation = false;
        boolean useProviderValidation = false;
        boolean useProviderNameMapping = false;
        boolean useProviderCaching = false;
        if (this.providerPropertyContext instanceof ProviderDestination || this.providerPropertyContext instanceof ProviderConnectionFactory) {
            useProviderValidation = true;
            useProviderNameMapping = true;
            useProviderCaching = true;
        } else if (this.providerPropertyContext instanceof ProviderMessageProducer) {
            useCommonValidation = true;
            useProviderValidation = true;
        } else {
            useCommonValidation = true;
        }
        if (this.settingDefaults) {
            validationEnabled = false;
        }
        if (useCommonValidation && name != null && validationEnabled) {
            this.validateProperty(name, value);
        }
        if (useProviderValidation && name != null && validationEnabled && !(validationSuccessful = ((JmsValidationInterface)((Object)this.providerPropertyContext)).validate(name, value))) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_NAME", name);
            inserts.put("XMSC_INSERT_VALUE", value == null ? "<null>" : value.toString());
            JMSException validationException = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0005", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "c.i.m.c.jms.internal.JmsPropertyContextImpl", "setObjectPropertyInternal(String,Object,boolean)", validationException, 1);
            }
            throw validationException;
        }
        String canonicalName = name;
        Object canonicalValue = value;
        Vector mapResult = null;
        if (useProviderNameMapping && (mapResult = ((JmsValidationInterface)((Object)this.providerPropertyContext)).mapToCanonical(name, value)) != null) {
            canonicalName = (String)mapResult.get(0);
            canonicalValue = mapResult.get(1);
        }
        boolean cacheSetOk = false;
        if (useProviderCaching) {
            cacheSetOk = ((JmsPropertyCacheInterface)((Object)this.providerPropertyContext)).setCachedValue(canonicalName, canonicalValue);
        }
        if (cacheSetOk) {
            this.providerCacheSynched = false;
        } else {
            super.getProperties().put(canonicalName, canonicalValue);
            if (mapResult != null && mapResult.size() > 2) {
                for (int index = 2; index < mapResult.size(); index += 2) {
                    super.getProperties().put((String)mapResult.get(index), mapResult.get(index + 1));
                }
            }
        }
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "getObjectProperty(String)", "via JmsPropertyContextImpl", (Object)name);
        }
        if (!(this.providerPropertyContext instanceof ProviderDestination) && !(this.providerPropertyContext instanceof ProviderConnectionFactory)) {
            Object result = super.getObjectProperty(name);
            return result;
        }
        if (this.providerPropertyContext != null) {
            String canonicalKey;
            Object canonicalValue;
            Object quickValue = ((JmsPropertyCacheInterface)((Object)this.providerPropertyContext)).getCachedValue(name);
            if (quickValue != null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "getObjectProperty(String)", (Object)"Returning cached value.");
                }
                return quickValue;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "getObjectProperty(String)", (Object)"Performing property mapping.");
            }
            if ((canonicalValue = ((JmsPropertyCacheInterface)((Object)this.providerPropertyContext)).getCachedValue(canonicalKey = ((JmsValidationInterface)((Object)this.providerPropertyContext)).getCanonicalKey(name))) == null) {
                canonicalValue = super.getProperties().get(canonicalKey);
            }
            Object returnValue = ((JmsValidationInterface)((Object)this.providerPropertyContext)).mapFromCanonical(name, canonicalValue);
            return returnValue;
        }
        Object other = super.getObjectProperty(name);
        return other;
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            if ("XMSC_PASSWORD".equals(name)) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setObjectProperty(String,Object)", new Object[]{name, "********"});
            } else {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setObjectProperty(String,Object)", new Object[]{name, value});
            }
        }
        try {
            this.setObjectPropertyInternal(name, value, true);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setObjectProperty(String,Object)", e);
            }
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setObjectProperty(String,Object)", e);
            }
            throw e;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "setObjectProperty(String,Object)");
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "setShortProperty(String,short)", "via JmsPropertyContextImpl", (Object)name);
        }
        this.setObjectProperty(name, new Short(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public boolean propertyExists(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "propertyExists(String)", new Object[]{name});
        }
        boolean traceRet1 = false;
        if (this.providerPropertyContext instanceof JmsPropertyCacheInterface) {
            traceRet1 = ((JmsPropertyCacheInterface)((Object)this.providerPropertyContext)).containsCachedValue(name);
        }
        if (!traceRet1) {
            traceRet1 = super.propertyExists(name);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "propertyExists(String)", traceRet1);
        }
        return traceRet1;
    }

    protected void flushPendingPropertyUpdates() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "flushPendingPropertyUpdates()");
        }
        if (this.isProviderCachingEnabled()) {
            this.flushCache();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "flushPendingPropertyUpdates()");
        }
    }

    protected void validateProperty(String name, Object value) throws JMSException {
    }

    protected Map getProperties() {
        if (this.isProviderCachingEnabled()) {
            this.flushCache();
        }
        Map map = super.getProperties();
        return map;
    }

    protected void initCache() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "initCache()");
        }
        Map m = super.getProperties();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            ((JmsPropertyCacheInterface)((Object)this.providerPropertyContext)).setCachedValue((String)key, m.get(key));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "initCache()");
        }
    }

    protected void flushCache() {
        boolean isProviderCachingEnabled = this.isProviderCachingEnabled();
        if (isProviderCachingEnabled && !this.providerCacheSynched) {
            if (Trace.isOn) {
                Trace.data(this, "flushCache()", "Synchronising the current provider cache into the propertyContext", null);
            }
            Map pc = super.getProperties();
            ((JmsPropertyCacheInterface)((Object)this.providerPropertyContext)).getCachedValueAll(pc);
            this.providerCacheSynched = true;
        }
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "clear()");
        }
        if (this.providerPropertyContext instanceof JmsPropertyCacheInterface) {
            ((JmsPropertyCacheInterface)((Object)this.providerPropertyContext)).clearCachedValueAll();
        }
        this.getProperties().clear();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "clear()");
        }
    }

    public boolean containsKey(Object key) {
        boolean result = this.getProperties().containsKey(key);
        return result;
    }

    public boolean containsValue(Object value) {
        boolean result = this.getProperties().containsValue(value);
        return result;
    }

    public Set entrySet() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "entrySet()");
        }
        Map props = this.getProperties();
        Set traceRet1 = props.entrySet();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "entrySet()", "@" + Integer.toHexString(System.identityHashCode(traceRet1)));
        }
        return traceRet1;
    }

    public Object get(Object key) {
        Object traceRet1 = this.getProperties().get(key);
        return traceRet1;
    }

    public boolean isEmpty() {
        boolean traceRet1 = this.getProperties().isEmpty();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "isEmpty()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public Set keySet() {
        Set result = this.getProperties().keySet();
        return result;
    }

    public Object put(Object arg0, Object arg1) {
        if (Trace.isOn) {
            if ("XMSC_PASSWORD".equals(arg0)) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "put(Object,Object)", new Object[]{arg0, "********"});
            } else {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "put(Object,Object)", new Object[]{arg0, arg1});
            }
        }
        Object traceRet1 = null;
        try {
            traceRet1 = this.getObjectProperty(arg0.toString());
            this.setObjectProperty(arg0.toString(), arg1);
        }
        catch (JMSException e) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("arg0", arg0);
            map.put("arg1", arg1);
            map.put("exception", (Object)e);
            Trace.ffst(this, "put(Object arg0, Object arg1)", "XJ00A001", map, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "put(Object,Object)", traceRet1);
        }
        return traceRet1;
    }

    public void putAll(Map arg0) {
        if (Trace.isOn) {
            if (arg0.containsKey("XMSC_PASSWORD")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(arg0);
                propsNotPasswd.put("XMSC_PASSWORD", "********");
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "putAll(Map)", new Object[]{propsNotPasswd});
            } else {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "putAll(Map)", new Object[]{arg0});
            }
        }
        Set entrySet = arg0.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                this.setObjectProperty((String)entry.getKey(), entry.getValue());
            }
            catch (JMSException e) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("arg0", arg0);
                map.put("exception", (Object)e);
                Trace.ffst(this, "putAll(Map arg0)", "XJ00A002", map, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "putAll(Map)");
        }
    }

    public Object remove(Object key) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "remove(Object)", new Object[]{key});
        }
        if (this.providerPropertyContext instanceof JmsPropertyCacheInterface) {
            ((JmsPropertyCacheInterface)((Object)this.providerPropertyContext)).clearCachedValue((String)key);
        }
        Object traceRet1 = this.getProperties().remove(key);
        if (Trace.isOn) {
            if ("XMSC_PASSWORD".equals(key)) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "remove(Object)", "********");
            } else {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "remove(Object)", traceRet1);
            }
        }
        return traceRet1;
    }

    public int size() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "size()");
        }
        int traceRet1 = this.getProperties().size();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "size()", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Collection values() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "values()");
        }
        Map props = this.getProperties();
        Collection traceRet1 = props.values();
        if (Trace.isOn) {
            if (props.containsKey("XMSC_PASSWORD")) {
                HashMap<String, String> propsNotPasswd = new HashMap<String, String>(props);
                propsNotPasswd.put("XMSC_PASSWORD", "********");
                Collection clln = propsNotPasswd.values();
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "values()", clln);
            } else {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "values()", traceRet1);
            }
        }
        return traceRet1;
    }

    private boolean isProviderCachingEnabled() {
        return (this.providerPropertyContext instanceof ProviderDestination || this.providerPropertyContext instanceof ProviderConnectionFactory) && this.providerPropertyContext instanceof JmsPropertyCacheInterface;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsPropertyContextImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsPropertyContextImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.54.1.2 09/11/17 10:52:14");
        }
    }
}

