/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsObjectInputStream;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderObjectMessage;
import com.ibm.msg.client.provider.ProviderSelfSerializingObjectMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class JmsObjectMessageImpl
extends JmsMessageImpl
implements ObjectMessage {
    private static final long serialVersionUID = 718892436974350599L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsObjectMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.27.1.2 10/12/06 11:23:17";
    ProviderObjectMessage providerObjectMessage;
    private transient String cachedObjectToString = null;

    public JmsObjectMessageImpl(JmsSessionImpl session) throws JMSException {
        super(session);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "<init>(JmsSessionImpl)", new Object[]{session});
        }
        this.providerObjectMessage = (ProviderObjectMessage)this.getProviderMessage();
        this.messageType = "jms_object";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "<init>(JmsSessionImpl)");
        }
    }

    public JmsObjectMessageImpl(String connectionType) throws JMSException {
        super(connectionType);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "<init>(String)", new Object[]{connectionType});
        }
        this.providerObjectMessage = (ProviderObjectMessage)this.getProviderMessage();
        this.messageType = "jms_object";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "<init>(String)");
        }
    }

    public JmsObjectMessageImpl(JmsSessionImpl session, Serializable serializedObj) throws JMSException {
        this(session);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "<init>(JmsSessionImpl,Serializable)", new Object[]{session, serializedObj});
        }
        this.messageType = "jms_object";
        this.setObject(serializedObj);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "<init>(JmsSessionImpl,Serializable)");
        }
    }

    public JmsObjectMessageImpl(ProviderObjectMessage newMsg, JmsSessionImpl newSess, String connectionTypeName) throws JMSException {
        super(newMsg, newSess, connectionTypeName);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "<init>(ProviderObjectMessage,JmsSessionImpl,String)", new Object[]{newMsg, newSess, connectionTypeName});
        }
        this.providerObjectMessage = newMsg;
        this.messageType = "jms_object";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "<init>(ProviderObjectMessage,JmsSessionImpl,String)");
        }
    }

    JmsObjectMessageImpl(JmsSessionImpl session, ObjectMessage objectMessage) throws JMSException {
        super(session, (Message)objectMessage);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "<init>(JmsSessionImpl,ObjectMessage)", new Object[]{session, objectMessage});
        }
        this.providerObjectMessage = (ProviderObjectMessage)this.getProviderMessage();
        this.messageType = "jms_object";
        this.setObject(objectMessage.getObject());
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "<init>(JmsSessionImpl,ObjectMessage)");
        }
    }

    public String toString() {
        String val = super.toString();
        if (this.cachedObjectToString == null) {
            String objString = null;
            Serializable obj = null;
            try {
                obj = this.getObjectInternal();
            }
            catch (Exception e) {
                String reason;
                objString = reason = JmsErrorUtils.getMessage("JMSCC0053", e.getClass().getName());
            }
            if (objString == null) {
                objString = obj == null ? "<null>" : obj.getClass().toString();
            }
            this.cachedObjectToString = objString;
        }
        String traceRet1 = val + "\n" + this.cachedObjectToString;
        return traceRet1;
    }

    public void setObjectAsBytes(byte[] bytes) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "setObjectAsBytes(byte[])", new Object[]{bytes});
        }
        this.providerObjectMessage.setSerializedObject(bytes);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "setObjectAsBytes(byte[])");
        }
    }

    public void setObject(Serializable obj) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "setObject(Serializable)", new Object[]{obj});
        }
        try {
            this.checkBodyWriteable("setObject");
            if (this.providerObjectMessage instanceof ProviderSelfSerializingObjectMessage) {
                ((ProviderSelfSerializingObjectMessage)this.providerObjectMessage).setSelfSerializedObject(obj);
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                this.providerObjectMessage.setSerializedObject(baos.toByteArray());
            }
            this.cachedObjectToString = null;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "setObject(Serializable)", e);
            }
            HashMap<String, IOException> inserts = new HashMap<String, IOException>();
            inserts.put("XMSC_INSERT_EXCEPTION", e);
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0052", inserts));
            je.setLinkedException((Exception)e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "setObject(Serializable)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "setObject(Serializable)");
        }
    }

    public Serializable getObject() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "getObject()");
        }
        Serializable obj = null;
        try {
            obj = this.getObjectInternal();
        }
        catch (ClassNotFoundException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "getObject()", e, 1);
            }
            HashMap<String, ClassNotFoundException> inserts = new HashMap<String, ClassNotFoundException>();
            inserts.put("XMSC_INSERT_EXCEPTION", e);
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0053", inserts));
            je.setLinkedException((Exception)e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "getObject()", je, 1);
            }
            throw je;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "getObject()", e, 2);
            }
            HashMap<String, Exception> inserts = new HashMap<String, Exception>();
            inserts.put("XMSC_INSERT_EXCEPTION", e);
            JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0053", inserts));
            je2.setLinkedException(e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "getObject()", je2, 2);
            }
            throw je2;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "getObject()", obj);
        }
        return obj;
    }

    private Serializable getObjectInternal() throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "getObjectInternal()");
        }
        Serializable obj = null;
        if (this.providerObjectMessage instanceof ProviderSelfSerializingObjectMessage) {
            obj = ((ProviderSelfSerializingObjectMessage)this.providerObjectMessage).getSelfSerializedObject();
        } else {
            byte[] byteForm = this.providerObjectMessage.getSerializedObject();
            if (byteForm != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(byteForm);
                JmsObjectInputStream ois = new JmsObjectInputStream(bais);
                obj = (Serializable)ois.readObject();
                bais = null;
                ois = null;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "getObjectInternal()", obj);
        }
        return obj;
    }

    protected ProviderMessage createProviderMessage(JmsSessionImpl session) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "createProviderMessage(JmsSessionImpl)", new Object[]{session});
        }
        this.providerObjectMessage = session != null ? this.providerMessageFactory.createObjectMessage(session.getProviderSession()) : this.providerMessageFactory.createObjectMessage(null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "createProviderMessage(JmsSessionImpl)", this.providerObjectMessage);
        }
        return this.providerObjectMessage;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsObjectMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsObjectMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.27.1.2 10/12/06 11:23:17");
        }
    }
}

