/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsMessageReference;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageReference;
import javax.jms.JMSException;
import javax.jms.Message;

public class JmsMessageReferenceImpl
implements JmsMessageReference {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ProviderMessageReference providerMessageReference;
    private Message message = null;
    private String connectionTypeName;

    JmsMessageReferenceImpl(String connectionTypeName, ProviderMessageReference providerMessageReference) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "<init>(String,ProviderMessageReference)", new Object[]{connectionTypeName, providerMessageReference});
        }
        this.connectionTypeName = connectionTypeName;
        this.providerMessageReference = providerMessageReference;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "<init>(String,ProviderMessageReference)");
        }
    }

    public int getDataQuantity() throws JMSException {
        int traceRet1 = this.providerMessageReference.getDataQuantity();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "getDataQuantity()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Message getMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "getMessage()");
        }
        if (null == this.message) {
            ProviderMessage pm = this.providerMessageReference.getMessage();
            if (null == pm) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "getMessage()", null, 1);
                }
                return null;
            }
            this.message = JmsMessageImpl.inboundJmsInstance(pm, null, this.connectionTypeName);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "getMessage()", this.message, 2);
        }
        return this.message;
    }

    Message getMessage(JmsSessionImpl session) throws JMSException {
        ProviderMessage providerMessage;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "getMessage(JmsSessionImpl)", new Object[]{session});
        }
        if (this.message == null && (providerMessage = this.providerMessageReference.getMessage()) != null) {
            this.message = JmsMessageImpl.inboundJmsInstance(providerMessage, session, this.connectionTypeName);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "getMessage(JmsSessionImpl)", this.message);
        }
        return this.message;
    }

    public byte[] flatten() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "flatten()");
        }
        byte[] traceRet1 = this.providerMessageReference.flatten();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "flatten()", traceRet1);
        }
        return traceRet1;
    }

    ProviderMessageReference getDelegate() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "getDelegate()", "getter", this.providerMessageReference);
        }
        return this.providerMessageReference;
    }

    public Object clone() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "clone()");
        }
        ProviderMessageReference other = (ProviderMessageReference)this.providerMessageReference.clone();
        JmsMessageReferenceImpl clone = new JmsMessageReferenceImpl(new String(this.connectionTypeName), other);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "clone()", clone);
        }
        return clone;
    }

    public int hashCode() {
        int hc = this.providerMessageReference.hashCode();
        return hc;
    }

    public boolean equals(Object other) {
        if (null == other || !(other instanceof JmsMessageReferenceImpl)) {
            return false;
        }
        JmsMessageReferenceImpl jmri = (JmsMessageReferenceImpl)other;
        if (null == jmri.providerMessageReference) {
            return false;
        }
        boolean equal = this.providerMessageReference.equals(jmri.providerMessageReference);
        return equal;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append("MessageReference(");
            buff.append(Integer.toHexString(System.identityHashCode(this)));
            buff.append(") connectionTypeName(");
            if (null == this.connectionTypeName) {
                buff.append("<null>");
            } else {
                buff.append(this.connectionTypeName);
            }
            buff.append(") message(");
            if (null == this.message) {
                buff.append("<null>");
            } else {
                buff.append(this.message.toString());
            }
            buff.append(") providerMessageReference(");
            if (null == this.providerMessageReference) {
                buff.append("<null>");
            } else {
                buff.append(this.providerMessageReference.toString());
            }
            buff.append(")");
        }
        catch (Throwable t) {
            buff.append("<ERROR>");
        }
        return buff.toString();
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsMessageReferenceImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.29.1.1 09/08/17 09:29:13");
        }
    }
}

