/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.ReentrantMutex;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsMessageProducer;
import com.ibm.msg.client.jms.admin.JmsDestinationImpl;
import com.ibm.msg.client.jms.internal.JmsDestinationImplProxy;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl;
import com.ibm.msg.client.jms.internal.JmsTemporaryTopicImpl;
import com.ibm.msg.client.jms.internal.State;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageProducer;
import com.ibm.msg.client.provider.ProviderSession;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class JmsMessageProducerImpl
extends JmsPropertyContextImpl
implements JmsMessageProducer {
    private static final long serialVersionUID = -1195401497038673446L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsMessageProducerImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.69.1.6 11/09/07 15:24:28";
    private static final int defaultDeliveryMode = 2;
    private static final int defaultPriority = 4;
    private static final long defaultTimeToLive = 0L;
    private static final boolean defaultDisableMessageTimestamp = false;
    private static final boolean defaultDisableMessageID = false;
    private JmsDestinationImpl destination;
    private ProviderMessageProducer providerProducer;
    private JmsSessionImpl session = null;
    protected State state = new State(1);
    private final ProducerProperties producerProps = new ProducerProperties();
    private ReentrantMutex sessionSyncMutex;

    protected JmsMessageProducerImpl(Destination dest, JmsSessionImpl session) throws JMSException {
        super(session, true);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "<init>(Destination,JmsSessionImpl)", new Object[]{dest, session});
        }
        this.setIntProperty("deliveryMode", 2);
        this.setIntProperty("priority", 4);
        this.setLongProperty("timeToLive", 0L);
        this.setBooleanProperty("XMSC_DISABLE_MSG_TS", false);
        this.setBooleanProperty("XMSC_DISABLE_MSG_ID", false);
        try {
            this.setLongProperty("OBJECT_IDENTITY", System.identityHashCode(this));
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.checkNotAlienDestination(dest);
        this.destination = (JmsDestinationImpl)dest;
        this.session = session;
        this.sessionSyncMutex = session.getSessionSyncMutex();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "<init>(Destination,JmsSessionImpl)");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "close()");
        }
        this.close(false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean closingFromSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "close(boolean)", new Object[]{closingFromSession});
        }
        if (!this.session.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            ReentrantMutex onMessageMutex = this.session.getOnMessageMutex();
            onMessageMutex.acquire(-1);
            try {
                if (this.state.close()) {
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "close(boolean)", 1);
                    }
                }
                if (this.providerProducer != null) {
                    this.providerProducer.close(closingFromSession);
                    this.session.removeProducer(this);
                }
            }
            finally {
                onMessageMutex.release();
            }
            Object var5_4 = null;
            if (!this.session.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!this.session.isAsync()) {
                this.sessionSyncMutex.release();
            }
            throw throwable;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "close(boolean)", 2);
        }
    }

    public int getDeliveryMode() throws JMSException {
        this.state.checkNotClosed("JMSCC0026");
        int dm = this.getIntProperty("deliveryMode");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "getDeliveryMode()", "getter", new Integer(dm));
        }
        return dm;
    }

    public Destination getDestination() throws JMSException {
        this.state.checkNotClosed("JMSCC0026");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "getDestination()", "getter", this.destination);
        }
        return this.destination;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.state.checkNotClosed("JMSCC0026");
        boolean disableMessageID = this.getBooleanProperty("XMSC_DISABLE_MSG_ID");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "getDisableMessageID()", "getter", disableMessageID);
        }
        return disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.state.checkNotClosed("JMSCC0026");
        boolean disableMessageTimestamp = this.getBooleanProperty("XMSC_DISABLE_MSG_TS");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "getDisableMessageTimestamp()", "getter", disableMessageTimestamp);
        }
        return disableMessageTimestamp;
    }

    public int getPriority() throws JMSException {
        this.state.checkNotClosed("JMSCC0026");
        int pri = this.getIntProperty("priority");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "getPriority()", "getter", new Integer(pri));
        }
        return pri;
    }

    public long getTimeToLive() throws JMSException {
        this.state.checkNotClosed("JMSCC0026");
        long ttl = this.getLongProperty("timeToLive");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "getTimeToLive()", "getter", new Long(ttl));
        }
        return ttl;
    }

    public void send(Destination dest, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "send(Destination,Message,int,int,long)", new Object[]{dest, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        this.checkNotNullDestination(dest);
        this.checkNotAlienDestination(dest);
        this.checkNotMixedDomain(dest);
        this.send_(false, (JmsDestinationImpl)dest, message, deliveryMode, priority, timeToLive, true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "send(Destination,Message,int,int,long)");
        }
    }

    public void send(Destination dest, Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "send(Destination,Message)", new Object[]{dest, message});
        }
        this.checkNotNullDestination(dest);
        this.checkNotAlienDestination(dest);
        this.checkNotMixedDomain(dest);
        int deliveryMode = this.getIntProperty("deliveryMode");
        int priority = this.getIntProperty("priority");
        long timeToLive = this.getLongProperty("timeToLive");
        this.send_(false, (JmsDestinationImpl)dest, message, deliveryMode, priority, timeToLive, false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "send(Destination,Message)");
        }
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "send(Message,int,int,long)", new Object[]{message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive)});
        }
        this.send_(true, this.destination, message, deliveryMode, priority, timeToLive, true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "send(Message,int,int,long)");
        }
    }

    public void send(Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "send(Message)", new Object[]{message});
        }
        int deliveryMode = this.getIntProperty("deliveryMode");
        int priority = this.getIntProperty("priority");
        long timeToLive = this.getLongProperty("timeToLive");
        this.send_(true, this.destination, message, deliveryMode, priority, timeToLive, false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "send(Message)");
        }
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "setDeliveryMode(int)", new Object[]{new Integer(deliveryMode)});
        }
        this.state.checkNotClosed("JMSCC0026");
        this.setIntProperty("deliveryMode", deliveryMode);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "setDeliveryMode(int)");
        }
    }

    private void validateDeliveryMode(int deliveryMode) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validateDeliveryMode(int)", new Object[]{new Integer(deliveryMode)});
        }
        if (deliveryMode != 1 && deliveryMode != 2) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_VALUE", "" + deliveryMode);
            inserts.put("XMSC_INSERT_NAME", "JMSDeliveryMode");
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0005", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validateDeliveryMode(int)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validateDeliveryMode(int)");
        }
    }

    public void setDisableMessageID(boolean disableMsgID) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "setDisableMessageID(boolean)", "setter", disableMsgID);
        }
        this.setBooleanProperty("XMSC_DISABLE_MSG_ID", disableMsgID);
    }

    public void setDisableMessageTimestamp(boolean disableMsgTS) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "setDisableMessageTimestamp(boolean)", "setter", disableMsgTS);
        }
        this.setBooleanProperty("XMSC_DISABLE_MSG_TS", disableMsgTS);
    }

    public void setPriority(int priority) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "setPriority(int)", new Object[]{new Integer(priority)});
        }
        this.state.checkNotClosed("JMSCC0026");
        this.setIntProperty("priority", priority);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "setPriority(int)");
        }
    }

    private void validatePriority(int pri) throws JMSException {
        boolean valid;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validatePriority(int)", new Object[]{new Integer(pri)});
        }
        boolean bl = valid = pri >= 0 && pri <= 9 ? true : this.providerProducer.providerPriorityValidate(pri);
        if (!valid) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_VALUE", "" + pri);
            inserts.put("XMSC_INSERT_NAME", "JMSPriority");
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0005", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validatePriority(int)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validatePriority(int)");
        }
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "setTimeToLive(long)", "setter", new Long(timeToLive));
        }
        this.state.checkNotClosed("JMSCC0026");
        this.setLongProperty("timeToLive", timeToLive);
    }

    private void validateTimeToLive(long timeToLive) throws JMSException {
        boolean valid;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validateTimeToLive(long)", new Object[]{new Long(timeToLive)});
        }
        boolean bl = valid = timeToLive >= 0L ? true : this.providerProducer.providerTimeToLiveValidate(timeToLive);
        if (!valid) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_VALUE", "" + timeToLive);
            inserts.put("XMSC_INSERT_NAME", "timeToLive");
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0005", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validateTimeToLive(long)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validateTimeToLive(long)");
        }
    }

    public ProviderMessageProducer getProviderProducer() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "getProviderProducer()", "getter", this.providerProducer);
        }
        return this.providerProducer;
    }

    public void setProviderProducer(ProviderMessageProducer providerProducer) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "setProviderProducer(ProviderMessageProducer)", "setter", providerProducer);
        }
        this.providerProducer = providerProducer;
    }

    protected void validateProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validateProperty(String,Object)", new Object[]{name, value});
        }
        this.state.checkNotClosed("JMSCC0026");
        boolean isValid = true;
        if (name.equals("deliveryMode")) {
            isValid = value instanceof Integer;
            this.validateDeliveryMode((Integer)value);
        } else if (name.equals("timeToLive")) {
            isValid = value instanceof Long;
            this.validateTimeToLive((Long)value);
        } else if (name.equals("priority")) {
            isValid = value instanceof Integer;
            this.validatePriority((Integer)value);
        }
        if (!isValid) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_VALUE", "" + value);
            inserts.put("XMSC_INSERT_NAME", name);
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0005", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validateProperty(String,Object)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "validateProperty(String,Object)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send_(boolean inIdentifiedContext, JmsDestinationImpl dest, Message message, int deliveryMode, int priority, long timeToLive, boolean validateProperties) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "send_(boolean,JmsDestinationImpl,Message,int,int,long,boolean)", new Object[]{inIdentifiedContext, dest, message, new Integer(deliveryMode), new Integer(priority), new Long(timeToLive), validateProperties});
        }
        this.sessionSyncMutex.acquire(-1);
        try {
            this.state.checkNotClosed("JMSCC0026");
            this.session.checkSynchronousUsage("send_");
            if (inIdentifiedContext) {
                this.checkNotUnidentifiedProducer();
            } else {
                this.checkNotIdentifiedProducer();
            }
            this.checkNotNullMessage(message);
            this.checkTemporaryDest(dest);
            if (validateProperties) {
                this.validatePriority(priority);
                this.validateDeliveryMode(deliveryMode);
                this.validateTimeToLive(timeToLive);
            }
            this.producerProps.update(dest, deliveryMode, priority, timeToLive);
            this.sendMessage(message, dest);
        }
        finally {
            this.sessionSyncMutex.release();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "send_(boolean,JmsDestinationImpl,Message,int,int,long,boolean)");
        }
    }

    private void checkTemporaryDest(JmsDestinationImpl dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkTemporaryDest(JmsDestinationImpl)", new Object[]{dest});
        }
        boolean isDeleted = false;
        if (dest instanceof JmsTemporaryQueueImpl) {
            isDeleted = ((JmsTemporaryQueueImpl)dest).isDeleted();
        } else if (dest instanceof JmsTemporaryTopicImpl) {
            isDeleted = ((JmsTemporaryTopicImpl)dest).isDeleted();
        }
        if (isDeleted) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_DESTINATION_NAME", dest.toString());
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3019", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkTemporaryDest(JmsDestinationImpl)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkTemporaryDest(JmsDestinationImpl)");
        }
    }

    private void sendMessage(Message message, JmsDestinationImpl dest) throws JMSException {
        boolean alienMessage;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "sendMessage(Message,JmsDestinationImpl)", new Object[]{message, dest});
        }
        JmsMessageImpl jmsMessage = (alienMessage = this.isAlienMessage(message)) ? JmsMessageImpl.messageToJmsMessageImpl(this.session, message) : (JmsMessageImpl)message;
        ProviderMessage providerMessage = jmsMessage.providerMessageFactory.convertMessageUsingSession(jmsMessage.getProviderMessage(), this.session.getProviderSession());
        int deliveryMode = this.producerProps.getEffectiveDeliveryMode();
        int priority = this.producerProps.getEffectivePriority();
        long timeToLive = this.producerProps.getEffectiveTTL();
        providerMessage.setJMSDeliveryMode(deliveryMode);
        providerMessage.setJMSPriority(priority);
        providerMessage.setJMSDestinationAsString(JmsDestinationImplProxy.getProviderDestination(dest).toURI());
        boolean disableMessageID = this.getBooleanProperty("XMSC_DISABLE_MSG_ID");
        if (!disableMessageID) {
            providerMessage.setJMSMessageID(this.session.getProviderSession().createMessageID());
        } else {
            providerMessage.setJMSMessageID(null);
        }
        boolean disableMessageTimestamp = this.getBooleanProperty("XMSC_DISABLE_MSG_TS");
        long timeNow = 0L;
        if (timeToLive != 0L || !disableMessageTimestamp) {
            timeNow = System.currentTimeMillis();
        }
        if (timeToLive == 0L) {
            providerMessage.setJMSExpiration(0L);
        } else {
            providerMessage.setJMSExpiration(timeNow + timeToLive);
        }
        if (!disableMessageTimestamp) {
            providerMessage.setJMSTimestamp(timeNow);
        } else {
            providerMessage.setJMSTimestamp(0L);
        }
        ProviderDestination providerDestination = this.destination == null ? JmsDestinationImplProxy.getProviderDestination(dest) : null;
        this.providerProducer.send(providerDestination, providerMessage);
        if (alienMessage) {
            this.updateAlienMessage(message, providerMessage, dest);
        }
        jmsMessage.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "sendMessage(Message,JmsDestinationImpl)");
        }
    }

    private boolean isAlienMessage(Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "isAlienMessage(Message)", new Object[]{message});
        }
        boolean result = false;
        boolean sameType = message instanceof JmsMessageImpl;
        if (!sameType) {
            result = true;
        } else {
            boolean sameConnection = ((JmsMessageImpl)message).getConnectionTypeName().equals(this.session.getConnectionTypeName());
            if (!sameConnection) {
                result = true;
            } else {
                ProviderSession providerSession = this.session.getProviderSession();
                result = providerSession.isMessageAlien(((JmsMessageImpl)message).getProviderMessage());
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "isAlienMessage(Message)", result);
        }
        return result;
    }

    private void updateAlienMessage(Message message, ProviderMessage providerMessage, Destination dest) throws JMSException {
        block7: {
            block6: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "updateAlienMessage(Message,ProviderMessage,Destination)", new Object[]{message, providerMessage, dest});
                }
                message.setJMSPriority(providerMessage.getJMSPriority().intValue());
                message.setJMSDeliveryMode(providerMessage.getJMSDeliveryMode().intValue());
                message.setJMSMessageID(providerMessage.getJMSMessageID());
                message.setJMSExpiration(providerMessage.getJMSExpiration().longValue());
                message.setJMSTimestamp(providerMessage.getJMSTimestamp().longValue());
                message.setJMSDestination(dest);
                try {
                    message.setStringProperty("JMSXAppID", providerMessage.getStringProperty("JMSXAppID"));
                    message.setStringProperty("JMSXUserID", providerMessage.getStringProperty("JMSXUserID"));
                    message.setStringProperty("JMSXGroupID", providerMessage.getStringProperty("JMSXGroupID"));
                    message.setIntProperty("JMSXGroupSeq", providerMessage.getIntProperty("JMSXGroupSeq"));
                }
                catch (Exception e) {
                    if (!Trace.isOn) break block6;
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "updateAlienMessage(Message,ProviderMessage,Destination)", e, 1);
                }
            }
            try {
                message.setStringProperty("JMS_IBM_PutDate", providerMessage.getStringProperty("JMS_IBM_PutDate"));
                message.setStringProperty("JMS_IBM_PutTime", providerMessage.getStringProperty("JMS_IBM_PutTime"));
                message.setIntProperty("JMS_IBM_PutApplType", providerMessage.getIntProperty("JMS_IBM_PutApplType"));
            }
            catch (Exception e) {
                if (!Trace.isOn) break block7;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "updateAlienMessage(Message,ProviderMessage,Destination)", e, 2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "updateAlienMessage(Message,ProviderMessage,Destination)");
        }
    }

    private void checkNotIdentifiedProducer() throws UnsupportedOperationException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotIdentifiedProducer()");
        }
        if (this.destination != null) {
            UnsupportedOperationException uoe = (UnsupportedOperationException)JmsErrorUtils.createException("JMSCC0030", null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotIdentifiedProducer()", uoe);
            }
            throw uoe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotIdentifiedProducer()");
        }
    }

    private void checkNotUnidentifiedProducer() throws UnsupportedOperationException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotUnidentifiedProducer()");
        }
        if (this.destination == null) {
            UnsupportedOperationException uoe = (UnsupportedOperationException)JmsErrorUtils.createException("JMSCC0029", null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotUnidentifiedProducer()", uoe);
            }
            throw uoe;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotUnidentifiedProducer()");
        }
    }

    private void checkNotNullMessage(Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotNullMessage(Message)", new Object[]{message});
        }
        if (message == null) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0098", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotNullMessage(Message)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotNullMessage(Message)");
        }
    }

    private void checkNotNullDestination(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotNullDestination(Destination)", new Object[]{destination});
        }
        if (destination == null) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0085", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotNullDestination(Destination)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotNullDestination(Destination)");
        }
    }

    private void checkNotAlienDestination(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotAlienDestination(Destination)", new Object[]{destination});
        }
        if (destination != null && !(destination instanceof JmsDestinationImpl)) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_DESTINATION_NAME", destination.toString());
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0099", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotAlienDestination(Destination)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotAlienDestination(Destination)");
        }
    }

    private void checkNotMixedDomain(Destination dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotMixedDomain(Destination)", new Object[]{dest});
        }
        if (dest instanceof Queue && this instanceof TopicPublisher || dest instanceof Topic && this instanceof QueueSender) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            String method = dest instanceof Queue ? "send(Queue)" : "send(Topic)";
            inserts.put("XMSC_INSERT_METHOD", method);
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotMixedDomain(Destination)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "checkNotMixedDomain(Destination)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsMessageProducerImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsMessageProducerImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.69.1.6 11/09/07 15:24:28");
        }
    }

    class ProducerProperties {
        private final int unsetDeliveryMode = Integer.MIN_VALUE;
        private final int unsetPriority = Integer.MIN_VALUE;
        private final long unsetTTL = Integer.MIN_VALUE;
        private JmsDestination dest;
        private int inDeliveryModeOverride = Integer.MIN_VALUE;
        private int inPriorityOverride = Integer.MIN_VALUE;
        private long inTTLOverride = Integer.MIN_VALUE;
        private int inDeliveryMode = Integer.MIN_VALUE;
        private int inPriority = Integer.MIN_VALUE;
        private long inTTL = Integer.MIN_VALUE;

        ProducerProperties() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.ProducerProperties", "<init>()");
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.ProducerProperties", "<init>()");
            }
        }

        void update(JmsDestination destination, int deliveryMode, int priority, long ttl) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.ProducerProperties", "update(JmsDestination,int,int,long)", new Object[]{destination, new Integer(deliveryMode), new Integer(priority), new Long(ttl)});
            }
            this.dest = destination;
            this.inDeliveryMode = deliveryMode;
            this.inPriority = priority;
            this.inTTL = ttl;
            this.inDeliveryModeOverride = Integer.MIN_VALUE;
            this.inPriorityOverride = Integer.MIN_VALUE;
            this.inTTLOverride = Integer.MIN_VALUE;
            this.calcOverrides();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.ProducerProperties", "update(JmsDestination,int,int,long)");
            }
        }

        private void calcOverrides() throws JMSException {
            long ttl;
            int pri;
            int dlv;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.ProducerProperties", "calcOverrides()");
            }
            if ((dlv = this.dest.getIntProperty("deliveryMode")) == 1 || dlv == 2) {
                this.inDeliveryModeOverride = dlv;
            }
            if ((pri = this.dest.getIntProperty("priority")) != -2) {
                this.inPriorityOverride = pri;
            }
            if ((ttl = this.dest.getLongProperty("timeToLive")) != -2L) {
                this.inTTLOverride = ttl;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.ProducerProperties", "calcOverrides()");
            }
        }

        int getEffectiveDeliveryMode() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.ProducerProperties", "getEffectiveDeliveryMode()");
            }
            int effectiveDeliveryMode = Integer.MIN_VALUE;
            effectiveDeliveryMode = this.inDeliveryModeOverride != Integer.MIN_VALUE ? this.inDeliveryModeOverride : this.inDeliveryMode;
            if (effectiveDeliveryMode == Integer.MIN_VALUE) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("destination", this.dest.toString());
                info.put("effectiveDeliveryMode", "" + effectiveDeliveryMode);
                info.put("inDeliveryModeOverride", "" + this.inDeliveryModeOverride);
                info.put("inDeliveryMode", "" + this.inDeliveryMode);
                Trace.ffst(this, "getEffectiveDeliveryMode()", "XJ007001", info, null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.ProducerProperties", "getEffectiveDeliveryMode()", new Integer(effectiveDeliveryMode));
            }
            return effectiveDeliveryMode;
        }

        int getEffectivePriority() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.ProducerProperties", "getEffectivePriority()");
            }
            int effectivePriority = Integer.MIN_VALUE;
            effectivePriority = this.inPriorityOverride != Integer.MIN_VALUE ? this.inPriorityOverride : this.inPriority;
            if (effectivePriority == Integer.MIN_VALUE) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("destination", this.dest.toString());
                info.put("effectivePriority", "" + effectivePriority);
                info.put("inPriorityOverride", "" + this.inPriorityOverride);
                info.put("inPriority", "" + this.inPriority);
                Trace.ffst(this, "getEffectivePriority()", "XJ007002", info, null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.ProducerProperties", "getEffectivePriority()", new Integer(effectivePriority));
            }
            return effectivePriority;
        }

        long getEffectiveTTL() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.ProducerProperties", "getEffectiveTTL()");
            }
            long effectiveTTL = Integer.MIN_VALUE;
            effectiveTTL = this.inTTLOverride != Integer.MIN_VALUE ? this.inTTLOverride : this.inTTL;
            if (effectiveTTL == Integer.MIN_VALUE) {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("destination", this.dest.toString());
                info.put("effectiveTTL", "" + effectiveTTL);
                info.put("inTTLOverride", "" + this.inTTLOverride);
                info.put("inTTL", "" + this.inTTL);
                Trace.ffst(this, "getEffectiveTTL()", "XJ007003", info, null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.ProducerProperties", "getEffectiveTTL()", new Long(effectiveTTL));
            }
            return effectiveTTL;
        }
    }
}

