/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.ReentrantMutex;
import com.ibm.msg.client.commonservices.Utils;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsFactoryFactory;
import com.ibm.msg.client.jms.admin.JmsDestinationImpl;
import com.ibm.msg.client.jms.internal.JmsBytesMessageImpl;
import com.ibm.msg.client.jms.internal.JmsDestinationImplProxy;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl;
import com.ibm.msg.client.jms.internal.JmsMapMessageImpl;
import com.ibm.msg.client.jms.internal.JmsObjectMessageImpl;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.jms.internal.JmsStreamMessageImpl;
import com.ibm.msg.client.jms.internal.JmsTextMessageImpl;
import com.ibm.msg.client.provider.ProviderBytesMessage;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderJmsFactory;
import com.ibm.msg.client.provider.ProviderMapMessage;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageFactory;
import com.ibm.msg.client.provider.ProviderMetaData;
import com.ibm.msg.client.provider.ProviderObjectMessage;
import com.ibm.msg.client.provider.ProviderStreamMessage;
import com.ibm.msg.client.provider.ProviderTextMessage;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ListIterator;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;

public class JmsMessageImpl
extends JmsPropertyContextImpl
implements Message {
    private static final long serialVersionUID = 5268072332264758613L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.67.1.8 12/12/11 14:50:47";
    protected static final String MESSAGETYPE_NONE = "jms_none";
    protected static final String MESSAGETYPE_TEXT = "jms_text";
    protected static final String MESSAGETYPE_OBJECT = "jms_object";
    protected static final String MESSAGETYPE_MAP = "jms_map";
    protected static final String MESSAGETYPE_STREAM = "jms_stream";
    protected static final String MESSAGETYPE_BYTES = "jms_bytes";
    private transient JmsSessionImpl theSession = null;
    protected transient ProviderMessageFactory providerMessageFactory = null;
    protected transient ProviderJmsFactory providerJmsFactory = null;
    private boolean bodyReadOnly = false;
    private boolean propertiesReadOnly = false;
    private static Hashtable JMS_IBM_props;
    private transient String cachedToString = null;
    private final Object cachedToStringLock = new Object();
    protected String messageType = null;
    private ProviderMessage providerMessage;
    private Destination jmsDestination = null;
    private Destination jmsReplyTo = null;
    private String connectionTypeName;
    private Enumeration jmsxPropertyNames;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ProviderMessageFactory obtainFactories(String connectionTypeName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "obtainFactories(String)", new Object[]{connectionTypeName});
        }
        if (this.providerMessageFactory == null) {
            try {
                JmsFactoryFactoryImpl jmsFactory = (JmsFactoryFactoryImpl)JmsFactoryFactory.getInstance(connectionTypeName);
                this.providerMessageFactory = jmsFactory.getProviderMessageFactory();
                this.providerJmsFactory = jmsFactory.getProviderFactoryFactory().getJmsFactory();
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "obtainFactories(String)", e);
                }
                HashMap<String, Exception> info = new HashMap<String, Exception>();
                info.put("exception", e);
                Trace.ffst(this, "obtainFactories(String)", "XJ001001", info, JMSException.class);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "obtainFactories(String)", this.providerMessageFactory);
        }
        return this.providerMessageFactory;
    }

    public JmsMessageImpl(JmsSessionImpl session) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(JmsSessionImpl)", new Object[]{session});
        }
        if (!$assertionsDisabled && session == null) {
            throw new AssertionError((Object)Trace.ffstAssertion(this, "<init>(JmsSessionImpl)", "XJ001004", new Object[]{"connectionTypeName=>" + this.connectionTypeName}));
        }
        this.providerMessageFactory = session.getMessageFactory();
        this.providerJmsFactory = session.getJmsFactory();
        this.theSession = session;
        ProviderMessage providerMessage = null;
        try {
            providerMessage = this.createProviderMessage(session);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(JmsSessionImpl)", e);
            }
            HashMap<String, Exception> info = new HashMap<String, Exception>();
            info.put("exception", e);
            Trace.ffst(this, "<init>(JmsSessionImpl)", "XJ001002", info, JMSException.class);
        }
        this.providerMessage = providerMessage;
        this.connectionTypeName = session.getConnectionTypeName();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(JmsSessionImpl)");
        }
    }

    public JmsMessageImpl(String connectionType) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(String)", new Object[]{connectionType});
        }
        this.providerMessageFactory = ((JmsFactoryFactoryImpl)JmsFactoryFactoryImpl.getInstance(connectionType)).getProviderMessageFactory();
        this.providerJmsFactory = ((JmsFactoryFactoryImpl)JmsFactoryFactoryImpl.getInstance(connectionType)).getProviderFactoryFactory().getJmsFactory();
        this.theSession = null;
        ProviderMessage providerMessage = null;
        try {
            providerMessage = this.createProviderMessage(null);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(String)", e);
            }
            HashMap<String, Exception> info = new HashMap<String, Exception>();
            info.put("exception", e);
            Trace.ffst(this, "<init>(JmsSessionImpl)", "XJ001002", info, JMSException.class);
        }
        this.providerMessage = providerMessage;
        this.connectionTypeName = connectionType;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(String)");
        }
    }

    JmsMessageImpl(ProviderMessage providerMessage, JmsSessionImpl newSess, String connectionTypeName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(ProviderMessage,JmsSessionImpl,String)", new Object[]{providerMessage, newSess, connectionTypeName});
        }
        this.connectionTypeName = connectionTypeName;
        if (newSess != null) {
            this.providerMessageFactory = newSess.getMessageFactory();
            this.providerJmsFactory = newSess.getJmsFactory();
        } else {
            this.obtainFactories(connectionTypeName);
        }
        this.providerMessage = providerMessage;
        this.theSession = newSess;
        this.messageType = MESSAGETYPE_NONE;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(ProviderMessage,JmsSessionImpl,String)");
        }
    }

    JmsMessageImpl(JmsSessionImpl session, Message message) throws JMSException {
        this(session);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(JmsSessionImpl,Message)", new Object[]{session, message});
        }
        this.setJMSCorrelationID(message.getJMSCorrelationID());
        this.setJMSType(message.getJMSType());
        this.theSession = session;
        Destination replyTo = message.getJMSReplyTo();
        if (replyTo instanceof JmsDestinationImpl) {
            replyTo = this.createDestination(this.connectionTypeName, (JmsDestinationImpl)replyTo);
        }
        this.setJMSReplyTo(replyTo);
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames != null && propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            Object value = message.getObjectProperty(name);
            try {
                this.setObjectProperty(name, value);
            }
            catch (Exception e) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(JmsSessionImpl,Message)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "<init>(JmsSessionImpl,Message)");
        }
    }

    public String getJMSMessageID() throws JMSException {
        String result = this.providerMessage.getJMSMessageID();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSMessageID()", "getter", result);
        }
        return result;
    }

    public void setJMSMessageID(String newMsgId) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSMessageID(String)", "setter", newMsgId);
        }
        this.providerMessage.setJMSMessageID(newMsgId);
        this.invalidateToStringCache();
    }

    public long getJMSTimestamp() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSTimestamp()");
        }
        Long ts = this.providerMessage.getJMSTimestamp();
        long val = 0L;
        val = ts != null ? ts : 0L;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSTimestamp()", new Long(val));
        }
        return val;
    }

    public void setJMSTimestamp(long time) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSTimestamp(long)", "setter", new Long(time));
        }
        this.providerMessage.setJMSTimestamp(time);
        this.invalidateToStringCache();
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        byte[] result = this.providerMessage.getJMSCorrelationIDAsBytes();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSCorrelationIDAsBytes()", "getter", result);
        }
        return result;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlIdBytes) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSCorrelationIDAsBytes(byte [ ])", "setter", correlIdBytes);
        }
        this.providerMessage.setJMSCorrelationIDAsBytes(correlIdBytes);
        this.invalidateToStringCache();
    }

    public void setJMSCorrelationID(String correl) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSCorrelationID(String)", "setter", correl);
        }
        this.providerMessage.setJMSCorrelationID(correl);
        this.invalidateToStringCache();
    }

    public String getJMSCorrelationID() throws JMSException {
        String correl = this.providerMessage.getJMSCorrelationID();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSCorrelationID()", "getter", correl);
        }
        return correl;
    }

    public Destination getJMSReplyTo() throws JMSException {
        if (this.jmsReplyTo != null) {
            return this.jmsReplyTo;
        }
        String providerReplyTo = this.providerMessage.getJMSReplyToAsString();
        if (providerReplyTo != null) {
            this.jmsReplyTo = this.providerDestToJmsDest(providerReplyTo);
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSReplyTo()", "getter", this.jmsReplyTo);
        }
        return this.jmsReplyTo;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSReplyTo(Destination)", new Object[]{destination});
        }
        this.invalidateToStringCache();
        this.jmsReplyTo = destination;
        if (destination == null) {
            this.providerMessage.setJMSReplyToAsString(null);
        } else if (destination instanceof JmsDestinationImpl) {
            JmsDestinationImpl jmsReplyTo = (JmsDestinationImpl)destination;
            if (!jmsReplyTo.getStringProperty("XMSC_CONNECTION_TYPE_NAME").equals(this.connectionTypeName)) {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_VALUE", jmsReplyTo.getStringProperty("XMSC_CONNECTION_TYPE_NAME"));
                inserts.put("XMSC_INSERT_NAME", "JMSReplyTo");
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0003", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSReplyTo(Destination)", je, 1);
                }
                throw je;
            }
            ProviderDestination providerDestination = JmsDestinationImplProxy.getProviderDestination(jmsReplyTo);
            if (Trace.isOn) {
                Trace.data(this, "Setting ProviderDestination in providerMessage", (Object)providerDestination);
            }
            this.providerMessage.setJMSReplyToAsString(providerDestination.toURI());
        } else if (destination instanceof Destination) {
            if (Trace.isOn) {
                Trace.data(this, "object is a foreign Destination. Attempting to create a ProviderDestination", (Object)destination.getClass().getName());
            }
            String name = null;
            if (destination instanceof Queue) {
                name = ((Queue)destination).getQueueName();
            } else if (destination instanceof Topic) {
                name = ((Topic)destination).getTopicName();
            }
            try {
                JmsDestinationImpl jmsReplyTo = new JmsDestinationImpl(this.connectionTypeName, name);
                ProviderDestination providerDestination = JmsDestinationImplProxy.getProviderDestination(jmsReplyTo);
                this.providerMessage.setJMSReplyToAsString(providerDestination.toURI());
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.data(this, "Failed to create JMSReplyTo ProviderDestination from foreign Destination object. The message will not contian a JMSReplyTo field", (Object)e);
                }
                this.providerMessage.setJMSReplyToAsString(null);
            }
        } else {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_VALUE", destination.getClass().toString());
            inserts.put("XMSC_INSERT_NAME", "JMSReplyTo");
            JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0003", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSReplyTo(Destination)", je2, 2);
            }
            throw je2;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSReplyTo(Destination)");
        }
    }

    public Destination getJMSDestination() throws JMSException {
        if (this.jmsDestination != null) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSDestination()", "getter. Returning Destination from common message", this.jmsDestination);
            }
            return this.jmsDestination;
        }
        String providerDest = this.providerMessage.getJMSDestinationAsString();
        JmsDestinationImpl newDestination = this.providerDestToJmsDest(providerDest);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSDestination()", "getter. Returning Destination from provider message", newDestination);
        }
        return newDestination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSDestination(Destination)", new Object[]{destination});
        }
        this.invalidateToStringCache();
        if (destination == null) {
            this.providerMessage.setJMSDestinationAsString(null);
            this.jmsDestination = null;
        } else if (destination instanceof JmsDestinationImpl) {
            JmsDestinationImpl jmsDestination = (JmsDestinationImpl)destination;
            if (jmsDestination.getStringProperty("XMSC_CONNECTION_TYPE_NAME").equals(this.connectionTypeName)) {
                if (Trace.isOn) {
                    Trace.data(this, "destination is a common client Destination from the same provider as this Message.Storing the ProviderDestination in the ProviderMessage", null);
                }
                ProviderDestination providerDestination = JmsDestinationImplProxy.getProviderDestination(jmsDestination);
                this.providerMessage.setJMSDestinationAsString(providerDestination.toURI());
                jmsDestination = null;
            } else {
                if (Trace.isOn) {
                    Trace.data(this, "destination is a common client Destination, but is from a different provider to this Message. Storing the Destination in the common client Message", null);
                }
                this.jmsDestination = destination;
                this.providerMessage.setJMSDestinationAsString(null);
            }
        } else if (destination instanceof Destination) {
            if (Trace.isOn) {
                Trace.data(this, "destination is from a non-common client JMS implementation. Storing the Destination in the common client Message", null);
            }
            this.jmsDestination = destination;
            this.providerMessage.setJMSDestinationAsString(null);
        } else {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_VALUE", destination.getClass().toString());
            inserts.put("XMSC_INSERT_NAME", "JMSDestination");
            JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0003", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSDestination(Destination)", je2, 2);
            }
            throw je2;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSDestination(Destination)");
        }
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSDeliveryMode()");
        }
        Integer dm = this.providerMessage.getJMSDeliveryMode();
        int val = 0;
        val = dm != null ? dm : 2;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSDeliveryMode()", new Integer(val));
        }
        return val;
    }

    public void setJMSDeliveryMode(int dm) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSDeliveryMode(int)", new Object[]{new Integer(dm)});
        }
        switch (dm) {
            case 1: 
            case 2: {
                this.providerMessage.setJMSDeliveryMode(dm);
                break;
            }
            default: {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_VALUE", String.valueOf(dm));
                inserts.put("XMSC_INSERT_NAME", "JMSDeliveryMode");
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0005", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSDeliveryMode(int)", je);
                }
                throw je;
            }
        }
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSDeliveryMode(int)");
        }
    }

    public boolean getJMSRedelivered() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSRedelivered()");
        }
        Boolean redeliv = this.providerMessage.getJMSRedelivered();
        boolean val = false;
        val = redeliv != null ? redeliv : false;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSRedelivered()", val);
        }
        return val;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSRedelivered(boolean)", "setter", redelivered);
        }
        this.providerMessage.setJMSRedelivered(redelivered);
        this.invalidateToStringCache();
    }

    public String getJMSType() throws JMSException {
        String type = this.providerMessage.getJMSType();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSType()", "getter", type);
        }
        return type;
    }

    public void setJMSType(String jmsType) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSType(String)", "setter", jmsType);
        }
        this.providerMessage.setJMSType(jmsType);
        this.invalidateToStringCache();
    }

    public long getJMSExpiration() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSExpiration()");
        }
        Long ex = this.providerMessage.getJMSExpiration();
        long exl = 0L;
        if (ex == null) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_PROPERTY", "JMSExpiration");
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0084", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSExpiration()", je);
            }
            throw je;
        }
        exl = ex;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSExpiration()", new Long(exl));
        }
        return exl;
    }

    public void setJMSExpiration(long exp) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSExpiration(long)", "setter", new Long(exp));
        }
        this.providerMessage.setJMSExpiration(exp);
        this.invalidateToStringCache();
    }

    public int getJMSPriority() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSPriority()");
        }
        Integer tempPri = this.providerMessage.getJMSPriority();
        int p = 0;
        if (tempPri == null) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_PROPERTY", "JMSPriority");
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0084", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSPriority()", je);
            }
            throw je;
        }
        p = tempPri;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getJMSPriority()", new Integer(p));
        }
        return p;
    }

    public void setJMSPriority(int newPriority) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSPriority(int)", new Object[]{new Integer(newPriority)});
        }
        try {
            this.providerMessage.setJMSPriority(newPriority);
            this.invalidateToStringCache();
        }
        catch (IllegalArgumentException iae) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSPriority(int)", iae);
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_VALUE", "" + newPriority);
            inserts.put("XMSC_INSERT_NAME", "JMSPriority");
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0005", inserts));
            je.setLinkedException((Exception)iae);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSPriority(int)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setJMSPriority(int)");
        }
    }

    public void clearProperties() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "clearProperties()");
        }
        this.providerMessage.clearProperties();
        this.propertiesReadOnly = false;
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "clearProperties()");
        }
    }

    public boolean propertyExists(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "propertyExists(String)", new Object[]{name});
        }
        boolean result = this.providerMessage.propertyExists(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "propertyExists(String)", result);
        }
        return result;
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        boolean result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getBooleanProperty(String)", new Object[]{name});
        }
        try {
            Object obj = this.getObjectProperty(name);
            result = JmsPropertyContextImpl.parseBoolean(obj, name, MessageFormatException.class);
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getBooleanProperty(String)", jmse);
            }
            throw jmse;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getBooleanProperty(String)", result);
        }
        return result;
    }

    public byte getByteProperty(String name) throws JMSException {
        byte result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getByteProperty(String)", new Object[]{name});
        }
        try {
            Object obj = this.getObjectProperty(name);
            result = JmsPropertyContextImpl.parseByte(obj, name, MessageFormatException.class);
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getByteProperty(String)", jmse);
            }
            throw jmse;
        }
        catch (NumberFormatException nfe) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getByteProperty(String)", nfe);
            }
            throw nfe;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getByteProperty(String)", new Byte(result));
        }
        return result;
    }

    public short getShortProperty(String name) throws JMSException {
        short result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getShortProperty(String)", new Object[]{name});
        }
        try {
            Object obj = this.getObjectProperty(name);
            result = JmsPropertyContextImpl.parseShort(obj, name, MessageFormatException.class);
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getShortProperty(String)", jmse);
            }
            throw jmse;
        }
        catch (NumberFormatException nfe) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getShortProperty(String)", nfe);
            }
            throw nfe;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getShortProperty(String)", new Short(result));
        }
        return result;
    }

    public int getIntProperty(String name) throws JMSException {
        int result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getIntProperty(String)", new Object[]{name});
        }
        try {
            Object obj = this.getObjectProperty(name);
            result = JmsPropertyContextImpl.parseInt(obj, name, MessageFormatException.class);
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getIntProperty(String)", jmse);
            }
            throw jmse;
        }
        catch (NumberFormatException nfe) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getIntProperty(String)", nfe);
            }
            throw nfe;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getIntProperty(String)", new Integer(result));
        }
        return result;
    }

    public long getLongProperty(String name) throws JMSException {
        long result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getLongProperty(String)", new Object[]{name});
        }
        try {
            Object obj = this.getObjectProperty(name);
            result = JmsPropertyContextImpl.parseLong(obj, name, MessageFormatException.class);
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getLongProperty(String)", jmse);
            }
            throw jmse;
        }
        catch (NumberFormatException nfe) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getLongProperty(String)", nfe);
            }
            throw nfe;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getLongProperty(String)", new Long(result));
        }
        return result;
    }

    public float getFloatProperty(String name) throws JMSException {
        float result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getFloatProperty(String)", new Object[]{name});
        }
        try {
            Object obj = this.getObjectProperty(name);
            result = JmsPropertyContextImpl.parseFloat(obj, name, MessageFormatException.class);
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getFloatProperty(String)", jmse);
            }
            throw jmse;
        }
        catch (NumberFormatException nfe) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getFloatProperty(String)", nfe);
            }
            throw nfe;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getFloatProperty(String)", new Float(result));
        }
        return result;
    }

    public double getDoubleProperty(String name) throws JMSException {
        double result;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getDoubleProperty(String)", new Object[]{name});
        }
        try {
            Object obj = this.getObjectProperty(name);
            result = JmsPropertyContextImpl.parseDouble(obj, name, MessageFormatException.class);
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getDoubleProperty(String)", jmse);
            }
            throw jmse;
        }
        catch (NumberFormatException nfe) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getDoubleProperty(String)", nfe);
            }
            throw nfe;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getDoubleProperty(String)", new Double(result));
        }
        return result;
    }

    public String getStringProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getStringProperty(String)", new Object[]{name});
        }
        Object obj = null;
        try {
            obj = name != null && name.equals("JMS_TOG_ARM_Correlator") ? this.getObjectProperty("JMS_IBM_ArmCorrelator") : this.getObjectProperty(name);
        }
        catch (JMSException jmse) {
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getStringProperty(String)", jmse);
            }
            throw jmse;
        }
        String value = null;
        value = obj instanceof String || obj == null ? (String)obj : obj.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getStringProperty(String)", value);
        }
        return value;
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getObjectProperty(String)", new Object[]{name});
        }
        if (name == null || "".equals(name)) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_PROPERTY", name);
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0049", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getObjectProperty(String)", je);
            }
            throw je;
        }
        Object result = this.providerMessage.getObjectProperty(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getObjectProperty(String)", result);
        }
        return result;
    }

    public Enumeration getPropertyNames() throws JMSException {
        Enumeration result = this.providerMessage.getPropertyNames();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getPropertyNames()", "getter", result);
        }
        return result;
    }

    public void setBooleanProperty(String name, boolean val) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setBooleanProperty(String,boolean)", new Object[]{name, val});
        }
        this.checkPropertiesWriteable("setBooleanProperty");
        this.checkPropName(name, "setBooleanProperty");
        this.checkSettablePropertyName(name, Boolean.class);
        this.providerMessage.setObjectProperty(name, new Boolean(val));
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setBooleanProperty(String,boolean)");
        }
    }

    public void setByteProperty(String name, byte val) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setByteProperty(String,byte)", new Object[]{name, new Byte(val)});
        }
        this.checkPropertiesWriteable("setByteProperty");
        this.checkPropName(name, "setByteProperty");
        this.checkSettablePropertyName(name, Byte.class);
        this.providerMessage.setObjectProperty(name, new Byte(val));
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setByteProperty(String,byte)");
        }
    }

    public void setShortProperty(String name, short val) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setShortProperty(String,short)", new Object[]{name, new Short(val)});
        }
        this.checkPropertiesWriteable("setShortProperty");
        this.checkPropName(name, "setShortProperty");
        this.checkSettablePropertyName(name, Short.class);
        this.providerMessage.setObjectProperty(name, new Short(val));
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setShortProperty(String,short)");
        }
    }

    public void setIntProperty(String name, int val) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setIntProperty(String,int)", new Object[]{name, new Integer(val)});
        }
        this.checkPropertiesWriteable("setIntProperty");
        this.checkPropName(name, "setIntProperty");
        if (name.equals("JMS_IBM_Character_Set")) {
            this.setStringProperty(name, String.valueOf(val));
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setIntProperty(String,int)", 1);
            }
            return;
        }
        this.checkSettablePropertyName(name, Integer.class);
        this.providerMessage.setObjectProperty(name, new Integer(val));
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setIntProperty(String,int)", 2);
        }
    }

    public void setLongProperty(String name, long val) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setLongProperty(String,long)", new Object[]{name, new Long(val)});
        }
        this.checkPropertiesWriteable("setLongProperty");
        this.checkPropName(name, "setLongProperty");
        this.checkSettablePropertyName(name, Long.class);
        this.providerMessage.setObjectProperty(name, new Long(val));
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setLongProperty(String,long)");
        }
    }

    public void setFloatProperty(String name, float val) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setFloatProperty(String,float)", new Object[]{name, new Float(val)});
        }
        this.checkPropertiesWriteable("setFloatProperty");
        this.checkPropName(name, "setFloatProperty");
        this.checkSettablePropertyName(name, Float.class);
        this.providerMessage.setObjectProperty(name, new Float(val));
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setFloatProperty(String,float)");
        }
    }

    public void setDoubleProperty(String name, double val) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setDoubleProperty(String,double)", new Object[]{name, new Double(val)});
        }
        this.checkPropertiesWriteable("setDoubleProperty");
        this.checkPropName(name, "setDoubleProperty");
        this.checkSettablePropertyName(name, Double.class);
        this.providerMessage.setObjectProperty(name, new Double(val));
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setDoubleProperty(String,double)");
        }
    }

    public void setStringProperty(String name, String val) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setStringProperty(String,String)", new Object[]{name, val});
        }
        this.checkPropertiesWriteable("setStringProperty");
        this.checkPropName(name, "setStringProperty");
        this.checkSettablePropertyName(name, String.class);
        if (name.equals("JMS_TOG_ARM_Correlator")) {
            this.providerMessage.setObjectProperty("JMS_IBM_ArmCorrelator", val);
        } else {
            this.providerMessage.setObjectProperty(name, val);
        }
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setStringProperty(String,String)");
        }
    }

    public void setObjectProperty(String name, Object obj) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setObjectProperty(String,Object)", new Object[]{name, obj});
        }
        this.checkPropertiesWriteable("setObjectProperty");
        this.checkPropName(name, "setObjectProperty");
        Class clazz = obj == null ? Object.class : obj.getClass();
        Class objType = clazz;
        this.checkSettablePropertyName(name, objType);
        if (obj == null || obj instanceof Boolean || obj instanceof Number || obj instanceof String) {
            this.providerMessage.setObjectProperty(name, obj);
            this.invalidateToStringCache();
        } else if (obj instanceof byte[] && (name.equals("JMS_IBM_MQMD_MsgId") || name.equals("JMS_IBM_MQMD_CorrelId") || name.equals("JMS_IBM_MQMD_AccountingToken") || name.equals("JMS_IBM_MQMD_GroupId"))) {
            this.providerMessage.setObjectProperty(name, obj);
            this.invalidateToStringCache();
        } else {
            HashMap<String, Object> inserts = new HashMap<String, Object>();
            inserts.put("XMSC_INSERT_PROPERTY", name);
            inserts.put("XMSC_INSERT_TYPE", objType);
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0039", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setObjectProperty(String,Object)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "setObjectProperty(String,Object)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "acknowledge()");
        }
        if (this.theSession == null) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "acknowledge()", 1);
            }
            return;
        }
        this.theSession.checkNotClosed();
        this.theSession.checkSynchronousUsage("acknowledge");
        if (this.theSession.getTransacted()) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "acknowledge()", 2);
            }
            return;
        }
        int sessAck = this.theSession.getAcknowledgeMode();
        if (sessAck == 2) {
            ReentrantMutex sessionSyncMutex = null;
            if (!this.theSession.isAsync()) {
                sessionSyncMutex = this.theSession.getSessionSyncMutex();
                sessionSyncMutex.acquire(-1);
            }
            try {
                this.theSession.commitTransaction();
            }
            finally {
                if (!this.theSession.isAsync()) {
                    sessionSyncMutex.release();
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "acknowledge()", 3);
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "clearBody()");
        }
        this.providerMessage.clearBody();
        this.bodyReadOnly = false;
        this.invalidateToStringCache();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "clearBody()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.cachedToStringLock;
        synchronized (object) {
            if (this.cachedToString == null) {
                try {
                    this.cachedToString = "TO_STRING_IN_PROGRESS";
                    StringBuffer sb = new StringBuffer(512);
                    sb.append("\n  JMSMessage class: " + this.messageType);
                    sb.append("\n  JMSType:          " + this.getJMSType());
                    sb.append("\n  JMSDeliveryMode:  " + this.getJMSDeliveryMode());
                    sb.append("\n  JMSExpiration:    " + this.getJMSExpiration());
                    sb.append("\n  JMSPriority:      " + this.getJMSPriority());
                    sb.append("\n  JMSMessageID:     " + this.getJMSMessageID());
                    sb.append("\n  JMSTimestamp:     " + this.getJMSTimestamp());
                    sb.append("\n  JMSCorrelationID: " + this.getJMSCorrelationID());
                    sb.append("\n  JMSDestination:   ");
                    try {
                        sb.append(this.getJMSDestination());
                    }
                    catch (Exception e) {
                        sb.append("<ERROR>");
                    }
                    sb.append("\n  JMSReplyTo:       ");
                    try {
                        sb.append(this.getJMSReplyTo());
                    }
                    catch (Exception e) {
                        sb.append("<ERROR>");
                    }
                    sb.append("\n  JMSRedelivered:   " + this.getJMSRedelivered());
                    Enumeration enumeration = this.getPropertyNames();
                    ArrayList keys = new ArrayList();
                    while (enumeration.hasMoreElements()) {
                        keys.add(enumeration.nextElement());
                    }
                    Collections.sort(keys);
                    ListIterator propNames = keys.listIterator();
                    while (propNames.hasNext()) {
                        String name = (String)propNames.next();
                        Object value = this.getObjectProperty(name);
                        if (value instanceof byte[]) {
                            StringBuffer s = Utils.bytesToHex((byte[])value);
                            if (s.length() > 100) {
                                s.setLength(100);
                                s.append(" ...");
                            }
                            value = s.toString();
                        }
                        sb.append("\n    " + name + ": " + value);
                    }
                    this.cachedToString = sb.toString();
                }
                catch (JMSException e) {
                    this.cachedToString = null;
                }
            }
        }
        return this.cachedToString;
    }

    protected ProviderMessage createProviderMessage(JmsSessionImpl session) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "createProviderMessage(JmsSessionImpl)", new Object[]{session});
        }
        this.messageType = MESSAGETYPE_NONE;
        ProviderMessage result = session != null ? this.providerMessageFactory.createMessage(session.getProviderSession()) : this.providerMessageFactory.createMessage(null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "createProviderMessage(JmsSessionImpl)", result);
        }
        return result;
    }

    protected ProviderMessage getProviderMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getProviderMessage()", "getter", this.providerMessage);
        }
        return this.providerMessage;
    }

    protected void checkBodyWriteable(String callingMethodName) throws JMSException {
        if (this.bodyReadOnly) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", callingMethodName);
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0044", inserts));
            throw je;
        }
    }

    protected void checkBodyReadable(String callingMethodName) throws MessageNotReadableException {
        if (!this.bodyReadOnly) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", callingMethodName);
            MessageNotReadableException je = (MessageNotReadableException)JmsErrorUtils.createException("JMSCC0046", inserts);
            throw je;
        }
    }

    private void checkPropertiesWriteable(String callingMethodName) throws JMSException {
        if (this.propertiesReadOnly) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", callingMethodName);
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0045", inserts));
            throw je;
        }
    }

    static Message inboundJmsInstance(ProviderMessage providerMessage, JmsSessionImpl newSess, String connectionTypeName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.internal.JmsMessageImpl", "inboundJmsInstance(ProviderMessage,JmsSessionImpl,String)", new Object[]{providerMessage, newSess, connectionTypeName});
        }
        JmsMessageImpl jmsMessage = null;
        jmsMessage = providerMessage instanceof ProviderBytesMessage ? new JmsBytesMessageImpl((ProviderBytesMessage)providerMessage, newSess, connectionTypeName) : (providerMessage instanceof ProviderMapMessage ? new JmsMapMessageImpl((ProviderMapMessage)providerMessage, newSess, connectionTypeName) : (providerMessage instanceof ProviderStreamMessage ? new JmsStreamMessageImpl((ProviderStreamMessage)providerMessage, newSess, connectionTypeName) : (providerMessage instanceof ProviderObjectMessage ? new JmsObjectMessageImpl((ProviderObjectMessage)providerMessage, newSess, connectionTypeName) : (providerMessage instanceof ProviderTextMessage ? new JmsTextMessageImpl((ProviderTextMessage)providerMessage, newSess, connectionTypeName) : new JmsMessageImpl(providerMessage, newSess, connectionTypeName)))));
        jmsMessage.bodyReadOnly = true;
        jmsMessage.propertiesReadOnly = true;
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.internal.JmsMessageImpl", "inboundJmsInstance(ProviderMessage,JmsSessionImpl,String)", jmsMessage);
        }
        return jmsMessage;
    }

    protected static JmsMessageImpl messageToJmsMessageImpl(JmsSessionImpl session, Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.internal.JmsMessageImpl", "messageToJmsMessageImpl(JmsSessionImpl,Message)", new Object[]{session, message});
        }
        JmsMessageImpl jmsMessage = null;
        if (message instanceof BytesMessage) {
            jmsMessage = new JmsBytesMessageImpl(session, (BytesMessage)message);
        } else if (message instanceof MapMessage) {
            jmsMessage = new JmsMapMessageImpl(session, (MapMessage)message);
        } else if (message instanceof ObjectMessage) {
            jmsMessage = new JmsObjectMessageImpl(session, (ObjectMessage)message);
        } else if (message instanceof StreamMessage) {
            jmsMessage = new JmsStreamMessageImpl(session, (StreamMessage)message);
        } else if (message instanceof TextMessage) {
            jmsMessage = new JmsTextMessageImpl(session, (TextMessage)message);
        } else if (message instanceof Message) {
            jmsMessage = new JmsMessageImpl(session, message);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.internal.JmsMessageImpl", "messageToJmsMessageImpl(JmsSessionImpl,Message)", jmsMessage);
        }
        return jmsMessage;
    }

    protected boolean isBodyReadOnly() {
        return this.bodyReadOnly;
    }

    protected void setBodyReadOnly() {
        this.bodyReadOnly = true;
    }

    private void checkPropName(String name, String callingMethodName) throws IllegalArgumentException, MessageFormatException {
        if (name == null || "".equals(name)) {
            IllegalArgumentException je = (IllegalArgumentException)JmsErrorUtils.createException("JMSCC0043", null);
            throw je;
        }
        if (JMS_IBM_props.containsKey(name)) {
            return;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_PROPERTY", name);
            MessageFormatException je2 = (MessageFormatException)JmsErrorUtils.createException("JMSCC0049", inserts);
            throw je2;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_PROPERTY", name);
            MessageFormatException je3 = (MessageFormatException)JmsErrorUtils.createException("JMSCC0049", inserts);
            throw je3;
        }
    }

    private void checkSettablePropertyName(String propertyName, Class propType) throws JMSException {
        if (propertyName.startsWith("JMS")) {
            if (JMS_IBM_props.containsKey(propertyName)) {
                Class expectedPropType = (Class)JMS_IBM_props.get(propertyName);
                if (expectedPropType != propType) {
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_INSERT_PROPERTY", propertyName);
                    inserts.put("XMSC_INSERT_TYPE", expectedPropType.getName());
                    inserts.put("XMSC_INSERT_OTHER_TYPE", propType.getName());
                    JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0051", inserts));
                    throw je;
                }
            } else if (propertyName.startsWith("JMSX")) {
                if (!(propertyName.equals("JMSXGroupID") || propertyName.equals("JMSXGroupSeq") || propertyName.equals("JMSXUserID") || propertyName.equals("JMSXAppID") || propertyName.equals("JMSXDeliveryCount") || propertyName.equals("JMSXState") || propertyName.equals("JMSXProducerTXID") || propertyName.equals("JMSXConsumerTXID") || propertyName.equals("JMSXRcvTimestamp"))) {
                    if (this.jmsxPropertyNames == null) {
                        ProviderMetaData metaData = ((JmsFactoryFactoryImpl)JmsFactoryFactory.getInstance(this.connectionTypeName)).getProviderMetaData();
                        this.jmsxPropertyNames = metaData.getJMSXPropertyNames();
                    }
                    boolean found = false;
                    while (this.jmsxPropertyNames.hasMoreElements()) {
                        String nextProp = (String)this.jmsxPropertyNames.nextElement();
                        if (!nextProp.equals(propertyName)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        HashMap<String, String> inserts = new HashMap<String, String>();
                        inserts.put("XMSC_INSERT_PROPERTY", propertyName);
                        JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0050", inserts));
                        throw je2;
                    }
                }
            } else {
                HashMap<String, String> inserts = new HashMap<String, String>();
                inserts.put("XMSC_INSERT_PROPERTY", propertyName);
                JMSException je3 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0050", inserts));
                throw je3;
            }
        }
    }

    private JmsDestinationImpl createDestination(String connectionTypeName, JmsDestinationImpl dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "createDestination(String,JmsDestinationImpl)", new Object[]{connectionTypeName, dest});
        }
        JmsDestinationImpl newDest = dest;
        JmsFactoryFactory factory = JmsFactoryFactory.getInstance(connectionTypeName);
        ProviderDestination providerDestination = JmsDestinationImplProxy.getProviderDestination(dest);
        String destName = providerDestination.getName();
        if (dest instanceof Queue) {
            newDest = (JmsDestinationImpl)((Object)factory.createQueue(destName));
        } else if (dest instanceof Topic) {
            newDest = (JmsDestinationImpl)((Object)factory.createTopic(destName));
        }
        Enumeration propNames = dest.getPropertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            try {
                newDest.setObjectProperty(propName, dest.getObjectProperty(propName));
            }
            catch (JMSException e) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "createDestination(String,JmsDestinationImpl)", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "createDestination(String,JmsDestinationImpl)", newDest);
        }
        return newDest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateToStringCache() {
        Object object = this.cachedToStringLock;
        synchronized (object) {
            this.cachedToString = null;
        }
    }

    protected String getConnectionTypeName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "getConnectionTypeName()", "getter", this.connectionTypeName);
        }
        return this.connectionTypeName;
    }

    private JmsDestinationImpl providerDestToJmsDest(String providerDestString) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "providerDestToJmsDest(String)", new Object[]{providerDestString});
        }
        JmsDestinationImpl jmsDest = null;
        if (providerDestString != null && providerDestString.trim().length() > 0) {
            jmsDest = (JmsDestinationImpl)this.providerJmsFactory.createDestination(providerDestString);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "providerDestToJmsDest(String)", jmsDest);
        }
        return jmsDest;
    }

    private void readObjectNoData() throws ObjectStreamException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "readObjectNoData()");
        }
        try {
            JmsFactoryFactoryImpl jmsFactory = (JmsFactoryFactoryImpl)JmsFactoryFactory.getInstance(this.connectionTypeName);
            this.providerMessageFactory = jmsFactory.getProviderMessageFactory();
            this.providerJmsFactory = jmsFactory.getProviderFactoryFactory().getJmsFactory();
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "readObjectNoData()", e);
            }
            Trace.ffst(this, "readObjectNoData()", "XJ001003", null, Exception.class);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageImpl", "readObjectNoData()");
        }
    }

    public void copyProperties(Message targetMsg) {
        try {
            Enumeration e = this.getPropertyNames();
            while (e.hasMoreElements()) {
                String str = (String)e.nextElement();
                Object value = this.getObjectProperty(str);
                targetMsg.setObjectProperty(str, value);
            }
            String s = this.getJMSCorrelationID();
            if (s != null) {
                targetMsg.setJMSCorrelationID(s);
            }
            targetMsg.setJMSDeliveryMode(this.getJMSDeliveryMode());
            targetMsg.setJMSExpiration(this.getJMSExpiration());
            targetMsg.setJMSPriority(this.getJMSPriority());
            targetMsg.setJMSRedelivered(this.getJMSRedelivered());
            targetMsg.setJMSTimestamp(this.getJMSTimestamp());
            targetMsg.setJMSType(this.getJMSType());
            targetMsg.setJMSMessageID(this.getJMSMessageID());
            targetMsg.setJMSDestination(this.getJMSDestination());
            targetMsg.setJMSReplyTo(this.getJMSReplyTo());
        }
        catch (JMSException e1) {
            e1.printStackTrace();
        }
    }

    static {
        boolean bl = $assertionsDisabled = !JmsMessageImpl.class.desiredAssertionStatus();
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.67.1.8 12/12/11 14:50:47");
        }
        JMS_IBM_props = null;
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.internal.JmsMessageImpl", "static()");
        }
        JMS_IBM_props = new Hashtable(50, 1.0f);
        JMS_IBM_props.put("JMS_IBM_Format", String.class);
        JMS_IBM_props.put("JMS_IBM_MsgType", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Feedback", Integer.class);
        JMS_IBM_props.put("JMS_IBM_PutApplType", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Exception", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Expiration", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_COA", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_COD", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_PAN", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_NAN", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Pass_Msg_ID", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Pass_Correl_ID", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Report_Discard_Msg", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Encoding", Integer.class);
        JMS_IBM_props.put("JMS_IBM_Character_Set", String.class);
        JMS_IBM_props.put("JMS_IBM_Last_Msg_In_Group", Boolean.class);
        JMS_IBM_props.put("JMS_IBM_PutDate", String.class);
        JMS_IBM_props.put("JMS_IBM_PutTime", String.class);
        JMS_IBM_props.put("JMS_IBM_ConnectionID", String.class);
        JMS_IBM_props.put("JMS_IBM_ArmCorrelator", String.class);
        JMS_IBM_props.put("JMS_IBM_RMCorrelator", String.class);
        JMS_IBM_props.put("JMS_TOG_ARM_Correlator", String.class);
        JMS_IBM_props.put("JMS_IBM_Retain", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_Report", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_MsgType", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_Expiry", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_Feedback", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_Encoding", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_CodedCharSetId", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_Format", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_Priority", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_Persistence", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_MsgId", [B.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_CorrelId", [B.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_BackoutCount", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_ReplyToQ", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_ReplyToQMgr", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_UserIdentifier", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_AccountingToken", [B.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_ApplIdentityData", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_PutApplType", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_PutApplName", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_PutDate", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_PutTime", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_ApplOriginData", String.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_GroupId", [B.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_MsgSeqNumber", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_Offset", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_MsgFlags", Integer.class);
        JMS_IBM_props.put("JMS_IBM_MQMD_OriginalLength", Integer.class);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.internal.JmsMessageImpl", "static()");
        }
    }
}

