/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.ReentrantMutex;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsMessageConsumer;
import com.ibm.msg.client.jms.admin.JmsDestinationImpl;
import com.ibm.msg.client.jms.internal.JmsConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsDestinationImplProxy;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.jms.internal.State;
import com.ibm.msg.client.provider.ProviderMessage;
import com.ibm.msg.client.provider.ProviderMessageConsumer;
import com.ibm.msg.client.provider.ProviderMessageListener;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.QueueReceiver;

public class JmsMessageConsumerImpl
extends JmsPropertyContextImpl
implements JmsMessageConsumer {
    private static final long serialVersionUID = 5264547666759984190L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsMessageConsumerImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.69.1.19 12/02/22 05:49:49";
    private Destination destination;
    private String selector;
    private boolean noLocal;
    private ProviderMessageConsumer providerConsumer;
    private MessageListener messageListener;
    private JmsSessionImpl session;
    protected boolean closed = false;
    private volatile boolean inboundDisabled = false;
    private boolean recoverMessage = false;
    protected State state = new State(1);
    private final int sessionAckMode;
    private final ReentrantMutex sessionSyncMutex;
    private boolean messageListenerSet = false;

    JmsMessageConsumerImpl(JmsSessionImpl session, Destination dest, String selector, boolean noLocal) throws JMSException {
        super(session, true);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "<init>(JmsSessionImpl,Destination,String,boolean)", new Object[]{session, dest, selector, noLocal});
        }
        this.destination = dest;
        this.selector = selector;
        this.noLocal = noLocal;
        this.session = session;
        this.sessionSyncMutex = session.getSessionSyncMutex();
        this.sessionAckMode = session.getAcknowledgeMode();
        this.setIntProperty("deliveryMode", 2);
        this.setBooleanProperty("XMSC_NOLOCAL", noLocal);
        try {
            this.setLongProperty("OBJECT_IDENTITY", System.identityHashCode(this));
        }
        catch (JMSException e) {
            // empty catch block
        }
        if (session.getState() == 1) {
            this.start();
        } else {
            this.stop();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "<init>(JmsSessionImpl,Destination,String,boolean)");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "close()");
        }
        this.close(false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close(boolean closingFromSession) throws JMSException {
        ReentrantMutex onMessageMutex;
        State state;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "close(boolean)", new Object[]{closingFromSession});
        }
        if (!this.session.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            if (this.state.isClosed()) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "close(boolean)", 3);
                }
                Object var3_2 = null;
                if (this.session.isAsync()) return;
                this.sessionSyncMutex.release();
                return;
            }
            state = null;
            if (!this.session.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (this.session.isAsync()) throw throwable;
            this.sessionSyncMutex.release();
            throw throwable;
        }
        if (Thread.currentThread().equals(this.session.messageListenerThread) && this.messageListenerSet) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3033", null));
            if (!Trace.isOn) throw je;
            Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "close(boolean)", je);
            throw je;
        }
        this.stopUnconditional();
        if (!this.session.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
        }
        try {
            onMessageMutex = this.session.getOnMessageMutex();
            onMessageMutex.acquire(-1);
            try {
                state = this.state;
                // MONITORENTER : state
                if (this.state.close()) {
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "close(boolean)", 1);
                    }
                    // MONITOREXIT : state
                }
            }
            finally {
                onMessageMutex.release();
            }
            Object var7_10 = null;
            if (!this.session.isAsync()) {
                this.sessionSyncMutex.release();
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (this.session.isAsync()) throw throwable;
            this.sessionSyncMutex.release();
            throw throwable;
        }
        JmsDestinationImplProxy.decrementUseCount((JmsDestinationImpl)this.destination);
        onMessageMutex = this.session.getOnMessageMutex();
        onMessageMutex.acquire(-1);
        try {
            try {
                this.setObjectProperty("onMessageMutex", onMessageMutex);
            }
            catch (JMSException je) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("Exception", (Object)je);
                data.put("onMessagemutex", onMessageMutex);
                Trace.ffst(this, "close(boolean)", "????????", data, JMSException.class);
            }
            if (this.providerConsumer != null) {
                this.providerConsumer.close(closingFromSession);
                this.session.removeConsumer(this);
            }
        }
        finally {
            onMessageMutex.release();
        }
        if (!Trace.isOn) return;
        Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "close(boolean)", 2);
    }

    public MessageListener getMessageListener() throws JMSException {
        this.state.checkNotClosed("JMSCC0032");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "getMessageListener()", "getter", this.messageListener);
        }
        return this.messageListener;
    }

    public String getMessageSelector() throws JMSException {
        this.state.checkNotClosed("JMSCC0032");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "getMessageSelector()", "getter", this.selector);
        }
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive()");
        }
        this.checkSynchronousUsage("receive");
        this.state.checkNotClosed("JMSCC0032");
        boolean msgLogged = false;
        while (2 == this.session.getState()) {
            Object c;
            if (!msgLogged) {
                msgLogged = true;
                c = (JmsConnectionImpl)this.session.getConnection();
                ((JmsConnectionImpl)c).logReceiveStoppedConnMsg();
            }
            try {
                c = this.state;
                synchronized (c) {
                    this.state.wait(5000L);
                }
            }
            catch (InterruptedException ie) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive()", ie);
            }
        }
        if (3 == this.session.getState()) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive()", null, 1);
            }
            return null;
        }
        Message msg = this.receiveInboundMessage(0L);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive()", msg, 2);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long millis) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive(long)", new Object[]{new Long(millis)});
        }
        if (0L == millis) {
            Message msg = this.receive();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive(long)", msg, 1);
            }
            return msg;
        }
        this.checkSynchronousUsage("receive");
        Message msg = null;
        State state = this.state;
        synchronized (state) {
            this.state.checkNotClosed("JMSCC0032");
            if (0L > millis) {
                HashMap<String, Long> inserts = new HashMap<String, Long>();
                inserts.put("XMSC_INSERT_TIMEOUT", new Long(millis));
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0107", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive(long)", je);
                }
                throw je;
            }
            if (2 == this.session.getState()) {
                JmsConnectionImpl c = (JmsConnectionImpl)this.session.getConnection();
                c.logReceiveStoppedConnMsg();
                long timeEntered = System.currentTimeMillis();
                long endTime = timeEntered + millis;
                long currTime = timeEntered;
                while (2 == this.session.getState() && currTime < endTime) {
                    block21: {
                        try {
                            this.state.wait(endTime - currTime);
                        }
                        catch (InterruptedException ie) {
                            if (!Trace.isOn) break block21;
                            Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive(long)", ie);
                        }
                    }
                    currTime = System.currentTimeMillis();
                }
                if (1 == this.session.getState()) {
                    millis = Math.max(0L, endTime - currTime);
                } else if (2 == this.session.getState()) {
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive(long)", null, 2);
                    }
                    return null;
                }
                if (millis == 0L) {
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive(long)", (Object)"timeout has expired, so returning null");
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive(long)", null, 5);
                    }
                    return null;
                }
            }
            if (3 == this.session.getState()) {
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive(long)", null, 3);
                }
                return null;
            }
            msg = this.receiveInboundMessage(millis);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receive(long)", msg, 4);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receiveNoWait()");
        }
        this.checkSynchronousUsage("receiveNoWait");
        Message message = null;
        State state = this.state;
        synchronized (state) {
            this.state.checkNotClosed("JMSCC0032");
            if (!this.inboundDisabled) {
                if (this.session.getState() == 1) {
                    message = this.receiveInboundMessage(-1L);
                } else if (this.session.getState() == 2) {
                    JmsConnectionImpl c = (JmsConnectionImpl)this.session.getConnection();
                    c.logReceiveStoppedConnMsg();
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receiveNoWait()", message);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener listener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "setMessageListener(MessageListener)", new Object[]{listener});
        }
        boolean sessSyncMutexAcquired = false;
        if (!this.session.isAsync()) {
            this.sessionSyncMutex.acquire(-1);
            sessSyncMutexAcquired = true;
        }
        try {
            this.state.checkNotClosed("JMSCC0032");
            if (listener == null) {
                this.providerConsumer.setMessageListener(null);
                this.messageListener = listener;
                this.session.registerSyncConsumer(this);
            } else {
                JmsProviderMessageListener providerListener = new JmsProviderMessageListener(listener);
                this.providerConsumer.setMessageListener(providerListener);
                this.messageListener = listener;
                this.session.registerAsyncConsumer(this);
            }
        }
        finally {
            if (sessSyncMutexAcquired) {
                this.sessionSyncMutex.release();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "setMessageListener(MessageListener)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void emergencyClose() {
        block10: {
            block11: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "emergencyClose()");
                }
                try {
                    block9: {
                        try {
                            if (this.providerConsumer == null) break block9;
                            this.providerConsumer.close(false);
                        }
                        catch (JMSException ex) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "emergencyClose()", ex);
                            }
                            Object var3_2 = null;
                            if (Trace.isOn) {
                                Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "emergencyClose()");
                            }
                            this.providerConsumer = null;
                            this.closed = true;
                            break block10;
                        }
                    }
                    Object var3_1 = null;
                    if (!Trace.isOn) break block11;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "emergencyClose()");
                    }
                    this.providerConsumer = null;
                    this.closed = true;
                    throw throwable;
                }
                Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "emergencyClose()");
            }
            this.providerConsumer = null;
            this.closed = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "emergencyClose()");
        }
    }

    public ProviderMessageConsumer getProviderConsumer() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "getProviderConsumer()", "getter", this.providerConsumer);
        }
        return this.providerConsumer;
    }

    public void setProviderConsumer(ProviderMessageConsumer providerConsumer) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "setProviderConsumer(ProviderMessageConsumer)", "setter", providerConsumer);
        }
        this.providerConsumer = providerConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "start()");
        }
        if (this.providerConsumer != null) {
            State state = this.state;
            synchronized (state) {
                if (!this.closed && !this.state.isClosed()) {
                    this.state.notify();
                    this.providerConsumer.start(false);
                }
            }
        }
        this.inboundDisabled = false;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "start()");
        }
    }

    protected void stopUnconditional() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "stopUnconditional()");
        }
        this.inboundDisabled = true;
        if (this.providerConsumer != null) {
            this.providerConsumer.stop();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "stopUnconditional()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "stop()");
        }
        State state = this.state;
        synchronized (state) {
            if (!this.closed && !this.state.isClosed()) {
                this.stopUnconditional();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "stop()");
        }
    }

    private void checkSynchronousUsage(String method) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "checkSynchronousUsage(String)", new Object[]{method});
        }
        this.session.checkSynchronousUsage(method);
        if (this.session.getMessageListener() != null) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", method);
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0033", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "checkSynchronousUsage(String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "checkSynchronousUsage(String)");
        }
    }

    private void removeProviderConsumer() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "removeProviderConsumer()");
        }
        if (this.providerConsumer != null) {
            this.providerConsumer.stop();
            this.providerConsumer.setMessageListener(null);
            if (this.session.getState() == 1) {
                this.providerConsumer.start(false);
            }
            this.providerConsumer = null;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "removeProviderConsumer()");
        }
    }

    private Message receiveInboundMessage(long timeout) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receiveInboundMessage(long)", new Object[]{new Long(timeout)});
        }
        this.state.checkNotClosed("JMSCC0032");
        ProviderMessage providerMessage = this.providerConsumer.receive(timeout);
        Message message = providerMessage != null ? JmsMessageImpl.inboundJmsInstance(providerMessage, this.session, this.session.getConnectionTypeName()) : null;
        if (message != null) {
            boolean isXA = false;
            this.session.notifyMessageConsumed(isXA);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "receiveInboundMessage(long)", message);
        }
        return message;
    }

    public boolean getNoLocal() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "getNoLocal()");
        }
        this.state.checkNotClosed("JMSCC0032");
        if (this instanceof QueueReceiver) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getNoLocal()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "getNoLocal()", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "getNoLocal()", this.noLocal);
        }
        return this.noLocal;
    }

    protected void recoverAsyncMessage() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", (Object)"recoverAsyncMessage()");
        }
        this.recoverMessage = true;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsMessageConsumerImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.69.1.19 12/02/22 05:49:49");
        }
    }

    private class JmsProviderMessageListener
    implements ProviderMessageListener {
        private MessageListener jmsListener = null;
        private ReentrantMutex onMessageMutex = null;
        private JmsConnectionImpl connection = null;

        public JmsProviderMessageListener(MessageListener jmsListener) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "<init>(MessageListener)", new Object[]{jmsListener});
            }
            this.jmsListener = jmsListener;
            this.onMessageMutex = JmsMessageConsumerImpl.this.session.getOnMessageMutex();
            this.connection = (JmsConnectionImpl)JmsMessageConsumerImpl.this.session.getConnection();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "<init>(MessageListener)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onMessage(ProviderMessage message) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "onMessage(ProviderMessage)", new Object[]{message});
            }
            JmsMessageConsumerImpl.this.messageListenerSet = true;
            try {
                ((JmsMessageConsumerImpl)JmsMessageConsumerImpl.this).session.messageListenerThread = Thread.currentThread();
                if (message != null) {
                    this.onMessageMutex.acquire(-1);
                    try {
                        boolean transacted = JmsMessageConsumerImpl.this.sessionAckMode == 0;
                        try {
                            JmsMessageConsumerImpl.this.session.notifyMessagePreConsume(transacted);
                            int attempts = this.getDeliveryCount(message);
                            boolean retry = false;
                            boolean onMessageThrewException = false;
                            do {
                                block26: {
                                    if (attempts > 1) {
                                        message.setJMSRedelivered(true);
                                    }
                                    if (retry && JmsMessageConsumerImpl.this.state.equals(3)) {
                                        if (JmsMessageConsumerImpl.this.sessionAckMode == 3 || JmsMessageConsumerImpl.this.sessionAckMode == 1) {
                                            JmsMessageConsumerImpl.this.session.rollbackTransaction();
                                        }
                                        if (!Trace.isOn) return;
                                        Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "onMessage(ProviderMessage)", 1);
                                        return;
                                    }
                                    retry = false;
                                    onMessageThrewException = false;
                                    try {
                                        Message jmsMessage = JmsMessageImpl.inboundJmsInstance(message, JmsMessageConsumerImpl.this.session, JmsMessageConsumerImpl.this.session.getConnectionTypeName());
                                        JmsMessageConsumerImpl.this.recoverMessage = false;
                                        int msgDeliveryMode = jmsMessage.getJMSDeliveryMode();
                                        this.jmsListener.onMessage(jmsMessage);
                                        if (JmsMessageConsumerImpl.this.sessionAckMode != 1 && JmsMessageConsumerImpl.this.sessionAckMode != 3 || msgDeliveryMode == 2) break block26;
                                        if (Trace.isOn) {
                                            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", (Object)"In AUTO_ACKNOWLEDGE or DUPS_OK_ACKNOWLEDGE mode, checking for recover call");
                                        }
                                        if (JmsMessageConsumerImpl.this.recoverMessage) {
                                            JmsMessageConsumerImpl.this.recoverMessage = false;
                                            if (Trace.isOn) {
                                                Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMessageConsumerImpl", (Object)"Redelivering message due to recover call");
                                            }
                                            retry = true;
                                        }
                                    }
                                    catch (Throwable re) {
                                        if (Trace.isOn) {
                                            Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "onMessage(ProviderMessage)", re, 1);
                                        }
                                        onMessageThrewException = true;
                                        retry = this.handleOnMessageThrowable(re, message, attempts);
                                    }
                                }
                                ++attempts;
                            } while (retry);
                            if (!(onMessageThrewException || JmsMessageConsumerImpl.this.sessionAckMode != 3 && JmsMessageConsumerImpl.this.sessionAckMode != 1)) {
                                JmsMessageConsumerImpl.this.session.notifyMessagePostConsume();
                            }
                        }
                        catch (Exception e) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "onMessage(ProviderMessage)", e, 2);
                            }
                            HashMap<String, Object> inserts = new HashMap<String, Object>();
                            inserts.put("XMSC_INSERT_EXCEPTION", e);
                            inserts.put("XMSC_INSERT_METHOD", "onMessage");
                            JMSException jmse = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0007", inserts));
                            jmse.setLinkedException(e);
                            JmsMessageConsumerImpl.this.emergencyClose();
                            if (this.connection != null) {
                                this.connection.reportException(jmse, false);
                            }
                        }
                    }
                    finally {
                        this.onMessageMutex.release();
                    }
                }
                this.attemptConsumerClose();
                ((JmsMessageConsumerImpl)JmsMessageConsumerImpl.this).session.messageListenerThread = null;
            }
            finally {
                JmsMessageConsumerImpl.this.messageListenerSet = false;
            }
            if (!Trace.isOn) return;
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "onMessage(ProviderMessage)", 2);
        }

        private int getDeliveryCount(ProviderMessage message) {
            int deliveryCount;
            block7: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "getDeliveryCount(ProviderMessage)", new Object[]{message});
                }
                deliveryCount = 1;
                try {
                    if (message.propertyExists("JMSXDeliveryCount")) {
                        deliveryCount = message.getIntProperty("JMSXDeliveryCount");
                    }
                }
                catch (NumberFormatException nfe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "getDeliveryCount(ProviderMessage)", nfe, 1);
                    }
                }
                catch (JMSException je) {
                    if (!Trace.isOn) break block7;
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "getDeliveryCount(ProviderMessage)", je, 2);
                }
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "getDeliveryCount(ProviderMessage)", new Integer(deliveryCount));
            }
            return deliveryCount;
        }

        private boolean handleOnMessageThrowable(Throwable re, ProviderMessage message, int attempts) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "handleOnMessageThrowable(Throwable,ProviderMessage,int)", new Object[]{re, message, new Integer(attempts)});
            }
            boolean retry = false;
            try {
                JMSException jmse = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0037", null));
                jmse.setLinkedException(new Exception(re));
                if (this.connection != null) {
                    this.connection.reportException(jmse, false);
                }
                if (!JmsMessageConsumerImpl.this.providerConsumer.shouldMessageBeRequeued(attempts, message)) {
                    retry = true;
                } else {
                    retry = false;
                    JmsMessageConsumerImpl.this.providerConsumer.handlePoisonMessage(message);
                }
            }
            catch (Exception e1) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "handleOnMessageThrowable(Throwable,ProviderMessage,int)", e1);
                }
                JmsMessageConsumerImpl.this.emergencyClose();
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "handleOnMessageThrowable(Throwable,ProviderMessage,int)", retry);
            }
            return retry;
        }

        private void attemptConsumerClose() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "attemptConsumerClose()");
            }
            int sessionState = JmsMessageConsumerImpl.this.session.getState();
            switch (sessionState) {
                case 3: {
                    try {
                        JmsMessageConsumerImpl.this.stopUnconditional();
                    }
                    catch (JMSException e) {
                        if (!Trace.isOn) break;
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "attemptConsumerClose()", e, 1);
                    }
                    break;
                }
                case 2: {
                    try {
                        JmsMessageConsumerImpl.this.stop();
                        break;
                    }
                    catch (JMSException jmse) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "attemptConsumerClose()", jmse, 2);
                        }
                        if (this.connection == null) break;
                        this.connection.reportException(jmse, false);
                    }
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageListener", "attemptConsumerClose()");
            }
        }
    }
}

