/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.provider.ProviderMapMessage;
import com.ibm.msg.client.provider.ProviderMessage;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;

public class JmsMapMessageImpl
extends JmsMessageImpl
implements MapMessage {
    private static final long serialVersionUID = -8315480708014156786L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsMapMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.28.1.1 09/08/17 09:28:44";
    private ProviderMapMessage providerMapMessage;
    private transient String cachedMapToString = null;

    public JmsMapMessageImpl(JmsSessionImpl session) throws JMSException {
        super(session);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "<init>(JmsSessionImpl)", new Object[]{session});
        }
        this.providerMapMessage = (ProviderMapMessage)this.getProviderMessage();
        this.messageType = "jms_map";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "<init>(JmsSessionImpl)");
        }
    }

    public JmsMapMessageImpl(String connectionType) throws JMSException {
        super(connectionType);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "<init>(String)", new Object[]{connectionType});
        }
        this.messageType = "jms_map";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "<init>(String)");
        }
    }

    protected JmsMapMessageImpl(ProviderMapMessage newMsg, JmsSessionImpl newSess, String connectionTypeName) throws JMSException {
        super(newMsg, newSess, connectionTypeName);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "<init>(ProviderMapMessage,JmsSessionImpl,String)", new Object[]{newMsg, newSess, connectionTypeName});
        }
        this.providerMapMessage = newMsg;
        this.messageType = "jms_map";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "<init>(ProviderMapMessage,JmsSessionImpl,String)");
        }
    }

    JmsMapMessageImpl(JmsSessionImpl session, MapMessage mapMessage) throws JMSException {
        super(session, (Message)mapMessage);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "<init>(JmsSessionImpl,MapMessage)", new Object[]{session, mapMessage});
        }
        this.providerMapMessage = (ProviderMapMessage)this.getProviderMessage();
        Enumeration mapNames = mapMessage.getMapNames();
        if (mapNames != null) {
            while (mapNames.hasMoreElements()) {
                String name = (String)mapNames.nextElement();
                Object value = mapMessage.getObject(name);
                this.setObject(name, value);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "<init>(JmsSessionImpl,MapMessage)");
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getBoolean(String)", new Object[]{name});
        }
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        boolean value = false;
        value = JmsPropertyContextImpl.parseBoolean(obj, name, MessageFormatException.class);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getBoolean(String)", value);
        }
        return value;
    }

    public byte getByte(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getByte(String)", new Object[]{name});
        }
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        byte value = 0;
        value = JmsPropertyContextImpl.parseByte(obj, name, MessageFormatException.class);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getByte(String)", new Byte(value));
        }
        return value;
    }

    public short getShort(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getShort(String)", new Object[]{name});
        }
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        short value = 0;
        value = JmsPropertyContextImpl.parseShort(obj, name, MessageFormatException.class);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getShort(String)", new Short(value));
        }
        return value;
    }

    public char getChar(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getChar(String)", new Object[]{name});
        }
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        char value = '\u0000';
        if (obj instanceof Character) {
            value = ((Character)obj).charValue();
        } else {
            if (obj == null) {
                NullPointerException npe = new NullPointerException();
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getChar(String)", npe);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getChar(String)", npe);
                }
                throw npe;
            }
            JmsMapMessageImpl.throwBadConvertException(obj, name, "Character", MessageFormatException.class);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getChar(String)", new Character(value));
        }
        return value;
    }

    public int getInt(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getInt(String)", new Object[]{name});
        }
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        int value = 0;
        value = JmsPropertyContextImpl.parseInt(obj, name, MessageFormatException.class);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getInt(String)", new Integer(value));
        }
        return value;
    }

    public long getLong(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getLong(String)", new Object[]{name});
        }
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        long value = 0L;
        value = JmsPropertyContextImpl.parseLong(obj, name, MessageFormatException.class);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getLong(String)", new Long(value));
        }
        return value;
    }

    public float getFloat(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getFloat(String)", new Object[]{name});
        }
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        float value = 0.0f;
        value = JmsPropertyContextImpl.parseFloat(obj, name, MessageFormatException.class);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getFloat(String)", new Float(value));
        }
        return value;
    }

    public double getDouble(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getDouble(String)", new Object[]{name});
        }
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        double value = 0.0;
        value = JmsPropertyContextImpl.parseDouble(obj, name, MessageFormatException.class);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getDouble(String)", new Double(value));
        }
        return value;
    }

    public String getString(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getString(String)", new Object[]{name});
        }
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        String value = null;
        if (obj instanceof String || obj == null) {
            value = (String)obj;
        } else if (obj instanceof byte[]) {
            JmsMapMessageImpl.throwBadConvertException(obj, name, "String", MessageFormatException.class);
        } else {
            value = obj.toString();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getString(String)", value);
        }
        return value;
    }

    public byte[] getBytes(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getBytes(String)", new Object[]{name});
        }
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        byte[] value = null;
        if (obj instanceof byte[]) {
            byte[] objB = (byte[])obj;
            value = new byte[objB.length];
            System.arraycopy(objB, 0, value, 0, objB.length);
        } else if (obj == null) {
            value = null;
        } else {
            JmsMapMessageImpl.throwBadConvertException(obj, name, "Byte[]", MessageFormatException.class);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getBytes(String)", value);
        }
        return value;
    }

    public Object getObject(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getObject(String)", new Object[]{name});
        }
        Object result = null;
        Object obj = null;
        obj = this.providerMapMessage.getObject(name);
        if (obj instanceof byte[]) {
            byte[] objB = (byte[])obj;
            byte[] value = new byte[objB.length];
            System.arraycopy(objB, 0, value, 0, objB.length);
            result = value;
        } else {
            result = obj;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getObject(String)", result);
        }
        return result;
    }

    public Enumeration getMapNames() throws JMSException {
        Enumeration map = null;
        map = this.providerMapMessage.getMapNames();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "getMapNames()", "getter", map);
        }
        return map;
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setBoolean(String,boolean)", new Object[]{name, value});
        }
        this.checkBodyWriteable("setBoolean");
        this.checkMapName(name, "setBoolean");
        this.providerMapMessage.setBoolean(name, value);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setBoolean(String,boolean)");
        }
    }

    public void setByte(String name, byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setByte(String,byte)", new Object[]{name, new Byte(value)});
        }
        this.checkBodyWriteable("setByte");
        this.checkMapName(name, "setByte");
        this.providerMapMessage.setByte(name, value);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setByte(String,byte)");
        }
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setBytes(String,byte [ ])", new Object[]{name, value});
        }
        this.checkBodyWriteable("setBytes");
        this.checkMapName(name, "setBytes(String, byte[])");
        int length = 0;
        if (value != null) {
            length = value.length;
        }
        this.setBytes(name, value, 0, length);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setBytes(String,byte [ ])");
        }
    }

    public void setBytes(String name, byte[] value, int start, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setBytes(String,byte [ ],int,int)", new Object[]{name, value, new Integer(start), new Integer(length)});
        }
        this.checkBodyWriteable("setBytes");
        this.checkMapName(name, "setBytes(String, byte[], int, int)");
        byte[] deepCopy = null;
        if (value != null) {
            deepCopy = new byte[length];
            System.arraycopy(value, start, deepCopy, 0, length);
        }
        this.providerMapMessage.setBytes(name, deepCopy);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setBytes(String,byte [ ],int,int)");
        }
    }

    public void setChar(String name, char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setChar(String,char)", new Object[]{name, new Character(value)});
        }
        this.checkBodyWriteable("setChar");
        this.checkMapName(name, "setChar");
        this.providerMapMessage.setChar(name, value);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setChar(String,char)");
        }
    }

    public void setDouble(String name, double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setDouble(String,double)", new Object[]{name, new Double(value)});
        }
        this.checkBodyWriteable("setDouble");
        this.checkMapName(name, "setDouble");
        this.providerMapMessage.setDouble(name, value);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setDouble(String,double)");
        }
    }

    public void setFloat(String name, float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setFloat(String,float)", new Object[]{name, new Float(value)});
        }
        this.checkBodyWriteable("setFloat");
        this.checkMapName(name, "setFloat");
        this.providerMapMessage.setFloat(name, value);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setFloat(String,float)");
        }
    }

    public void setInt(String name, int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setInt(String,int)", new Object[]{name, new Integer(value)});
        }
        this.checkBodyWriteable("setInt");
        this.checkMapName(name, "setInt");
        this.providerMapMessage.setInt(name, value);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setInt(String,int)");
        }
    }

    public void setLong(String name, long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setLong(String,long)", new Object[]{name, new Long(value)});
        }
        this.checkBodyWriteable("setLong");
        this.checkMapName(name, "setLong");
        this.providerMapMessage.setLong(name, value);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setLong(String,long)");
        }
    }

    public void setObject(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setObject(String,Object)", new Object[]{name, value});
        }
        this.checkBodyWriteable("setObject");
        this.checkMapName(name, "setObject");
        if (!(value == null || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof byte[])) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_OBJECT", value.getClass().getName());
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0083", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setObject(String,Object)", traceRet1);
            }
            throw traceRet1;
        }
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            byte[] tmp = new byte[v.length];
            System.arraycopy(v, 0, tmp, 0, v.length);
            value = tmp;
        }
        this.providerMapMessage.setObject(name, value);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setObject(String,Object)");
        }
    }

    public void setShort(String name, short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setShort(String,short)", new Object[]{name, new Short(value)});
        }
        this.checkBodyWriteable("setShort");
        this.checkMapName(name, "setShort");
        this.providerMapMessage.setShort(name, value);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setShort(String,short)");
        }
    }

    public void setString(String name, String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setString(String,String)", new Object[]{name, value});
        }
        this.checkBodyWriteable("setString");
        this.checkMapName(name, "setString");
        this.providerMapMessage.setString(name, value);
        this.cachedMapToString = null;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "setString(String,String)");
        }
    }

    public boolean itemExists(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "itemExists(String)", new Object[]{name});
        }
        boolean exists = false;
        exists = this.providerMapMessage.itemExists(name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "itemExists(String)", exists);
        }
        return exists;
    }

    public String toString() {
        String val = super.toString();
        if (this.cachedMapToString == null) {
            StringBuffer sb = new StringBuffer();
            try {
                Enumeration props = this.getMapNames();
                while (props.hasMoreElements()) {
                    String nextKey = (String)props.nextElement();
                    Object propVal = this.getObject(nextKey);
                    if (propVal == null) {
                        propVal = "<null>";
                    }
                    sb.append("\n" + nextKey + " = " + propVal);
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.cachedMapToString = sb.toString();
        }
        val = val + this.cachedMapToString;
        return val;
    }

    protected ProviderMessage createProviderMessage(JmsSessionImpl session) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "createProviderMessage(JmsSessionImpl)", new Object[]{session});
        }
        this.providerMapMessage = session != null ? this.providerMessageFactory.createMapMessage(session.getProviderSession()) : this.providerMessageFactory.createMapMessage(null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "createProviderMessage(JmsSessionImpl)", this.providerMapMessage);
        }
        return this.providerMapMessage;
    }

    protected void checkMapName(String name, String callingMethodName) throws IllegalArgumentException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "checkMapName(String,String)", new Object[]{name, callingMethodName});
        }
        if (name == null || "".equals(name)) {
            IllegalArgumentException je = (IllegalArgumentException)JmsErrorUtils.createException("JMSCC0043", null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "checkMapName(String,String)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "checkMapName(String,String)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsMapMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsMapMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.28.1.1 09/08/17 09:28:44");
        }
    }
}

