/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.componentmanager.Component;
import com.ibm.msg.client.commonservices.componentmanager.ComponentManager;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsCapabilityContext;
import com.ibm.msg.client.jms.JmsConnectionFactory;
import com.ibm.msg.client.jms.JmsConstants;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsFactoryFactory;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsQueueConnectionFactory;
import com.ibm.msg.client.jms.JmsTopic;
import com.ibm.msg.client.jms.JmsTopicConnectionFactory;
import com.ibm.msg.client.jms.JmsXAConnectionFactory;
import com.ibm.msg.client.jms.JmsXAQueueConnectionFactory;
import com.ibm.msg.client.jms.JmsXATopicConnectionFactory;
import com.ibm.msg.client.jms.internal.JmsCapabilityContextImpl;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.provider.ProviderFactoryFactory;
import com.ibm.msg.client.provider.ProviderJmsFactory;
import com.ibm.msg.client.provider.ProviderMessageFactory;
import com.ibm.msg.client.provider.ProviderMetaData;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;

public class JmsFactoryFactoryImpl
extends JmsFactoryFactory {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Hashtable factories;
    protected int connectionType;
    protected String connectionTypeName;
    private ProviderFactoryFactory providerFactory;
    private ProviderJmsFactory providerJmsFactory;

    public static JmsFactoryFactory getInstance(int connectionType) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getInstance(int)", new Object[]{new Integer(connectionType)});
        }
        JmsFactoryFactory factory = null;
        if (connectionType < 0 || connectionType >= JmsConstants.providerNames.length) {
            HashMap<String, Integer> inserts = new HashMap<String, Integer>();
            inserts.put("XMSC_CONNECTION_TYPE", new Integer(connectionType));
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0091", inserts));
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getInstance(int)", je);
            }
            throw je;
        }
        factory = JmsFactoryFactoryImpl.getInstance(JmsConstants.providerNames[connectionType]);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getInstance(int)", factory);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JmsFactoryFactory getInstance(String connectionTypeName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getInstance(String)", new Object[]{connectionTypeName});
        }
        JmsFactoryFactoryImpl factory = null;
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            factory = (JmsFactoryFactoryImpl)factories.get(connectionTypeName);
            if (factory == null) {
                try {
                    factory = new JmsFactoryFactoryImpl();
                    factory.connectionTypeName = connectionTypeName;
                    for (int count = 0; count < JmsConstants.providerNames.length; ++count) {
                        if (!JmsConstants.providerNames[count].equalsIgnoreCase(connectionTypeName)) continue;
                        factory.connectionType = count;
                        break;
                    }
                    ComponentManager compMgr = ComponentManager.getInstance();
                    HashMap<String, String> filter = new HashMap<String, String>();
                    filter.put("XMSC_PROVIDER_NAME", connectionTypeName);
                    Component component = compMgr.getComponent("MPI", filter);
                    factory.providerFactory = (ProviderFactoryFactory)component.getFactoryInstance();
                    factories.put(connectionTypeName, factory);
                    factory.providerJmsFactory = factory.providerFactory.getJmsFactory();
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock("com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getInstance(String)", e);
                    }
                    HashMap<String, String> inserts = new HashMap<String, String>();
                    inserts.put("XMSC_CONNECTION_TYPE", connectionTypeName);
                    JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0091", inserts));
                    je.setLinkedException(e);
                    if (Trace.isOn) {
                        Trace.throwing("com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getInstance(String)", je);
                    }
                    throw je;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getInstance(String)", factory);
        }
        return factory;
    }

    public static JmsFactoryFactory getInstance(HashMap filter) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getInstance(HashMap)", new Object[]{filter});
        }
        String connectionTypeName = (String)filter.get("XMSC_PROVIDER_NAME");
        JmsFactoryFactory traceRet1 = JmsFactoryFactoryImpl.getInstance(connectionTypeName);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getInstance(HashMap)", traceRet1);
        }
        return traceRet1;
    }

    public JmsConnectionFactory createConnectionFactory() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createConnectionFactory()");
        }
        JmsConnectionFactory traceRet1 = this.providerJmsFactory.createConnectionFactory();
        traceRet1.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)20);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createConnectionFactory()", traceRet1);
        }
        return traceRet1;
    }

    public JmsQueueConnectionFactory createQueueConnectionFactory() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createQueueConnectionFactory()");
        }
        JmsQueueConnectionFactory traceRet1 = this.providerJmsFactory.createQueueConnectionFactory();
        traceRet1.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)17);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createQueueConnectionFactory()", traceRet1);
        }
        return traceRet1;
    }

    public JmsTopicConnectionFactory createTopicConnectionFactory() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createTopicConnectionFactory()");
        }
        JmsTopicConnectionFactory traceRet1 = this.providerJmsFactory.createTopicConnectionFactory();
        traceRet1.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)18);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createTopicConnectionFactory()", traceRet1);
        }
        return traceRet1;
    }

    public JmsXAConnectionFactory createXAConnectionFactory() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createXAConnectionFactory()");
        }
        JmsXAConnectionFactory traceRet1 = this.providerJmsFactory.createXAConnectionFactory();
        traceRet1.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)84);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createXAConnectionFactory()", traceRet1);
        }
        return traceRet1;
    }

    public JmsXAQueueConnectionFactory createXAQueueConnectionFactory() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createXAQueueConnectionFactory()");
        }
        JmsXAQueueConnectionFactory traceRet1 = this.providerJmsFactory.createXAQueueConnectionFactory();
        traceRet1.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)81);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createXAQueueConnectionFactory()", traceRet1);
        }
        return traceRet1;
    }

    public JmsXATopicConnectionFactory createXATopicConnectionFactory() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createXATopicConnectionFactory()");
        }
        JmsXATopicConnectionFactory traceRet1 = this.providerJmsFactory.createXATopicConnectionFactory();
        traceRet1.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)82);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createXATopicConnectionFactory()", traceRet1);
        }
        return traceRet1;
    }

    public JmsQueue createQueue(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createQueue(String)", new Object[]{name});
        }
        JmsQueue traceRet1 = this.providerJmsFactory.createQueue(name);
        traceRet1.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)33);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createQueue(String)", traceRet1);
        }
        return traceRet1;
    }

    public JmsTopic createTopic(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createTopic(String)", new Object[]{name});
        }
        JmsTopic traceRet1 = this.providerJmsFactory.createTopic(name);
        traceRet1.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)34);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createTopic(String)", traceRet1);
        }
        return traceRet1;
    }

    public int getConnectionType() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getConnectionType()", "getter", new Integer(this.connectionType));
        }
        return this.connectionType;
    }

    public String getConnectionTypeName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getConnectionTypeName()", "getter", this.connectionTypeName);
        }
        return this.connectionTypeName;
    }

    public JmsCapabilityContext getCapabilities() throws JMSException {
        Map captable = this.providerFactory.getCapabilities();
        JmsCapabilityContextImpl capabilities = new JmsCapabilityContextImpl(captable, false);
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getCapabilities()", "getter", capabilities);
        }
        return capabilities;
    }

    public ProviderFactoryFactory getProviderFactoryFactory() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getProviderFactoryFactory()", "getter", this.providerFactory);
        }
        return this.providerFactory;
    }

    protected ProviderMessageFactory getProviderMessageFactory() throws JMSException {
        ProviderMessageFactory traceRet1 = this.providerFactory.getMessageFactory();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getProviderMessageFactory()", "getter", traceRet1);
        }
        return traceRet1;
    }

    protected ProviderMetaData getProviderMetaData() throws JMSException {
        ProviderMetaData traceRet1 = this.providerFactory.getMetaData();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "getProviderMetaData()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public JmsConnectionFactory createConnectionFactory(short flag) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createConnectionFactory(short)", new Object[]{new Short(flag)});
        }
        JmsConnectionFactory cf = (JmsConnectionFactory)this.createJmsObject((short)(flag | 0x10), null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createConnectionFactory(short)", cf);
        }
        return cf;
    }

    public JmsDestination createDestination(short flag, String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createDestination(short,String)", new Object[]{new Short(flag), name});
        }
        JmsDestination dest = (JmsDestination)this.createJmsObject((short)(flag | 0x20), name);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createDestination(short,String)", dest);
        }
        return dest;
    }

    public JmsPropertyContext createJmsObject(short flag, Object parameter) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createJmsObject(short,Object)", new Object[]{new Short(flag), parameter});
        }
        short[] invalidFlags = new short[]{48, 36, 7, 96, 288, 320};
        boolean valid = true;
        for (int count = 0; count < invalidFlags.length; ++count) {
            valid = this.checkFlag(flag, invalidFlags[count]);
            if (valid) continue;
            HashMap<String, Object> inserts = new HashMap<String, Object>();
            inserts.put("XMSC_INSERT_VALUE", new Short(flag));
            inserts.put("XMSC_INSERT_NAME", "JmsObject flag");
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0005", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createJmsObject(short,Object)", je);
            }
            throw je;
        }
        JmsPropertyContext jmsObject = this.providerJmsFactory.createJmsObject(flag, parameter);
        if (jmsObject != null) {
            jmsObject.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", flag);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "createJmsObject(short,Object)", jmsObject);
        }
        return jmsObject;
    }

    private boolean checkFlag(short flag, short flagToCheck) {
        boolean containsInvalidFlag;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "checkFlag(short,short)", new Object[]{new Short(flag), new Short(flagToCheck)});
        }
        boolean bl = containsInvalidFlag = (flag & flagToCheck) == flagToCheck;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "checkFlag(short,short)", !containsInvalidFlag);
        }
        return !containsInvalidFlag;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsFactoryFactoryImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.40.1.1 09/08/17 09:28:34");
        }
        factories = new Hashtable();
    }
}

