/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConnectionMetaData;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.provider.ProviderConnection;
import com.ibm.msg.client.provider.ProviderMetaData;
import java.util.Enumeration;
import javax.jms.JMSException;

public class JmsConnectionMetaDataImpl
extends JmsPropertyContextImpl
implements JmsConnectionMetaData {
    private static final long serialVersionUID = -5283281176774919988L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsConnectionMetaDataImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.22.1.2 09/10/14 15:05:29";
    private static final int MY_JMS_MAJOR_VERSION = 1;
    private static final int MY_JMS_MINOR_VERSION = 1;
    private static final String MY_JMS_VERSION = "1.1";
    private ProviderMetaData providerMetaData;
    private boolean isInitialized;

    protected JmsConnectionMetaDataImpl(ProviderConnection providerConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "<init>(ProviderConnection)", new Object[]{providerConnection});
        }
        this.providerMetaData = providerConnection.getMetaData();
        this.setStringProperty("XMSC_JMS_VERSION", MY_JMS_VERSION);
        this.setIntProperty("XMSC_JMS_MAJOR_VERSION", 1);
        this.setIntProperty("XMSC_JMS_MINOR_VERSION", 1);
        this.setStringProperty("XMSC_PROVIDER_NAME", this.providerMetaData.getProviderName());
        this.setStringProperty("XMSC_VERSION", this.providerMetaData.getProviderVersion());
        this.setIntProperty("XMSC_MAJOR_VERSION", this.providerMetaData.getProviderMajorVersion());
        this.setIntProperty("XMSC_MINOR_VERSION", this.providerMetaData.getProviderMinorVersion());
        try {
            this.setLongProperty("OBJECT_IDENTITY", System.identityHashCode(this));
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.isInitialized = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "<init>(ProviderConnection)");
        }
    }

    public String getJMSVersion() throws JMSException {
        String traceRet1 = this.getStringProperty("XMSC_JMS_VERSION");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "getJMSVersion()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public int getJMSMajorVersion() throws JMSException {
        int traceRet1 = this.getIntProperty("XMSC_JMS_MAJOR_VERSION");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "getJMSMajorVersion()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getJMSMinorVersion() throws JMSException {
        int traceRet1 = this.getIntProperty("XMSC_JMS_MINOR_VERSION");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "getJMSMinorVersion()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public String getJMSProviderName() throws JMSException {
        String traceRet1 = this.getStringProperty("XMSC_PROVIDER_NAME");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "getJMSProviderName()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public String getProviderVersion() throws JMSException {
        String traceRet1 = this.getStringProperty("XMSC_VERSION");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "getProviderVersion()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public int getProviderMajorVersion() throws JMSException {
        int traceRet1 = this.getIntProperty("XMSC_MAJOR_VERSION");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "getProviderMajorVersion()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getProviderMinorVersion() throws JMSException {
        int traceRet1 = this.getIntProperty("XMSC_MINOR_VERSION");
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "getProviderMinorVersion()", "getter", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        Enumeration traceRet1 = this.providerMetaData.getJMSXPropertyNames();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "getJMSXPropertyNames()", "getter", traceRet1);
        }
        return traceRet1;
    }

    protected void validateProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "validateProperty(String,Object)", new Object[]{name, value});
        }
        if (this.isInitialized) {
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3040", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "validateProperty(String,Object)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "validateProperty(String,Object)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsConnectionMetaDataImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.22.1.2 09/10/14 15:05:29");
        }
    }
}

