/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConnection;
import com.ibm.msg.client.jms.JmsConnectionBrowser;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsMessageReferenceHandler;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsTopic;
import com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl;
import com.ibm.msg.client.jms.admin.JmsDestinationImpl;
import com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl;
import com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl;
import com.ibm.msg.client.jms.internal.JmsConnectionMetaDataImpl;
import com.ibm.msg.client.jms.internal.JmsDestinationImplProxy;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl;
import com.ibm.msg.client.jms.internal.JmsMessageReferenceImpl;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsProviderExceptionListener;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.jms.internal.State;
import com.ibm.msg.client.provider.ProviderConnection;
import com.ibm.msg.client.provider.ProviderConnectionBrowser;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderFactoryFactory;
import com.ibm.msg.client.provider.ProviderJmsFactory;
import com.ibm.msg.client.provider.ProviderMessageFactory;
import com.ibm.msg.client.provider.ProviderMessageReference;
import com.ibm.msg.client.provider.ProviderMessageReferenceHandler;
import com.ibm.msg.client.provider.ProviderSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;

public class JmsConnectionImpl
extends JmsPropertyContextImpl
implements JmsConnection {
    private static final long serialVersionUID = -1683009756330801802L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static int DEFAULT_DUPS_THRESHOLD;
    private ProviderFactoryFactory providerFactory;
    private ProviderMessageFactory providerMessageFactory;
    private ProviderJmsFactory providerJmsFactory;
    private ProviderConnection providerConnection;
    private ConnectionMetaData metaData;
    private JmsProviderExceptionListener exceptionListenerProxy;
    private volatile boolean clientIDFixed = false;
    protected ArrayList sessions;
    private ArrayList browsers;
    private ArrayList temporaryDestinations;
    protected State state = new State(2);
    private String connectionTypeName;
    private boolean receiveStoppedConnMsgLogged = false;
    private Object receiveStoppedConnMsgLoggedLock = new Object();
    static final /* synthetic */ boolean $assertionsDisabled;

    public JmsConnectionImpl(JmsConnectionFactoryImpl connectionFactory) throws JMSException {
        super(connectionFactory, true);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "<init>(JmsConnectionFactoryImpl)", new Object[]{connectionFactory});
        }
        this.sessions = new ArrayList();
        this.browsers = new ArrayList();
        this.exceptionListenerProxy = new JmsProviderExceptionListener(this.getIntProperty("XMSC_ASYNC_EXCEPTIONS"));
        this.temporaryDestinations = new ArrayList();
        this.state.setState(2);
        this.connectionTypeName = this.getStringProperty("XMSC_CONNECTION_TYPE_NAME");
        this.providerFactory = ((JmsFactoryFactoryImpl)JmsFactoryFactoryImpl.getInstance(this.connectionTypeName)).getProviderFactoryFactory();
        this.providerMessageFactory = this.providerFactory.getMessageFactory();
        this.providerJmsFactory = this.providerFactory.getJmsFactory();
        try {
            this.setLongProperty("OBJECT_IDENTITY", System.identityHashCode(this));
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "<init>(JmsConnectionFactoryImpl)");
        }
    }

    public void finalize() throws Throwable {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "finalize()");
            }
            try {
                this.close();
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "finalize()", je);
            }
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "finalize()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        block18: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "close()");
            }
            if (this.state.close()) {
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "close()", 1);
                }
                return;
            }
            this.fixClientID();
            this.exceptionListenerProxy.setExceptionListener(null);
            try {
                try {
                    State state = this.state;
                    synchronized (state) {
                        ArrayList clonedBrowsers = (ArrayList)this.browsers.clone();
                        Iterator browserIterator = clonedBrowsers.iterator();
                        while (browserIterator.hasNext()) {
                            ((JmsConnectionBrowserImpl)browserIterator.next()).close(true);
                        }
                        clonedBrowsers.clear();
                        clonedBrowsers = null;
                        if (!$assertionsDisabled && this.browsers.size() != 0) {
                            throw new AssertionError((Object)Trace.ffstAssertion(this, "close()", "XJ006002", new Object[]{"assertion=>browsers.size()==0", this.browsers}));
                        }
                        ArrayList clonedSessions = (ArrayList)this.sessions.clone();
                        Iterator sessionIterator = clonedSessions.iterator();
                        while (sessionIterator.hasNext()) {
                            ((JmsSessionImpl)sessionIterator.next()).close(true);
                        }
                        clonedSessions.clear();
                        clonedSessions = null;
                        if (!$assertionsDisabled && this.sessions.size() != 0) {
                            throw new AssertionError((Object)Trace.ffstAssertion(this, "close()", "XJ006001", new Object[]{"assertion=>sessions.size()==0", this.sessions}));
                        }
                    }
                }
                catch (JMSException je) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "close()", je);
                    }
                    throw je;
                }
                Object var8_7 = null;
                if (!Trace.isOn) break block18;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (Trace.isOn) {
                    Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "close()");
                }
                if (this.providerConnection != null) {
                    this.providerConnection.close();
                }
                throw throwable;
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "close()");
        }
        if (this.providerConnection != null) {
            this.providerConnection.close();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "close()", 2);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", new Object[]{destination, messageSelector, sessionPool, new Integer(maxMessages)});
        }
        this.state.checkNotClosed("JMSCC0008");
        if (destination == null || !(destination instanceof JmsQueue) && !(destination instanceof JmsTopic)) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0085", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", je, 1);
            }
            throw je;
        }
        if (null == sessionPool) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1084", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", je, 2);
            }
            throw je;
        }
        if (maxMessages <= 0) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1083", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", je, 3);
            }
            throw je;
        }
        this.fixClientID();
        JmsConnectionConsumerImpl connectionConsumer = new JmsConnectionConsumerImpl(this, (JmsDestination)destination, messageSelector, sessionPool, maxMessages);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createConnectionConsumer(Destination,String,ServerSessionPool,int)", connectionConsumer);
        }
        return connectionConsumer;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic destination, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", new Object[]{destination, subscriptionName, messageSelector, sessionPool, new Integer(maxMessages)});
        }
        this.state.checkNotClosed("JMSCC0008");
        if (destination == null || !(destination instanceof JmsTopic)) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0085", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", je, 1);
            }
            throw je;
        }
        JmsDestinationImpl jmsTopic = (JmsDestinationImpl)destination;
        ProviderDestination providerDestination = JmsDestinationImplProxy.getProviderDestination(jmsTopic);
        if (providerDestination.isTemporary()) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_TYPE", "Topic");
            inserts.put("XMSC_DESTINATION_NAME", jmsTopic.getTopicName());
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0093", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", je, 2);
            }
            throw je;
        }
        if (null == sessionPool) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1084", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", je, 3);
            }
            throw je;
        }
        if (maxMessages <= 0) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1083", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", je, 4);
            }
            throw je;
        }
        if (null == subscriptionName || subscriptionName.length() == 0) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3039", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", je, 5);
            }
            throw je;
        }
        this.fixClientID();
        String clientID = this.getClientID();
        if (clientID == null || "".equals(clientID)) {
            JMSException je5 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0101", null));
            throw je5;
        }
        JmsConnectionConsumerImpl connectionConsumer = new JmsConnectionConsumerImpl(this, (JmsTopic)destination, subscriptionName, messageSelector, sessionPool, maxMessages);
        JmsDestinationImplProxy.incrementUseCount((JmsDestinationImpl)destination);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionConsumer(Topic,String,String,ServerSessionPool,int)", connectionConsumer);
        }
        return connectionConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createSession(boolean,int)", new Object[]{transacted, new Integer(ackMode)});
        }
        this.state.checkNotClosed("JMSCC0008");
        if (!transacted && 1 != ackMode && 2 != ackMode && 3 != ackMode) {
            HashMap<String, Integer> inserts = new HashMap<String, Integer>();
            inserts.put("XMSC_ACKNOWLEDGE_MODE", new Integer(ackMode));
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0097", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createSession(boolean,int)", je);
            }
            throw je;
        }
        this.fixClientID();
        if (transacted) {
            ackMode = 0;
        }
        JmsSessionImpl jmsSession = this.instantiateSession(transacted, ackMode);
        jmsSession.setIntProperty("XMSC_ACKNOWLEDGE_MODE", ackMode);
        jmsSession.setBooleanProperty("XMSC_TRANSACTED", ackMode == 0);
        if (this instanceof XAConnection || this instanceof XAQueueConnection || this instanceof XATopicConnection) {
            short newFlags = (short)(jmsSession.getShortProperty("XMSC_ADMIN_OBJECT_TYPE") & 0xFFFFFFBF);
            jmsSession.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", newFlags);
        }
        ProviderSession providerSession = this.providerConnection.createSession(jmsSession);
        jmsSession.setProviderSession(providerSession);
        State state = this.state;
        synchronized (state) {
            if (this.state.equals(1)) {
                jmsSession.start();
            }
            this.sessions.add(jmsSession);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createSession(boolean,int)", jmsSession);
        }
        return jmsSession;
    }

    public String getClientID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getClientID()");
        }
        this.state.checkNotClosed("JMSCC0008");
        String cliendId = null;
        cliendId = this.getStringProperty("XMSC_CLIENT_ID");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getClientID()", cliendId);
        }
        return cliendId;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getExceptionListener()");
        }
        this.state.checkNotClosed("JMSCC0008");
        ExceptionListener traceRet1 = this.exceptionListenerProxy.getExceptionListener();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getExceptionListener()", traceRet1);
        }
        return traceRet1;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getMetaData()");
        }
        this.state.checkNotClosed("JMSCC0008");
        if (this.metaData == null) {
            this.metaData = new JmsConnectionMetaDataImpl(this.providerConnection);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getMetaData()", this.metaData);
        }
        return this.metaData;
    }

    public void setClientID(String clientID) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "setClientID(String)", new Object[]{clientID});
        }
        if (this.clientIDFixed) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3031", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "setClientID(String)", je, 1);
            }
            throw je;
        }
        if (null == clientID || clientID.length() == 0) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0002", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "setClientID(String)", je, 2);
            }
            throw je;
        }
        if (this.propertyExists("XMSC_CLIENT_ID") && null != this.getStringProperty("XMSC_CLIENT_ID") && this.getStringProperty("XMSC_CLIENT_ID").trim().length() > 0) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3032", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "setClientID(String)", je, 3);
            }
            throw je;
        }
        this.setStringProperty("XMSC_CLIENT_ID", clientID);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "setClientID(String)");
        }
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "setExceptionListener(ExceptionListener)", new Object[]{exceptionListener});
        }
        this.state.checkNotClosed("JMSCC0008");
        this.fixClientID();
        if (this.exceptionListenerProxy.getExceptionListener() != exceptionListener) {
            this.exceptionListenerProxy.setExceptionListener(exceptionListener);
            if (exceptionListener == null) {
                this.providerConnection.setExceptionListener(null);
            } else {
                this.providerConnection.setExceptionListener(this.exceptionListenerProxy);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "setExceptionListener(ExceptionListener)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "start()");
        }
        this.providerConnection.start();
        this.fixClientID();
        Object object = this.state;
        synchronized (object) {
            this.state.checkNotClosed("JMSCC0008");
            if (this.state.equals(2)) {
                int i;
                for (i = 0; i < this.sessions.size(); ++i) {
                    ((JmsSessionImpl)this.sessions.get(i)).start();
                }
                for (i = 0; i < this.browsers.size(); ++i) {
                    ((JmsConnectionBrowserImpl)this.browsers.get(i)).start();
                }
                this.state.setState(1);
            }
        }
        object = this.receiveStoppedConnMsgLoggedLock;
        synchronized (object) {
            this.receiveStoppedConnMsgLogged = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "start()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "stop()");
        }
        this.fixClientID();
        State state = this.state;
        synchronized (state) {
            this.state.checkNotClosed("JMSCC0008");
            if (this.state.equals(1) || this.state.equals(2)) {
                int i;
                for (i = 0; i < this.sessions.size(); ++i) {
                    ((JmsSessionImpl)this.sessions.get(i)).stop();
                }
                for (i = 0; i < this.browsers.size(); ++i) {
                    ((JmsConnectionBrowserImpl)this.browsers.get(i)).stop();
                }
                this.state.setState(2);
            }
            this.providerConnection.stop();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "stop()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmsConnectionBrowser createConnectionBrowser(JmsDestination destination, String selector, JmsMessageReferenceHandler messageRefHandler, int quantityHint) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createConnectionBrowser(JmsDestination,String,JmsMessageReferenceHandler,int)", new Object[]{destination, selector, messageRefHandler, new Integer(quantityHint)});
        }
        this.state.checkNotClosed("JMSCC0008");
        if (quantityHint != 0 && quantityHint != 1 && quantityHint != 2) {
            IllegalArgumentException iae = (IllegalArgumentException)JmsErrorUtils.createException("JMSCC1094", null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createConnectionBrowser(JmsDestination,String,JmsMessageReferenceHandler,int)", iae, 1);
            }
            throw iae;
        }
        if (destination == null || !(destination instanceof JmsQueue) && !(destination instanceof JmsTopic)) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0085", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createConnectionBrowser(JmsDestination,String,JmsMessageReferenceHandler,int)", je, 2);
            }
            throw je;
        }
        if (null == messageRefHandler) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1093", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createConnectionBrowser(JmsDestination,String,JmsMessageReferenceHandler,int)", je, 3);
            }
            throw je;
        }
        this.fixClientID();
        JmsConnectionBrowserImpl connBrowser = new JmsConnectionBrowserImpl(this, destination, selector, messageRefHandler, quantityHint);
        ProviderDestination provDest = JmsDestinationImplProxy.getProviderDestination((JmsDestinationImpl)destination);
        JmsProviderMessageRefHandler pmrh = new JmsProviderMessageRefHandler(messageRefHandler);
        ProviderConnectionBrowser providerConnectionBrowser = this.providerConnection.createConnectionBrowser(provDest, selector, pmrh, quantityHint);
        connBrowser.setProviderConnectionBrowser(providerConnectionBrowser);
        State state = this.state;
        synchronized (state) {
            if (this.state.equals(1)) {
                connBrowser.start();
            }
            this.browsers.add(connBrowser);
        }
        JmsDestinationImplProxy.incrementUseCount((JmsDestinationImpl)destination);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createConnectionBrowser(JmsDestination,String,JmsMessageReferenceHandler,int)", connBrowser);
        }
        return connBrowser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmsConnectionBrowser createDurableConnectionBrowser(JmsTopic topic, String subName, String selector, JmsMessageReferenceHandler messageRefHandler, int quantityHint, boolean noLocal) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionBrowser(JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)", new Object[]{topic, subName, selector, messageRefHandler, new Integer(quantityHint), noLocal});
        }
        this.state.checkNotClosed("JMSCC0008");
        if (quantityHint != 0 && quantityHint != 1 && quantityHint != 2) {
            IllegalArgumentException iae = (IllegalArgumentException)JmsErrorUtils.createException("JMSCC1094", null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionBrowser(JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)", iae, 1);
            }
            throw iae;
        }
        if (topic == null) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0085", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionBrowser(JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)", je, 2);
            }
            throw je;
        }
        JmsDestinationImpl jmsTopic = (JmsDestinationImpl)((Object)topic);
        ProviderDestination providerDestionation = JmsDestinationImplProxy.getProviderDestination(jmsTopic);
        if (providerDestionation.isTemporary()) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_TYPE", "Topic");
            inserts.put("XMSC_DESTINATION_NAME", jmsTopic.getTopicName());
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0093", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionBrowser(JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)", je, 3);
            }
            throw je;
        }
        if (null == messageRefHandler) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1093", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionBrowser(JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)", je, 4);
            }
            throw je;
        }
        if (null == subName || subName.length() == 0) {
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3039", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionBrowser(JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)", je, 5);
            }
            throw je;
        }
        this.fixClientID();
        String clientID = this.getClientID();
        if (clientID == null || "".equals(clientID)) {
            JMSException je5 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0101", null));
            throw je5;
        }
        JmsConnectionBrowserImpl connBrowser = new JmsConnectionBrowserImpl(this, topic, subName, selector, messageRefHandler, quantityHint, noLocal);
        ProviderDestination provDest = JmsDestinationImplProxy.getProviderDestination((JmsDestinationImpl)((Object)topic));
        JmsProviderMessageRefHandler pmrh = new JmsProviderMessageRefHandler(messageRefHandler);
        String clientid = this.getStringProperty("XMSC_CLIENT_ID");
        ProviderConnectionBrowser providerConnectionBrowser = this.providerConnection.createDurableConnectionBrowser(provDest, clientid, subName, selector, pmrh, quantityHint, noLocal);
        connBrowser.setProviderConnectionBrowser(providerConnectionBrowser);
        State state = this.state;
        synchronized (state) {
            if (this.state.equals(1)) {
                connBrowser.start();
            }
            this.browsers.add(connBrowser);
        }
        JmsDestinationImplProxy.incrementUseCount((JmsDestinationImpl)((Object)topic));
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "createDurableConnectionBrowser(JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)", connBrowser);
        }
        return connBrowser;
    }

    public ProviderConnection getProviderConnection() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getProviderConnection()", "getter", this.providerConnection);
        }
        return this.providerConnection;
    }

    public void setProviderConnection(ProviderConnection providerConnection) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "setProviderConnection(ProviderConnection)", "setter", providerConnection);
        }
        this.providerConnection = providerConnection;
    }

    public ProviderFactoryFactory getProviderFactory() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getProviderFactory()", "getter", this.providerFactory);
        }
        return this.providerFactory;
    }

    public ProviderMessageFactory getMessageFactory() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getMessageFactory()", "getter", this.providerMessageFactory);
        }
        return this.providerMessageFactory;
    }

    public ProviderJmsFactory getJmsFactory() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getJmsFactory()", "getter", this.providerJmsFactory);
        }
        return this.providerJmsFactory;
    }

    public void setProviderFactory(ProviderFactoryFactory providerFactory) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "setProviderFactory(ProviderFactoryFactory)", "setter", providerFactory);
        }
        this.providerFactory = providerFactory;
    }

    public void reportException(JMSException e, boolean connectionBroken) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "reportException(JMSException,boolean)", new Object[]{e, connectionBroken});
        }
        this.exceptionListenerProxy.onException(e, connectionBroken);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "reportException(JMSException,boolean)");
        }
    }

    protected JmsSessionImpl instantiateSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "instantiateSession(boolean,int)", new Object[]{transacted, new Integer(acknowledgeMode)});
        }
        JmsSessionImpl jmsSession = null;
        jmsSession = new JmsSessionImpl(transacted, acknowledgeMode, this);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "instantiateSession(boolean,int)", jmsSession);
        }
        return jmsSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(JmsSessionImpl sess) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "removeSession(JmsSessionImpl)", new Object[]{sess});
        }
        State state = this.state;
        synchronized (state) {
            this.sessions.remove(sess);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "removeSession(JmsSessionImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnectionBrowser(JmsConnectionBrowserImpl browser) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "removeConnectionBrowser(JmsConnectionBrowserImpl)", new Object[]{browser});
        }
        State state = this.state;
        synchronized (state) {
            this.browsers.remove(browser);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "removeConnectionBrowser(JmsConnectionBrowserImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State getState() {
        State state = this.state;
        synchronized (state) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getState()", "getter", this.state);
            }
            return this.state;
        }
    }

    protected void fixClientID() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "fixClientID()");
        }
        this.clientIDFixed = true;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "fixClientID()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTemporaryDestination(JmsDestination tempDest) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "addTemporaryDestination(JmsDestination)", new Object[]{tempDest});
        }
        this.fixClientID();
        ArrayList arrayList = this.temporaryDestinations;
        synchronized (arrayList) {
            this.temporaryDestinations.add(tempDest);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "addTemporaryDestination(JmsDestination)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTemporaryDestination(JmsDestination tempDest) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "removeTemporaryDestination(JmsDestination)", new Object[]{tempDest});
        }
        ArrayList arrayList = this.temporaryDestinations;
        synchronized (arrayList) {
            this.temporaryDestinations.remove(tempDest);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "removeTemporaryDestination(JmsDestination)");
        }
    }

    protected String getConnectionTypeName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "getConnectionTypeName()", "getter", this.connectionTypeName);
        }
        return this.connectionTypeName;
    }

    protected void validateProperty(String name, Object value) throws JMSException {
        if (Trace.isOn) {
            if ("XMSC_PASSWORD".equals(name)) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "validateProperty(String,Object)", new Object[]{name, "********"});
            } else {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "validateProperty(String,Object)", new Object[]{name, value});
            }
        }
        this.state.checkNotClosed("JMSCC0008");
        if (name.equals("XMSC_CLIENT_ID")) {
            if (this.clientIDFixed) {
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC3031", null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "setClientID(String)", je, 1);
                }
                throw je;
            }
            this.fixClientID();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "validateProperty(String,Object)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logReceiveStoppedConnMsg() {
        boolean b;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "logReceiveStoppedConnMsg()");
        }
        Object object = this.receiveStoppedConnMsgLoggedLock;
        synchronized (object) {
            b = this.receiveStoppedConnMsgLogged;
            this.receiveStoppedConnMsgLogged = true;
        }
        if (!b) {
            JmsErrorUtils.log(this, "logReceiveStoppedConnMsg", "JMSCC0004", null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionImpl", "logReceiveStoppedConnMsg()");
        }
    }

    static {
        boolean bl = $assertionsDisabled = !JmsConnectionImpl.class.desiredAssertionStatus();
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsConnectionImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsConnectionImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.70.1.9 12/07/11 16:42:19");
        }
        DEFAULT_DUPS_THRESHOLD = 20;
    }

    class JmsProviderMessageRefHandler
    implements ProviderMessageReferenceHandler {
        private JmsMessageReferenceHandler refHandler;

        JmsProviderMessageRefHandler(JmsMessageReferenceHandler refHandler) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageRefHandler", "<init>(JmsMessageReferenceHandler)", new Object[]{refHandler});
            }
            this.refHandler = refHandler;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageRefHandler", "<init>(JmsMessageReferenceHandler)");
            }
        }

        public void endDeliver() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageRefHandler", "endDeliver()");
            }
            this.refHandler.endDeliver();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageRefHandler", "endDeliver()");
            }
        }

        public void handleMessageReference(ProviderMessageReference msgReference) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageRefHandler", "handleMessageReference(ProviderMessageReference)", new Object[]{msgReference});
            }
            JmsMessageReferenceImpl jmsMessageRef = new JmsMessageReferenceImpl(JmsConnectionImpl.this.connectionTypeName, msgReference);
            this.refHandler.handleMessageReference(jmsMessageRef);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsProviderMessageRefHandler", "handleMessageReference(ProviderMessageReference)");
            }
        }
    }
}

