/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConnection;
import com.ibm.msg.client.jms.JmsConnectionBrowser;
import com.ibm.msg.client.jms.JmsConnectionConsumer;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsMessageReference;
import com.ibm.msg.client.jms.JmsMessageReferenceHandler;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsSession;
import com.ibm.msg.client.jms.JmsTopic;
import com.ibm.msg.client.jms.internal.JmsConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.State;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;

public class JmsConnectionConsumerImpl
extends JmsPropertyContextImpl
implements JmsConnectionConsumer {
    private static final long serialVersionUID = -4200467330524463500L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsConnectionConsumerImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.44.1.3 10/02/02 11:53:59";
    private JmsConnection connection;
    private String connectionTypeName;
    private JmsDestination destination;
    private String messageSelector;
    private ServerSessionPool serverSessionPool;
    private int maxMessages;
    private String subscriptionName;
    private State state = new State(1);
    private JmsConnectionBrowser connBrowser;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected JmsConnectionConsumerImpl(JmsConnectionImpl connection, JmsDestination destination, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        this(connection, destination, null, messageSelector, serverSessionPool, maxMessages);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "<init>(JmsConnectionImpl,JmsDestination,String,ServerSessionPool,int)", new Object[]{connection, destination, messageSelector, serverSessionPool, new Integer(maxMessages)});
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "<init>(JmsConnectionImpl,JmsDestination,String,ServerSessionPool,int)");
        }
    }

    protected JmsConnectionConsumerImpl(JmsConnectionImpl connection, JmsDestination destination, String subscriptionName, String messageSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        super(connection, true);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "<init>(JmsConnectionImpl,JmsDestination,String,String,ServerSessionPool,int)", new Object[]{connection, destination, subscriptionName, messageSelector, serverSessionPool, new Integer(maxMessages)});
        }
        if (!$assertionsDisabled && null == connection) {
            throw new AssertionError();
        }
        this.connection = connection;
        this.connectionTypeName = connection.getConnectionTypeName();
        this.destination = destination;
        this.messageSelector = messageSelector;
        this.serverSessionPool = serverSessionPool;
        this.maxMessages = maxMessages;
        this.subscriptionName = subscriptionName;
        this.createConnectionBrowser();
        try {
            this.setLongProperty("OBJECT_IDENTITY", System.identityHashCode(this));
        }
        catch (JMSException e) {
            // empty catch block
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "<init>(JmsConnectionImpl,JmsDestination,String,String,ServerSessionPool,int)");
        }
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "getServerSessionPool()", "getter", this.serverSessionPool);
        }
        return this.serverSessionPool;
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "close()");
        }
        if (this.state.close()) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "close()", 1);
            }
            return;
        }
        this.connBrowser.close();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "close()", 2);
        }
    }

    private void createConnectionBrowser() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "createConnectionBrowser()");
        }
        JmsMessageReferenceHandlerImpl refHandler = new JmsMessageReferenceHandlerImpl();
        if (this.destination instanceof JmsQueue || this.subscriptionName == null) {
            this.connBrowser = this.connection.createConnectionBrowser(this.destination, this.messageSelector, refHandler, 0);
        } else {
            boolean nolocal = false;
            this.connBrowser = this.connection.createDurableConnectionBrowser((JmsTopic)this.destination, this.subscriptionName, this.messageSelector, refHandler, 0, nolocal);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "createConnectionBrowser()");
        }
    }

    static {
        boolean bl = $assertionsDisabled = !JmsConnectionConsumerImpl.class.desiredAssertionStatus();
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsConnectionConsumerImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.44.1.3 10/02/02 11:53:59");
        }
    }

    private class JmsMessageReferenceHandlerImpl
    implements JmsMessageReferenceHandler {
        private ArrayList messageReferences;
        static final /* synthetic */ boolean $assertionsDisabled;

        JmsMessageReferenceHandlerImpl() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "<init>()");
            }
            if (JmsConnectionConsumerImpl.this.maxMessages <= 0) {
                HashMap<String, Integer> inserts = new HashMap<String, Integer>();
                inserts.put("XMSC_INSERT_BATCH_SIZE", new Integer(JmsConnectionConsumerImpl.this.maxMessages));
                JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0086", inserts));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "<init>()", je, 1);
                }
                throw je;
            }
            if (JmsConnectionConsumerImpl.this.serverSessionPool == null) {
                JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0087", null));
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "<init>()", je2, 2);
                }
                throw je2;
            }
            this.messageReferences = new ArrayList(JmsConnectionConsumerImpl.this.maxMessages);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "<init>()");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endDeliver() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "endDeliver()");
            }
            ArrayList currentReferences = null;
            JmsMessageReferenceHandlerImpl jmsMessageReferenceHandlerImpl = this;
            synchronized (jmsMessageReferenceHandlerImpl) {
                if (!$assertionsDisabled && this.messageReferences.size() > 1) {
                    throw new AssertionError((Object)Trace.ffstAssertion(this, "endDeliver()", "XJ009001", new Object[]{"assertion=>messageReferences.size() <= 1", this.messageReferences}));
                }
                if (0 == this.messageReferences.size()) {
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "endDeliver()", 1);
                    }
                    return;
                }
                currentReferences = this.messageReferences;
                this.messageReferences = new ArrayList(JmsConnectionConsumerImpl.this.maxMessages);
            }
            this.endDeliverInternal(currentReferences);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "endDeliver()", 2);
            }
        }

        private void endDeliverInternal(ArrayList currentReferences) throws JMSException {
            ServerSession serverSession;
            block15: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "endDeliverInternal(ArrayList)", new Object[]{currentReferences});
                }
                serverSession = null;
                try {
                    serverSession = JmsConnectionConsumerImpl.this.serverSessionPool.getServerSession();
                }
                catch (Exception e) {
                    if (!Trace.isOn) break block15;
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "endDeliverInternal(ArrayList)", e, 1);
                }
            }
            if (serverSession == null) {
                this.messageReferences.clear();
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "endDeliverInternal(ArrayList)", 1);
                }
                return;
            }
            Session jmsSession = null;
            Exception thrown = null;
            try {
                jmsSession = serverSession.getSession();
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "endDeliverInternal(ArrayList)", e, 2);
                }
                thrown = e;
            }
            if (jmsSession == null || !(jmsSession instanceof JmsSession)) {
                HashMap<String, Session> inserts = new HashMap<String, Session>();
                inserts.put("XMSC_INSERT_SESSION", jmsSession);
                JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0089", inserts));
                if (thrown != null) {
                    je2.setLinkedException(thrown);
                }
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "endDeliverInternal(ArrayList)", je2);
                }
                throw je2;
            }
            try {
                ((JmsSession)jmsSession).deliver(currentReferences);
            }
            catch (JMSException jmsEx1) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "endDeliverInternal(ArrayList)", jmsEx1, 3);
                }
                HashMap<String, Object> ffstData = new HashMap<String, Object>();
                ffstData.put("JMS Session", jmsSession);
                ffstData.put("Exception", (Object)jmsEx1);
                Trace.ffst(this, "endDeliverInternal()", "XJ009003", ffstData, null);
            }
            serverSession.start();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "endDeliverInternal(ArrayList)", 2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessageReference(JmsMessageReference messageReference) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "handleMessageReference(JmsMessageReference)", new Object[]{messageReference});
            }
            ArrayList messagesToDeliver = null;
            JmsMessageReferenceHandlerImpl jmsMessageReferenceHandlerImpl = this;
            synchronized (jmsMessageReferenceHandlerImpl) {
                if (this.messageReferences.size() < JmsConnectionConsumerImpl.this.maxMessages) {
                    this.messageReferences.add(messageReference);
                } else {
                    HashMap<String, Integer> ffstData = new HashMap<String, Integer>();
                    ffstData.put("maxMessages", new Integer(JmsConnectionConsumerImpl.this.maxMessages));
                    ffstData.put("messageReferences.size()", new Integer(this.messageReferences.size()));
                    Trace.ffst(this, "handleMessageReference()", "XJ009002", ffstData, null);
                }
                if (this.messageReferences.size() == JmsConnectionConsumerImpl.this.maxMessages) {
                    messagesToDeliver = this.messageReferences;
                    this.messageReferences = new ArrayList(JmsConnectionConsumerImpl.this.maxMessages);
                }
            }
            if (messagesToDeliver != null) {
                this.endDeliverInternal(messagesToDeliver);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsMessageReferenceHandlerImpl", "handleMessageReference(JmsMessageReference)");
            }
        }

        static {
            $assertionsDisabled = !(class$com$ibm$msg$client$jms$internal$JmsConnectionConsumerImpl == null ? (class$com$ibm$msg$client$jms$internal$JmsConnectionConsumerImpl = JmsConnectionConsumerImpl.class$("com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl")) : class$com$ibm$msg$client$jms$internal$JmsConnectionConsumerImpl).desiredAssertionStatus();
        }
    }
}

