/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConnectionBrowser;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsMessageReferenceHandler;
import com.ibm.msg.client.jms.JmsTopic;
import com.ibm.msg.client.jms.admin.JmsDestinationImpl;
import com.ibm.msg.client.jms.internal.JmsConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsDestinationImplProxy;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.State;
import com.ibm.msg.client.provider.ProviderConnectionBrowser;
import javax.jms.JMSException;

public class JmsConnectionBrowserImpl
extends JmsPropertyContextImpl
implements JmsConnectionBrowser {
    private static final long serialVersionUID = -3527307861058577428L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid1 = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsConnectionBrowserImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.27.1.2 09/10/14 15:05:19";
    private JmsDestination destination;
    private String selector;
    private JmsMessageReferenceHandler messageRefHandler;
    private int quantityHint;
    private String subName;
    private boolean noLocal;
    private ProviderConnectionBrowser providerConnectionBrowser;
    private JmsConnectionImpl connection;
    private State state = new State(1);

    public JmsConnectionBrowserImpl(JmsConnectionImpl conn, JmsDestination destination, String selector, JmsMessageReferenceHandler messageRefHandler, int quantityHint) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "<init>(JmsConnectionImpl,JmsDestination,String,JmsMessageReferenceHandler,int)", new Object[]{conn, destination, selector, messageRefHandler, new Integer(quantityHint)});
        }
        this.destination = destination;
        this.selector = selector;
        this.messageRefHandler = messageRefHandler;
        this.quantityHint = quantityHint;
        this.connection = conn;
        try {
            this.setLongProperty("OBJECT_IDENTITY", System.identityHashCode(this));
        }
        catch (JMSException e) {
            // empty catch block
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "<init>(JmsConnectionImpl,JmsDestination,String,JmsMessageReferenceHandler,int)");
        }
    }

    public JmsConnectionBrowserImpl(JmsConnectionImpl conn, JmsTopic topic, String subName, String selector, JmsMessageReferenceHandler messageRefHandler, int quantityHint, boolean noLocal) {
        this(conn, topic, selector, messageRefHandler, quantityHint);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "<init>(JmsConnectionImpl,JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)", new Object[]{conn, topic, subName, selector, messageRefHandler, new Integer(quantityHint), noLocal});
        }
        this.subName = subName;
        this.noLocal = noLocal;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "<init>(JmsConnectionImpl,JmsTopic,String,String,JmsMessageReferenceHandler,int,boolean)");
        }
    }

    void start() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "start()");
        }
        this.providerConnectionBrowser.start();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "start()");
        }
    }

    void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "stop()");
        }
        this.providerConnectionBrowser.stop();
        this.messageRefHandler.endDeliver();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "stop()");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "close()");
        }
        this.close(false);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "close()");
        }
    }

    public void close(boolean closingFromConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "close(boolean)", new Object[]{closingFromConnection});
        }
        if (this.state.close()) {
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "close(boolean)", 1);
            }
            return;
        }
        this.connection.removeConnectionBrowser(this);
        JmsDestinationImplProxy.decrementUseCount((JmsDestinationImpl)this.destination);
        this.stop();
        this.state.setState(3);
        this.providerConnectionBrowser.close(closingFromConnection);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "close(boolean)", 2);
        }
    }

    protected ProviderConnectionBrowser getProviderConnectionBrowser() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "getProviderConnectionBrowser()", "getter", this.providerConnectionBrowser);
        }
        return this.providerConnectionBrowser;
    }

    protected void setProviderConnectionBrowser(ProviderConnectionBrowser providerConnectionBrowser) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "setProviderConnectionBrowser(ProviderConnectionBrowser)", "setter", providerConnectionBrowser);
        }
        this.providerConnectionBrowser = providerConnectionBrowser;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsConnectionBrowserImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsConnectionBrowserImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.27.1.2 09/10/14 15:05:19");
        }
    }
}

