/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.internal.Float390;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsMessageImpl;
import com.ibm.msg.client.jms.internal.JmsSessionImpl;
import com.ibm.msg.client.provider.ProviderBytesMessage;
import com.ibm.msg.client.provider.ProviderMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;

public class JmsBytesMessageImpl
extends JmsMessageImpl
implements BytesMessage {
    private static final long serialVersionUID = 5350812021957171977L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsBytesMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.29.1.1 09/08/17 09:27:13";
    public static final int ENC_INTEGER_MASK = 15;
    public static final int ENC_FLOAT_MASK = 3840;
    public static final int ENC_INTEGER_UNDEFINED = 0;
    public static final int ENC_INTEGER_NORMAL = 1;
    public static final int ENC_INTEGER_REVERSED = 2;
    public static final int ENC_FLOAT_UNDEFINED = 0;
    public static final int ENC_FLOAT_IEEE_NORMAL = 256;
    public static final int ENC_FLOAT_IEEE_REVERSED = 512;
    public static final int ENC_FLOAT_S390 = 768;
    private ProviderBytesMessage providerBytesMessage;
    private boolean providerBytesBodySet;
    private int lastEncoding;
    private boolean requiresInit = false;
    private transient ByteArrayOutputStream writeByteStream;
    private transient DataOutputStream writeStream;
    private static final int ARRAY_SIZE = 20;
    private int integerCount;
    private int[] integerOffsets;
    private int[] integerSizes;
    private Vector integers;
    private Vector floatOffsets;
    private Vector floatValues;
    private boolean populatedByClient = true;
    private byte[] dataBuffer;
    private int integerEncoding = 1;
    private int floatEncoding = 256;
    private transient ByteArrayInputStream readStream;
    private int streamOffset;
    private boolean markInUse = false;
    private transient String cachedBytesToString = null;

    protected JmsBytesMessageImpl(JmsSessionImpl session) throws JMSException {
        super(session);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "<init>(JmsSessionImpl)", new Object[]{session});
        }
        this.clearBody();
        this.messageType = "jms_bytes";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "<init>(JmsSessionImpl)");
        }
    }

    public JmsBytesMessageImpl(String connectionType) throws JMSException {
        super(connectionType);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "<init>(String)", new Object[]{connectionType});
        }
        this.clearBody();
        this.messageType = "jms_bytes";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "<init>(String)");
        }
    }

    JmsBytesMessageImpl(ProviderBytesMessage providerBytesMessage, JmsSessionImpl jmsSession, String connectionTypeName) throws JMSException {
        super(providerBytesMessage, jmsSession, connectionTypeName);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "<init>(ProviderBytesMessage,JmsSessionImpl,String)", new Object[]{providerBytesMessage, jmsSession, connectionTypeName});
        }
        this.requiresInit = true;
        this.providerBytesMessage = providerBytesMessage;
        this.setBodyReadOnly();
        this.messageType = "jms_bytes";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "<init>(ProviderBytesMessage,JmsSessionImpl,String)");
        }
    }

    JmsBytesMessageImpl(JmsSessionImpl session, BytesMessage bytesMessage) throws JMSException {
        super(session, (Message)bytesMessage);
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "<init>(JmsSessionImpl,BytesMessage)", new Object[]{session, bytesMessage});
        }
        this.clearBody();
        bytesMessage.reset();
        int MAX_BUFFER_SIZE = 32768;
        int bufferSize = 0;
        long bodyLength = bytesMessage.getBodyLength();
        bufferSize = bodyLength > 32768L ? 32768 : (int)bodyLength;
        byte[] buffer = new byte[bufferSize];
        int nRead = 0;
        while ((nRead = bytesMessage.readBytes(buffer)) > 0) {
            this.writeBytes(buffer, 0, nRead);
        }
        this.messageType = "jms_bytes";
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "<init>(JmsSessionImpl,BytesMessage)");
        }
    }

    private void lazyInit() {
        block6: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "lazyInit()");
            }
            this.requiresInit = false;
            try {
                this.dataBuffer = this.providerBytesMessage.getBytes();
                if (this.dataBuffer == null) {
                    this.dataBuffer = new byte[0];
                }
                this.readStream = new ByteArrayInputStream(this.dataBuffer);
                if (this.propertyExists("JMS_IBM_Encoding")) {
                    int encoding = this.getIntProperty("JMS_IBM_Encoding");
                    this.integerEncoding = encoding & 0xF;
                    this.floatEncoding = encoding & 0xF00;
                }
            }
            catch (JMSException je) {
                if (!Trace.isOn) break block6;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "lazyInit()", je);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "lazyInit()");
        }
    }

    protected ProviderMessage createProviderMessage(JmsSessionImpl session) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "createProviderMessage(JmsSessionImpl)", new Object[]{session});
        }
        this.providerBytesMessage = session != null ? this.providerMessageFactory.createBytesMessage(session.getProviderSession()) : this.providerMessageFactory.createBytesMessage(null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "createProviderMessage(JmsSessionImpl)", this.providerBytesMessage);
        }
        return this.providerBytesMessage;
    }

    protected ProviderMessage getProviderMessage() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "getProviderMessage()");
        }
        if (!this.isBodyReadOnly()) {
            int encoding = this.integerEncoding | this.floatEncoding;
            if (this.propertyExists("JMS_IBM_Encoding")) {
                encoding = this.getIntProperty("JMS_IBM_Encoding");
            }
            if (!this.providerBytesBodySet || encoding != this.lastEncoding) {
                byte[] encodedBody = this.encodeBody(encoding);
                this.providerBytesMessage.setBytes(encodedBody);
                this.lastEncoding = encoding;
                this.providerBytesBodySet = true;
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "getProviderMessage()", this.providerBytesMessage);
        }
        return this.providerBytesMessage;
    }

    private byte[] encodeBody(int encoding) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "encodeBody(int)", new Object[]{new Integer(encoding)});
        }
        try {
            this.dataBuffer = this.writeByteStream.toByteArray();
            if (this.populatedByClient) {
                int requestedIntegerEncoding = encoding & 0xF;
                int requestedFloatEncoding = encoding & 0xF00;
                if (this.integerEncoding <= 1 && requestedIntegerEncoding == 2 || this.integerEncoding == 2 && requestedIntegerEncoding <= 1) {
                    if (this.integers != null) {
                        for (int i = 0; i < this.integers.size(); i += 2) {
                            int[] offsets = (int[])this.integers.elementAt(i);
                            int[] sizes = (int[])this.integers.elementAt(i + 1);
                            for (int j = 0; j < 20; ++j) {
                                this.reverse(this.dataBuffer, offsets[j], sizes[j]);
                            }
                        }
                    }
                    for (int j = 0; j < this.integerCount; ++j) {
                        this.reverse(this.dataBuffer, this.integerOffsets[j], this.integerSizes[j]);
                    }
                }
                if (this.floatEncoding != requestedFloatEncoding) {
                    ByteArrayOutputStream floatbaos = new ByteArrayOutputStream(8);
                    DataOutputStream floatstream = new DataOutputStream(floatbaos);
                    if (this.floatOffsets != null && this.floatValues != null) {
                        for (int i = 0; i < this.floatOffsets.size(); ++i) {
                            floatbaos.reset();
                            Object value = this.floatValues.elementAt(i);
                            int offset = (Integer)this.floatOffsets.elementAt(i);
                            if (value instanceof Float) {
                                float floatValue = ((Float)value).floatValue();
                                switch (requestedFloatEncoding) {
                                    case 256: 
                                    case 512: {
                                        floatstream.writeInt(Float.floatToIntBits(floatValue));
                                        break;
                                    }
                                    case 768: {
                                        floatstream.writeInt(Float390.floatToS390IntBits(floatValue));
                                        break;
                                    }
                                    default: {
                                        HashMap<String, String> inserts = new HashMap<String, String>();
                                        inserts.put("JMS_IBM_Encoding", Integer.toHexString(requestedFloatEncoding));
                                        JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0063", inserts));
                                        if (Trace.isOn) {
                                            Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "encodeBody(int)", traceRet1, 1);
                                        }
                                        throw traceRet1;
                                    }
                                }
                                byte[] floatbytes = floatbaos.toByteArray();
                                if (requestedFloatEncoding == 512) {
                                    this.reverse(floatbytes, 0, 4);
                                }
                                System.arraycopy(floatbytes, 0, this.dataBuffer, offset, 4);
                                continue;
                            }
                            if (!(value instanceof Double)) continue;
                            double doubleValue = (Double)value;
                            switch (requestedFloatEncoding) {
                                case 256: 
                                case 512: {
                                    floatstream.writeLong(Double.doubleToLongBits(doubleValue));
                                    break;
                                }
                                case 768: {
                                    floatstream.writeLong(Float390.doubleToS390LongBits(doubleValue));
                                    break;
                                }
                                default: {
                                    HashMap<String, String> inserts = new HashMap<String, String>();
                                    inserts.put("JMS_IBM_Encoding", Integer.toHexString(requestedFloatEncoding));
                                    JMSException traceRet2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0063", inserts));
                                    if (Trace.isOn) {
                                        Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "encodeBody(int)", traceRet2, 2);
                                    }
                                    throw traceRet2;
                                }
                            }
                            byte[] floatbytes = floatbaos.toByteArray();
                            if (requestedFloatEncoding == 512) {
                                this.reverse(floatbytes, 0, 8);
                            }
                            System.arraycopy(floatbytes, 0, this.dataBuffer, offset, 8);
                        }
                    }
                }
            } else {
                byte[] newBytes = new byte[this.dataBuffer.length];
                System.arraycopy(this.dataBuffer, 0, newBytes, 0, this.dataBuffer.length);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "encodeBody(int)", newBytes, 1);
                }
                return newBytes;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "encodeBody(int)", this.dataBuffer, 2);
            }
            return this.dataBuffer;
        }
        catch (IOException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "encodeBody(int)", e);
            }
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0064", null));
            je.setLinkedException((Exception)e);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "encodeBody(int)", je, 3);
            }
            throw je;
        }
    }

    public void clearBody() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "clearBody()");
        }
        super.clearBody();
        this.dataBuffer = null;
        this.readStream = null;
        this.writeByteStream = new ByteArrayOutputStream();
        this.writeStream = new DataOutputStream(this.writeByteStream);
        this.populatedByClient = true;
        if (this.providerBytesMessage != null) {
            this.providerBytesMessage.removeProperty("JMS_IBM_Encoding");
            this.providerBytesMessage.removeProperty("JMS_IBM_Character_Set");
        }
        this.integerEncoding = 1;
        this.floatEncoding = 256;
        this.integerCount = 0;
        this.integerOffsets = new int[20];
        this.integerSizes = new int[20];
        if (this.integers != null) {
            this.integers.removeAllElements();
        }
        if (this.floatOffsets != null) {
            this.floatOffsets.removeAllElements();
        }
        if (this.floatValues != null) {
            this.floatValues.removeAllElements();
        }
        this.cachedBytesToString = null;
        this.providerBytesBodySet = false;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "clearBody()");
        }
    }

    public long getBodyLength() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "getBodyLength()");
        }
        this.checkBodyReadable("getBodyLength");
        if (this.requiresInit) {
            this.lazyInit();
        }
        long bLen = this.isBodyReadOnly() ? (this.dataBuffer == null ? 0L : (long)this.dataBuffer.length) : (this.writeByteStream == null ? 0L : (long)this.writeByteStream.size());
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "getBodyLength()", new Long(bLen));
        }
        return bLen;
    }

    public boolean readBoolean() throws JMSException {
        boolean traceRet2;
        int byteRead;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readBoolean()");
        }
        this.checkBodyReadable("readBoolean");
        if (this.requiresInit) {
            this.lazyInit();
        }
        if ((byteRead = this.readStream.read()) < 0) {
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0065", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readBoolean()", traceRet1);
            }
            throw traceRet1;
        }
        boolean bl = traceRet2 = byteRead != 0;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readBoolean()", traceRet2);
        }
        return traceRet2;
    }

    public byte readByte() throws JMSException {
        int byteRead;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readByte()");
        }
        this.checkBodyReadable("readByte");
        if (this.requiresInit) {
            this.lazyInit();
        }
        if ((byteRead = this.readStream.read()) < 0) {
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0065", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readByte()", traceRet1);
            }
            throw traceRet1;
        }
        byte traceRet2 = (byte)byteRead;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readByte()", new Byte(traceRet2));
        }
        return traceRet2;
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readBytes(byte [ ],int)", new Object[]{value, new Integer(length)});
        }
        this.checkBodyReadable("readBytes");
        if (this.requiresInit) {
            this.lazyInit();
        }
        if (value.length < length || length < 0) {
            IndexOutOfBoundsException traceRet1 = new IndexOutOfBoundsException();
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readBytes(byte [ ],int)", traceRet1);
            }
            throw traceRet1;
        }
        int traceRet2 = this.readStream.read(value, 0, length);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readBytes(byte [ ],int)", new Integer(traceRet2));
        }
        return traceRet2;
    }

    public int readBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readBytes(byte [ ])", new Object[]{value});
        }
        int traceRet1 = this.readBytes(value, value.length);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readBytes(byte [ ])", new Integer(traceRet1));
        }
        return traceRet1;
    }

    public char readChar() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readChar()");
        }
        this.checkBodyReadable("readChar");
        if (this.requiresInit) {
            this.lazyInit();
        }
        if (!this.markInUse) {
            this.readStream.mark(2);
        }
        int byte1 = this.readStream.read();
        int byte2 = this.readStream.read();
        if (byte2 < 0) {
            this.readStream.reset();
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0065", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readChar()", traceRet1);
            }
            throw traceRet1;
        }
        if (this.integerEncoding == 2) {
            char traceRet2 = (char)((byte2 << 8) + byte1);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readChar()", new Character(traceRet2), 1);
            }
            return traceRet2;
        }
        char traceRet3 = (char)((byte1 << 8) + byte2);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readChar()", new Character(traceRet3), 2);
        }
        return traceRet3;
    }

    public double readDouble() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readDouble()");
        }
        int savedEncoding = this.integerEncoding;
        try {
            switch (this.floatEncoding) {
                case 256: {
                    this.integerEncoding = 1;
                    double traceRet1 = Double.longBitsToDouble(this.readLong());
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readDouble()", new Double(traceRet1), 1);
                    }
                    return traceRet1;
                }
                case 512: {
                    this.integerEncoding = 2;
                    double traceRet2 = Double.longBitsToDouble(this.readLong());
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readDouble()", new Double(traceRet2), 2);
                    }
                    return traceRet2;
                }
                case 768: {
                    this.integerEncoding = 1;
                    double traceRet3 = Float390.longS390BitsToDouble(this.readLong());
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readDouble()", new Double(traceRet3), 3);
                    }
                    return traceRet3;
                }
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("JMS_IBM_Encoding", Integer.toHexString(this.floatEncoding));
            JMSException traceRet4 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0063", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readDouble()", traceRet4, 1);
            }
            throw traceRet4;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readDouble()", ex);
            }
            HashMap<String, Object> inserts = new HashMap<String, Object>();
            inserts.put("XMSC_INSERT_EXCEPTION", ex);
            inserts.put("XMSC_INSERT_METHOD", "readDouble");
            JMSException traceRet5 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0007", inserts));
            traceRet5.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readDouble()", traceRet5, 2);
            }
            throw traceRet5;
        }
    }

    public float readFloat() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readFloat()");
        }
        int savedEncoding = this.integerEncoding;
        try {
            switch (this.floatEncoding) {
                case 256: {
                    this.integerEncoding = 1;
                    float traceRet1 = Float.intBitsToFloat(this.readInt());
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readFloat()", new Float(traceRet1), 1);
                    }
                    return traceRet1;
                }
                case 512: {
                    this.integerEncoding = 2;
                    float traceRet2 = Float.intBitsToFloat(this.readInt());
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readFloat()", new Float(traceRet2), 2);
                    }
                    return traceRet2;
                }
                case 768: {
                    this.integerEncoding = 1;
                    float traceRet3 = Float390.intS390BitsToFloat(this.readInt());
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readFloat()", new Float(traceRet3), 3);
                    }
                    return traceRet3;
                }
            }
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("JMS_IBM_Encoding", Integer.toHexString(this.floatEncoding));
            JMSException traceRet4 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0063", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readFloat()", traceRet4, 1);
            }
            throw traceRet4;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readFloat()", ex);
            }
            HashMap<String, Object> inserts = new HashMap<String, Object>();
            inserts.put("XMSC_INSERT_EXCEPTION", ex);
            inserts.put("XMSC_INSERT_METHOD", "readFloat");
            JMSException traceRet5 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0007", inserts));
            traceRet5.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readFloat()", traceRet5, 2);
            }
            throw traceRet5;
        }
    }

    public int readInt() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readInt()");
        }
        this.checkBodyReadable("readInt");
        if (this.requiresInit) {
            this.lazyInit();
        }
        if (!this.markInUse) {
            this.readStream.mark(4);
        }
        int byte1 = this.readStream.read();
        int byte2 = this.readStream.read();
        int byte3 = this.readStream.read();
        int byte4 = this.readStream.read();
        if (byte4 < 0) {
            this.readStream.reset();
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0065", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readInt()", traceRet1);
            }
            throw traceRet1;
        }
        if (this.integerEncoding == 2) {
            int traceRet2 = (byte4 << 24) + (byte3 << 16) + (byte2 << 8) + byte1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readInt()", new Integer(traceRet2), 1);
            }
            return traceRet2;
        }
        int traceRet3 = (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + byte4;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readInt()", new Integer(traceRet3), 2);
        }
        return traceRet3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws JMSException {
        long l;
        block10: {
            long int2;
            long int1;
            block8: {
                long l2;
                block9: {
                    if (Trace.isOn) {
                        Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readLong()");
                    }
                    try {
                        this.checkBodyReadable("readLong");
                        if (this.requiresInit) {
                            this.lazyInit();
                        }
                        this.readStream.mark(8);
                        this.markInUse = true;
                        int1 = (long)this.readInt() & 0xFFFFFFFFL;
                        int2 = (long)this.readInt() & 0xFFFFFFFFL;
                        if (this.integerEncoding != 2) break block8;
                        long traceRet1 = (int2 << 32) + int1;
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readLong()", new Long(traceRet1), 1);
                        }
                        l2 = traceRet1;
                        Object var10_7 = null;
                        if (!Trace.isOn) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        if (Trace.isOn) {
                            Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readLong()");
                        }
                        this.markInUse = false;
                        throw throwable;
                    }
                    Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readLong()");
                }
                this.markInUse = false;
                return l2;
            }
            long traceRet2 = (int1 << 32) + int2;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readLong()", new Long(traceRet2), 2);
            }
            l = traceRet2;
            Object var10_8 = null;
            if (!Trace.isOn) break block10;
            Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readLong()");
        }
        this.markInUse = false;
        return l;
    }

    public short readShort() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readShort()");
        }
        this.checkBodyReadable("readShort");
        if (this.requiresInit) {
            this.lazyInit();
        }
        if (!this.markInUse) {
            this.readStream.mark(2);
        }
        int byte1 = this.readStream.read();
        int byte2 = this.readStream.read();
        if (byte2 < 0) {
            this.readStream.reset();
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0065", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readShort()", traceRet1);
            }
            throw traceRet1;
        }
        if (this.integerEncoding == 2) {
            short traceRet2 = (short)((byte2 << 8) + byte1);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readShort()", new Short(traceRet2), 1);
            }
            return traceRet2;
        }
        short traceRet3 = (short)((byte1 << 8) + byte2);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readShort()", new Short(traceRet3), 2);
        }
        return traceRet3;
    }

    public int readUnsignedByte() throws JMSException {
        int byteRead;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUnsignedByte()");
        }
        this.checkBodyReadable("readUnsignedByte");
        if (this.requiresInit) {
            this.lazyInit();
        }
        if ((byteRead = this.readStream.read()) < 0) {
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0065", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUnsignedByte()", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUnsignedByte()", new Integer(byteRead));
        }
        return byteRead;
    }

    public int readUnsignedShort() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUnsignedShort()");
        }
        this.checkBodyReadable("readUnsignedShort");
        if (this.requiresInit) {
            this.lazyInit();
        }
        if (!this.markInUse) {
            this.readStream.mark(2);
        }
        int byte1 = this.readStream.read();
        int byte2 = this.readStream.read();
        if (byte2 < 0) {
            this.readStream.reset();
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0065", null));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUnsignedShort()", traceRet1);
            }
            throw traceRet1;
        }
        if (this.integerEncoding == 2) {
            int traceRet2 = (byte2 << 8) + byte1;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUnsignedShort()", new Integer(traceRet2), 1);
            }
            return traceRet2;
        }
        int traceRet3 = (byte1 << 8) + byte2;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUnsignedShort()", new Integer(traceRet3), 2);
        }
        return traceRet3;
    }

    public String readUTF() throws JMSException {
        String string;
        int savedEncoding;
        block12: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUTF()");
            }
            savedEncoding = this.integerEncoding;
            try {
                this.checkBodyReadable("readUTF");
                if (this.requiresInit) {
                    this.lazyInit();
                }
                this.readStream.mark(8);
                this.markInUse = true;
                this.integerEncoding = 1;
                int length = this.readUnsignedShort();
                byte[] utfBytes = new byte[length];
                if (this.readBytes(utfBytes, length) != length) {
                    this.readStream.reset();
                    JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0065", null));
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUTF()", traceRet1, 1);
                    }
                    throw traceRet1;
                }
                String traceRet2 = new String(utfBytes, 0, length, "UTF8");
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUTF()", traceRet2);
                }
                string = traceRet2;
                Object var7_9 = null;
                if (!Trace.isOn) break block12;
            }
            catch (UnsupportedEncodingException ex) {
                try {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUTF()", ex);
                    }
                    JMSException traceRet3 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0066", null));
                    traceRet3.setLinkedException((Exception)ex);
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUTF()", traceRet3, 2);
                    }
                    throw traceRet3;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (Trace.isOn) {
                        Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUTF()");
                    }
                    this.integerEncoding = savedEncoding;
                    this.markInUse = false;
                    throw throwable;
                }
            }
            Trace.finallyBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readUTF()");
        }
        this.integerEncoding = savedEncoding;
        this.markInUse = false;
        return string;
    }

    private void recordInteger(int offset, int length) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "recordInteger(int,int)", new Object[]{new Integer(offset), new Integer(length)});
        }
        if (this.integerCount == 20) {
            if (this.integers == null) {
                this.integers = new Vector();
            }
            this.integers.addElement(this.integerOffsets);
            this.integers.addElement(this.integerSizes);
            this.integerOffsets = new int[20];
            this.integerSizes = new int[20];
            this.integerCount = 0;
        }
        this.integerOffsets[this.integerCount] = offset;
        this.integerSizes[this.integerCount++] = length;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "recordInteger(int,int)");
        }
    }

    public void reset() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "reset()");
        }
        if (!this.isBodyReadOnly()) {
            this.dataBuffer = this.writeByteStream.toByteArray();
            this.lastEncoding = this.integerEncoding | this.floatEncoding;
            this.providerBytesMessage.setBytes(this.encodeBody(this.lastEncoding));
            this.providerBytesBodySet = true;
            this.writeStream = null;
            this.writeByteStream = null;
            this.setBodyReadOnly();
        }
        if (this.dataBuffer == null) {
            this.dataBuffer = new byte[0];
        }
        this.readStream = new ByteArrayInputStream(this.dataBuffer);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "reset()");
        }
    }

    private void reverse(byte[] buffer, int offset, int length) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "reverse(byte [ ],int,int)", new Object[]{buffer, new Integer(offset), new Integer(length)});
        }
        for (int i = 0; i < length / 2; ++i) {
            byte temp = buffer[offset + i];
            buffer[offset + i] = buffer[offset + (length - 1) - i];
            buffer[offset + (length - 1) - i] = temp;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "reverse(byte [ ],int,int)");
        }
    }

    public String toString() {
        if (this.cachedBytesToString == null) {
            int MAX_LINES = 10;
            int LINE_LENGTH = 40;
            StringBuffer retval = new StringBuffer();
            if (!this.isBodyReadOnly()) {
                try {
                    this.getProviderMessage();
                }
                catch (JMSException e) {
                    // empty catch block
                }
            }
            if (this.requiresInit) {
                this.lazyInit();
            }
            if (this.dataBuffer != null) {
                int curpos = 0;
                for (int lines_written = 0; lines_written < MAX_LINES; ++lines_written) {
                    if (this.dataBuffer.length <= curpos + LINE_LENGTH) {
                        JmsBytesMessageImpl.binToHex(this.dataBuffer, curpos, this.dataBuffer.length - curpos, retval);
                        curpos = this.dataBuffer.length;
                        retval.append("\n");
                        break;
                    }
                    JmsBytesMessageImpl.binToHex(this.dataBuffer, curpos, LINE_LENGTH, retval);
                    retval.append("\n");
                    curpos += LINE_LENGTH;
                }
                if (curpos != this.dataBuffer.length) {
                    retval.append("...\n");
                }
            }
            this.cachedBytesToString = retval.toString();
        }
        String val = super.toString() + "\n" + this.cachedBytesToString;
        return val;
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeBoolean(boolean)", new Object[]{value});
        }
        this.checkBodyWriteable("writeBoolean");
        this.writeByte((byte)(value ? 1 : 0));
        this.cachedBytesToString = null;
        this.providerBytesBodySet = false;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeBoolean(boolean)");
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeByte(byte)", new Object[]{new Byte(value)});
        }
        try {
            this.checkBodyWriteable("writeByte");
            this.writeStream.writeByte(value);
            this.cachedBytesToString = null;
            this.providerBytesBodySet = false;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeByte(byte)", ex);
            }
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0067", null));
            traceRet1.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeByte(byte)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeByte(byte)");
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeBytes(byte [ ],int,int)", new Object[]{value, new Integer(offset), new Integer(length)});
        }
        try {
            this.checkBodyWriteable("writeBytes");
            this.writeStream.write(value, offset, length);
            this.cachedBytesToString = null;
            this.providerBytesBodySet = false;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeBytes(byte [ ],int,int)", ex);
            }
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0067", null));
            traceRet1.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeBytes(byte [ ],int,int)", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeBytes(byte [ ],int,int)");
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeBytes(byte [ ])", new Object[]{value});
        }
        this.writeBytes(value, 0, value.length);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeBytes(byte [ ])");
        }
    }

    public void writeChar(char value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeChar(char)", new Object[]{new Character(value)});
        }
        try {
            this.checkBodyWriteable("writeChar");
            this.writeStream.writeChar(value);
            this.recordInteger(this.writeStream.size() - 2, 2);
            this.cachedBytesToString = null;
            this.providerBytesBodySet = false;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeChar(char)", ex);
            }
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0067", null));
            je.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeChar(char)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeChar(char)");
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeDouble(double)", new Object[]{new Double(value)});
        }
        try {
            this.checkBodyWriteable("writeDouble");
            this.writeStream.writeLong(Double.doubleToLongBits(value));
            if (this.floatValues == null) {
                this.floatValues = new Vector();
            }
            this.floatValues.addElement(new Double(value));
            if (this.floatOffsets == null) {
                this.floatOffsets = new Vector();
            }
            this.floatOffsets.addElement(new Integer(this.writeStream.size() - 8));
            this.cachedBytesToString = null;
            this.providerBytesBodySet = false;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeDouble(double)", ex);
            }
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0067", null));
            je.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeDouble(double)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeDouble(double)");
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeFloat(float)", new Object[]{new Float(value)});
        }
        try {
            this.checkBodyWriteable("writeFloat");
            this.writeStream.writeInt(Float.floatToIntBits(value));
            if (this.floatValues == null) {
                this.floatValues = new Vector();
            }
            this.floatValues.addElement(new Float(value));
            if (this.floatOffsets == null) {
                this.floatOffsets = new Vector();
            }
            this.floatOffsets.addElement(new Integer(this.writeStream.size() - 4));
            this.cachedBytesToString = null;
            this.providerBytesBodySet = false;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeFloat(float)", ex);
            }
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0067", null));
            je.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeFloat(float)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeFloat(float)");
        }
    }

    public void writeInt(int value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeInt(int)", new Object[]{new Integer(value)});
        }
        try {
            this.checkBodyWriteable("writeInt");
            this.writeStream.writeInt(value);
            this.recordInteger(this.writeStream.size() - 4, 4);
            this.cachedBytesToString = null;
            this.providerBytesBodySet = false;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeInt(int)", ex);
            }
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0067", null));
            je.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeInt(int)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeInt(int)");
        }
    }

    public void writeLong(long value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeLong(long)", new Object[]{new Long(value)});
        }
        try {
            this.checkBodyWriteable("writeLong");
            this.writeStream.writeLong(value);
            this.recordInteger(this.writeStream.size() - 8, 8);
            this.cachedBytesToString = null;
            this.providerBytesBodySet = false;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeLong(long)", ex);
            }
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0067", null));
            je.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeLong(long)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeLong(long)");
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeObject(Object)", new Object[]{value});
        }
        this.checkBodyWriteable("writeObject");
        if (value == null) {
            NullPointerException npe = (NullPointerException)JmsErrorUtils.createException("JMSCC0103", null);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeObject(Object)", npe, 1);
            }
            throw npe;
        }
        if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_OBJECT", value.getClass().getName());
            JMSException je2 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0083", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeObject(Object)", je2, 2);
            }
            throw je2;
        }
        this.cachedBytesToString = null;
        this.providerBytesBodySet = false;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeObject(Object)");
        }
    }

    public void writeShort(short value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeShort(short)", new Object[]{new Short(value)});
        }
        try {
            this.checkBodyWriteable("writeShort");
            this.writeStream.writeShort(value);
            this.recordInteger(this.writeStream.size() - 2, 2);
            this.cachedBytesToString = null;
            this.providerBytesBodySet = false;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeShort(short)", ex);
            }
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0067", null));
            je.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeShort(short)", je);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeShort(short)");
        }
    }

    public void writeUTF(String value) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeUTF(String)", new Object[]{value});
        }
        try {
            this.checkBodyWriteable("writeUTF");
            this.writeStream.writeUTF(value);
            this.cachedBytesToString = null;
            this.providerBytesBodySet = false;
        }
        catch (UTFDataFormatException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeUTF(String)", ex, 1);
            }
            JMSException traceRet1 = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0066", null));
            traceRet1.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeUTF(String)", traceRet1, 1);
            }
            throw traceRet1;
        }
        catch (IOException ex) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeUTF(String)", ex, 2);
            }
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0067", null));
            je.setLinkedException((Exception)ex);
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeUTF(String)", je, 2);
            }
            throw je;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeUTF(String)");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeObject(java.io.ObjectOutputStream)", new Object[]{out});
        }
        if (this.requiresInit) {
            this.lazyInit();
        }
        if (this.isBodyReadOnly()) {
            this.streamOffset = this.dataBuffer.length - this.readStream.available();
        } else if (this.writeByteStream != null) {
            this.dataBuffer = this.writeByteStream.toByteArray();
        }
        out.defaultWriteObject();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "writeObject(java.io.ObjectOutputStream)");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        in.defaultReadObject();
        if (this.isBodyReadOnly()) {
            this.readStream = new ByteArrayInputStream(this.dataBuffer);
            this.readStream.skip(this.streamOffset);
        } else {
            this.writeByteStream = new ByteArrayOutputStream();
            this.writeStream = new DataOutputStream(this.writeByteStream);
            this.writeStream.write(this.dataBuffer);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "readObject(java.io.ObjectInputStream)");
        }
    }

    static int binToHex(byte[] bin, int start, int length, StringBuffer hex) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "binToHex(byte [ ],int,int,StringBuffer)", new Object[]{bin, new Integer(start), new Integer(length), hex});
        }
        char[] BIN2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int sum = 0;
        for (int i = start; i < start + length; ++i) {
            int binByte = bin[i];
            if (binByte < 0) {
                binByte += 256;
            }
            sum += binByte;
            hex.append(BIN2HEX[binByte / 16]);
            hex.append(BIN2HEX[binByte % 16]);
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "binToHex(byte [ ],int,int,StringBuffer)", new Integer(sum));
        }
        return sum;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.internal.JmsBytesMessageImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JmsBytesMessageImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.29.1.1 09/08/17 09:27:13");
        }
    }
}

