/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.internal;

import com.ibm.msg.client.commonservices.componentmanager.Component;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class JMSComponent
extends Component {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/internal/JMSComponent.java, jmscc.jms.internal, k701, k701-112-140304 1.8.2.1 09/08/17 09:15:37";

    public JMSComponent() {
        this.name = "com.ibm.msg.client.jms";
        this.title = "Java Message Service Client";
        this.type = "INFRA";
        this.inPreferenceTo = null;
        Object o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int[] newversion = null;
                try {
                    URL resource = this.getClass().getResource("version.properties");
                    if (resource == null) {
                        resource = ClassLoader.getSystemResource("META-INF/version.properties");
                    }
                    if (resource != null) {
                        String CMVCLevel;
                        Properties props = new Properties();
                        props.load(resource.openStream());
                        String stringVersion = props.getProperty(JMSComponent.this.name);
                        if (stringVersion != null) {
                            newversion = new int[4];
                            StringTokenizer token = new StringTokenizer(stringVersion);
                            int i = 0;
                            while (token.hasMoreElements()) {
                                int value;
                                String t = token.nextToken(".");
                                newversion[i] = value = Integer.parseInt(t);
                                ++i;
                            }
                        }
                        if ((CMVCLevel = props.getProperty("CMVC")) != null) {
                            JMSComponent.this.implementationInfo = new HashMap();
                            JMSComponent.this.implementationInfo.put("CMVC", CMVCLevel);
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("JMSComponent failed to initialize " + e.getMessage());
                }
                return newversion;
            }
        });
        if (o != null) {
            this.version = (int[])o;
        }
    }

    public Class getFactoryClass() {
        return null;
    }

    public Object getFactoryInstance() {
        return null;
    }

    public boolean isSuitable(HashMap filters) {
        return true;
    }
}

