/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.admin;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConstants;
import com.ibm.msg.client.jms.JmsXAConnectionFactory;
import com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl;
import com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl;
import com.ibm.msg.client.jms.internal.JmsXAConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsXAQueueConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsXATopicConnectionImpl;
import com.ibm.msg.client.provider.ProviderFactoryFactory;
import com.ibm.msg.client.provider.ProviderXAConnection;
import com.ibm.msg.client.provider.ProviderXAConnectionFactory;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;

public class JmsXAConnectionFactoryImpl
extends JmsConnectionFactoryImpl
implements JmsXAConnectionFactory {
    private static final long serialVersionUID = 4123977461522689892L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/admin/JmsXAConnectionFactoryImpl.java, jmscc.jms.internal, k701, k701-112-140304 1.28.1.1 09/08/17 09:26:49";
    protected ProviderFactoryFactory providerFactory;
    protected ProviderXAConnectionFactory providerXAConnectionFactory;
    private String connectionTypeName;

    public JmsXAConnectionFactoryImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "<init>()");
        }
    }

    protected JmsXAConnectionFactoryImpl(String connectionTypeName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "<init>(String)", new Object[]{connectionTypeName});
        }
        this.setStringProperty("XMSC_CONNECTION_TYPE_NAME", connectionTypeName);
        boolean found = false;
        for (int count = 0; count < JmsConstants.providerNames.length; ++count) {
            if (!JmsConstants.providerNames[count].equalsIgnoreCase(connectionTypeName)) continue;
            this.setIntProperty("XMSC_CONNECTION_TYPE", count);
            found = true;
            break;
        }
        if (!found) {
            this.setIntProperty("XMSC_CONNECTION_TYPE", -1);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("XMSC_CONNECTION_TYPE_NAME", connectionTypeName);
            data.put("MSG", "Unkown connection type name");
            Trace.ffst("JmsXAConnectionFactoryImpl", "<init>String providerName)", "", data, JMSException.class);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "<init>(String)");
        }
    }

    private void setProviderFactory() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "setProviderFactory()");
        }
        if (this.providerFactory == null) {
            this.connectionTypeName = this.getStringProperty("XMSC_CONNECTION_TYPE_NAME");
            this.providerFactory = ((JmsFactoryFactoryImpl)JmsFactoryFactoryImpl.getInstance(this.connectionTypeName)).getProviderFactoryFactory();
            ProviderXAConnectionFactory providerXACF = this.providerFactory.createProviderXAConnectionFactory(this);
            this.setProviderXAConnectionFactory(providerXACF);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "setProviderFactory()");
        }
    }

    private void setProviderXAConnectionFactory(ProviderXAConnectionFactory providerXACF) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "setProviderXAConnectionFactory(ProviderXAConnectionFactory)", "setter", providerXACF);
        }
        this.providerXAConnectionFactory = providerXACF;
    }

    public XAConnection createXAConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "createXAConnection()");
        }
        XAConnection traceRet1 = this.createXAConnection(null, null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "createXAConnection()", traceRet1);
        }
        return traceRet1;
    }

    public XAConnection createXAConnection(String userID, String password) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "createXAConnection(String,String)", new Object[]{userID, password == null ? password : "********"});
        }
        this.setProviderFactory();
        JmsXAConnectionImpl connection = this instanceof QueueConnectionFactory ? new JmsXAQueueConnectionImpl(this) : (this instanceof TopicConnectionFactory ? new JmsXATopicConnectionImpl(this) : new JmsXAConnectionImpl(this));
        if (userID != null) {
            connection.setStringProperty("XMSC_USERID", userID);
        }
        if (password != null) {
            connection.setStringProperty("XMSC_PASSWORD", password);
        }
        ProviderXAConnection providerXAConnection = this.providerXAConnectionFactory.createProviderXAConnection(connection);
        connection.setProviderConnection(providerXAConnection);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "createXAConnection(String,String)", connection);
        }
        return connection;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.admin.JmsXAConnectionFactoryImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/admin/JmsXAConnectionFactoryImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.28.1.1 09/08/17 09:26:49");
        }
    }
}

