/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.admin;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsFactoryFactory;
import com.ibm.msg.client.jms.JmsPropertyContext;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class JmsJndiObjectFactory
implements ObjectFactory {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/admin/JmsJndiObjectFactory.java, jmscc.jms.internal, k701, k701-112-140304 1.20.1.1 09/08/17 09:03:39";

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Reference ref;
        StringRefAddr connectionTypeName;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsJndiObjectFactory", "getObjectInstance(Object,Name,Context,Hashtable)", new Object[]{obj, name, nameCtx, environment});
        }
        JmsPropertyContext adminObject = null;
        if (obj instanceof Reference && (connectionTypeName = (StringRefAddr)(ref = (Reference)obj).get("XMSC_CONNECTION_TYPE_NAME")) != null) {
            String providerName = (String)connectionTypeName.getContent();
            JmsFactoryFactory factoryFactory = JmsFactoryFactory.getInstance(providerName);
            StringRefAddr objectTypeRef = (StringRefAddr)ref.get("XMSC_ADMIN_OBJECT_TYPE");
            if (objectTypeRef != null) {
                short objectType = Short.parseShort((String)objectTypeRef.getContent());
                if ((objectType & 0x10) != 0) {
                    if ((objectType & 1) != 0) {
                        adminObject = factoryFactory.createQueueConnectionFactory();
                    } else if ((objectType & 2) != 0) {
                        adminObject = factoryFactory.createTopicConnectionFactory();
                    } else if ((objectType & 4) != 0) {
                        adminObject = factoryFactory.createConnectionFactory();
                    }
                } else if ((objectType & 0x20) != 0) {
                    String destname = (String)ref.get("XMSC_DESTINATION_NAME").getContent();
                    if ((objectType & 1) != 0) {
                        adminObject = factoryFactory.createQueue(destname);
                    } else if ((objectType & 2) != 0) {
                        adminObject = factoryFactory.createTopic(destname);
                    }
                }
                if (adminObject != null) {
                    Enumeration<RefAddr> addrs = ref.getAll();
                    while (addrs.hasMoreElements()) {
                        StringRefAddr addr = (StringRefAddr)addrs.nextElement();
                        adminObject.setObjectProperty(addr.getType(), addr.getContent());
                    }
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.admin.JmsJndiObjectFactory", "getObjectInstance(Object,Name,Context,Hashtable)", adminObject);
        }
        return adminObject;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.admin.JmsJndiObjectFactory", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/admin/JmsJndiObjectFactory.java, jmscc.jms.internal, k701, k701-112-140304  1.20.1.1 09/08/17 09:03:39");
        }
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.admin.JmsJndiObjectFactory", "static()");
        }
        if (Trace.isOn) {
            Trace.data("JmsJndiObjectFactory", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/admin/JmsJndiObjectFactory.java, jmscc.jms.internal, k701, k701-112-140304  1.20.1.1 09/08/17 09:03:39");
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.admin.JmsJndiObjectFactory", "static()");
        }
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.admin.JmsJndiObjectFactory", "static()");
        }
        if (Trace.isOn) {
            // empty if block
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.admin.JmsJndiObjectFactory", "static()");
        }
    }
}

