/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.admin;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConstants;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsFactoryFactory;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsTemporaryQueue;
import com.ibm.msg.client.jms.JmsTemporaryTopic;
import com.ibm.msg.client.jms.JmsTopic;
import com.ibm.msg.client.jms.internal.JmsErrorUtils;
import com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl;
import com.ibm.msg.client.provider.ProviderDestination;
import com.ibm.msg.client.provider.ProviderFactoryFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class JmsDestinationImpl
extends JmsPropertyContextImpl
implements JmsDestination {
    private static final long serialVersionUID = -6804615500270643424L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String connectionTypeName;
    private transient ProviderDestination providerDestination;
    private volatile transient int useCount;
    private transient Object useCountLock = new Object();

    public JmsDestinationImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "<init>()");
        }
        try {
            this.initialise(null, null);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "<init>()", e);
            }
            HashMap<String, JMSException> info = new HashMap<String, JMSException>();
            info.put("exception", e);
            Trace.ffst(this, "setDefaultProperties()", "XJ005002", info, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "<init>()");
        }
    }

    public JmsDestinationImpl(String connectionTypeName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "<init>(String)", new Object[]{connectionTypeName});
        }
        try {
            this.initialise(connectionTypeName, null);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "<init>(String)", e);
            }
            HashMap<String, JMSException> info = new HashMap<String, JMSException>();
            info.put("exception", e);
            Trace.ffst(this, "setDefaultProperties()", "XJ005003", info, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "<init>(String)");
        }
    }

    public JmsDestinationImpl(String connectionTypeName, String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "<init>(String,String)", new Object[]{connectionTypeName, name});
        }
        if (!(this instanceof JmsTemporaryQueue) && !(this instanceof JmsTemporaryTopic) && (name == null || name.length() == 0 || name.equals("queue://") || name.equals("topic://"))) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_DESTINATION_NAME", name);
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC0095", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "<init>(String,String)", je);
            }
            throw je;
        }
        this.initialise(connectionTypeName, name);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "<init>(String,String)");
        }
    }

    protected void initialise(String connectionTypeName1, String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "initialise(String,String)", new Object[]{connectionTypeName1, name});
        }
        this.setDefaultProperties();
        if (connectionTypeName1 != null) {
            this.setConnectionTypeName(connectionTypeName1);
            if (name == null) {
                this.setProviderDestination();
            } else {
                this.setProviderDestination(name);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "initialise(String,String)");
        }
    }

    protected String getName() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getName()");
        }
        if (this.providerDestination != null) {
            String traceRet2 = this.providerDestination.getName();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getName()", traceRet2, 1);
            }
            return traceRet2;
        }
        try {
            String name = this.getStringProperty("XMSC_DESTINATION_NAME");
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getName()", name, 2);
            }
            return name;
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getName()", e);
            }
            if (Trace.isOn) {
                Trace.data(this, "getName", "Failed to retrieve name from either a ProviderDestination, or from the DESTINATION_NAME property", null);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getName()", null, 3);
            }
            return null;
        }
    }

    protected void setProviderDestination() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setProviderDestination()");
        }
        this.setProviderDestination((String)null);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setProviderDestination()");
        }
    }

    protected void setProviderDestination(String name) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setProviderDestination(String)", new Object[]{name});
        }
        if (this.providerDestination == null) {
            ProviderFactoryFactory providerFactory = ((JmsFactoryFactoryImpl)JmsFactoryFactory.getInstance(this.connectionTypeName)).getProviderFactoryFactory();
            int destType = -1;
            if (this instanceof JmsQueue) {
                destType = 1;
            } else if (this instanceof JmsTopic) {
                destType = 2;
            }
            this.setProviderDestination(providerFactory.createProviderDestination(destType, name, this));
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setProviderDestination(String)");
        }
    }

    protected void setProviderDestination(ProviderDestination providerDest) throws JMSException {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setProviderDestination(ProviderDestination)", "setter", providerDest);
        }
        this.providerDestination = providerDest;
    }

    protected ProviderDestination getProviderDestination() throws JMSException {
        this.setProviderDestination();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getProviderDestination()", "getter", this.providerDestination);
        }
        return this.providerDestination;
    }

    protected String getConnectionTypeName() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getConnectionTypeName()", "getter", this.connectionTypeName);
        }
        return this.connectionTypeName;
    }

    public String toString() {
        String traceRet1 = this.toURI();
        return traceRet1;
    }

    protected void setConnectionTypeName(String connectionTypeName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setConnectionTypeName(String)", new Object[]{connectionTypeName});
        }
        this.connectionTypeName = connectionTypeName;
        try {
            this.setStringProperty("XMSC_CONNECTION_TYPE_NAME", connectionTypeName);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setConnectionTypeName(String)", e, 1);
            }
            Trace.ffst(this, "setConnectionTypeName(String)", "XJ005004", null, null);
        }
        boolean found = false;
        for (int count = 0; count < JmsConstants.providerNames.length; ++count) {
            if (!JmsConstants.providerNames[count].equalsIgnoreCase(connectionTypeName)) continue;
            try {
                this.setIntProperty("XMSC_CONNECTION_TYPE", count);
            }
            catch (JMSException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setConnectionTypeName(String)", e, 2);
                }
                Trace.ffst(this, "setConnectionTypeName(String)", "XJ005005", null, null);
            }
            found = true;
            break;
        }
        if (!found) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("XMSC_CONNECTION_TYPE_NAME", connectionTypeName);
            data.put("MSG", "Unkown connection type name");
            Trace.ffst(this, "setConnectionTypeName(String)", "XJ005006", data, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setConnectionTypeName(String)");
        }
    }

    private void setName(String name) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setName(String)", new Object[]{name});
        }
        try {
            this.setStringProperty("XMSC_DESTINATION_NAME", name);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setName(String)", e);
            }
            Trace.ffst(this, "setName(String)", "XJ005009", null, JMSException.class);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setName(String)");
        }
    }

    protected String toURI() {
        String uri;
        block5: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "toURI()");
            }
            uri = null;
            if (this.providerDestination != null) {
                try {
                    uri = this.providerDestination.toURI();
                }
                catch (JMSException e) {
                    if (!Trace.isOn) break block5;
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "toURI()", e);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "toURI()", uri);
        }
        return uri;
    }

    public String getQueueName() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getQueueName()");
        }
        if (this.providerDestination != null && this.providerDestination.isTopic()) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getQueueName()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getQueueName()", je);
            }
            throw je;
        }
        String traceRet1 = this.toURI();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getQueueName()", traceRet1);
        }
        return traceRet1;
    }

    public String getTopicName() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getTopicName()");
        }
        if (this.providerDestination != null && this.providerDestination.isQueue()) {
            HashMap<String, String> inserts = new HashMap<String, String>();
            inserts.put("XMSC_INSERT_METHOD", "getTopicName()");
            inserts.put("XMSC_INSERT_TYPE", this.getClass().getName());
            JMSException je = (JMSException)((Object)JmsErrorUtils.createException("JMSCC1112", inserts));
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getTopicName()", je);
            }
            throw je;
        }
        String traceRet1 = this.toURI();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getTopicName()", traceRet1);
        }
        return traceRet1;
    }

    protected int getUseCount() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "getUseCount()", "getter", new Integer(this.useCount));
        }
        return this.useCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementUseCount() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "incrementUseCount()");
        }
        Object object = this.useCountLock;
        synchronized (object) {
            ++this.useCount;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "incrementUseCount()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementUseCount() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "decrementUseCount()");
        }
        Object object = this.useCountLock;
        synchronized (object) {
            --this.useCount;
            if (this.useCount < 0) {
                Trace.ffst(this, "decrementUsageCount()", "XJ005001", null, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "decrementUseCount()");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "readObject(java.io.ObjectInputStream)", new Object[]{in});
        }
        in.defaultReadObject();
        try {
            if (this.connectionTypeName != null) {
                this.setProviderDestination();
            }
            this.useCountLock = new Object();
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "readObject(java.io.ObjectInputStream)", e);
            }
            HashMap<String, JMSException> info = new HashMap<String, JMSException>();
            info.put("exception", e);
            Trace.ffst(this, "readObject(ObjectInputStream)", "XJ005007", info, JMSException.class);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "readObject(java.io.ObjectInputStream)");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "readObjectNoData()");
        }
        this.useCountLock = new Object();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "readObjectNoData()");
        }
    }

    protected void setDefaultProperties() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setDefaultProperties()");
        }
        try {
            if (this instanceof Queue) {
                this.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)33);
            } else if (this instanceof Topic) {
                this.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)34);
            } else {
                this.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", (short)36);
            }
            this.setIntProperty("deliveryMode", -2);
            this.setLongProperty("timeToLive", -2L);
            this.setIntProperty("priority", -2);
        }
        catch (JMSException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setDefaultProperties()", e);
            }
            HashMap<String, JMSException> info = new HashMap<String, JMSException>();
            info.put("exception", e);
            Trace.ffst(this, "setDefaultProperties()", "XJ005008", info, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsDestinationImpl", "setDefaultProperties()");
        }
    }

    protected static void _decrementUseCount(JmsDestinationImpl dest) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.admin.JmsDestinationImpl", "_decrementUseCount(JmsDestinationImpl)", new Object[]{dest});
        }
        dest.decrementUseCount();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.admin.JmsDestinationImpl", "_decrementUseCount(JmsDestinationImpl)");
        }
    }

    protected static void _incrementUseCount(JmsDestinationImpl dest) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.admin.JmsDestinationImpl", "_incrementUseCount(JmsDestinationImpl)", new Object[]{dest});
        }
        dest.incrementUseCount();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.admin.JmsDestinationImpl", "_incrementUseCount(JmsDestinationImpl)");
        }
    }

    protected static void _setProviderDestination(JmsDestinationImpl dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.admin.JmsDestinationImpl", "_setProviderDestination(JmsDestinationImpl)", new Object[]{dest});
        }
        dest.setProviderDestination();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.admin.JmsDestinationImpl", "_setProviderDestination(JmsDestinationImpl)");
        }
    }

    protected static ProviderDestination _getProviderDestination(JmsDestinationImpl dest) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.admin.JmsDestinationImpl", "_getProviderDestination(JmsDestinationImpl)", new Object[]{dest});
        }
        ProviderDestination traceRet1 = dest.getProviderDestination();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.admin.JmsDestinationImpl", "_getProviderDestination(JmsDestinationImpl)", traceRet1);
        }
        return traceRet1;
    }

    public int hashCode() {
        int result;
        block3: {
            result = 42;
            try {
                Iterator i = this.getProperties().entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Object key = e.getKey();
                    String value = this.getStringProperty((String)key);
                    if (value == null) continue;
                    result ^= value.hashCode();
                }
            }
            catch (JMSException e) {
                if (!Trace.isOn) break block3;
                Trace.catchBlock("com.ibm.msg.client.jms.internal.JmsDestinationImpl", "hashCode", e);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = true;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!this.getClass().getName().equals(obj.getClass().getName())) {
            result = false;
        } else {
            try {
                result = this.compareContexts(this, (JmsReadablePropertyContextImpl)obj);
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.admin.JmsDestinationImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/admin/JmsDestinationImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.48.1.2 10/04/22 10:59:09");
        }
    }
}

