/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms.admin;

import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsConnection;
import com.ibm.msg.client.jms.JmsConnectionFactory;
import com.ibm.msg.client.jms.JmsConstants;
import com.ibm.msg.client.jms.internal.JmsConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl;
import com.ibm.msg.client.jms.internal.JmsPropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsQueueConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsReadablePropertyContextImpl;
import com.ibm.msg.client.jms.internal.JmsTopicConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsXAConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsXAQueueConnectionImpl;
import com.ibm.msg.client.jms.internal.JmsXATopicConnectionImpl;
import com.ibm.msg.client.provider.ProviderConnection;
import com.ibm.msg.client.provider.ProviderConnectionFactory;
import com.ibm.msg.client.provider.ProviderFactoryFactory;
import com.ibm.msg.client.provider.ProviderXAConnection;
import com.ibm.msg.client.provider.ProviderXAConnectionFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;

public class JmsConnectionFactoryImpl
extends JmsPropertyContextImpl
implements JmsConnectionFactory {
    private static final long serialVersionUID = 1768302810905848221L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected transient ProviderFactoryFactory providerFactory;
    protected ProviderConnectionFactory providerConnectionFactory;
    private String connectionTypeName;
    private int connectionType;

    public JmsConnectionFactoryImpl() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "<init>()");
        }
    }

    protected JmsConnectionFactoryImpl(String connectionTypeName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "<init>(String)", new Object[]{connectionTypeName});
        }
        this.setStringProperty("XMSC_CONNECTION_TYPE_NAME", connectionTypeName);
        boolean found = false;
        for (int count = 0; count < JmsConstants.providerNames.length; ++count) {
            if (!JmsConstants.providerNames[count].equalsIgnoreCase(connectionTypeName)) continue;
            this.setIntProperty("XMSC_CONNECTION_TYPE", count);
            found = true;
            break;
        }
        if (!found) {
            this.setIntProperty("XMSC_CONNECTION_TYPE", -1);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("XMSC_CONNECTION_TYPE_NAME", connectionTypeName);
            data.put("MSG", "Unknown connection type name");
            Trace.ffst("JmsConnectionFactoryImpl", "<init>String providerName)", "XJ004001", data, JMSException.class);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "<init>(String)");
        }
    }

    protected synchronized void setProviderFactory(boolean xa) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "setProviderFactory(boolean)", new Object[]{xa});
        }
        if (this.providerFactory == null) {
            ProviderConnectionFactory providerCF;
            this.connectionTypeName = this.getStringProperty("XMSC_CONNECTION_TYPE_NAME");
            this.connectionType = this.getIntProperty("XMSC_CONNECTION_TYPE");
            this.providerFactory = ((JmsFactoryFactoryImpl)JmsFactoryFactoryImpl.getInstance(this.connectionTypeName)).getProviderFactoryFactory();
            try {
                providerCF = xa ? this.providerFactory.createProviderXAConnectionFactory(this) : this.providerFactory.createProviderConnectionFactory(this);
            }
            catch (JMSException je) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "setProviderFactory(boolean)", je);
                }
                this.providerFactory = null;
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "setProviderFactory(boolean)", je);
                }
                throw je;
            }
            this.setProviderConnectionFactory(providerCF);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "setProviderFactory(boolean)");
        }
    }

    private void setProviderConnectionFactory(ProviderConnectionFactory providerCF) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "setProviderConnectionFactory(ProviderConnectionFactory)", "setter", providerCF);
        }
        this.providerConnectionFactory = providerCF;
    }

    public Connection createConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "createConnection()");
        }
        Connection traceRet1 = this.createConnection(null, null);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "createConnection()", traceRet1);
        }
        return traceRet1;
    }

    public Connection createConnection(String userID, String password) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "createConnection(String,String)", new Object[]{userID, password == null ? password : "********"});
        }
        String myUserID = this.checkUserID(userID);
        boolean xa = this instanceof XAConnectionFactory || this instanceof XAQueueConnectionFactory || this instanceof XATopicConnectionFactory;
        this.setProviderFactory(xa);
        JmsConnectionImpl connection = this instanceof QueueConnectionFactory ? new JmsQueueConnectionImpl(this) : (this instanceof TopicConnectionFactory ? new JmsTopicConnectionImpl(this) : new JmsConnectionImpl(this));
        if (xa) {
            short newFlags = (short)(connection.getShortProperty("XMSC_ADMIN_OBJECT_TYPE") & 0xFFFFFFBF);
            connection.setShortProperty("XMSC_ADMIN_OBJECT_TYPE", newFlags);
        }
        connection.setStringProperty("XMSC_USERID", myUserID);
        if (password != null) {
            connection.setStringProperty("XMSC_PASSWORD", password);
        }
        ProviderConnection providerConnection = this.providerConnectionFactory.createProviderConnection(connection);
        connection.setProviderConnection(providerConnection);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "createConnection(String,String)", connection);
        }
        return connection;
    }

    private String checkUserID(String userID) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "checkUserID(String)", new Object[]{userID});
        }
        String result = "";
        PropertyStore.register("com.ibm.mq.jms.ForceUserID", false);
        boolean bForceUserID = PropertyStore.getBooleanPropertyObject("com.ibm.mq.jms.ForceUserID");
        if (userID == null || userID.trim().equals("")) {
            if (bForceUserID) {
                result = PropertyStore.user_name;
                if (Trace.isOn) {
                    Trace.data(this, "Defaulting user id to : '" + result + "'", null);
                }
            }
        } else {
            result = userID;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "checkUserID(String)", result);
        }
        return result;
    }

    protected JmsConnection createXAConnectionInternal(String userID, String password) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "createXAConnectionInternal(String,String)", new Object[]{userID, password == null ? password : "********"});
        }
        String myUserID = this.checkUserID(userID);
        this.setProviderFactory(true);
        JmsXAConnectionImpl connection = null;
        if (this instanceof XAQueueConnectionFactory) {
            connection = new JmsXAQueueConnectionImpl(this);
        } else if (this instanceof XATopicConnectionFactory) {
            connection = new JmsXATopicConnectionImpl(this);
        } else if (this instanceof XAConnectionFactory) {
            connection = new JmsXAConnectionImpl(this);
        } else {
            HashMap<String, JmsConnectionFactoryImpl> data = new HashMap<String, JmsConnectionFactoryImpl>();
            data.put("connection", this);
            Trace.ffst(this, "createXAConnection(String,String)", "XJ004002", data, JMSException.class);
        }
        connection.setStringProperty("XMSC_USERID", myUserID);
        if (password != null) {
            connection.setStringProperty("XMSC_PASSWORD", password);
        }
        ProviderXAConnection providerXAConnection = ((ProviderXAConnectionFactory)this.providerConnectionFactory).createProviderXAConnection(connection);
        connection.setProviderConnection(providerXAConnection);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "createXAConnectionInternal(String,String)", connection);
        }
        return connection;
    }

    public int hashCode() {
        int result;
        block3: {
            result = 42;
            try {
                Iterator i = this.getProperties().entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Object key = e.getKey();
                    String value = this.getStringProperty((String)key);
                    if (value == null) continue;
                    result ^= value.hashCode();
                }
            }
            catch (JMSException e) {
                if (!Trace.isOn) break block3;
                Trace.catchBlock("com.ibm.msg.client.jms.internal.JmsConnectionFactoryImpl", "hashCode", e);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = true;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!this.getClass().getName().equals(obj.getClass().getName())) {
            result = false;
        } else {
            try {
                result = this.compareContexts(this, (JmsReadablePropertyContextImpl)obj);
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.admin.JmsConnectionFactoryImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms.internal/src/com/ibm/msg/client/jms/admin/JmsConnectionFactoryImpl.java, jmscc.jms.internal, k701, k701-112-140304  1.40.1.4 10/04/22 10:55:32");
        }
    }
}

