/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms;

import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.JmsCapabilityContext;
import com.ibm.msg.client.jms.JmsConnectionFactory;
import com.ibm.msg.client.jms.JmsDestination;
import com.ibm.msg.client.jms.JmsPropertyContext;
import com.ibm.msg.client.jms.JmsQueue;
import com.ibm.msg.client.jms.JmsQueueConnectionFactory;
import com.ibm.msg.client.jms.JmsTopic;
import com.ibm.msg.client.jms.JmsTopicConnectionFactory;
import com.ibm.msg.client.jms.JmsXAConnectionFactory;
import com.ibm.msg.client.jms.JmsXAQueueConnectionFactory;
import com.ibm.msg.client.jms.JmsXATopicConnectionFactory;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.jms.JMSException;

public abstract class JmsFactoryFactory {
    static final String JMS_FACTORY_FACTORY_IMPL_CLASS = "com.ibm.msg.client.jms.internal.JmsFactoryFactoryImpl";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected JmsFactoryFactory() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.JmsFactoryFactory", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.JmsFactoryFactory", "<init>()");
        }
    }

    public static JmsFactoryFactory getInstance(int connectionType) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(int)", new Object[]{new Integer(connectionType)});
        }
        JmsFactoryFactory factory = null;
        try {
            Class factoryClass = CSSystem.dynamicLoadClass(JMS_FACTORY_FACTORY_IMPL_CLASS, JmsFactoryFactory.class);
            Method method = factoryClass.getMethod("getInstance", Integer.TYPE);
            if (method != null) {
                factory = (JmsFactoryFactory)method.invoke(null, new Integer(connectionType));
            }
        }
        catch (Exception e) {
            Throwable cause;
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(int)", e);
            }
            JMSException rethrow = null;
            if (e instanceof InvocationTargetException && (cause = ((InvocationTargetException)e).getCause()) instanceof JMSException) {
                rethrow = (JMSException)cause;
            }
            if (rethrow == null) {
                rethrow = new JMSException(e.getMessage());
                rethrow.setLinkedException(e);
                HashMap<String, Serializable> data = new HashMap<String, Serializable>();
                data.put("exception", e);
                data.put("connectionType", new Integer(connectionType));
                Trace.ffst("JmsFactoryFactory", "getIntance(int)", "XI001004", data, null);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(int)", rethrow);
            }
            throw rethrow;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(int)", factory);
        }
        return factory;
    }

    public static JmsFactoryFactory getInstance(String connectionTypeName) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(String)", new Object[]{connectionTypeName});
        }
        JmsFactoryFactory factory = null;
        try {
            Class factoryClass = CSSystem.dynamicLoadClass(JMS_FACTORY_FACTORY_IMPL_CLASS, JmsFactoryFactory.class, true, 4);
            Method method = factoryClass.getMethod("getInstance", String.class);
            if (method != null) {
                factory = (JmsFactoryFactory)method.invoke(null, connectionTypeName);
            }
        }
        catch (Exception e) {
            Throwable cause;
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(String)", e);
            }
            JMSException rethrow = null;
            if (e instanceof InvocationTargetException && (cause = ((InvocationTargetException)e).getCause()) instanceof JMSException) {
                rethrow = (JMSException)cause;
            }
            if (rethrow == null) {
                rethrow = new JMSException(e.getMessage());
                rethrow.setLinkedException(e);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("exception", e);
                data.put("connectionTypeName", connectionTypeName);
                Trace.ffst("JmsFactoryFactory", "getIntance(int)", "XI001005", data, null);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(String)", rethrow);
            }
            throw rethrow;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(String)", factory);
        }
        return factory;
    }

    public static JmsFactoryFactory getInstance(HashMap filter) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(HashMap)", new Object[]{filter});
        }
        JmsFactoryFactory factory = null;
        try {
            Class factoryClass = CSSystem.dynamicLoadClass(JMS_FACTORY_FACTORY_IMPL_CLASS, JmsFactoryFactory.class);
            Method method = factoryClass.getMethod("getInstance", HashMap.class);
            if (method != null) {
                factory = (JmsFactoryFactory)method.invoke(null, filter);
            }
        }
        catch (Exception e) {
            Throwable cause;
            if (Trace.isOn) {
                Trace.catchBlock("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(HashMap)", e);
            }
            JMSException rethrow = null;
            if (e instanceof InvocationTargetException && (cause = ((InvocationTargetException)e).getCause()) instanceof JMSException) {
                rethrow = (JMSException)cause;
            }
            if (rethrow == null) {
                rethrow = new JMSException(e.getMessage());
                rethrow.setLinkedException(e);
                HashMap<String, Serializable> data = new HashMap<String, Serializable>();
                data.put("exception", e);
                data.put("connectionTypeFilter", filter);
                Trace.ffst("JmsFactoryFactory", "getIntance(int)", "XI001006", data, null);
            }
            if (Trace.isOn) {
                Trace.throwing("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(HashMap)", rethrow);
            }
            throw rethrow;
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.jms.JmsFactoryFactory", "getInstance(HashMap)", factory);
        }
        return factory;
    }

    public abstract JmsConnectionFactory createConnectionFactory() throws JMSException;

    public abstract JmsQueueConnectionFactory createQueueConnectionFactory() throws JMSException;

    public abstract JmsTopicConnectionFactory createTopicConnectionFactory() throws JMSException;

    public abstract JmsQueue createQueue(String var1) throws JMSException;

    public abstract JmsTopic createTopic(String var1) throws JMSException;

    public abstract JmsXAConnectionFactory createXAConnectionFactory() throws JMSException;

    public abstract JmsXAQueueConnectionFactory createXAQueueConnectionFactory() throws JMSException;

    public abstract JmsXATopicConnectionFactory createXATopicConnectionFactory() throws JMSException;

    public abstract JmsConnectionFactory createConnectionFactory(short var1) throws JMSException;

    public abstract JmsDestination createDestination(short var1, String var2) throws JMSException;

    public abstract JmsPropertyContext createJmsObject(short var1, Object var2) throws JMSException;

    public abstract int getConnectionType();

    public abstract String getConnectionTypeName();

    public abstract JmsCapabilityContext getCapabilities() throws JMSException;

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.JmsFactoryFactory", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms/src/com/ibm/msg/client/jms/JmsFactoryFactory.java, jmscc.jms, k701, k701-112-140304  1.43.1.2 12/06/06 19:18:42");
        }
    }
}

