/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.jms;

import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.jms.DetailedIllegalStateException;
import com.ibm.msg.client.jms.DetailedInvalidDestinationException;
import com.ibm.msg.client.jms.DetailedInvalidSelectorException;
import com.ibm.msg.client.jms.DetailedJMSException;
import com.ibm.msg.client.jms.DetailedJMSSecurityException;
import com.ibm.msg.client.jms.DetailedMessageEOFException;
import com.ibm.msg.client.jms.DetailedMessageFormatException;
import com.ibm.msg.client.jms.DetailedMessageNotReadableException;
import com.ibm.msg.client.jms.DetailedMessageNotWriteableException;
import com.ibm.msg.client.jms.DetailedResourceAllocationException;
import com.ibm.msg.client.jms.DetailedTransactionInProgressException;
import com.ibm.msg.client.jms.DetailedTransactionRolledBackException;
import com.ibm.msg.client.jms.JmsExceptionDetail;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.JMSException;

public class JmsExceptionFactory
implements Serializable {
    private static final long serialVersionUID = 8593377892654124834L;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    int version;
    String exceptionData;
    ArrayList linkedExceptions = new ArrayList();
    static final String EXCLAMATION_POINT = "</exclam/>";
    static final String EQUALS = "</equals/>";
    static final String AMPERSAND = "</ampersand/>";

    public JmsExceptionFactory(Throwable e) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "<init>(Throwable)", new Object[]{e});
        }
        this.version = 7;
        this.exceptionData = this.collapseToString(e);
        Throwable linkedException = e.getCause();
        while (linkedException != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(linkedException);
                out.close();
                byte[] buf = bos.toByteArray();
                bos.close();
                this.linkedExceptions.add(buf);
                linkedException = linkedException.getCause();
            }
            catch (IOException ioe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "<init>(Throwable)", ioe);
                }
                linkedException.printStackTrace();
                ioe.printStackTrace();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "<init>(Throwable)");
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "readResolve()");
        }
        Exception traceRet1 = this.createException();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.JmsExceptionFactory", "readResolve()", traceRet1);
        }
        return traceRet1;
    }

    public Exception createException() {
        Exception e;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "createException()");
        }
        Throwable currentException = e = this.inflateFromString(this.exceptionData);
        for (int i = 0; i < this.linkedExceptions.size(); ++i) {
            byte[] buf = (byte[])this.linkedExceptions.get(i);
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(buf);
                ObjectInputStream ois = new ObjectInputStream(bis);
                Throwable t = (Throwable)ois.readObject();
                ois.close();
                bis.close();
                if (currentException instanceof JMSException) {
                    ((JMSException)currentException).setLinkedException((Exception)t);
                }
                currentException = t;
                continue;
            }
            catch (IOException ioe) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "createException()", ioe, 1);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "createException()", cnfe, 2);
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.JmsExceptionFactory", "createException()", e);
        }
        return e;
    }

    private String collapseToString(Throwable exception) {
        StringBuffer serializedStackTrace;
        StringBuffer data;
        block11: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "collapseToString(Throwable)", new Object[]{exception});
            }
            data = new StringBuffer();
            data.append("!V" + this.version);
            data.append("!JMS_EXCEPTION");
            data.append("!" + this.removeInvalidChars(exception.getClass().getName()));
            data.append("!" + this.removeInvalidChars(((JMSException)exception).getErrorCode()));
            data.append("!" + this.removeInvalidChars(((JMSException)exception).getMessage()));
            StackTraceElement[] stackTrace = exception.getStackTrace();
            serializedStackTrace = new StringBuffer();
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(stackTrace);
                out.close();
                byte[] buf = bos.toByteArray();
                bos.close();
                for (int j = 0; j < buf.length; ++j) {
                    serializedStackTrace.append(Byte.toString(buf[j]));
                    serializedStackTrace.append(",");
                }
            }
            catch (IOException ioe) {
                if (!Trace.isOn) break block11;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "collapseToString(Throwable)", ioe, 1);
            }
        }
        data.append("!" + serializedStackTrace);
        data.append("!EXCEPTION_DETAILS!");
        if (exception instanceof DetailedIllegalStateException || exception instanceof DetailedInvalidDestinationException || exception instanceof DetailedInvalidSelectorException || exception instanceof DetailedJMSException || exception instanceof DetailedJMSSecurityException || exception instanceof DetailedMessageEOFException || exception instanceof DetailedMessageFormatException || exception instanceof DetailedMessageNotReadableException || exception instanceof DetailedMessageNotWriteableException || exception instanceof DetailedResourceAllocationException || exception instanceof DetailedTransactionInProgressException || exception instanceof DetailedTransactionRolledBackException) {
            StringBuffer serializedInserts;
            block12: {
                JmsExceptionDetail e = (JmsExceptionDetail)((Object)exception);
                data.append("reason=").append(this.removeInvalidChars(exception.getMessage()));
                data.append("&errorCode=").append(this.removeInvalidChars(((JMSException)((Object)e)).getErrorCode()));
                data.append("&explanation=").append(this.removeInvalidChars(e.getExplanation()));
                data.append("&useraction=").append(this.removeInvalidChars(e.getUserAction()));
                Properties props = new Properties();
                Iterator i = e.getKeys();
                if (i != null) {
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        props.put(key, e.getValue(key));
                    }
                }
                serializedInserts = new StringBuffer();
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(bos);
                    out.writeObject(props);
                    out.close();
                    byte[] buf = bos.toByteArray();
                    bos.close();
                    for (int j = 0; j < buf.length; ++j) {
                        serializedInserts.append(Byte.toString(buf[j]));
                        serializedInserts.append(",");
                    }
                }
                catch (IOException ioe) {
                    if (!Trace.isOn) break block12;
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "collapseToString(Throwable)", ioe, 2);
                }
            }
            data.append("&inserts=").append(serializedInserts);
        }
        String traceRet1 = data.toString();
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.JmsExceptionFactory", "collapseToString(Throwable)", traceRet1);
        }
        return traceRet1;
    }

    private Exception inflateFromString(String string) {
        Properties eInserts;
        String eAction;
        String eExplanation;
        String eCode;
        String eReason;
        StackTraceElement[] stackTrace;
        String exceptionType;
        JmsExceptionDetail e;
        block25: {
            String[] fields;
            block24: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "inflateFromString(String)", new Object[]{string});
                }
                e = null;
                fields = string.split("!");
                String version = fields[1];
                exceptionType = this.replaceInvalidChars(fields[3]);
                String errorCode = this.replaceInvalidChars(fields[4]);
                String errorMessage = this.replaceInvalidChars(fields[5]);
                String stackTraceString = fields[6];
                stackTrace = null;
                try {
                    String[] stackTraceStringArray = stackTraceString.split(",");
                    byte[] stackTraceBytes = new byte[stackTraceStringArray.length];
                    for (int j = 0; j < stackTraceBytes.length; ++j) {
                        stackTraceBytes[j] = Byte.parseByte(stackTraceStringArray[j]);
                    }
                    ByteArrayInputStream bis = new ByteArrayInputStream(stackTraceBytes);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    stackTrace = (StackTraceElement[])ois.readObject();
                    ois.close();
                    bis.close();
                }
                catch (IOException ioe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "inflateFromString(String)", ioe, 1);
                    }
                    ioe.printStackTrace();
                }
                catch (ClassNotFoundException cnfe) {
                    if (!Trace.isOn) break block24;
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "inflateFromString(String)", cnfe, 2);
                }
            }
            String[] eData = fields[8].split("&");
            eReason = eData[0];
            eReason = eReason.substring(eReason.indexOf("=") + 1, eReason.length());
            eReason = this.replaceInvalidChars(eReason);
            eCode = eData[1];
            eCode = eCode.substring(eCode.indexOf("=") + 1, eCode.length());
            eCode = this.replaceInvalidChars(eCode);
            eExplanation = eData[2];
            eExplanation = eExplanation.substring(eExplanation.indexOf("=") + 1, eExplanation.length());
            eExplanation = this.replaceInvalidChars(eExplanation);
            eAction = eData[3];
            eAction = eAction.substring(eAction.indexOf("=") + 1, eAction.length());
            eAction = this.replaceInvalidChars(eAction);
            String eInsertsString = eData[4];
            eInsertsString = eInsertsString.substring(eInsertsString.indexOf("=") + 1, eInsertsString.length());
            eInserts = null;
            try {
                String[] eInsertsStringArray = eInsertsString.split(",");
                byte[] eInsertsBytes = new byte[eInsertsStringArray.length];
                for (int j = 0; j < eInsertsBytes.length; ++j) {
                    eInsertsBytes[j] = Byte.parseByte(eInsertsStringArray[j]);
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(eInsertsBytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                eInserts = (Properties)ois.readObject();
                ois.close();
                bis.close();
            }
            catch (IOException ioe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "inflateFromString(String)", ioe, 3);
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (!Trace.isOn) break block25;
                Trace.catchBlock(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "inflateFromString(String)", cnfe, 4);
            }
        }
        if (exceptionType.equals(DetailedIllegalStateException.class.getName())) {
            e = new DetailedIllegalStateException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedInvalidDestinationException.class.getName())) {
            e = new DetailedInvalidDestinationException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedInvalidSelectorException.class.getName())) {
            e = new DetailedInvalidSelectorException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedJMSException.class.getName())) {
            e = new DetailedJMSException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedJMSSecurityException.class.getName())) {
            e = new DetailedJMSSecurityException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedMessageEOFException.class.getName())) {
            e = new DetailedMessageEOFException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedMessageFormatException.class.getName())) {
            e = new DetailedMessageFormatException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedMessageNotReadableException.class.getName())) {
            e = new DetailedMessageNotReadableException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedMessageNotWriteableException.class.getName())) {
            e = new DetailedMessageNotWriteableException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedResourceAllocationException.class.getName())) {
            e = new DetailedResourceAllocationException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedTransactionInProgressException.class.getName())) {
            e = new DetailedTransactionInProgressException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (exceptionType.equals(DetailedTransactionRolledBackException.class.getName())) {
            e = new DetailedTransactionRolledBackException(eReason, eCode, eExplanation, eAction, eInserts);
            ((Throwable)((Object)e)).setStackTrace(stackTrace);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.JmsExceptionFactory", "inflateFromString(String)", e);
        }
        return e;
    }

    private String removeInvalidChars(String inputLine) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "removeInvalidChars(String)", new Object[]{inputLine});
        }
        if (inputLine == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "removeInvalidChars(String)", null, 1);
            }
            return null;
        }
        String result = inputLine;
        result = result.replaceAll("!", EXCLAMATION_POINT);
        result = result.replaceAll("&", AMPERSAND);
        result = result.replaceAll("=", EQUALS);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "removeInvalidChars(String)", result, 2);
        }
        return result;
    }

    private String replaceInvalidChars(String inputLine) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.jms.JmsExceptionFactory", "replaceInvalidChars(String)", new Object[]{inputLine});
        }
        String result = inputLine;
        result = result.replaceAll(EXCLAMATION_POINT, "!");
        result = result.replaceAll(AMPERSAND, "&");
        result = result.replaceAll(EQUALS, "=");
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.jms.JmsExceptionFactory", "replaceInvalidChars(String)", result);
        }
        return result;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.jms.JmsExceptionFactory", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.jms/src/com/ibm/msg/client/jms/JmsExceptionFactory.java, jmscc.jms, k701, k701-112-140304  1.10.1.1 09/08/17 09:13:49");
        }
    }
}

