/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.workqueue;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.CSIListener;
import com.ibm.msg.client.commonservices.CommonServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.provider.workqueue.CSPWorkQueueManager;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.workqueue.PIWorkQueueManager;
import com.ibm.msg.client.commonservices.workqueue.SimpleWorkQueueItem;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueItem;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueToken;
import java.util.HashMap;

public final class WorkQueueManager {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/workqueue/WorkQueueManager.java, jmscc.commonservices, k701, k701-112-140304 1.21.1.1 09/08/17 08:24:31";
    public static final String maxThreadPoolSizeProperty = "jmscc.workqueue.poolSize";
    public static final int maxThreadPoolSizeProperty_default = -1;
    public static final String maintainThreadPoolSizeProperty = "jmscc.workqueue.maintainPoolSize";
    public static final boolean maintainThreadPoolSizeProperty_default = false;
    public static final String threadPoolInactiveTimeoutProperty = "jmscc.workqueue.poolTimeout";
    public static final long threadPoolInactiveTimeoutProperty_default = 0L;
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_HIGH = 1;
    protected static int maxThreadPoolSize;
    protected static boolean maintainThreadPoolSize;
    protected static long threadPoolInactiveTimeout;
    protected static CSPWorkQueueManager manager;
    protected static boolean initialized;
    protected static boolean listening;
    static /* synthetic */ Class class$com$ibm$msg$client$commonservices$CSIException;

    private WorkQueueManager() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "<init>()");
        }
    }

    public static void start() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "start()");
        }
        manager.start();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "start()");
        }
    }

    public static void pause() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "pause()");
        }
        manager.pause();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "pause()");
        }
    }

    public static void close() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "close()");
        }
        manager.close();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "close()");
        }
    }

    public static WorkQueueToken enqueue(Runnable newTask) throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "enqueue(Runnable)", new Object[]{newTask});
        }
        WorkQueueToken newToken = WorkQueueManager.enqueue(newTask, 0, false);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "enqueue(Runnable)", newToken);
        }
        return newToken;
    }

    public static WorkQueueToken enqueue(Runnable newTask, int priority, boolean repeating) throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "enqueue(Runnable,int,boolean)", new Object[]{newTask, new Integer(priority), repeating});
        }
        SimpleWorkQueueItem newItem = new SimpleWorkQueueItem(newTask);
        newItem.setRepeats(repeating);
        WorkQueueToken newToken = new WorkQueueToken(newItem);
        manager.enqueueItem(newItem, priority);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "enqueue(Runnable,int,boolean)", newToken);
        }
        return newToken;
    }

    public static WorkQueueToken enqueue(WorkQueueItem newItem) throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "enqueue(WorkQueueItem)", new Object[]{newItem});
        }
        WorkQueueToken newToken = WorkQueueManager.enqueue(newItem, 0, false);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "enqueue(WorkQueueItem)", newToken);
        }
        return newToken;
    }

    public static WorkQueueToken enqueue(WorkQueueItem newItem, int priority, boolean repeating) throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "enqueue(WorkQueueItem,int,boolean)", new Object[]{newItem, new Integer(priority), repeating});
        }
        WorkQueueToken newToken = new WorkQueueToken(newItem);
        newItem.setRepeats(repeating);
        manager.enqueueItem(newItem, priority);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "enqueue(WorkQueueItem,int,boolean)", newToken);
        }
        return newToken;
    }

    public static void runWorkQueueItem(WorkQueueItem item) {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "runWorkQueueItem(WorkQueueItem)", new Object[]{item});
        }
        item.run();
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "runWorkQueueItem(WorkQueueItem)");
        }
    }

    public static void setMaxThreadPoolSize(int newMaxPoolSize) {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "setMaxThreadPoolSize(int)", "setter", (Object)new Integer(newMaxPoolSize));
        }
        if (newMaxPoolSize < -1) {
            newMaxPoolSize = -1;
        }
        maxThreadPoolSize = newMaxPoolSize;
    }

    public static int getMaxThreadPoolSize() {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "getMaxThreadPoolSize()", "getter", (Object)new Integer(maxThreadPoolSize));
        }
        return maxThreadPoolSize;
    }

    public static int getCurrentThreadPoolSize() throws CSIException {
        int traceRet1 = manager.getCurrentThreadPoolSize();
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "getCurrentThreadPoolSize()", "getter", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public static void setPoolInactiveTimeout(long newTimeout) {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "setPoolInactiveTimeout(long)", "setter", (Object)new Long(newTimeout));
        }
        if (newTimeout < 0L) {
            newTimeout = 0L;
        }
        threadPoolInactiveTimeout = newTimeout;
    }

    public static long getPoolInactiveTimeout() {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "getPoolInactiveTimeout()", "getter", (Object)new Long(threadPoolInactiveTimeout));
        }
        return threadPoolInactiveTimeout;
    }

    public static void setMaintainThreadPoolSize(boolean maintain) {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "setMaintainThreadPoolSize(boolean)", "setter", (Object)maintain);
        }
        maintainThreadPoolSize = maintain;
    }

    public static boolean getMaintainThreadPoolSize() {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "getMaintainThreadPoolSize()", "getter", (Object)maintainThreadPoolSize);
        }
        return maintainThreadPoolSize;
    }

    public static void registerProperties() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "registerProperties()");
        }
        PropertyStore.register(maxThreadPoolSizeProperty, -1L, new Long(-1L), new Long(1000000L));
        PropertyStore.register(maintainThreadPoolSizeProperty, false);
        PropertyStore.register(threadPoolInactiveTimeoutProperty, 0L, new Long(0L), null);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "registerProperties()");
        }
    }

    private static void queryProperties() {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "queryProperties()");
        }
        maxThreadPoolSize = (int)PropertyStore.getLongProperty(maxThreadPoolSizeProperty);
        maintainThreadPoolSize = PropertyStore.getBooleanProperty(maintainThreadPoolSizeProperty);
        threadPoolInactiveTimeout = PropertyStore.getLongProperty(threadPoolInactiveTimeoutProperty);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "queryProperties()");
        }
    }

    public static void initialize() throws CSIException {
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "initialize()");
        }
        if (!initialized) {
            try {
                manager = CommonServices.getWorkQueueManager();
                WorkQueueManager.registerProperties();
                WorkQueueManager.queryProperties();
                initialized = true;
                if (maintainThreadPoolSize) {
                    int i = manager.fillThreadPool();
                    if (Trace.isOn) {
                        Trace.traceData("com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManager", "static initializer", "Created " + i + " new threads in thread pool", null);
                    }
                }
            }
            catch (CSIException csie) {
                if (Trace.isOn) {
                    Trace.catchBlock("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "initialize()", csie);
                }
                if (!listening) {
                    manager = new PIWorkQueueManager();
                    CSIListener listener = new CSIListener(){

                        public void onCSIInitialize() {
                            if (Trace.isOn) {
                                Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "onCSIInitialize()");
                            }
                            try {
                                WorkQueueManager.initialize();
                                listening = false;
                                CommonServices.removeCSIListener(this);
                            }
                            catch (CSIException csie2) {
                                if (Trace.isOn) {
                                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.workqueue.null", "onCSIInitialize()", csie2);
                                }
                                HashMap<String, CSIException> hash = new HashMap<String, CSIException>();
                                hash.put("Exception", csie2);
                                Trace.ffst(this, "onCSIInitialize", "Failed to initialize CSI from WorkQueueManager listener", hash, class$com$ibm$msg$client$commonservices$CSIException == null ? (class$com$ibm$msg$client$commonservices$CSIException = WorkQueueManager.class$("com.ibm.msg.client.commonservices.CSIException")) : class$com$ibm$msg$client$commonservices$CSIException);
                            }
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.commonservices.workqueue.null", "onCSIInitialize()");
                            }
                        }
                    };
                    CommonServices.addCSIListener(listener);
                    listening = true;
                }
                if (Trace.isOn) {
                    Trace.throwing("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "initialize()", csie);
                }
                throw csie;
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "initialize()");
        }
    }

    static {
        block5: {
            if (Trace.isOn) {
                Trace.data("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/workqueue/WorkQueueManager.java, jmscc.commonservices, k701, k701-112-140304  1.21.1.1 09/08/17 08:24:31");
            }
            maxThreadPoolSize = -1;
            maintainThreadPoolSize = false;
            threadPoolInactiveTimeout = 0L;
            initialized = false;
            listening = false;
            if (Trace.isOn) {
                Trace.entry("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "static()");
            }
            try {
                WorkQueueManager.initialize();
            }
            catch (CSIException csie) {
                if (!Trace.isOn) break block5;
                Trace.catchBlock("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "static()", csie);
            }
        }
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.workqueue.WorkQueueManager", "static()");
        }
    }
}

