/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.workqueue;

import com.ibm.msg.client.commonservices.trace.Trace;

public abstract class WorkQueueItem
implements Runnable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/workqueue/WorkQueueItem.java, jmscc.commonservices, k701, k701-112-140304 1.23.1.1 09/08/17 08:24:19";
    public static final int STATE_WAITING = 0;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_RUNNING = 2;
    public static final int STATE_ENDING = 3;
    public static final int STATE_COMPLETE = 4;
    private int state = 0;
    private Runnable task;
    private boolean repeats = false;
    private Object completedNotifier = new Object();
    private Throwable lastThrown = null;

    protected WorkQueueItem(Runnable newTask) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "<init>(Runnable)", new Object[]{newTask});
        }
        this.state = 0;
        this.task = newTask;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "<init>(Runnable)");
        }
    }

    public int getState() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "getState()", "getter", new Integer(this.state));
        }
        return this.state;
    }

    protected void setState(int newState) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "setState(int)", "setter", new Integer(newState));
        }
        this.state = newState;
    }

    public void setRepeats(boolean repeats) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "setRepeats(boolean)", "setter", repeats);
        }
        this.repeats = repeats;
    }

    public boolean repeats() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "repeats()");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "repeats()", this.repeats);
        }
        return this.repeats;
    }

    protected void setTask(Runnable newTask) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "setTask(Runnable)", "setter", newTask);
        }
        if (this.task == null) {
            this.task = newTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "pause()");
        }
        WorkQueueItem workQueueItem = this;
        synchronized (workQueueItem) {
            this.state = 1;
            this.notifyAll();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "pause()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "resume()");
        }
        WorkQueueItem workQueueItem = this;
        synchronized (workQueueItem) {
            this.state = 0;
            this.notifyAll();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "resume()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "end()");
        }
        WorkQueueItem workQueueItem = this;
        synchronized (workQueueItem) {
            this.state = 3;
            this.notifyAll();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "end()");
        }
    }

    protected void runTask() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "runTask()");
        }
        this.task.run();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "runTask()");
        }
    }

    public abstract void runItem();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "run()");
        }
        try {
            this.runItem();
        }
        catch (Throwable t) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "run()", t);
            }
            this.lastThrown = t;
            this.end();
        }
        Object object = this.completedNotifier;
        synchronized (object) {
            this.setState(4);
            this.completedNotifier.notifyAll();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "run()");
        }
    }

    public Throwable getLastThrown() {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "getLastThrown()", "getter", this.lastThrown);
        }
        return this.lastThrown;
    }

    protected void setLastThrown(Throwable t) {
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "setLastThrown(Throwable)", "setter", t);
        }
        this.lastThrown = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "waitForCompletion()");
        }
        Object object = this.completedNotifier;
        synchronized (object) {
            block9: {
                if (this.getState() == 4) {
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "waitForCompletion()", 1);
                    }
                    return;
                }
                try {
                    this.completedNotifier.wait();
                }
                catch (InterruptedException e) {
                    if (!Trace.isOn) break block9;
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "waitForCompletion()", e);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "waitForCompletion()", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion(long timeout) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "waitForCompletion(long)", new Object[]{new Long(timeout)});
        }
        Object object = this.completedNotifier;
        synchronized (object) {
            block9: {
                if (this.getState() == 4) {
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "waitForCompletion(long)", 1);
                    }
                    return;
                }
                try {
                    this.completedNotifier.wait(timeout);
                }
                catch (InterruptedException e) {
                    if (!Trace.isOn) break block9;
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "waitForCompletion(long)", e);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "waitForCompletion(long)", 2);
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.workqueue.WorkQueueItem", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/workqueue/WorkQueueItem.java, jmscc.commonservices, k701, k701-112-140304  1.23.1.1 09/08/17 08:24:19");
        }
    }
}

