/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.trace;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.CSIListener;
import com.ibm.msg.client.commonservices.CommonServices;
import com.ibm.msg.client.commonservices.Utils;
import com.ibm.msg.client.commonservices.componentmanager.Component;
import com.ibm.msg.client.commonservices.componentmanager.ComponentManager;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.provider.trace.CSPTrace;
import com.ibm.msg.client.commonservices.trace.FlightRecorder;
import com.ibm.msg.client.commonservices.trace.NullTracer;
import com.ibm.msg.client.commonservices.trace.StartupTracer;
import com.ibm.msg.client.commonservices.trace.TableBuilder;
import com.ibm.msg.client.commonservices.trace.TraceFFSTInfo;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueManager;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;

public final class Trace {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/trace/Trace.java, jmscc.commonservices, k701, k701-112-140304 1.70.1.8 11/06/29 10:00:01";
    public static final String traceStatusProperty = "com.ibm.msg.client.commonservices.trace.status";
    public static final String traceStatusProperty_ON = "ON";
    public static final String traceStatusProperty_OFF = "OFF";
    public static final String traceStatusProperty_LISTEN = "LISTEN";
    public static final String traceStatusProperty_default = "OFF";
    public static final String startupTraceProperty = "com.ibm.msg.client.commonservices.trace.startup";
    public static final String errorStreamProperty = "com.ibm.msg.client.commonservices.trace.errorStream";
    public static final String traceLevelProperty = "com.ibm.msg.client.commonservices.trace.level";
    public static final long traceLevelProperty_default = 9L;
    private static final int JCA_TRACE_EXCEPTION = 1;
    private static final int JCA_TRACE_WARNING = 3;
    private static final int JCA_TRACE_INFO = 6;
    private static final int JCA_TRACE_ENTRYEXIT = 8;
    private static final int JCA_TRACE_DATA = 9;
    private static final int JCA_TRACE_ALL = Integer.MAX_VALUE;
    public static final int ENTRY_TRACE_LEVEL = 8;
    public static final int EXIT_TRACE_LEVEL = 8;
    public static final int THROW_TRACE_LEVEL = 1;
    public static final int CATCH_TRACE_LEVEL = 1;
    public static final int FINALLY_TRACE_LEVEL = 8;
    public static final int WARNING_TRACE_LEVEL = 3;
    public static final int INFO_TRACE_LEVEL = 6;
    public static final int DATA_TRACE_LEVEL = 9;
    public static final int ALL_TRACE_LEVEL = Integer.MAX_VALUE;
    public static final int FINEST_TRACE_LEVEL = 10;
    public static final String DUMMY_PROBEID = "????????";
    public static boolean isOn;
    private static int traceLevel;
    private static CSPTrace currentTracer;
    private static CSPTrace functionalTracer;
    private static NullTracer nullTracer;
    private static Hashtable currentlyTracing;
    static boolean startupTracing;
    protected static boolean initialized;
    protected static boolean listening;
    private static TraceFFSTInfo providerFFSTInfo;
    private static String lineSeparatorProperty;
    public static String lineSeparator;
    private static Map traceHandlers;
    private static final String PROBE_1 = "1";
    private static final String PROBE_2 = "2";
    private static final String PROBE_3 = "3";
    private static final String PROBE_4 = "4";
    private static final String PROBE_5 = "5";
    private static final String PROBE_6 = "6";
    public static PrintStream errorStream;
    public static final String outputFileNameProperty = "com.ibm.msg.client.commonservices.trace.outputName";
    public static final String includedPackagesProperty = "com.ibm.msg.client.commonservices.trace.include";
    public static final String includedPackagesProperty_default = "ALL";
    public static final String excludedPackagesProperty = "com.ibm.msg.client.commonservices.trace.exclude";
    public static final String excludedPackagesProperty_default = "NONE";
    public static final String searchStringProperty = "com.ibm.msg.client.commonservices.trace.searchString";
    public static final String searchStringProperty_default = "";
    public static final String maxTraceBytesProperty = "com.ibm.msg.client.commonservices.trace.maxBytes";
    public static final int maxTraceBytesProperty_default = -1;
    public static final String traceFileLimitProperty = "com.ibm.msg.client.commonservices.trace.limit";
    public static final int traceFileLimitProperty_default = 0;
    public static final String traceFileCountProperty = "com.ibm.msg.client.commonservices.trace.count";
    public static final int traceFileCountProperty_default = 1;
    public static final String parameterTraceProperty = "com.ibm.msg.client.commonservices.trace.parameter";
    public static final boolean parameterTraceProperty_default = true;
    public static final String appendTraceProperty = "com.ibm.msg.client.commonservices.trace.append";
    public static final boolean appendTraceProperty_default = true;
    public static final String traceHandlerNameProperty = "com.ibm.msg.client.commonservices.trace.traceHandler";
    public static final String traceHandlerNameProperty_default = "";
    public static final String traceFormatterNameProperty = "com.ibm.msg.client.commonservices.trace.traceFormatter";
    public static final String traceFormatterNameProperty_default = "";
    public static final String compressedTraceProperty = "com.ibm.msg.client.commonservices.trace.compress";
    public static final boolean compressedTraceProperty_default = false;
    public static final String produceJavaCoreProperty = "com.ibm.msg.client.commonservices.j2se.produceJavaCore";
    public static final boolean produceJavaCoreProperty_default = false;
    public static Properties productProps;
    public static final String suppressFFST = "com.ibm.msg.client.commonservices.ffst.suppress";
    public static final int suppressFFST_default = 0;
    private static HashMap receivedFfst;
    private static int ffstSuppressionLevel;
    private static boolean ffstSuppressionUnchecked;
    private static ThreadLocal tls;
    static /* synthetic */ Class class$com$ibm$msg$client$commonservices$trace$Trace$Thrower;

    private static synchronized void checkForFfstSuppression() {
        PropertyStore.register(suppressFFST, 0L, new Long(-1L), new Long(Integer.MAX_VALUE));
        ffstSuppressionLevel = (int)PropertyStore.getLongProperty(suppressFFST);
    }

    private Trace() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setOn(boolean traceOn) {
        if (isOn != traceOn || !currentTracer.equals(functionalTracer) && !currentTracer.equals(nullTracer)) {
            isOn = traceOn;
            if (traceOn) {
                functionalTracer.initialize();
                currentTracer = functionalTracer;
                Trace.traceData("com.ibm.msg.client.commonservices.trace.Trace", "setOn(boolean)", "Enabled trace", null);
                StringBuffer version = new StringBuffer();
                version = Trace.getVersion(version);
                Trace.traceData("com.ibm.msg.client.commonservices.trace.Trace", "setOn(boolean)", "Version Information", (Object)version);
            } else {
                Trace.traceData("com.ibm.msg.client.commonservices.trace.Trace", "setOn(boolean)", "Disabling Trace", null);
                currentTracer.close();
                currentTracer = nullTracer;
            }
            if (null != traceHandlers) {
                Map map = traceHandlers;
                synchronized (map) {
                    Set keys = traceHandlers.keySet();
                    Iterator iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        ((TraceHandler)iterator.next()).setOn(isOn);
                    }
                }
            }
        }
    }

    public static void setTraceLevel(int newTraceLevel) {
        traceLevel = newTraceLevel;
        functionalTracer.setTraceLevel(newTraceLevel);
    }

    public static int getTraceLevel() {
        return traceLevel;
    }

    public static void registerTraceHandler(TraceHandler handler) {
        if (handler != null && !traceHandlers.containsKey(handler)) {
            traceHandlers.put(handler, null);
            handler.setOn(isOn);
        }
    }

    public static void setCSPTrace(CSPTrace newTracer) {
        functionalTracer = null == newTracer ? nullTracer : newTracer;
        Trace.setOn(isOn);
    }

    public static CSPTrace getCSPTrace() {
        if (null == functionalTracer || functionalTracer instanceof NullTracer) {
            return null;
        }
        return functionalTracer;
    }

    private static boolean traceable() {
        Thread currentThread = Thread.currentThread();
        Boolean alreadyTracing = (Boolean)currentlyTracing.get(currentThread);
        if (null == alreadyTracing || !alreadyTracing.booleanValue()) {
            currentlyTracing.put(currentThread, new Boolean(true));
            return true;
        }
        return false;
    }

    private static void endTracing() {
        Thread currentThread = Thread.currentThread();
        Boolean alreadyTracing = (Boolean)currentlyTracing.get(currentThread);
        if (null == alreadyTracing || !alreadyTracing.booleanValue()) {
            return;
        }
        currentlyTracing.remove(currentThread);
    }

    public static void entry(Object parentClass, String parentClassName, String methodSignature, Object[] parameters) {
        Trace.methodEntryInternal(parentClass, parentClassName, methodSignature, parameters);
    }

    public static void entry(Object parentClass, String parentClassName, String methodSignature) {
        Trace.methodEntryInternal(parentClass, parentClassName, methodSignature, null);
    }

    public static void entry(String parentClassName, String methodSignature) {
        Trace.methodEntryInternal(null, parentClassName, methodSignature, null);
    }

    public static void entry(String parentClassName, String methodSignature, Object[] parameters) {
        Trace.methodEntryInternal(null, parentClassName, methodSignature, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void methodEntryInternal(Object parentClass, String parentClassName, String methodSignature, Object[] parameters) {
        if (isOn && Trace.traceable()) {
            FlightRecorder.entry(parentClassName + "." + methodSignature);
            try {
                currentTracer.methodEntry(8, parentClass, parentClassName, methodSignature, parameters);
            }
            catch (Throwable t) {
                Trace.endTracing();
                Trace.catchBlock("com.ibm.msg.client.commonservices.trace.Trace", "methodEntryInternal", t);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("reason", "Entry trace threw exception");
                data.put("exception", t);
                Trace.ffst("com.ibm.msg.client.commonservices.trace.Trace", "methodEntryInternal(Object, String, Object[])", PROBE_1, data, CSIException.class);
            }
            finally {
                Trace.endTracing();
            }
        }
    }

    public static void exit(Object parentClass, String parentClassName, String methodSignature, Object returnValue, int exitIndex) {
        Trace.methodExitInternal(parentClass, parentClassName, methodSignature, returnValue, exitIndex);
    }

    public static void exit(Object parentClass, String parentClassName, String methodSignature) {
        Trace.methodExitInternal(parentClass, parentClassName, methodSignature, null, -1);
    }

    public static void exit(Object parentClass, String parentClassName, String methodSignature, Object returnValue) {
        Trace.methodExitInternal(parentClass, parentClassName, methodSignature, returnValue, -1);
    }

    public static void exit(Object parentClass, String parentClassName, String methodSignature, int exitIndex) {
        Trace.methodExitInternal(parentClass, parentClassName, methodSignature, null, exitIndex);
    }

    public static void exit(String parentClassName, String methodSignature) {
        Trace.methodExitInternal(null, parentClassName, methodSignature, null, -1);
    }

    public static void exit(String parentClassName, String methodSignature, Object returnValue) {
        Trace.methodExitInternal(null, parentClassName, methodSignature, returnValue, -1);
    }

    public static void exit(String parentClassName, String methodSignature, int exitIndex) {
        Trace.methodExitInternal(null, parentClassName, methodSignature, null, exitIndex);
    }

    public static void exit(String parentClassName, String methodSignature, Object returnValue, int exitIndex) {
        Trace.methodExitInternal(null, parentClassName, methodSignature, returnValue, exitIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void methodExitInternal(Object parentClass, String parentClassName, String methodSignature, Object returnValue, int exitIndex) {
        if (isOn && Trace.traceable()) {
            FlightRecorder.exit(parentClassName + "." + methodSignature + "(" + exitIndex + ") --> " + returnValue);
            try {
                currentTracer.methodExit(8, parentClass, parentClassName, methodSignature, returnValue, exitIndex);
            }
            catch (Throwable t) {
                Trace.endTracing();
                Trace.catchBlock("com.ibm.msg.client.commonservices.trace.Trace", "methodExitInternal", t);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("Reason", "Exit trace threw exception");
                data.put("exception", t);
                Trace.ffst("com.ibm.msg.client.commonservices.trace.Trace", "methodExitInternal(Object, String, Object, int)", PROBE_2, data, CSIException.class);
            }
            finally {
                Trace.endTracing();
            }
        }
    }

    public static void traceData(Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceDataInternal(9, parentClass, parentClassName, methodSignature, uniqueDescription, data);
    }

    public static void traceData(int level, Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceDataInternal(level, parentClass, parentClassName, methodSignature, uniqueDescription, data);
    }

    public static void traceData(Object parentClass, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceDataInternal(9, parentClass, null, methodSignature, uniqueDescription, data);
    }

    public static void traceData(int level, Object parentClass, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceDataInternal(level, parentClass, null, methodSignature, uniqueDescription, data);
    }

    public static void data(Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceDataInternal(9, parentClass, parentClassName, methodSignature, uniqueDescription, data);
    }

    public static void data(int methodTraceLevel, Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceDataInternal(methodTraceLevel, parentClass, parentClassName, methodSignature, uniqueDescription, data);
    }

    public static void data(Object parentClass, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceDataInternal(9, parentClass, null, methodSignature, uniqueDescription, data);
    }

    public static void traceData(String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceDataInternal(9, null, parentClassName, methodSignature, uniqueDescription, data);
    }

    public static void data(String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceDataInternal(9, null, parentClassName, methodSignature, uniqueDescription, data);
    }

    public static void traceData(Object parentClass, String uniqueDescription, Object data) {
        Trace.traceDataInternal(9, parentClass, null, "unspecified method", uniqueDescription, data);
    }

    public static void data(Object parentClass, String uniqueDescription, Object data) {
        Trace.traceDataInternal(9, parentClass, null, "unspecified method", uniqueDescription, data);
    }

    public static void traceData(String parentClassName, String uniqueDescription, Object data) {
        Trace.traceDataInternal(9, null, parentClassName, "unspecified method", uniqueDescription, data);
    }

    public static void data(String parentClassName, String uniqueDescription, Object data) {
        Trace.traceDataInternal(9, null, parentClassName, "unspecified method", uniqueDescription, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceDataInternal(int level, Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        if (isOn && Trace.traceable()) {
            try {
                currentTracer.traceData(level, parentClass, parentClassName, methodSignature, uniqueDescription, data);
            }
            catch (Throwable t) {
                Trace.endTracing();
                Trace.catchBlock("com.ibm.msg.client.commonservices.trace.Trace", "traceDataInternal", t);
                HashMap<String, Object> data1 = new HashMap<String, Object>();
                data1.put("Reason", "Data trace threw exception");
                data1.put("exception", t);
                Trace.ffst("com.ibm.msg.client.commonservices.trace.Trace", "traceDataInternal(Object, String, String, Object)", PROBE_3, data1, CSIException.class);
            }
            finally {
                Trace.endTracing();
            }
        }
    }

    public static void catchBlock(Object parentClass, String parentClassName, String methodSignature, Throwable thrown, int exitIndex) {
        Trace.catchBlockInternal(parentClass, parentClassName, methodSignature, thrown, exitIndex);
    }

    public static void catchBlock(Object parentClass, String parentClassName, String methodSignature, Throwable thrown) {
        Trace.catchBlockInternal(parentClass, parentClassName, methodSignature, thrown, -1);
    }

    public static void catchBlock(String parentClassName, String methodSignature, Throwable thrown) {
        Trace.catchBlockInternal(null, parentClassName, methodSignature, thrown, -1);
    }

    public static void catchBlock(String parentClassName, String methodSignature, Throwable thrown, int exitIndex) {
        Trace.catchBlockInternal(null, parentClassName, methodSignature, thrown, exitIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void catchBlockInternal(Object parentClass, String parentClassName, String methodSignature, Throwable thrown, int exitIndex) {
        if (isOn && Trace.traceable()) {
            try {
                currentTracer.catchBlock(1, parentClass, parentClassName, methodSignature, thrown, exitIndex);
            }
            catch (Throwable t) {
                Trace.endTracing();
                Trace.catchBlock("com.ibm.msg.client.commonservices.trace.Trace", "catchBlockInternal", t);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("Reason", "Catch trace threw exception");
                data.put("exception", t);
                Trace.ffst("com.ibm.msg.client.commonservices.trace.Trace", "catchBlockInternal(Object, String, Throwable, int)", PROBE_4, data, CSIException.class);
            }
            finally {
                Trace.endTracing();
            }
        }
    }

    public static void throwing(Object parentClass, String parentClassName, String methodSignature, Throwable thrown, int exitIndex) {
        Trace.throwingInternal(parentClass, parentClassName, methodSignature, thrown, exitIndex);
    }

    public static void throwing(Object parentClass, String parentClassName, String methodSignature, Throwable thrown) {
        Trace.throwingInternal(parentClass, parentClassName, methodSignature, thrown, -1);
    }

    public static void throwing(String parentClassName, String methodSignature, Throwable thrown) {
        Trace.throwingInternal(null, parentClassName, methodSignature, thrown, -1);
    }

    public static void throwing(String parentClassName, String methodSignature, Throwable thrown, int exitIndex) {
        Trace.throwingInternal(null, parentClassName, methodSignature, thrown, exitIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void throwingInternal(Object parentClass, String parentClassName, String methodSignature, Throwable thrown, int exitIndex) {
        if (isOn && Trace.traceable()) {
            try {
                currentTracer.throwing(1, parentClass, parentClassName, methodSignature, thrown, exitIndex);
            }
            catch (Throwable t) {
                Trace.endTracing();
                Trace.catchBlock("com.ibm.msg.client.commonservices.trace.Trace", "throwingInternal", t);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("Reason", "Throw trace threw exception");
                data.put("exception", t);
                Trace.ffst("com.ibm.msg.client.commonservices.trace.Trace", "throwingInternal(Object, String, Throwable, int)", PROBE_5, data, CSIException.class);
            }
            finally {
                Trace.endTracing();
            }
        }
    }

    public static void finallyBlock(Object parentClass, String parentClassName, String methodSignature, int exitIndex) {
        Trace.finallyBlockInternal(parentClass, parentClassName, methodSignature, exitIndex);
    }

    public static void finallyBlock(Object parentClass, String parentClassName, String methodSignature) {
        Trace.finallyBlockInternal(parentClass, parentClassName, methodSignature, -1);
    }

    public static void finallyBlock(String parentClassName, String methodSignature) {
        Trace.finallyBlockInternal(null, parentClassName, methodSignature, -1);
    }

    public static void finallyBlock(String parentClassName, String methodSignature, int exitIndex) {
        Trace.finallyBlockInternal(null, parentClassName, methodSignature, exitIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finallyBlockInternal(Object parentClass, String parentClassName, String methodSignature, int exitIndex) {
        if (isOn && Trace.traceable()) {
            try {
                currentTracer.finallyBlock(8, parentClass, parentClassName, methodSignature, exitIndex);
            }
            catch (Throwable t) {
                Trace.endTracing();
                Trace.catchBlock("com.ibm.msg.client.commonservices.trace.Trace", "finallyBlockInternal", t);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("Reason", "Finally trace threw exception");
                data.put("exception", t);
                Trace.ffst("com.ibm.msg.client.commonservices.trace.Trace", "finallyBlockInternal(Object, String, int)", PROBE_6, data, CSIException.class);
            }
            finally {
                Trace.endTracing();
            }
        }
    }

    private static ThreadLocalStorage getTraceTls() {
        ThreadLocalStorage threadLocalStorage = (ThreadLocalStorage)tls.get();
        if (threadLocalStorage == null) {
            threadLocalStorage = new ThreadLocalStorage();
            tls.set(threadLocalStorage);
        }
        return threadLocalStorage;
    }

    private static boolean ffstSafeToEnter() {
        ThreadLocalStorage threadLocalStorage = Trace.getTraceTls();
        boolean isSafeToEnter = false;
        if (!threadLocalStorage.insideFFST) {
            threadLocalStorage.insideFFST = true;
            isSafeToEnter = true;
        }
        return isSafeToEnter;
    }

    private static void leaveFFST() {
        ThreadLocalStorage threadLocalStorage = Trace.getTraceTls();
        threadLocalStorage.insideFFST = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void ffst(Object sourceClass, String methodSignature, String probeID, HashMap data, Class exceptionClassToThrow) {
        if (Trace.ffstSafeToEnter()) {
            try {
                Trace.ffstInternal(sourceClass, methodSignature, probeID, data, exceptionClassToThrow);
            }
            finally {
                Trace.leaveFFST();
            }
        }
        try {
            System.err.println("FFST called when already creating FFST.");
            if (sourceClass != null) {
                System.err.println("sourceClass = " + sourceClass.getClass().getName());
            }
            if (methodSignature != null) {
                System.err.println("method = " + methodSignature);
            }
            if (probeID != null) {
                System.err.println("probeID = " + probeID);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ffst(String sourceClassName, String methodSignature, String probeID, HashMap data, Class exceptionClassToThrow) {
        if (Trace.ffstSafeToEnter()) {
            try {
                Trace.ffstInternal(sourceClassName, methodSignature, probeID, data, exceptionClassToThrow);
            }
            finally {
                Trace.leaveFFST();
            }
        }
        try {
            System.err.println("FFST called when already creating FFST.");
            if (sourceClassName != null) {
                System.err.println("sourceClass = " + sourceClassName);
            }
            if (methodSignature != null) {
                System.err.println("method = " + methodSignature);
            }
            if (probeID != null) {
                System.err.println("probeID = " + probeID);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public static synchronized String ffstAssertion(Object sourceClass, String methodSignature, String probeID, Object[] data2) {
        Trace.traceData(sourceClass, methodSignature, (Object)"Creating FFST Data");
        HashMap<String, Object> data = new HashMap<String, Object>(data2.length);
        StringBuffer data2AsString = new StringBuffer();
        for (int count1 = 0; count1 < data2.length; ++count1) {
            if (data2[count1] instanceof String) {
                String nameValuePair = (String)data2[count1];
                int splitIndex = nameValuePair.indexOf("=>");
                if (splitIndex > 0) {
                    String key = nameValuePair.substring(0, splitIndex);
                    String value = nameValuePair.substring(splitIndex + 2);
                    data.put(key, value);
                } else {
                    data.put("Key" + count1, data2[count1]);
                }
            } else {
                data.put("Key" + count1, data2[count1]);
            }
            data2AsString.append(":").append(data2[count1]);
        }
        String ffstName = null;
        try {
            Trace.ffst(sourceClass, methodSignature, probeID, data, null);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return sourceClass + " " + methodSignature + lineSeparator + "Assertion:" + probeID + " Data" + data2AsString + lineSeparator + "FDC File " + ffstName + " Written";
    }

    private static void ffstInternal(Object sourceClass, String methodSignature, String probeID, HashMap data, Class exceptionClassToThrow) {
        if (ffstSuppressionUnchecked) {
            Trace.checkForFfstSuppression();
        }
        boolean suppress = false;
        if (ffstSuppressionLevel != 0) {
            String key = sourceClass.getClass() + ":" + methodSignature + ":" + probeID;
            Integer callCount = (Integer)receivedFfst.get(key);
            if (callCount != null) {
                if (ffstSuppressionLevel == -1) {
                    suppress = true;
                } else if (ffstSuppressionLevel > 0) {
                    if (callCount % ffstSuppressionLevel != 0) {
                        suppress = true;
                    }
                    receivedFfst.put(key, new Integer(callCount + 1));
                }
            } else {
                receivedFfst.put(key, new Integer(1));
            }
        }
        String filename = "Suppressed";
        if (!suppress) {
            if (isOn) {
                Trace.traceData(sourceClass, methodSignature, (Object)"Creating FFST Data");
            }
            String ffstString = Trace.createFFSTString(sourceClass, methodSignature, probeID, data);
            if (isOn) {
                Trace.traceData(sourceClass, methodSignature, (Object)("FFST string " + ffstString));
            }
            filename = functionalTracer.ffst(sourceClass, methodSignature, probeID, data, ffstString);
        }
        if (exceptionClassToThrow != null) {
            Throwable ie = null;
            try {
                StackTraceElement[] stack;
                String message = "JMSCS0006: " + NLSServices.getMessage("JMSCS0006", filename);
                Constructor constructor = exceptionClassToThrow.getConstructor(String.class);
                ie = (Throwable)constructor.newInstance(message);
                Object linkedException = data.get("exception");
                if (linkedException == null) {
                    linkedException = data.get("EXCEPTION");
                }
                if (linkedException != null && linkedException instanceof Throwable) {
                    ie.initCause((Throwable)linkedException);
                }
                if ((stack = ie.getStackTrace()).length > 0) {
                    int newStackSize;
                    int stackShouldStartAt = 0;
                    for (int count1 = 0; count1 < stack.length; ++count1) {
                        StackTraceElement elem = stack[count1];
                        if (!elem.getClassName().equalsIgnoreCase("com.ibm.msg.client.commonservices.trace.Trace") || !elem.getMethodName().equalsIgnoreCase("ffst")) continue;
                        stackShouldStartAt = count1;
                        break;
                    }
                    if ((newStackSize = stack.length - stackShouldStartAt) > 1) {
                        StackTraceElement[] newStack = new StackTraceElement[newStackSize];
                        System.arraycopy(stack, stackShouldStartAt, newStack, 0, newStackSize);
                        ie.setStackTrace(newStack);
                    }
                }
            }
            catch (Exception e) {
                String message = "JMSCS0006: An internal problem occurred and diagnostic information for service was written to " + filename + ". It was not possible to throw the requested exception due to follow-on problems.";
                System.err.println(message);
                e.printStackTrace(System.err);
                System.err.flush();
            }
            if (ie != null) {
                Thrower.sneakyThrow(filename, ie);
            }
        }
    }

    private static String createFFSTString(Object sourceClass, String methodSignature, String probeID, HashMap data) {
        StringBuffer output = new StringBuffer();
        String sourceClassName = new String();
        if (null != sourceClass) {
            sourceClassName = sourceClass instanceof String ? (String)sourceClass : sourceClass.getClass().getName();
        }
        output.append(lineSeparator);
        output = Trace.getFFSTHeader(output, sourceClassName, methodSignature, probeID, data);
        output.append(lineSeparator);
        output = Trace.getVersion(output);
        output.append(lineSeparator);
        output = Trace.getCurrentPosition(output);
        output.append(lineSeparator);
        output = Trace.getFFSTPropertyStore(output);
        output.append(lineSeparator);
        output = Trace.getFFSTWorkQueueManager(output);
        output.append(lineSeparator);
        output = Trace.getRuntimeProperties(output);
        output.append(lineSeparator);
        output = Trace.getFFSTComponentManager(output);
        output.append(lineSeparator);
        output = Trace.getFFSTPropertyContext(output, sourceClass);
        output.append(lineSeparator);
        output = Trace.getFFSTProviderInformation(output, sourceClass);
        output.append(lineSeparator);
        return output.toString();
    }

    private static StringBuffer getVersion(StringBuffer output) {
        ComponentManager compMgr = ComponentManager.getInstance();
        Component[] components = compMgr.getComponents(null);
        if (components != null && components.length > 0) {
            Trace.newSubTitle(output, "Version information");
            for (int c = 0; c < components.length; ++c) {
                String cmvcLevel;
                output.append(components[c].getTitle()).append(lineSeparator);
                output.append(components[c].getVersionString()).append(lineSeparator);
                Map info = components[c].getImplementationInfo(true);
                if (info != null && (cmvcLevel = (String)info.get("CMVC")) != null) {
                    output.append(cmvcLevel).append(lineSeparator);
                }
                output.append("Production").append(lineSeparator);
                output.append(lineSeparator);
            }
        } else {
            output.append("No Components Found").append(lineSeparator);
        }
        return output;
    }

    private static StringBuffer getCurrentPosition(StringBuffer output) {
        TableBuilder builder = new TableBuilder();
        Exception e = new Exception();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        builder.append("FFST Location", sw.toString());
        Trace.newSubTitle(output, "Stack trace");
        output.append("Stack trace to show the location of the FFST call").append(lineSeparator);
        output.append(builder.toStringBuffer());
        return output;
    }

    private static StringBuffer newTitle(StringBuffer output, String title) {
        return Trace.newHeading(output, title, ' ');
    }

    private static StringBuffer newSubTitle(StringBuffer output, String title) {
        return Trace.newHeading(output, title, '-');
    }

    private static StringBuffer newHeading(StringBuffer output, String title, char marker) {
        int i;
        output.append(lineSeparator);
        int indent = 40 - Math.round((float)title.length() / 2.0f);
        for (i = 0; i < indent; ++i) {
            output.append(' ');
        }
        output.append(title + lineSeparator);
        for (i = 0; i < indent; ++i) {
            output.append(' ');
        }
        for (i = 0; i < title.length(); ++i) {
            output.append(marker);
        }
        output.append(lineSeparator).append(lineSeparator);
        return output;
    }

    private static StringBuffer getFFSTHeader(StringBuffer output, String sourceClassString, String methodSignature, String probeID, HashMap data) {
        long time = System.currentTimeMillis();
        Trace.newTitle(output, "FDCTitle");
        output.append("Product          :- ProductName");
        output.append(lineSeparator);
        output.append("Date/Time        :- " + Trace.getTimestamp(time));
        output.append(lineSeparator);
        output.append("System time      :- " + Long.toString(time));
        output.append(lineSeparator);
        output.append("Operating System :- " + PropertyStore.os_name);
        output.append(lineSeparator);
        output.append("UserID           :- " + PropertyStore.user_name);
        output.append(lineSeparator);
        output.append("Java Vendor      :- " + PropertyStore.java_vm_vendor);
        output.append(lineSeparator);
        output.append("Java Version     :- " + PropertyStore.java_vm_version);
        output.append(lineSeparator);
        output.append(lineSeparator);
        output.append("Source Class     :- " + sourceClassString);
        output.append(lineSeparator);
        output.append("Source Method    :- " + methodSignature);
        output.append(lineSeparator);
        output.append("ProbeID          :- " + probeID);
        output.append(lineSeparator);
        output.append("Thread           :- " + Trace.getCurrentThreadName());
        output.append(lineSeparator);
        Trace.newSubTitle(output, "Data");
        TableBuilder dataBuilder = new TableBuilder();
        if (null == data) {
            output.append("Data        :- none");
        } else {
            Set keys = data.keySet();
            Iterator iterate = keys.iterator();
            while (iterate.hasNext()) {
                String key = (String)iterate.next();
                Object value = data.get(key);
                if (value instanceof Throwable) {
                    Throwable e = (Throwable)value;
                    TableBuilder exceptBuilder = new TableBuilder();
                    int exceptionDepth = 1;
                    while (null != e) {
                        exceptBuilder.append("Cause:" + exceptionDepth, e.toString());
                        String msg = e.getMessage();
                        if (null != msg) {
                            exceptBuilder.append("Message:" + exceptionDepth, msg);
                        }
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        pw.flush();
                        sw.flush();
                        exceptBuilder.append("StackTrace:" + exceptionDepth, sw.toString());
                        pw.close();
                        try {
                            sw.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        e = e.getCause();
                        ++exceptionDepth;
                    }
                    dataBuilder.append(key, "ExceptionDepth is " + exceptionDepth);
                    dataBuilder.append(key, exceptBuilder);
                    continue;
                }
                if (value instanceof byte[]) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("ByteArray len=").append(((byte[])value).length);
                    buffer.append("  id=").append(value);
                    buffer.append(lineSeparator);
                    buffer.append(Utils.formatObjectDetailed(value));
                    dataBuilder.append(key, buffer);
                    continue;
                }
                if (value instanceof ByteBuffer) {
                    ByteBuffer bb = (ByteBuffer)value;
                    int position = bb.position();
                    bb.position(0);
                    byte[] newarray = new byte[bb.capacity()];
                    bb.get(newarray, 0, bb.capacity());
                    bb.position(position);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("ByteBuffer ").append(bb);
                    buffer.append(lineSeparator);
                    buffer.append(Utils.formatObjectDetailed(newarray));
                    dataBuilder.append(key, buffer);
                    continue;
                }
                dataBuilder.append(key, value);
            }
        }
        output.append(dataBuilder.toStringBuffer());
        return output;
    }

    private static StringBuffer getFFSTPropertyStore(StringBuffer output) {
        Trace.newSubTitle(output, "Property Store Contents");
        output.append("All currently set properties").append(lineSeparator);
        HashMap properties = PropertyStore.getAll();
        Set keys = properties.keySet();
        Iterator iterate = keys.iterator();
        TableBuilder builder = new TableBuilder();
        while (iterate.hasNext()) {
            String key;
            Object value = properties.get(key = (String)iterate.next());
            builder.append(key, value == null ? "<null>" : value.toString());
        }
        output.append(builder.toStringBuffer());
        return output;
    }

    private static StringBuffer getFFSTPropertyContext(StringBuffer output, Object sourceClass) {
        if (sourceClass instanceof Map) {
            Trace.newSubTitle(output, "FFST Object Properties");
            output.append("All currently set properties").append(lineSeparator);
            Map properties = (Map)sourceClass;
            Set keys = properties.keySet();
            Iterator iterate = keys.iterator();
            TableBuilder builder = new TableBuilder();
            while (iterate.hasNext()) {
                String key;
                Object value = properties.get(key = (String)iterate.next());
                builder.append(key, value == null ? "<null>" : value.toString());
            }
            output.append(builder.toStringBuffer());
        }
        return output;
    }

    private static StringBuffer getFFSTComponentManager(StringBuffer output) {
        Trace.newSubTitle(output, "Component Manager Contents");
        ComponentManager compMgr = ComponentManager.getInstance();
        if (compMgr != null) {
            Object value;
            String key;
            TableBuilder builder;
            Iterator iterate;
            Set keys;
            HashMap properties;
            int i;
            Component[] csiComponents = null;
            try {
                csiComponents = compMgr.getComponents("CSI", null);
            }
            catch (CSIException e) {
                // empty catch block
            }
            Component[] mpiComponents = null;
            try {
                mpiComponents = compMgr.getComponents("MPI", null);
            }
            catch (CSIException e) {
                // empty catch block
            }
            output.append("Common Services Components:").append(lineSeparator);
            for (i = 0; csiComponents != null && i < csiComponents.length; ++i) {
                properties = csiComponents[i].getDetails();
                keys = properties.keySet();
                iterate = keys.iterator();
                builder = new TableBuilder();
                while (iterate.hasNext()) {
                    value = properties.get(key = (String)iterate.next());
                    builder.append(key, value == null ? "<null>" : value.toString());
                }
                output.append(builder.toStringBuffer()).append(lineSeparator).append(lineSeparator);
            }
            output.append("Messaging Provider Components:").append(lineSeparator);
            for (i = 0; mpiComponents != null && i < mpiComponents.length; ++i) {
                properties = mpiComponents[i].getDetails();
                keys = properties.keySet();
                iterate = keys.iterator();
                builder = new TableBuilder();
                while (iterate.hasNext()) {
                    value = properties.get(key = (String)iterate.next());
                    builder.append(key, value == null ? "<null>" : value.toString());
                }
                output.append(builder.toStringBuffer()).append(lineSeparator).append(lineSeparator);
            }
        }
        return output;
    }

    private static StringBuffer getFFSTProviderInformation(StringBuffer output, Object sourceClass) {
        String providerOutput;
        if (providerFFSTInfo != null && (providerOutput = providerFFSTInfo.providerInformation(sourceClass)) != null) {
            Trace.newSubTitle(output, "Provider Specific Information");
            output.append(providerOutput);
        }
        return output;
    }

    private static StringBuffer getFFSTWorkQueueManager(StringBuffer output) {
        Trace.newSubTitle(output, "WorkQueueMananger Contents");
        TableBuilder builder = new TableBuilder();
        try {
            builder.append("Current ThreadPool size", Integer.toString(WorkQueueManager.getCurrentThreadPoolSize()));
        }
        catch (CSIException e) {
            builder.append("unavailable - ", e.toString());
        }
        builder.append("Maximum ThreadPool size", Integer.toString(WorkQueueManager.getMaxThreadPoolSize()));
        builder.append("Maintain ThreadPool size", Boolean.toString(WorkQueueManager.getMaintainThreadPoolSize()));
        builder.append("ThreadPool inactive timeout", Long.toString(WorkQueueManager.getPoolInactiveTimeout()));
        output.append(builder.toStringBuffer());
        return output;
    }

    public static void initialize() throws CSIException {
        if (!initialized) {
            try {
                if (!CommonServices.isInitialized() || !CommonServices.isModuleInitialized(4)) {
                    String msg = NLSServices.getMessage("JMSCS0002");
                    CSIException thrown = new CSIException(msg);
                    throw thrown;
                }
                Trace.registerConfigurationProperties();
                functionalTracer = CommonServices.getTrace();
                initialized = true;
                ComponentManager.setUseStartupTrace(false);
                PropertyStore.register(traceLevelProperty, 9L, new Long(Integer.MIN_VALUE), new Long(Integer.MAX_VALUE));
                int userTraceLevel = (int)PropertyStore.getLongProperty(traceLevelProperty);
                Trace.setTraceLevel(userTraceLevel);
                PropertyStore.register(traceStatusProperty, "OFF");
                String traceOn = PropertyStore.getStringProperty(traceStatusProperty);
                if (null != traceOn && traceOn.equalsIgnoreCase(traceStatusProperty_ON)) {
                    Trace.setOn(true);
                } else {
                    Trace.setOn(false);
                }
            }
            catch (CSIException csie) {
                if (!listening) {
                    functionalTracer = startupTracing ? StartupTracer.getInstance() : new NullTracer();
                    CSIListener listener = new CSIListener(){

                        public void onCSIInitialize() {
                            try {
                                Trace.initialize();
                                listening = false;
                                CommonServices.removeCSIListener(this);
                                ComponentManager.setUseStartupTrace(false);
                                PropertyStore.register(Trace.traceStatusProperty, "OFF");
                                String traceOn = PropertyStore.getStringProperty(Trace.traceStatusProperty);
                                if (null != traceOn && traceOn.equalsIgnoreCase(Trace.traceStatusProperty_ON)) {
                                    Trace.setOn(true);
                                } else {
                                    Trace.setOn(false);
                                }
                            }
                            catch (CSIException csie2) {
                                HashMap<String, CSIException> hash = new HashMap<String, CSIException>();
                                hash.put("Exception", csie2);
                                Trace.ffst(this, "onCSIInitialize", "Failed to initialize CSI from Trace listener", hash, class$com$ibm$msg$client$commonservices$CSIException == null ? (class$com$ibm$msg$client$commonservices$CSIException = Trace.class$("com.ibm.msg.client.commonservices.CSIException")) : class$com$ibm$msg$client$commonservices$CSIException);
                            }
                        }
                    };
                    CommonServices.addCSIListener(listener);
                    listening = true;
                }
                throw csie;
            }
        }
    }

    private static String getTimestamp(long time) {
        return new Date(time).toString();
    }

    private static StringBuffer getRuntimeProperties(StringBuffer output) {
        Runtime runtime = Runtime.getRuntime();
        if (runtime != null) {
            Trace.newSubTitle(output, "Runtime properties");
            TableBuilder properties = new TableBuilder();
            properties.append("Available processors", "" + runtime.availableProcessors());
            properties.append("Total memory in bytes (now)", "" + runtime.totalMemory());
            properties.append("Free memory in bytes (now)", "" + runtime.freeMemory());
            properties.append("Max memory in bytes", "" + runtime.maxMemory());
            output.append(properties.toStringBuffer());
            return output;
        }
        return output;
    }

    private static String getCurrentThreadName() {
        Map values = (Map)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Thread thread = Thread.currentThread();
                map.put("Thread", thread);
                map.put("ThreadName", thread.getName());
                map.put("Priority", new Integer(thread.getPriority()));
                map.put("ThreadGroup", thread.getThreadGroup().getName());
                map.put("ContextClassLoader", thread.getContextClassLoader());
                return map;
            }
        });
        String ccl = "<ContextClassLoader is null>";
        ClassLoader cl = (ClassLoader)values.get("ContextClassLoader");
        if (cl != null) {
            ccl = cl.toString();
        }
        StringBuffer sb = new StringBuffer(32);
        sb.append("name=");
        sb.append(values.get("ThreadName"));
        sb.append(" priority=");
        sb.append(values.get("Priority"));
        sb.append(" group=");
        sb.append(values.get("ThreadGroup"));
        sb.append(" ccl=");
        sb.append(ccl);
        return sb.toString();
    }

    public static void traceInfo(Object parentClass, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceInfoInternal(parentClass, null, methodSignature, uniqueDescription, data);
    }

    public static void traceInfo(Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceInfoInternal(parentClass, parentClassName, methodSignature, uniqueDescription, data);
    }

    public static void traceInfo(String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceInfoInternal(null, parentClassName, methodSignature, uniqueDescription, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceInfoInternal(Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        if (isOn && Trace.traceable()) {
            try {
                currentTracer.traceData(6, parentClass, parentClassName, methodSignature, uniqueDescription, data);
            }
            catch (Throwable t) {
                Trace.endTracing();
                Trace.catchBlock("com.ibm.msg.client.commonservices.trace.Trace", "traceInfoInternal", t);
                HashMap<String, Object> data1 = new HashMap<String, Object>();
                data1.put("Reason", "Data trace threw exception");
                data1.put("exception", t);
                Trace.ffst("com.ibm.msg.client.commonservices.trace.Trace", "traceInfoInternal(Object, String, String, Object)", PROBE_3, data1, CSIException.class);
            }
            finally {
                Trace.endTracing();
            }
        }
    }

    public static void traceWarning(Object parentClass, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceWarningInternal(parentClass, null, methodSignature, uniqueDescription, data);
    }

    public static void traceWarning(Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceWarningInternal(parentClass, parentClassName, methodSignature, uniqueDescription, data);
    }

    public static void traceWarning(String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        Trace.traceWarningInternal(null, parentClassName, methodSignature, uniqueDescription, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceWarningInternal(Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        if (isOn && Trace.traceable()) {
            try {
                currentTracer.traceData(3, parentClass, parentClassName, methodSignature, uniqueDescription, data);
            }
            catch (Throwable t) {
                Trace.endTracing();
                Trace.catchBlock("com.ibm.msg.client.commonservices.trace.Trace", "traceDataInternal", t);
                HashMap<String, Object> data1 = new HashMap<String, Object>();
                data1.put("Reason", "Data trace threw exception");
                data1.put("exception", t);
                Trace.ffst("com.ibm.msg.client.commonservices.trace.Trace", "traceDataInternal(Object, String, String, Object)", PROBE_3, data1, CSIException.class);
            }
            finally {
                Trace.endTracing();
            }
        }
    }

    public static void registerFFSTInfo(TraceFFSTInfo providerFFST) {
        providerFFSTInfo = providerFFST;
    }

    private static void registerConfigurationProperties() {
        productProps = CommonServices.getProductization();
        PropertyStore.register(outputFileNameProperty, (String)productProps.get("TraceFilename"));
        PropertyStore.register(includedPackagesProperty, includedPackagesProperty_default);
        PropertyStore.register(excludedPackagesProperty, excludedPackagesProperty_default);
        PropertyStore.register(searchStringProperty, "");
        PropertyStore.register(maxTraceBytesProperty, -1L, new Long(-1L), new Long(Integer.MAX_VALUE));
        PropertyStore.register(traceFileLimitProperty, 0L, new Long(0L), new Long(Integer.MAX_VALUE));
        PropertyStore.register(traceFileCountProperty, 1L, new Long(0L), new Long(Integer.MAX_VALUE));
        PropertyStore.register(parameterTraceProperty, true);
        PropertyStore.register(compressedTraceProperty, false);
        PropertyStore.register(traceFormatterNameProperty, null);
        PropertyStore.register(traceHandlerNameProperty, "");
        PropertyStore.register(appendTraceProperty, true);
    }

    static {
        Object o;
        isOn = false;
        traceLevel = Integer.MAX_VALUE;
        currentTracer = null;
        functionalTracer = null;
        nullTracer = null;
        currentlyTracing = null;
        startupTracing = false;
        initialized = false;
        listening = false;
        providerFFSTInfo = null;
        lineSeparatorProperty = "line.separator";
        lineSeparator = null;
        traceHandlers = Collections.synchronizedMap(new WeakHashMap());
        errorStream = System.err;
        receivedFfst = new HashMap();
        ffstSuppressionLevel = 0;
        ffstSuppressionUnchecked = true;
        nullTracer = new NullTracer();
        functionalTracer = nullTracer;
        Object errorStreamObject = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(Trace.errorStreamProperty);
                }
                catch (AccessControlException ace) {
                    return null;
                }
            }
        });
        if (errorStreamObject != null && errorStreamObject instanceof String) {
            String stream = (String)errorStreamObject;
            if (stream.equalsIgnoreCase("System.err")) {
                errorStream = System.err;
            } else if (stream.equalsIgnoreCase("System.out")) {
                errorStream = System.out;
            } else {
                try {
                    FileOutputStream fos = new FileOutputStream(stream, true);
                    errorStream = new PrintStream(fos);
                }
                catch (Throwable e) {
                    errorStream = System.err;
                    errorStream.println("Failed to open requested error stream " + e.getMessage());
                }
            }
        } else {
            errorStream = System.err;
        }
        if ((o = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(Trace.startupTraceProperty);
                }
                catch (AccessControlException ace) {
                    return null;
                }
            }
        })) != null && ((String)o).equalsIgnoreCase("TRUE")) {
            String s = new String();
            s.toString();
            startupTracing = true;
            isOn = true;
            currentTracer = StartupTracer.getInstance();
        } else {
            currentTracer = nullTracer;
        }
        currentlyTracing = new Hashtable();
        functionalTracer = currentTracer;
        lineSeparator = PropertyStore.line_separator;
        try {
            Trace.initialize();
        }
        catch (CSIException cSIException) {
            // empty catch block
        }
        tls = new ThreadLocal();
    }

    static class Thrower {
        private static Throwable t;

        private Thrower() throws Throwable {
            throw t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static synchronized void sneakyThrow(String filename, Throwable exceptionToThrow) {
            t = exceptionToThrow;
            try {
                (class$com$ibm$msg$client$commonservices$trace$Trace$Thrower == null ? (class$com$ibm$msg$client$commonservices$trace$Trace$Thrower = Trace.class$("com.ibm.msg.client.commonservices.trace.Trace$Thrower")) : class$com$ibm$msg$client$commonservices$trace$Trace$Thrower).newInstance();
            }
            catch (InstantiationException e) {
                String message = "JMSCS0006: An internal problem occurred. Please contact your service representative. Diagnostic information for service was written to " + filename + ".";
                System.err.println(message);
                e.printStackTrace(System.err);
                System.err.flush();
            }
            catch (IllegalAccessException e) {
                String message = "JMSCS0006: An internal problem occurred. Please contact your service representative. Diagnostic information for service was written to " + filename + ".";
                System.err.println(message);
                e.printStackTrace(System.err);
                System.err.flush();
            }
            finally {
                t = null;
            }
        }
    }

    static class ThreadLocalStorage {
        public boolean insideFFST;

        ThreadLocalStorage() {
        }
    }

    public static interface TraceHandler {
        public void setOn(boolean var1);
    }
}

