/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.trace;

import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TableBuilder {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/trace/TableBuilder.java, jmscc.commonservices, k701, k701-112-140304 1.11.2.1 09/08/17 08:06:13";
    private static String lineSeparator;
    ArrayList entries = new ArrayList();
    int maxKeyLength = 0;
    String sep = ":-";
    String startIndent;
    String newLine;
    private boolean setOutputSorted = true;

    public TableBuilder() {
        lineSeparator = PropertyStore.line_separator;
        this.startIndent = "|   ";
    }

    public TableBuilder(int startIndentAmount, boolean outputSorted) {
        this();
        this.startIndent = "|";
        this.setOutputSorted = outputSorted;
        for (int count = 0; count < startIndentAmount; ++count) {
            this.startIndent = this.startIndent + " ";
        }
    }

    public StringBuffer toStringBuffer() {
        StringBuffer buffer = new StringBuffer();
        if (this.setOutputSorted) {
            Collections.sort(this.entries);
        }
        int size = this.entries.size();
        for (int count = 0; count < size; ++count) {
            Entry entry = (Entry)this.entries.get(count);
            String key = entry.key;
            int keySize = key.length();
            buffer.append(this.startIndent).append(key);
            int spacesToAdd = this.maxKeyLength - keySize + 2;
            for (int i = 0; i < spacesToAdd; ++i) {
                buffer.append(' ');
            }
            buffer.append(this.sep).append("  ");
            Object value = entry.value;
            if (value instanceof TableBuilder) {
                buffer.append(lineSeparator).append(this.startIndent);
            }
            String stringValue = value.toString();
            stringValue = stringValue.replaceAll(lineSeparator, lineSeparator + this.startIndent);
            buffer.append(stringValue);
            if (count + 1 >= size) continue;
            buffer.append(lineSeparator);
        }
        return buffer;
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String key, Object value) {
        if (value == null) {
            value = "<null>";
        }
        ArrayList arrayList = this.entries;
        synchronized (arrayList) {
            Entry entry = new Entry();
            entry.key = key;
            if (value instanceof Map) {
                TableBuilder mapTable = new TableBuilder();
                Map map = (Map)value;
                Iterator keyIterator = map.keySet().iterator();
                while (keyIterator.hasNext()) {
                    Object itemKey = keyIterator.next();
                    mapTable.append(itemKey.toString(), map.get(itemKey));
                }
                entry.value = mapTable;
            } else if (value instanceof List) {
                TableBuilder listTable = new TableBuilder();
                List list = (List)value;
                Iterator iterator = list.iterator();
                int itemIndex = 0;
                while (iterator.hasNext()) {
                    listTable.append(Integer.toString(itemIndex++), iterator.next());
                }
                entry.value = listTable;
            } else {
                entry.value = value instanceof TableBuilder ? value : value.toString();
            }
            this.entries.add(entry);
            int keyLength = key.length();
            if (key.length() > this.maxKeyLength) {
                this.maxKeyLength = keyLength;
            }
        }
    }

    public void populate(HashMap table) {
        if (table != null) {
            Iterator it = table.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.append(key, table.get(key));
            }
        }
    }

    static {
        String lineSeparatorProperty = "line.separator";
        PropertyStore.register(lineSeparatorProperty, "\n");
    }

    class Entry
    implements Comparable {
        String key;
        Object value;

        Entry() {
        }

        public int compareTo(Object o) {
            return this.key.compareTo(((Entry)o).key);
        }
    }
}

