/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.trace;

import com.ibm.msg.client.commonservices.provider.trace.CSPTrace;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.trace.TraceFormatter;
import com.ibm.msg.client.commonservices.trace.TraceHandler;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class StartupTracer
implements CSPTrace {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/trace/StartupTracer.java, jmscc.commonservices, k701, k701-112-140304 1.14.2.1 09/08/17 08:46:06";
    private Calendar calendar;
    private Date date = new Date();
    private static StartupTracer startupTracer;
    private PrintStream stream;

    private StartupTracer() {
        this.calendar = new GregorianCalendar();
        this.stream = Trace.errorStream;
        StringBuffer buffer = this.getBaseMessage(this);
        buffer.append("Startup Trace Initalized.... STARTUP_INIT");
        this.stream.println(buffer);
    }

    public static StartupTracer getInstance() {
        if (startupTracer == null) {
            startupTracer = new StartupTracer();
        }
        return startupTracer;
    }

    public void catchBlock(int level, Object parentClass, String parentClassName, String methodSignature, Throwable thrown, int exitIndex) {
        StringBuffer output = this.getBaseMessage(parentClass == null ? parentClassName : parentClass);
        if (thrown == null) {
            thrown = new Throwable("Unknown throwable");
        }
        output.append(methodSignature + " ");
        if (exitIndex != -1) {
            output.append("<exitIndex " + exitIndex + "> ");
        }
        output.append(thrown.getClass().getName());
        output.append(" caught: " + thrown.getMessage());
        this.appendStackTrace(thrown, output);
        this.stream.println(output);
    }

    public void finallyBlock(int level, Object parentClass, String parentClassName, String methodSignature, int exitIndex) {
        StringBuffer output = this.getBaseMessage(parentClass == null ? parentClassName : parentClass);
        output.append(methodSignature);
        if (exitIndex != -1) {
            output.append(" <exitIndex " + exitIndex + ">");
        }
        output.append(" finally");
        this.stream.println(output);
    }

    public void methodEntry(int level, Object parentClass, String parentClassName, String methodSignature, Object[] parameters) {
        StringBuffer output = this.getBaseMessage(parentClass == null ? parentClassName : parentClass);
        output.append("==> ");
        output.append(methodSignature + " entry ");
        this.incrementIndents();
        if (parameters != null) {
            this.indent(output);
            output.append("params:");
            Object parameter = null;
            for (int i = 0; i < parameters.length; ++i) {
                parameter = parameters[i];
                if (parameter == null) continue;
                if (i > 0) {
                    this.indent(output);
                }
                output.append('\t');
                output.append(parameter.getClass());
                output.append(" = ");
                output.append(parameter.toString());
            }
        }
        this.stream.println(output);
    }

    public void methodExit(int level, Object parentClass, String parentClassName, String methodSignature, Object returnValue, int exitIndex) {
        StringBuffer output = this.getBaseMessage(parentClass == null ? parentClassName : parentClass);
        this.decrementIndents();
        output.append("<== ");
        output.append(methodSignature);
        if (exitIndex != -1) {
            output.append(" <exitIndex " + exitIndex + "> ");
        }
        output.append("exit ");
        if (returnValue != null) {
            this.indent(output);
            output.append(" return = ");
            output.append(returnValue.toString());
        }
        this.stream.println(output);
    }

    public void throwing(int level, Object parentClass, String parentClassName, String methodSignature, Throwable thrown, int exitIndex) {
        StringBuffer output = this.getBaseMessage(parentClass == null ? parentClassName : parentClass);
        output.append(methodSignature + " ");
        if (exitIndex != -1) {
            output.append(" <exitIndex " + exitIndex + "> ");
        }
        output.append(thrown.getClass().getName());
        output.append(" exception thrown: " + thrown.getMessage());
        for (Throwable cause = thrown.getCause(); cause != null; cause = cause.getCause()) {
            this.incrementIndents();
            this.indent(output);
            output.append("\tCaused by " + cause.getClass().getName());
            output.append(" exception thrown: " + thrown.getMessage());
            this.appendStackTrace(cause, output);
            this.decrementIndents();
        }
        this.stream.println(output);
    }

    void appendStackTrace(Throwable t, StringBuffer buffer) {
        StackTraceElement[] stack = t.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            this.indent(buffer);
            buffer.append("\tat " + stack[i] + '\n');
        }
    }

    public void traceData(int level, Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        StringBuffer output = this.getBaseMessage(parentClass == null ? parentClassName : parentClass);
        output.append(' ');
        output.append(uniqueDescription);
        if (data != null) {
            this.indent(output);
            output.append(" Data==>");
            output.append(data.toString());
        }
        this.stream.println(output);
    }

    private void indent(StringBuffer output) {
    }

    private void incrementIndents() {
    }

    private void decrementIndents() {
    }

    public void close() {
    }

    public void initialize() {
    }

    public void setTraceFormatter(TraceFormatter newFormatter) {
    }

    public void setTraceHandler(TraceHandler newHandler) {
    }

    private StringBuffer getBaseMessage(Object parentClass) {
        StringBuffer output = new StringBuffer();
        this.appendTimestamp(output, System.currentTimeMillis());
        String className = null;
        if (parentClass instanceof String) {
            className = (String)parentClass;
        } else if (parentClass != null) {
            className = parentClass.getClass().getName();
        }
        output.append('[' + Thread.currentThread().getName() + "] ");
        output.append(className);
        output.append(' ');
        return output;
    }

    StringBuffer appendTimestamp(StringBuffer buffer, long millis) {
        this.date.setTime(millis);
        this.calendar.setTime(this.date);
        int h = this.calendar.get(11);
        int m = this.calendar.get(12);
        int s = this.calendar.get(13);
        if (h < 10) {
            buffer.append("0" + h + ":");
        } else {
            buffer.append(h + ":");
        }
        if (m < 10) {
            buffer.append("0" + m + ":");
        } else {
            buffer.append(m + ":");
        }
        if (s < 10) {
            buffer.append("0" + s + ":");
        } else {
            buffer.append(s + " ");
        }
        buffer.append("[" + millis + "] ");
        return buffer;
    }

    public String ffst(Object sourceClass, String methodSignature, String probeID, HashMap data, String header) {
        this.stream.println(header);
        return "FFST called for " + probeID + " @ " + sourceClass + ":" + methodSignature;
    }

    public int getTraceLevel() {
        return Integer.MAX_VALUE;
    }

    public void setTraceLevel(int traceLevel) {
    }
}

