/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.trace;

import java.io.File;
import java.io.FileWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.WeakHashMap;

public final class FlightRecorder {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/trace/FlightRecorder.java, jmscc.commonservices, k701, k701-112-140304 1.2.1.2 10/02/26 17:33:54";
    private static String NL = "\n";
    private static boolean inUse = false;
    private static final int SIZE = 500;
    private static ThreadLocal tls = new ThreadLocal();
    private static WeakHashMap map = new WeakHashMap();
    private static final FlightRecorderType DATA;
    private static final FlightRecorderType ENTRY;
    private static final FlightRecorderType EXIT;

    public static void start() {
        inUse = false;
        Boolean inUseValue = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return new Boolean(Boolean.getBoolean("com.ibm.msg.client.FlightRecorder"));
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        if (inUseValue != null) {
            inUse = inUseValue;
        }
    }

    public static void entry(String text) {
        FlightRecorder.put(ENTRY, text);
    }

    public static void exit(String text) {
        FlightRecorder.put(EXIT, text);
    }

    public static void data(String text) {
        FlightRecorder.put(DATA, text);
    }

    private static void put(FlightRecorderType type, String text) {
        if (inUse) {
            FlightRecorderThreadData data = FlightRecorder.getCurrentThreadData();
            ((FlightRecorderThreadData)data).array[((FlightRecorderThreadData)data).currentPosition] = new FlightRecorderItem(type, text);
            data.currentPosition++;
            if (data.currentPosition >= 500) {
                data.currentPosition = 0;
            }
        }
    }

    private static String dump(Thread thread) {
        StringBuffer sb = new StringBuffer();
        FlightRecorderThreadData data = (FlightRecorderThreadData)map.get(thread);
        if (data != null) {
            int i;
            String name = thread.getName();
            sb.append(name);
            sb.append(NL);
            sb.append(FlightRecorder.fill('-', name.length()));
            sb.append(NL);
            int level = 20;
            for (i = data.currentPosition; i < 500; ++i) {
                level = FlightRecorder.dump(data.array[i], level, sb);
            }
            for (i = 0; i < data.currentPosition; ++i) {
                level = FlightRecorder.dump(data.array[i], level, sb);
            }
            sb.append(NL);
        }
        return sb.toString();
    }

    private static int dump(FlightRecorderItem item, int level, StringBuffer sb) {
        int result = level;
        if (item != null) {
            sb.append(item.toString(level));
            sb.append(NL);
            result += item.getType().getLevelUpdate();
        }
        return result;
    }

    public static void dump() {
        if (inUse) {
            StringBuffer sb = new StringBuffer();
            int arraySize = Thread.activeCount() + 32;
            Thread[] array = new Thread[arraySize];
            int numberOfThreads = Thread.enumerate(array);
            for (int i = 0; i < numberOfThreads; ++i) {
                Thread thread = array[i];
                String string = FlightRecorder.dump(thread);
                sb.append(string);
            }
            try {
                File filename = new File("FlightRecorder.txt");
                FileWriter fw = new FileWriter(filename);
                fw.write(sb.toString());
                fw.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static FlightRecorderThreadData getCurrentThreadData() {
        FlightRecorderThreadData data = (FlightRecorderThreadData)tls.get();
        if (data == null) {
            data = new FlightRecorderThreadData();
            tls.set(data);
            Thread thread = Thread.currentThread();
            map.put(thread, data);
        }
        return data;
    }

    private static String fill(char ch, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append(ch);
        }
        return sb.toString();
    }

    static {
        String nlValue = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("line.separator");
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        if (nlValue != null) {
            NL = nlValue;
        }
        DATA = new FlightRecorderType(0, "");
        ENTRY = new FlightRecorderType(1, " -->");
        EXIT = new FlightRecorderType(-1, "<--");
    }

    static class FlightRecorderItem {
        private FlightRecorderType type;
        private String text;

        public FlightRecorderItem(FlightRecorderType type, String text) {
            this.type = type;
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public FlightRecorderType getType() {
            return this.type;
        }

        public void setType(FlightRecorderType type) {
            this.type = type;
        }

        public String toString(int level) {
            StringBuffer sb = new StringBuffer();
            sb.append(FlightRecorder.fill(' ', level));
            sb.append(this.type.getText());
            sb.append(" ");
            sb.append(this.text);
            return sb.toString();
        }
    }

    static class FlightRecorderType {
        private int update;
        private String text;

        public FlightRecorderType(int update, String text) {
            this.update = update;
            this.text = text;
        }

        public int getLevelUpdate() {
            return this.update;
        }

        public String getText() {
            return this.text;
        }
    }

    static class FlightRecorderThreadData {
        private FlightRecorderItem[] array = new FlightRecorderItem[500];
        private int currentPosition;

        FlightRecorderThreadData() {
        }
    }
}

