/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.propertystore;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.CSIListener;
import com.ibm.msg.client.commonservices.CommonServices;
import com.ibm.msg.client.commonservices.propertystore.PIPropertyStore;
import com.ibm.msg.client.commonservices.propertystore.PropertiesFileException;
import com.ibm.msg.client.commonservices.provider.propertystore.CSPPropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public final class PropertyStore {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/propertystore/PropertyStore.java, jmscc.commonservices, k701, k701-112-140304 1.23.1.4 11/03/18 15:01:00";
    private static CSPPropertyStore functionalPropertyStore = null;
    protected static boolean initialized = false;
    protected static boolean listening = false;
    public static String java_version;
    public static String java_vendor;
    public static String java_vendor_url;
    public static String java_home;
    public static String java_vm_specification_version;
    public static String java_vm_specification_vendor;
    public static String java_vm_specification_name;
    public static String java_vm_version;
    public static String java_vm_vendor;
    public static String java_vm_name;
    public static String java_specification_version;
    public static String java_specification_vendor;
    public static String java_specification_name;
    public static String java_class_version;
    public static String java_class_path;
    public static String java_library_path;
    public static String java_io_tmpdir;
    public static String java_compiler;
    public static String java_ext_dirs;
    public static String os_name;
    public static String os_arch;
    public static String os_version;
    public static String file_separator;
    public static String path_separator;
    public static String line_separator;
    public static String user_name;
    public static String user_home;
    public static String user_dir;
    static /* synthetic */ Class class$com$ibm$msg$client$commonservices$CSIException;

    public static String getStringProperty(String name) {
        return functionalPropertyStore.getStringProperty(name);
    }

    public static long getLongProperty(String name) {
        return functionalPropertyStore.getLongProperty(name);
    }

    public static Long getLongPropertyObject(String name) {
        Long retVal = null;
        try {
            long value = functionalPropertyStore.getLongProperty(name);
            retVal = new Long(value);
        }
        catch (Throwable t) {
            retVal = null;
        }
        return retVal;
    }

    public static boolean getBooleanProperty(String name) {
        return functionalPropertyStore.getBooleanProperty(name);
    }

    public static Boolean getBooleanPropertyObject(String name) {
        Boolean retVal = null;
        try {
            boolean value = functionalPropertyStore.getBooleanProperty(name);
            retVal = new Boolean(value);
        }
        catch (Throwable t) {
            retVal = null;
        }
        return retVal;
    }

    public static Object getObjectProperty(String name) {
        return functionalPropertyStore.getObjectProperty(name);
    }

    public static boolean wasOverridden(String name, StringBuffer unparsableUserValue) {
        return functionalPropertyStore.wasOverridden(name, unparsableUserValue);
    }

    public static void addPropertiesFile(String filename, String namespace, boolean optional) throws PropertiesFileException {
        functionalPropertyStore.addPropertiesFile(filename, namespace, optional);
    }

    public static void set(String name, String value) {
        functionalPropertyStore.set(name, value);
    }

    public static void set(String name, Object value) {
        functionalPropertyStore.set(name, value);
    }

    public static void register(String name, String defaultValue, boolean controlled) {
        functionalPropertyStore.register(name, defaultValue, controlled);
    }

    public static void register(String name, boolean defaultValue, boolean controlled) {
        functionalPropertyStore.register(name, defaultValue, controlled);
    }

    public static void register(String name, Object defaultValue, boolean controlled) {
        functionalPropertyStore.register(name, defaultValue, controlled);
    }

    public static void register(String name, long defaultValue, Long minValid, Long maxValid, boolean controlled) {
        functionalPropertyStore.register(name, defaultValue, minValid, maxValid, controlled);
    }

    public static void register(String name, String defaultValue) {
        functionalPropertyStore.register(name, defaultValue, false);
    }

    public static void register(String name, boolean defaultValue) {
        functionalPropertyStore.register(name, defaultValue, false);
    }

    public static void register(String name, Object defaultValue) {
        functionalPropertyStore.register(name, defaultValue, false);
    }

    public static void register(String name, long defaultValue, Long minValid, Long maxValid) {
        functionalPropertyStore.register(name, defaultValue, minValid, maxValid, false);
    }

    public static HashMap getAll() {
        return functionalPropertyStore.getAll();
    }

    public static void initialize() throws CSIException {
        if (!initialized) {
            try {
                HashMap preExistingProps = null;
                if (functionalPropertyStore != null) {
                    preExistingProps = functionalPropertyStore.getAll();
                }
                functionalPropertyStore = CommonServices.getPropertyStore();
                if (preExistingProps != null) {
                    if (Trace.isOn) {
                        Trace.data("com.ibm.msg.client.commonservices.propertystore.PropertyStore", "Setting pre-existing properties on new propertystore", (Object)preExistingProps);
                    }
                    Iterator it = preExistingProps.keySet().iterator();
                    while (it.hasNext()) {
                        Object key = it.next();
                        Object value = preExistingProps.get(key);
                        if (!(key instanceof String)) continue;
                        if (value instanceof Boolean) {
                            functionalPropertyStore.register((String)key, (Boolean)value, false);
                            continue;
                        }
                        if (value instanceof Long) {
                            functionalPropertyStore.register((String)key, (Long)value, new Long(Long.MIN_VALUE), new Long(Long.MAX_VALUE), false);
                            continue;
                        }
                        if (value instanceof String) {
                            functionalPropertyStore.register((String)key, (String)value, false);
                            continue;
                        }
                        functionalPropertyStore.register((String)key, value, false);
                    }
                }
                initialized = true;
                CommonServices.notifyListeners();
            }
            catch (CSIException csie) {
                if (!listening) {
                    functionalPropertyStore = new PIPropertyStore();
                    CSIListener listener = new CSIListener(){

                        public void onCSIInitialize() {
                            try {
                                PropertyStore.initialize();
                                listening = false;
                                CommonServices.removeCSIListener(this);
                            }
                            catch (CSIException csie2) {
                                HashMap<String, CSIException> hash = new HashMap<String, CSIException>();
                                hash.put("Exception", csie2);
                                Trace.ffst(this, "onCSIInitialize", "XC004001", hash, class$com$ibm$msg$client$commonservices$CSIException == null ? (class$com$ibm$msg$client$commonservices$CSIException = PropertyStore.class$("com.ibm.msg.client.commonservices.CSIException")) : class$com$ibm$msg$client$commonservices$CSIException);
                            }
                        }
                    };
                    CommonServices.addCSIListener(listener);
                    listening = true;
                }
                throw csie;
            }
        }
    }

    private static synchronized void setStandardSystemProperties() {
        Object sysPropsObj = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Properties traceRet1 = System.getProperties();
                    return traceRet1;
                }
                catch (AccessControlException ace) {
                    try {
                        os_name = System.getProperty("os.name");
                    }
                    catch (AccessControlException ace2) {
                        // empty catch block
                    }
                    try {
                        user_name = System.getProperty("user.name");
                    }
                    catch (AccessControlException ace2) {
                        // empty catch block
                    }
                    try {
                        line_separator = System.getProperty("line.separator");
                    }
                    catch (AccessControlException ace2) {
                        // empty catch block
                    }
                    try {
                        path_separator = System.getProperty("path.separator");
                    }
                    catch (AccessControlException accessControlException) {
                        // empty catch block
                    }
                    return ace;
                }
            }
        });
        if (sysPropsObj instanceof Properties) {
            Properties sysProps = (Properties)sysPropsObj;
            java_version = sysProps.getProperty("java.version");
            java_vendor = sysProps.getProperty("java.vendor");
            java_vendor_url = sysProps.getProperty("java.vendor.url");
            java_home = sysProps.getProperty("java.home");
            java_vm_specification_version = sysProps.getProperty("java.vm.specification.version");
            java_vm_specification_vendor = sysProps.getProperty("java.vm.specification.vendor");
            java_vm_specification_name = sysProps.getProperty("java.vm.specification.name");
            java_vm_version = sysProps.getProperty("java.vm.version");
            java_vm_vendor = sysProps.getProperty("java.vm.vendor");
            java_vm_name = sysProps.getProperty("java.vm.name");
            java_specification_version = sysProps.getProperty("java.specification.version");
            java_specification_vendor = sysProps.getProperty("java.specification.vendor");
            java_specification_name = sysProps.getProperty("java.specification.name");
            java_class_version = sysProps.getProperty("java.class.version");
            java_class_path = sysProps.getProperty("java.class.path");
            java_library_path = sysProps.getProperty("java.library.path");
            java_io_tmpdir = sysProps.getProperty("java.io.tmpdir");
            java_compiler = sysProps.getProperty("java.compiler");
            java_ext_dirs = sysProps.getProperty("java.ext.dirs");
            os_name = sysProps.getProperty("os.name");
            os_arch = sysProps.getProperty("os.arch");
            os_version = sysProps.getProperty("os.version");
            file_separator = sysProps.getProperty("file.separator");
            path_separator = sysProps.getProperty("path.separator");
            line_separator = sysProps.getProperty("line.separator");
            user_name = sysProps.getProperty("user.name");
            user_home = sysProps.getProperty("user.home");
            user_dir = sysProps.getProperty("user.dir");
        } else if (!(sysPropsObj instanceof AccessControlException)) {
            HashMap data = new HashMap();
            data.put("property", sysPropsObj);
            Trace.ffst("PropertyStore", "setStandardSystemProperties()", "XC004002", data, null);
        }
    }

    static {
        line_separator = "\n";
        try {
            PropertyStore.setStandardSystemProperties();
            PropertyStore.initialize();
        }
        catch (CSIException cSIException) {
            // empty catch block
        }
    }
}

