/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.propertystore;

import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertiesFileException;
import com.ibm.msg.client.commonservices.provider.propertystore.CSPPropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class PIPropertyStore
implements CSPPropertyStore {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/propertystore/PIPropertyStore.java, jmscc.commonservices, k701, k701-112-140304 1.27.1.2 10/02/26 17:33:46";
    private static Hashtable props;
    private static String NULL_OBJECT;

    public String getStringProperty(String name) {
        String retVal;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getStringProperty(String)", new Object[]{name});
        }
        if ((retVal = (String)props.get(name)) == NULL_OBJECT) {
            retVal = null;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getStringProperty(String)", retVal);
        }
        return retVal;
    }

    public long getLongProperty(String name) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getLongProperty(String)", new Object[]{name});
        }
        long retVal = 0L;
        try {
            retVal = (Long)props.get(name);
        }
        catch (ClassCastException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getLongProperty(String)", e);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("property", name);
            data.put("exception", e);
            Trace.ffst("PIPropertyStore", "getLongProperty", "XC005002", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getLongProperty(String)", new Long(retVal));
        }
        return retVal;
    }

    public boolean getBooleanProperty(String name) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getBooleanProperty(String)", new Object[]{name});
        }
        boolean retVal = false;
        try {
            retVal = (Boolean)props.get(name);
        }
        catch (ClassCastException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getBooleanProperty(String)", e);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("property", name);
            data.put("exception", e);
            Trace.ffst("PIPropertyStore", "getBooleanProperty", "XC005003", data, null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getBooleanProperty(String)", retVal);
        }
        return retVal;
    }

    public Object getObjectProperty(String name) {
        Object traceRet1;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getObjectProperty(String)", new Object[]{name});
        }
        if ((traceRet1 = props.get(name)) == NULL_OBJECT) {
            traceRet1 = null;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getObjectProperty(String)", traceRet1);
        }
        return traceRet1;
    }

    public void addPropertiesFile(String filename, String namespace, boolean optional) throws PropertiesFileException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "addPropertiesFile(String,String,boolean)", new Object[]{filename, namespace, optional});
        }
        String msg = NLSServices.getMessage("JMSCS0002");
        PropertiesFileException traceRet1 = new PropertiesFileException(msg, null);
        if (Trace.isOn) {
            Trace.throwing(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "addPropertiesFile(String,String,boolean)", traceRet1);
        }
        throw traceRet1;
    }

    public void set(String name, String value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "set(String,String)", new Object[]{name, value});
        }
        props.put(name, value == null ? NULL_OBJECT : value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "set(String,String)");
        }
    }

    public void set(String name, Object value) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "set(String,Object)", new Object[]{name, value});
        }
        props.put(name, value == null ? NULL_OBJECT : value);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "set(String,Object)");
        }
    }

    public HashMap getAll() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getAll()");
        }
        HashMap ret = new HashMap();
        Set keys = props.keySet();
        Iterator iterate = keys.iterator();
        Object key = null;
        while (iterate.hasNext()) {
            key = iterate.next();
            ret.put(key, props.get(key));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "getAll()", ret);
        }
        return ret;
    }

    public void register(String name, String defaultValue) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,String)", new Object[]{name, defaultValue});
        }
        props.put(name, defaultValue == null ? NULL_OBJECT : defaultValue);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,String)");
        }
    }

    public void register(String name, boolean defaultValue) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,boolean)", new Object[]{name, defaultValue});
        }
        props.put(name, new Boolean(defaultValue));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,boolean)");
        }
    }

    public void register(String name, Object defaultValue) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,Object)", new Object[]{name, defaultValue});
        }
        props.put(name, defaultValue == null ? NULL_OBJECT : defaultValue);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,Object)");
        }
    }

    public void register(String name, long defaultValue, Long minValid, Long maxValid) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,long,Long,Long)", new Object[]{name, new Long(defaultValue), minValid, maxValid});
        }
        props.put(name, new Long(defaultValue));
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,long,Long,Long)");
        }
    }

    public boolean wasOverridden(String name, StringBuffer unparsableUserValue) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "wasOverridden(String,StringBuffer)", new Object[]{name, unparsableUserValue});
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "wasOverridden(String,StringBuffer)", false);
        }
        return false;
    }

    public void register(String name, String defaultValue, boolean controlled) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,String,boolean)", new Object[]{name, defaultValue, controlled});
        }
        this.register(name, defaultValue);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,String,boolean)");
        }
    }

    public void register(String name, boolean defaultValue, boolean controlled) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,boolean,boolean)", new Object[]{name, defaultValue, controlled});
        }
        this.register(name, defaultValue);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,boolean,boolean)");
        }
    }

    public void register(String name, long defaultValue, Long minValid, Long maxValid, boolean controlled) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,long,Long,Long,boolean)", new Object[]{name, new Long(defaultValue), minValid, maxValid, controlled});
        }
        this.register(name, defaultValue, minValid, maxValid);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,long,Long,Long,boolean)");
        }
    }

    public void register(String name, Object defaultValue, boolean controlled) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,Object,boolean)", new Object[]{name, defaultValue, controlled});
        }
        this.register(name, defaultValue);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "register(String,Object,boolean)");
        }
    }

    static {
        block12: {
            if (Trace.isOn) {
                Trace.data("com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/propertystore/PIPropertyStore.java, jmscc.commonservices, k701, k701-112-140304  1.27.1.2 10/02/26 17:33:46");
            }
            props = new Hashtable();
            NULL_OBJECT = new String("NULL OBJECT PROXY");
            try {
                Object sysprops;
                if (Trace.isOn) {
                    Trace.entry("com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "static()");
                }
                if (props == null) {
                    props = new Hashtable();
                }
                if (NULL_OBJECT == null) {
                    NULL_OBJECT = new String("NULL OBJECT PROXY");
                }
                if ((sysprops = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (Trace.isOn) {
                            Trace.entry(this, "com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "run()");
                        }
                        try {
                            Properties traceRet1 = System.getProperties();
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.null", "run()", traceRet1, 1);
                            }
                            return traceRet1;
                        }
                        catch (AccessControlException ace) {
                            if (Trace.isOn) {
                                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.propertystore.null", "run()", ace);
                            }
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.commonservices.propertystore.null", "run()", ace, 2);
                            }
                            return ace;
                        }
                    }
                })) instanceof Properties) {
                    Enumeration<Object> keys = ((Properties)sysprops).keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        if (key == null || null != props.get(key)) continue;
                        String value = ((Properties)sysprops).getProperty(key);
                        if (value == null) {
                            value = NULL_OBJECT;
                        }
                        props.put(key, value);
                    }
                } else if (!(sysprops instanceof AccessControlException)) {
                    HashMap data = new HashMap();
                    data.put("property", sysprops);
                    Trace.ffst("PIPropertyStore", "static initializer", "XC005001", data, null);
                }
                if (Trace.isOn) {
                    Trace.exit("com.ibm.msg.client.commonservices.propertystore.PIPropertyStore", "static()");
                }
            }
            catch (Throwable t) {
                System.err.println("Serious problem encountered in <clinit> for class PIPropertyStore - Contact IBM Service");
                t.printStackTrace(System.err);
                if (!(t instanceof Error)) break block12;
                throw (Error)t;
            }
        }
    }
}

