/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.workqueue;

import com.ibm.msg.client.commonservices.provider.workqueue.CSPWorkQueueManager;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueItem;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class WorkQueueManagerImplementation
implements CSPWorkQueueManager {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/workqueue/WorkQueueManagerImplementation.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.27.1.1 09/08/17 08:29:42";
    private static final String threadGroupName = "JMSCCThreadPool";
    private static final String threadPoolMasterName = "JMSCCThreadPoolMaster";
    private static final String threadPoolWorkerNamePrefix = "JMSCCThreadPoolWorker-";
    private final ThreadGroup poolGroup = new ThreadGroup("JMSCCThreadPool");
    private int threadCount = 0;
    private Vector threadPool;
    private Vector inactiveThreadPool;
    private LinkedList workQueue;
    private LinkedList highPriorityWorkQueue;
    private WorkQueueManagerThread workManagerThread;
    private boolean useDeamonThreads = true;

    public WorkQueueManagerImplementation() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "<init>()");
        }
        this.threadPool = new Vector();
        this.inactiveThreadPool = new Vector();
        this.workQueue = new LinkedList();
        this.highPriorityWorkQueue = new LinkedList();
        this.workManagerThread = new WorkQueueManagerThread(threadPoolMasterName);
        this.workManagerThread.setDaemon(this.useDeamonThreads);
        this.workManagerThread.start();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "<init>()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueItem(WorkQueueItem newItem, int priority) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "enqueueItem(WorkQueueItem,int)", new Object[]{newItem, new Integer(priority)});
        }
        if (newItem == null) {
            if (Trace.isOn) {
                Trace.traceData(this, "enqueueItem(WorkQueueItem,int)", "New item is null, returning", null);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "enqueueItem(WorkQueueItem,int)", 1);
            }
            return;
        }
        if (priority == 1) {
            LinkedList linkedList = this.highPriorityWorkQueue;
            synchronized (linkedList) {
                if (Trace.isOn) {
                    Trace.traceData(this, "enqueueItem(WorkQueueItem,int)", "Enqueueing high priority item", (Object)newItem);
                }
                this.highPriorityWorkQueue.addLast(newItem);
            }
        }
        LinkedList linkedList = this.workQueue;
        synchronized (linkedList) {
            if (Trace.isOn) {
                Trace.traceData(this, "enqueueItem(WorkQueueItem,int)", "Enqueueing normal priority item", (Object)newItem);
            }
            this.workQueue.addLast(newItem);
        }
        if (Trace.isOn) {
            Trace.traceData(this, "enqueueItem(WorkQueueItem,int)", "Waking WorkManagerThread", (Object)this.workManagerThread);
        }
        this.workManagerThread.setWorkWaiting();
        if (Trace.isOn) {
            Trace.traceData(this, "enqueueItem(WorkQueueItem,int)", "Woken WorkManagerThread", null);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "enqueueItem(WorkQueueItem,int)", 2);
        }
    }

    public int fillThreadPool() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "fillThreadPool()");
        }
        int threadsCreated = 0;
        int threadsToCreate = WorkQueueManager.getMaxThreadPoolSize() - this.threadPool.size();
        if (Trace.isOn) {
            Trace.traceData(this, "fillThreadPool()", "Creating " + threadsToCreate + " Threads", null);
        }
        if (threadsToCreate > 0) {
            for (int i = 0; i < threadsToCreate; ++i) {
                this.inactiveThreadPool.add(this.createNewThread());
                ++threadsCreated;
            }
        } else {
            threadsCreated = threadsToCreate;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "fillThreadPool()", new Integer(threadsCreated));
        }
        return threadsCreated;
    }

    public int emptyThreadPool() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "emptyThreadPool()");
        }
        ThreadPoolWorker currentThread = null;
        Iterator iterator = this.threadPool.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            currentThread = (ThreadPoolWorker)iterator.next();
            currentThread.closePolitely();
            ++count;
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "emptyThreadPool()", new Integer(count));
        }
        return count;
    }

    public int getCurrentThreadPoolSize() {
        int currentSize = this.threadPool.size();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "getCurrentThreadPoolSize()", "getter", new Integer(currentSize));
        }
        return currentSize;
    }

    public void start() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "start()");
        }
        this.workManagerThread.restart();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "start()");
        }
    }

    public void pause() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "pause()");
        }
        this.workManagerThread.pause();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "pause()");
        }
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "close()");
        }
        this.workManagerThread.close();
        WorkQueueManager.setMaintainThreadPoolSize(false);
        this.emptyThreadPool();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "close()");
        }
    }

    public void end() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "end()");
        }
        this.close();
        while (this.threadPool.size() > 0 || this.workManagerThread.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                if (!Trace.isOn) continue;
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "end()", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "end()");
        }
    }

    private ThreadPoolWorker getWorkerThread() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "getWorkerThread()");
        }
        ThreadPoolWorker thisThread = null;
        thisThread = this.getInactiveWorkerThread();
        if (Trace.isOn && thisThread == null) {
            Trace.traceData(this, "getWorkerThread()", "No inactive thread was available", null);
        }
        int maxPoolSize = WorkQueueManager.getMaxThreadPoolSize();
        if (thisThread == null && (maxPoolSize == -1 || this.threadPool.size() < maxPoolSize)) {
            thisThread = this.createNewThread();
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "getWorkerThread()", thisThread);
        }
        return thisThread;
    }

    private ThreadPoolWorker getInactiveWorkerThread() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "getInactiveWorkerThread()");
        }
        ThreadPoolWorker thisThread = null;
        int inactiveThreadPoolSize = this.inactiveThreadPool.size();
        if (inactiveThreadPoolSize >= 1) {
            thisThread = (ThreadPoolWorker)this.inactiveThreadPool.firstElement();
        } else if (Trace.isOn) {
            Trace.traceData(this, "getInactiveWorkerThread()", "inactiveThreadPoolSize", (Object)(inactiveThreadPoolSize + ""));
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "getInactiveWorkerThread()", thisThread);
        }
        return thisThread;
    }

    private ThreadPoolWorker createNewThread() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "createNewThread()");
        }
        ++this.threadCount;
        String newThreadName = new String(threadPoolWorkerNamePrefix + this.threadCount);
        if (Trace.isOn) {
            Trace.traceData(this, "createNewThread()", "Creating new ThreadPoolWorker", (Object)newThreadName);
        }
        ThreadPoolWorker thisThread = new ThreadPoolWorker(newThreadName, this.poolGroup, this.threadPool, this);
        thisThread.setDaemon(this.useDeamonThreads);
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "createNewThread()", thisThread);
        }
        return thisThread;
    }

    void wakeManagerThread() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "wakeManagerThread()");
        }
        this.workManagerThread.wake();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "wakeManagerThread()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerImplementation", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/workqueue/WorkQueueManagerImplementation.java, jmscc.commonservices.j2se, k701, k701-112-140304  1.27.1.1 09/08/17 08:29:42");
        }
    }

    class ThreadPoolWorker
    extends Thread {
        static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2006, 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/workqueue/WorkQueueManagerImplementation.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.27.1.1 09/08/17 08:29:42";
        private boolean inactive;
        private WorkQueueItem workItem;
        private Object notifier;
        private Vector parentThreadPool;
        private boolean working;
        private WorkQueueManagerImplementation manager;

        public ThreadPoolWorker(String threadName, ThreadGroup poolGroup, Vector threadPool, WorkQueueManagerImplementation parentManager) {
            super(poolGroup, threadName);
            this.inactive = true;
            this.notifier = null;
            this.working = false;
            this.manager = null;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "<init>(String,ThreadGroup,Vector,WorkQueueManagerImplementation)", new Object[]{threadName, poolGroup, threadPool, parentManager});
            }
            this.manager = parentManager;
            this.parentThreadPool = threadPool;
            this.notifier = new Object();
            this.init();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "<init>(String,ThreadGroup,Vector,WorkQueueManagerImplementation)");
            }
        }

        private void init() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "init()");
            }
            this.parentThreadPool.add(this);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "init()");
            }
        }

        private boolean waitForNotification() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "waitForNotification()");
            }
            boolean interrupted = this.waitForNotification(-1L);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "waitForNotification()", interrupted);
            }
            return interrupted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForNotification(long waitTimeout) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "waitForNotification(long)", new Object[]{new Long(waitTimeout)});
            }
            boolean interrupted = false;
            try {
                Object object = this.notifier;
                synchronized (object) {
                    if (!this.inactive) {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "waitForNotification(long)", true, 1);
                        }
                        return true;
                    }
                    if (waitTimeout == 0L) {
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "waitForNotification(long)", false, 2);
                        }
                        return false;
                    }
                    if (waitTimeout == -1L) {
                        this.notifier.wait();
                    } else {
                        this.notifier.wait(waitTimeout);
                    }
                }
            }
            catch (InterruptedException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "waitForNotification(long)", e);
                }
                interrupted = true;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "waitForNotification(long)", interrupted, 3);
            }
            return interrupted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wake() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "wake()");
            }
            Object object = this.notifier;
            synchronized (object) {
                this.inactive = false;
                this.notifier.notifyAll();
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "wake()");
            }
        }

        void closePolitely() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "closePolitely()");
            }
            if (this.inactive) {
                WorkQueueManagerImplementation.this.inactiveThreadPool.remove(this);
            }
            this.working = false;
            this.wake();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "closePolitely()");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWorkQueueItem(WorkQueueItem newItem) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "setWorkQueueItem(final WorkQueueItem)", new Object[]{newItem});
            }
            if (this.workItem == null) {
                if (Trace.isOn) {
                    Trace.traceData(this, "setWorkQueueItem(WorkQueueItem)", "Synchronizing on notifier", null);
                }
                Object object = this.notifier;
                synchronized (object) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "setWorkQueueItem(WorkQueueItem)", "Synchronized", null);
                    }
                    this.workItem = newItem;
                    this.inactive = false;
                    AccessController.doPrivileged(new PrivilegedAction(this, newItem){
                        private final /* synthetic */ WorkQueueItem val$newItem;
                        private final /* synthetic */ ThreadPoolWorker this$1;
                        {
                            this.this$1 = this$1;
                            this.val$newItem = val$newItem;
                        }

                        public Object run() {
                            if (Trace.isOn) {
                                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "run()");
                            }
                            this.this$1.setContextClassLoader(this.val$newItem.getClass().getClassLoader());
                            if (Trace.isOn) {
                                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.null", "run()", null);
                            }
                            return null;
                        }
                    });
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "setWorkQueueItem(final WorkQueueItem)");
            }
        }

        public void start() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "start()");
            }
            if (!this.working) {
                if (Trace.isOn) {
                    Trace.traceData(this, "start()", "not in working state, starting", null);
                }
                this.working = true;
                super.start();
            } else {
                if (Trace.isOn) {
                    Trace.traceData(this, "start()", "already in working state, waking", null);
                }
                this.wake();
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "start()");
            }
        }

        public void run() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "run()");
            }
            long timeout = WorkQueueManager.getPoolInactiveTimeout();
            while (this.working) {
                this.inactive = false;
                if (this.workItem != null) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "run()", "running WorkQueueItem...", (Object)this.workItem);
                    }
                    WorkQueueManager.runWorkQueueItem(this.workItem);
                }
                if (!this.working) {
                    if (Trace.isOn) {
                        Trace.data(this, "run()", "Asked to close while working", null);
                    }
                    this.workItem = null;
                    if (Trace.isOn) {
                        Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "run()", 1);
                    }
                    return;
                }
                if (WorkQueueManagerImplementation.this.threadPool.size() <= WorkQueueManager.getMaxThreadPoolSize() || !WorkQueueManagerImplementation.this.highPriorityWorkQueue.isEmpty()) {
                    if (Trace.isOn) {
                        Trace.data(this, "run()", "Returning thread to inactive pool", null);
                    }
                    this.workItem = null;
                    this.inactive = true;
                    if (timeout != 0L) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "run()", "returning thread to pool", null);
                        }
                        WorkQueueManagerImplementation.this.inactiveThreadPool.add(this);
                        if (Trace.isOn) {
                            Trace.traceData(this, "run()", "Waking managerThread", null);
                        }
                        this.manager.wakeManagerThread();
                    }
                    if (WorkQueueManager.getMaintainThreadPoolSize()) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "run()", "Maintaining pool size. Waiting indefinitely for notification", null);
                        }
                        this.waitForNotification();
                        continue;
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "run()", "Waiting for interrupt or timeout", null);
                    }
                    if (timeout != 0L && this.waitForNotification(WorkQueueManager.getPoolInactiveTimeout())) continue;
                    if (Trace.isOn) {
                        Trace.traceData(this, "run()", "Timed out in pool, closing thread", null);
                    }
                    WorkQueueManagerImplementation.this.inactiveThreadPool.remove(this);
                    if (this.workItem != null) continue;
                    this.parentThreadPool.remove(this);
                    this.working = false;
                    continue;
                }
                this.workItem = null;
                this.working = false;
            }
            if (Trace.isOn) {
                Trace.traceData(this, "run()", "Removing thread from pool", null);
            }
            this.parentThreadPool.remove(this);
            if (Trace.isOn) {
                Trace.traceData(this, "run()", "waking managerThread", null);
            }
            this.manager.wakeManagerThread();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "run()", 2);
            }
        }

        public boolean isInactive() {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.commonservices.j2se.workqueue.ThreadPoolWorker", "isInactive()", "getter", this.inactive);
            }
            return this.inactive;
        }
    }

    private class WorkQueueManagerThread
    extends Thread {
        static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2006, 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/workqueue/WorkQueueManagerImplementation.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.27.1.1 09/08/17 08:29:42";
        private static final int STATE_RUNNING = 1;
        private static final int STATE_PAUSED = 2;
        private static final int STATE_ENDING = 3;
        private int state;
        private final Object threadNotifierLock;
        private boolean workWaiting;

        public WorkQueueManagerThread(String name) {
            super(name);
            this.state = 1;
            this.threadNotifierLock = new Object();
            this.workWaiting = false;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "<init>(String)", new Object[]{name});
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "<init>(String)");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setWorkWaiting() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "setWorkWaiting()");
            }
            Object object = this.threadNotifierLock;
            synchronized (object) {
                this.workWaiting = true;
                this.wake();
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "setWorkWaiting()");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wake() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "wake()");
            }
            Object object = this.threadNotifierLock;
            synchronized (object) {
                if (Trace.isOn) {
                    Trace.traceData(this, "wake()", "Notifying threadNotifierLock", null);
                }
                this.threadNotifierLock.notify();
                if (Trace.isOn) {
                    Trace.traceData(this, "wake()", "threadNotifierLock notified", null);
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "wake()");
            }
        }

        private boolean waitForNotification() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "waitForNotification()");
            }
            boolean interrupted = this.waitForNotification(-1L);
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "waitForNotification()", interrupted);
            }
            return interrupted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForNotification(long waitTimeout) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "waitForNotification(long)", new Object[]{new Long(waitTimeout)});
            }
            boolean interrupted = false;
            try {
                if (Trace.isOn) {
                    Trace.traceData(this, "waitForNotification(long)", "synchronizing on threadNotifierLock", null);
                }
                Object object = this.threadNotifierLock;
                synchronized (object) {
                    if (!this.workWaiting) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "waitForNotification(long)", "workWaiting=false. Waiting for " + waitTimeout, null);
                        }
                        if (waitTimeout == -1L) {
                            this.threadNotifierLock.wait();
                        } else {
                            this.threadNotifierLock.wait(waitTimeout);
                        }
                    }
                }
                object = this.threadNotifierLock;
                synchronized (object) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "waitForNotification(long)", "setting workWaiting=false.", null);
                    }
                    this.workWaiting = false;
                }
            }
            catch (InterruptedException e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "waitForNotification(long)", e);
                }
                interrupted = true;
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "waitForNotification(long)", interrupted);
            }
            return interrupted;
        }

        public void close() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "close()");
            }
            this.state = 3;
            this.wake();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "close()");
            }
        }

        public void pause() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "pause()");
            }
            this.state = 2;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "pause()");
            }
        }

        public void restart() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "restart()");
            }
            this.state = 1;
            this.wake();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "restart()");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "run()");
            }
            ThreadPoolWorker newThread = null;
            WorkQueueItem currentItem = null;
            if (Trace.isOn) {
                Trace.traceData(this, "run()", "Current state", (Object)new Integer(this.state));
            }
            while (this.state != 3) {
                if (Trace.isOn) {
                    Trace.traceData(this, "run()", "Synchronizing on threadNotifierLock", this.threadNotifierLock);
                }
                Object object = this.threadNotifierLock;
                synchronized (object) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "run()", "Got sync lock", this.threadNotifierLock);
                    }
                    if (this.state == 2) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "in pause state. Pausing", null);
                        }
                        this.waitForNotification();
                    }
                }
                if (!WorkQueueManagerImplementation.this.highPriorityWorkQueue.isEmpty()) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "run()", "", null);
                    }
                    object = WorkQueueManagerImplementation.this.highPriorityWorkQueue;
                    synchronized (object) {
                        currentItem = (WorkQueueItem)WorkQueueManagerImplementation.this.highPriorityWorkQueue.removeFirst();
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "run()", "getting worker Thread from pool", null);
                    }
                    if ((newThread = WorkQueueManagerImplementation.this.getWorkerThread()) == null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "run()", "Thread was null, creating new Worker Thread", null);
                        }
                        newThread = WorkQueueManagerImplementation.this.createNewThread();
                    }
                    if (Trace.isOn) {
                        Trace.traceData(this, "run()", "Setting work item", null);
                    }
                    newThread.setWorkQueueItem(currentItem);
                    if (Trace.isOn) {
                        Trace.traceData(this, "run()", "Starting new Thread", (Object)newThread);
                    }
                    newThread.start();
                    if (Trace.isOn) {
                        Trace.traceData(this, "run()", "Setting newThread reference to null", null);
                    }
                    newThread = null;
                    continue;
                }
                if (Trace.isOn) {
                    Trace.traceData(this, "run()", "No high priority work to do", null);
                }
                boolean proceedable = true;
                if (!WorkQueueManagerImplementation.this.workQueue.isEmpty()) {
                    if (Trace.isOn) {
                        Trace.traceData(this, "run()", "Normal priority Work on work queue. Getting workerThread", null);
                    }
                    if ((newThread = WorkQueueManagerImplementation.this.getWorkerThread()) != null) {
                        if (Trace.isOn) {
                            Trace.traceData(this, "run()", "Got thread. Synchronizing", null);
                        }
                        LinkedList linkedList = WorkQueueManagerImplementation.this.workQueue;
                        synchronized (linkedList) {
                            if (Trace.isOn) {
                                Trace.traceData(this, "run()", "Getting item from queue", null);
                            }
                            currentItem = (WorkQueueItem)WorkQueueManagerImplementation.this.workQueue.removeFirst();
                            if (Trace.isOn) {
                                Trace.traceData(this, "run()", "Got workQueueItem", (Object)currentItem);
                            }
                        }
                        if (Trace.isOn) {
                            Trace.traceData(this, "run()", "Setting item in thread", null);
                        }
                        newThread.setWorkQueueItem(currentItem);
                        if (Trace.isOn) {
                            Trace.traceData(this, "run()", "Sterting workerThread", null);
                        }
                        newThread.start();
                        newThread = null;
                        proceedable = true;
                    } else {
                        proceedable = false;
                    }
                } else {
                    proceedable = false;
                }
                if (proceedable) continue;
                if (Trace.isOn) {
                    Trace.traceData(this, "run()", "No work to be done. Waiting for further notification", null);
                }
                this.waitForNotification();
                if (newThread == null || newThread.inactive) continue;
                if (Trace.isOn) {
                    Trace.traceData(this, "run()", "newThread is " + (newThread == null ? "null" : " inactive") + " setting thread to null.", null);
                }
                newThread = null;
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.workqueue.WorkQueueManagerThread", "run()");
            }
        }
    }
}

