/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.trace;

import com.ibm.msg.client.commonservices.trace.FlightRecorder;
import java.util.HashMap;

public class TraceUtils {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/trace/TraceUtils.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.14.1.1 09/08/17 08:23:32";
    private static TraceUtils utils = null;
    HashMap objectAdapters = new HashMap();
    ObjectFormatAdapter genericAdapter;

    private TraceUtils() {
        this.objectAdapters.put([B.class, new ByteArrayFormatAdapter());
        this.genericAdapter = new GenericFormatAdapter();
    }

    public static StringBuffer formatObject(Object input) {
        return TraceUtils.formatObject(input, -1);
    }

    public static StringBuffer formatObject(Object input, int maxLength) {
        ObjectFormatAdapter adapter = (ObjectFormatAdapter)TraceUtils.utils.objectAdapters.get(input.getClass());
        if (adapter == null) {
            adapter = TraceUtils.utils.genericAdapter;
        }
        return adapter.formatObject(input, maxLength);
    }

    public static StringBuffer formatObjectDetailed(Object input) {
        return TraceUtils.formatObjectDetailed(input, -1);
    }

    public static StringBuffer formatObjectDetailed(Object input, int maxLength) {
        ObjectFormatAdapter adapter = (ObjectFormatAdapter)TraceUtils.utils.objectAdapters.get(input.getClass());
        if (adapter == null) {
            adapter = TraceUtils.utils.genericAdapter;
        }
        return adapter.formatObjectDetailed(input, maxLength);
    }

    static StringBuffer bytesToHex(byte[] bArray, int maxLength) {
        StringBuffer hex = new StringBuffer();
        if (bArray == null) {
            hex.append("<null>");
            return hex;
        }
        int dumpLength = bArray.length;
        if (maxLength != -1 && maxLength < dumpLength) {
            dumpLength = maxLength;
        }
        for (int i = 0; i < dumpLength; ++i) {
            int binByte = bArray[i];
            if (binByte < 0) {
                binByte += 256;
            }
            if (binByte < 16) {
                hex.append('0');
            }
            hex.append(Integer.toHexString(binByte).toUpperCase());
        }
        return hex;
    }

    static StringBuffer bytesToHex(byte[] bArray) {
        return TraceUtils.bytesToHex(bArray, -1);
    }

    public static byte[] hexToBytes(String hex) throws Exception {
        byte[] out = null;
        if (hex != null) {
            int len = hex.length();
            if (len % 2 != 0) {
                throw new Exception("Invalid Hex String");
            }
            out = new byte[len /= 2];
            for (int i = 0; i < len; ++i) {
                int digit1 = Character.digit(hex.charAt(2 * i), 16);
                int digit2 = Character.digit(hex.charAt(2 * i + 1), 16);
                if (digit1 == -1 || digit2 == -1) {
                    throw new Exception("Invalid Hex String");
                }
                out[i] = (byte)(digit1 * 16 + digit2);
            }
        }
        return out;
    }

    static boolean byteArraysEqual(byte[] a, byte[] b) {
        boolean result;
        if (a == b) {
            result = true;
        } else if (a.length != b.length) {
            result = false;
        } else {
            result = true;
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (a[i] == b[i]) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected static StringBuffer getFormattedHexBytes(byte[] toDump, int maxLength) {
        StringBuffer buffer = new StringBuffer();
        if (maxLength == 0) {
            return buffer;
        }
        int dumpLength = toDump.length;
        if (maxLength != -1 && maxLength < dumpLength) {
            dumpLength = maxLength;
        }
        for (int lineStart = 0; lineStart < dumpLength; lineStart += 16) {
            int lineEnd = Math.min(lineStart + 16, dumpLength);
            StringBuffer hex = new StringBuffer();
            StringBuffer ascii = new StringBuffer();
            for (int i = lineStart; i < lineEnd; ++i) {
                int b = toDump[i];
                b = (b + 256) % 256;
                int c1 = b / 16;
                int c2 = b % 16;
                hex.append((char)(c1 < 10 ? 48 + c1 : 97 + c1 - 10));
                hex.append((char)(c2 < 10 ? 48 + c2 : 97 + c2 - 10));
                if (i % 2 == 1) {
                    hex.append(' ');
                }
                if (b >= 32 && b <= 126) {
                    ascii.append((char)b);
                    continue;
                }
                ascii.append('.');
            }
            int pad = 16 - (lineEnd - lineStart);
            int spaces = (pad * 5 + pad % 2) / 2;
            spaces += 3;
            for (int i = 0; i < spaces; ++i) {
                hex.append(' ');
            }
            String offset = "0000" + Integer.toHexString(lineStart);
            offset = offset.substring(offset.length() - 4);
            buffer.append(offset);
            buffer.append(":  ");
            buffer.append(hex.toString());
            buffer.append(ascii.toString());
            buffer.append('\n');
        }
        return buffer;
    }

    public static String foldPackageName(String qualifiedClassName) {
        StringBuffer result;
        FlightRecorder.entry("TraceUtils.foldPackageName: " + qualifiedClassName);
        if (qualifiedClassName == null) {
            return "<Unknown>";
        }
        String[] elements = qualifiedClassName.split("\\.");
        if (elements.length > 3) {
            result = new StringBuffer(64);
            int idx = 0;
            for (idx = 0; idx < elements.length; ++idx) {
                if (0 != idx) {
                    result.append(".");
                }
                if (idx < elements.length - 3) {
                    result.append(elements[idx].charAt(0));
                    continue;
                }
                result.append(elements[idx]);
            }
        } else {
            result = new StringBuffer(qualifiedClassName);
        }
        FlightRecorder.exit("TraceUtils.foldPackageName");
        return result.toString();
    }

    public static String objectToString(Object obj, String parentClassName) {
        StringBuffer result;
        if (obj == null) {
            return parentClassName;
        }
        String objectClassName = obj.getClass().getName();
        String[] elements = objectClassName.split("\\.");
        if (elements.length > 3) {
            result = new StringBuffer(64);
            int idx = 0;
            for (idx = 0; idx < elements.length; ++idx) {
                if (0 != idx) {
                    result.append(".");
                }
                if (idx < elements.length - 3) {
                    result.append(elements[idx].charAt(0));
                    continue;
                }
                result.append(elements[idx]);
            }
        } else {
            result = new StringBuffer(objectClassName);
        }
        if (null != parentClassName && !result.toString().equals(parentClassName) && objectClassName.indexOf(36) == -1) {
            int pIndex = parentClassName.lastIndexOf(".");
            result.append("(");
            result.append(parentClassName.substring(pIndex + 1));
            result.append(")");
        }
        result.append("@");
        result.append(Integer.toHexString(System.identityHashCode(obj)));
        return result.toString();
    }

    static {
        utils = new TraceUtils();
    }

    class ByteArrayFormatAdapter
    extends ObjectFormatAdapter {
        ByteArrayFormatAdapter() {
        }

        StringBuffer formatObject(Object input, int maxLength) throws ClassCastException {
            byte[] bytes = (byte[])input;
            StringBuffer output = TraceUtils.bytesToHex(bytes, maxLength);
            return output;
        }

        StringBuffer formatObjectDetailed(Object input, int maxLength) throws ClassCastException {
            byte[] bytes = (byte[])input;
            StringBuffer output = TraceUtils.getFormattedHexBytes(bytes, maxLength);
            return output;
        }
    }

    class GenericFormatAdapter
    extends ObjectFormatAdapter {
        GenericFormatAdapter() {
        }

        StringBuffer formatObject(Object input, int maxLength) throws ClassCastException {
            StringBuffer output = new StringBuffer();
            if (maxLength == 0) {
                return output;
            }
            output.append(input.toString());
            if (maxLength < 0 || output.length() <= maxLength) {
                return output;
            }
            String fullOutput = output.toString();
            fullOutput = ((Object)fullOutput.subSequence(0, maxLength - 1)).toString();
            output = new StringBuffer(fullOutput);
            return output;
        }
    }

    abstract class ObjectFormatAdapter {
        ObjectFormatAdapter() {
        }

        abstract StringBuffer formatObject(Object var1, int var2) throws ClassCastException;

        StringBuffer formatObjectDetailed(Object input, int maxLength) throws ClassCastException {
            return this.formatObject(input, maxLength);
        }
    }
}

