/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.trace;

import com.ibm.msg.client.commonservices.j2se.trace.PackageNode;
import java.util.StringTokenizer;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TraceFilter
implements Filter {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/trace/TraceFilter.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.11.2.1 09/08/17 08:22:46";
    private boolean stringMatching = false;
    private Pattern searchStringPattern = null;
    private boolean packageMatching = false;
    private PackageNode packageTree = null;
    private static final String openBracket = "(";
    private static final String point = ".";

    public TraceFilter() {
    }

    public TraceFilter(PackageNode packageTree) {
        this.initialize(packageTree, null);
    }

    public TraceFilter(String searchString) {
        this.initialize(null, searchString);
    }

    public TraceFilter(PackageNode packageTree, String searchString) {
        this.initialize(packageTree, searchString);
    }

    private void initialize(PackageNode packageTree, String searchString) {
        this.setPackageTree(packageTree);
        this.setSearchString(searchString);
    }

    public void setSearchString(String searchString) {
        if (null != searchString) {
            this.searchStringPattern = Pattern.compile(searchString);
        }
        this.stringMatching = null != searchString;
    }

    public void setPackageTree(PackageNode packageTree) {
        this.packageTree = packageTree;
        this.packageMatching = null != packageTree;
    }

    public boolean isLoggable(LogRecord record) {
        String className;
        String packageName;
        if (this.packageMatching && !this.isPackageIncluded(packageName = this.getPackage(record.getSourceClassName()))) {
            return false;
        }
        if (this.stringMatching && (className = record.getSourceClassName()) != null) {
            StringBuffer match = new StringBuffer(className);
            match.append(point).append(record.getSourceMethodName());
            Matcher matcher = this.searchStringPattern.matcher(match.toString());
            if (matcher.matches()) {
                return false;
            }
        }
        return true;
    }

    private boolean isPackageIncluded(String packageName) {
        StringTokenizer packages = new StringTokenizer(packageName, point, false);
        if (packages == null || !packages.hasMoreTokens()) {
            return true;
        }
        String nextName = null;
        PackageNode currentNode = this.packageTree;
        PackageNode nextNode = null;
        while (packages.hasMoreTokens()) {
            nextName = packages.nextToken();
            nextNode = currentNode.getChild(nextName);
            if (null == nextNode) {
                nextNode = currentNode.getChild("*");
                if (null != nextNode) break;
                nextNode = currentNode;
                break;
            }
            currentNode = nextNode;
        }
        boolean traceRet1 = nextNode.isIncluded();
        return traceRet1;
    }

    private String getPackage(String className) {
        if (className == null) {
            return "";
        }
        int bracket = className.indexOf(openBracket);
        StringBuffer result = null;
        result = bracket == -1 ? new StringBuffer(className) : new StringBuffer(className.substring(0, bracket));
        int lastPoint = result.lastIndexOf(point);
        if (lastPoint == -1) {
            return result.toString();
        }
        return result.substring(0, lastPoint);
    }

    public PackageNode addPackageListToTree(PackageNode treeRoot, String packageList, boolean included) {
        if (null == treeRoot) {
            treeRoot = new PackageNode(null);
        }
        if (null == packageList) {
            return treeRoot;
        }
        if (packageList.equals("NONE")) {
            treeRoot.setIncluded(!included);
            return treeRoot;
        }
        if (packageList.equals("ALL")) {
            treeRoot.setIncluded(included);
            return treeRoot;
        }
        StringTokenizer tokens = new StringTokenizer(packageList, ";");
        String thisPackage = null;
        while (tokens.hasMoreTokens()) {
            thisPackage = tokens.nextToken();
            treeRoot.addPackage(thisPackage, included);
        }
        return treeRoot;
    }
}

