/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.trace;

import com.ibm.msg.client.commonservices.j2se.trace.DefaultTracer;
import com.ibm.msg.client.commonservices.j2se.trace.TraceUtils;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.trace.TraceFormatter;
import com.ibm.msg.client.commonservices.trace.TraceHandler;
import com.ibm.msg.client.commonservices.trace.TraceRecord;
import java.util.HashMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleFormatter
extends Formatter
implements TraceFormatter {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/trace/SimpleFormatter.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.12.2.1 09/08/17 08:22:35";
    static HashMap messageFormatAdapters;
    public static final String entryTag = "==>";
    public static final String exitTag = "<==";
    public static final String throwTag = "thr";
    public static final String catchTag = "cat";
    public static final String finallyTag = "fin";
    public static final String dataTag = "dat";
    int maxTraceBytes = -1;

    public SimpleFormatter() {
        if (messageFormatAdapters == null) {
            messageFormatAdapters = new HashMap();
            messageFormatAdapters.put("CATCH_BLOCK", new CatchFormatAdapter());
            messageFormatAdapters.put("TRACE_DATA", new DataFormatAdapter());
            messageFormatAdapters.put("METHOD_ENTRY", new EntryFormatAdapter());
            messageFormatAdapters.put("METHOD_EXIT", new ExitFormatAdapter());
            messageFormatAdapters.put("FINALLY_BLOCK", new FinallyFormatAdapter());
            messageFormatAdapters.put("THROWING", new ThrowFormatAdapter());
        }
        try {
            DefaultTracer cfr_ignored_0 = (DefaultTracer)Trace.getCSPTrace();
            this.maxTraceBytes = DefaultTracer.getMaxTraceBytes();
        }
        catch (ClassCastException cce) {
            this.maxTraceBytes = -1;
        }
    }

    public String format(LogRecord record) {
        StringBuffer output = new StringBuffer(256);
        MessageFormatAdapter adapter = (MessageFormatAdapter)messageFormatAdapters.get(record.getMessage());
        if (adapter == null) {
            adapter = (MessageFormatAdapter)messageFormatAdapters.get("TRACE_DATA");
        }
        try {
            adapter.doFormatMessage(record, output);
        }
        catch (Throwable t) {
            output.append("\n");
            output.append(" *** Problem occurred formatting trace line: ");
            try {
                output.append(t);
            }
            catch (Throwable t2) {
                output.append(" Could not retrieve message from Throwable");
            }
            output.append(" ***\n");
        }
        String traceRet1 = output.toString();
        return traceRet1;
    }

    public String format(TraceRecord record) {
        return null;
    }

    public String getHead(TraceHandler h) {
        return null;
    }

    public String getTail(TraceHandler h) {
        return null;
    }

    class DataFormatAdapter
    extends MessageFormatAdapter {
        DataFormatAdapter() {
        }

        void doFormatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            buffer.append(SimpleFormatter.dataTag);
            buffer.append('#');
            buffer.append(record.getMessage().length());
            buffer.append('#');
            buffer.append(record.getMessage());
            Object[] parameters = record.getParameters();
            if (parameters != null) {
                Object parameter = null;
                StringBuffer value = null;
                int length = 0;
                for (int i = 0; i < parameters.length; ++i) {
                    parameter = parameters[i];
                    if (parameter == null) continue;
                    value = TraceUtils.formatObject(parameter, SimpleFormatter.this.maxTraceBytes);
                    length = value.length();
                    buffer.append('#');
                    buffer.append(length);
                    buffer.append('#');
                    buffer.append(value);
                }
            }
            buffer.append("##\n");
        }
    }

    class FinallyFormatAdapter
    extends MessageFormatAdapter {
        FinallyFormatAdapter() {
        }

        void doFormatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            buffer.append(SimpleFormatter.finallyTag);
            buffer.append('#');
            buffer.append(record.getSourceMethodName());
            buffer.append("##\n");
        }
    }

    class CatchFormatAdapter
    extends MessageFormatAdapter {
        CatchFormatAdapter() {
        }

        void doFormatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            buffer.append(SimpleFormatter.catchTag);
            buffer.append('#');
            buffer.append(record.getSourceMethodName());
            buffer.append('#');
            Throwable thrown = record.getThrown();
            if (thrown == null) {
                thrown = new Throwable("Unknown Throwable");
            }
            buffer.append(thrown.getClass().getName());
            buffer.append('#');
            buffer.append(thrown.getMessage());
            buffer.append("##\n");
        }
    }

    class ThrowFormatAdapter
    extends MessageFormatAdapter {
        ThrowFormatAdapter() {
        }

        void doFormatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            buffer.append(SimpleFormatter.throwTag);
            buffer.append('#');
            buffer.append(record.getSourceMethodName());
            buffer.append('#');
            Throwable thrown = record.getThrown();
            buffer.append(thrown.getClass().getName());
            buffer.append('#');
            buffer.append(thrown.getMessage());
            this.appendStackTrace(thrown, buffer);
            for (Throwable cause = thrown.getCause(); cause != null; cause = cause.getCause()) {
                buffer.append("#cause#");
                buffer.append(cause.getClass().getName());
                buffer.append('#');
                buffer.append(thrown.getMessage());
                this.appendStackTrace(cause, buffer);
            }
            buffer.append("##\n");
        }

        void appendStackTrace(Throwable t, StringBuffer buffer) {
            StackTraceElement[] stack = t.getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                buffer.append('#');
                buffer.append(stack[i]);
            }
        }
    }

    class ExitFormatAdapter
    extends MessageFormatAdapter {
        ExitFormatAdapter() {
        }

        void doFormatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            buffer.append(SimpleFormatter.exitTag);
            buffer.append('#');
            buffer.append(record.getSourceMethodName());
            Object[] parameters = record.getParameters();
            if (parameters != null && parameters[0] != null) {
                Object parameter = parameters[0];
                StringBuffer value = TraceUtils.formatObject(parameter, SimpleFormatter.this.maxTraceBytes);
                int length = value.length();
                buffer.append('#');
                buffer.append(length);
                buffer.append('#');
                buffer.append(parameter.getClass().getName());
                buffer.append('#');
                buffer.append(value);
            }
            buffer.append("##\n");
        }
    }

    class EntryFormatAdapter
    extends MessageFormatAdapter {
        EntryFormatAdapter() {
        }

        void doFormatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            buffer.append(SimpleFormatter.entryTag);
            buffer.append('#');
            buffer.append(record.getSourceMethodName());
            Object[] parameters = record.getParameters();
            if (parameters != null) {
                Object parameter = null;
                StringBuffer value = null;
                for (int i = 0; i < parameters.length; ++i) {
                    parameter = parameters[i];
                    if (parameter == null) continue;
                    value = TraceUtils.formatObject(parameter, SimpleFormatter.this.maxTraceBytes);
                    int length = value.length();
                    buffer.append('#');
                    buffer.append(length);
                    buffer.append('#');
                    buffer.append(parameter.getClass().getPackage().getName());
                    buffer.append('.');
                    buffer.append(parameter.getClass().getName());
                    buffer.append('#');
                    buffer.append(value);
                }
            }
            buffer.append("##\n");
        }
    }

    abstract class MessageFormatAdapter {
        MessageFormatAdapter() {
        }

        abstract void doFormatMessage(LogRecord var1, StringBuffer var2);

        void appendBaseMessage(LogRecord record, StringBuffer buffer) {
            buffer.append(record.getMillis());
            buffer.append('#');
            buffer.append(Thread.currentThread().getName());
            buffer.append('#');
            buffer.append(TraceUtils.foldPackageName(record.getSourceClassName()));
            buffer.append('#');
        }
    }
}

