/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.trace;

import com.ibm.msg.client.commonservices.j2se.trace.DefaultFormatter;
import com.ibm.msg.client.commonservices.provider.trace.CSPTrace;
import com.ibm.msg.client.commonservices.trace.TraceFormatter;
import com.ibm.msg.client.commonservices.trace.TraceHandler;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import java.util.logging.StreamHandler;

public class MinimalTracer
implements CSPTrace {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/trace/MinimalTracer.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.10.2.1 09/08/17 08:22:15";
    private Logger logger;
    private LogManager manager = LogManager.getLogManager();
    private MemoryHandler memHandler;
    private OutputStream outputStream;
    private String parentClassName;
    private StreamHandler sHandler;

    public MinimalTracer() {
        this.logger = Logger.getLogger("com.ibm.msg.client.commonservices.j2se.MinimalTracer");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MinimalTracer.this.logger.setLevel(Level.ALL);
                return null;
            }
        });
        this.outputStream = new ByteArrayOutputStream();
        this.sHandler = new StreamHandler(this.outputStream, new DefaultFormatter());
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MinimalTracer.this.sHandler.setLevel(Level.ALL);
                return null;
            }
        });
        this.memHandler = new MemoryHandler(this.sHandler, 20, Level.SEVERE);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MinimalTracer.this.logger.addHandler(MinimalTracer.this.memHandler);
                return null;
            }
        });
    }

    public void catchBlock(int level, Object parentClass, String parentClassName2, String methodSignature, Throwable thrown, int exitIndex) {
        this.parentClassName = parentClass instanceof String ? (String)parentClass : parentClass.getClass().getPackage().getName() + '.' + parentClass.getClass().getName();
        this.logger.logp(Level.FINE, this.parentClassName, exitIndex == -1 ? methodSignature : methodSignature + "<exitIndex " + exitIndex + ">", "CATCH_BLOCK", thrown);
    }

    public void close() {
        this.manager.reset();
    }

    public void dumpFFSTTrace(String outputFileName) {
        this.memHandler.push();
        this.sHandler.flush();
        byte[] bytes = ((ByteArrayOutputStream)this.outputStream).toByteArray();
        try {
            FileOutputStream fOut = new FileOutputStream(outputFileName, true);
            try {
                fOut.write(bytes);
                fOut.close();
            }
            catch (IOException ioe) {
                System.err.print("\nCould not write to file. ");
                throw ioe;
            }
        }
        catch (Exception e) {
            System.err.println("Could not write data to " + outputFileName);
            System.err.println("Writing data to System.err instead:");
            System.err.println(new String(bytes));
        }
    }

    public void finallyBlock(int level, Object parentClass, String parentClassName2, String methodSignature, int exitIndex) {
        this.parentClassName = parentClass instanceof String ? (String)parentClass : parentClass.getClass().getPackage().getName() + '.' + parentClass.getClass().getName();
        this.logger.logp(Level.FINE, this.parentClassName, exitIndex == -1 ? methodSignature : methodSignature + "<exitIndex " + exitIndex + ">", "FINALLY_BLOCK");
    }

    public void initialize() {
    }

    public void methodEntry(int level, Object parentClass, String parentClassName2, String methodSignature, Object[] parameters) {
        this.parentClassName = parentClass instanceof String ? (String)parentClass : parentClass.getClass().getPackage().getName() + '.' + parentClass.getClass().getName();
        this.logger.logp(Level.FINE, this.parentClassName, methodSignature, "METHOD_ENTRY");
    }

    public void methodExit(int level, Object parentClass, String parentClassName2, String methodSignature, Object returnValue, int exitIndex) {
        this.parentClassName = parentClass instanceof String ? (String)parentClass : parentClass.getClass().getPackage().getName() + '.' + parentClass.getClass().getName();
        this.logger.logp(Level.FINE, this.parentClassName, exitIndex == -1 ? methodSignature : methodSignature + "<exitIndex " + exitIndex + ">", "METHOD_EXIT");
    }

    public void setTraceFormatter(TraceFormatter newFormatter) {
    }

    public void setTraceHandler(TraceHandler newHandler) {
    }

    public void throwing(int level, Object parentClass, String parentClassName2, String methodSignature, Throwable thrown, int exitIndex) {
        this.parentClassName = parentClass instanceof String ? (String)parentClass : parentClass.getClass().getPackage().getName() + '.' + parentClass.getClass().getName();
        this.logger.logp(Level.FINE, this.parentClassName, exitIndex == -1 ? methodSignature : methodSignature + "<exitIndex " + exitIndex + ">", "THROWING");
    }

    public void traceData(int level, Object parentClass, String parentClassName2, String methodSignature, String uniqueDescription, Object data) {
    }

    public String ffst(Object sourceClass, String methodSignature, String probeID, HashMap data, String header) {
        return null;
    }

    public int getTraceLevel() {
        return Integer.MAX_VALUE;
    }

    public void setTraceLevel(int traceLevel) {
    }
}

