/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.trace;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.jar.JarOutputStream;
import java.util.logging.FileHandler;
import java.util.zip.ZipEntry;

public class JarFileHandler
extends FileHandler {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/trace/JarFileHandler.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.12.2.1 09/08/17 08:22:03";
    private static int compLevel = 5;
    static String jarComment;
    private static String traceFileName;
    private static String traceFileExtension;
    private static String tracepid;
    private static int traceFileCount;
    BufferedOutputStream buffer;
    JarOutputStream jarStream;

    public static void setPID(String pid) {
        tracepid = pid;
    }

    public JarFileHandler() throws IOException, SecurityException {
    }

    public JarFileHandler(String pattern) throws IOException, SecurityException {
        super(pattern);
        traceFileName = pattern;
    }

    public JarFileHandler(String pattern, boolean append) throws IOException, SecurityException {
        super(pattern, append);
        traceFileName = pattern;
    }

    public JarFileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        super(pattern, limit, count);
        traceFileName = pattern;
    }

    public JarFileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        super(pattern, limit, count, append);
        traceFileName = pattern;
    }

    public synchronized void close() throws SecurityException {
        super.close();
        if (null != this.buffer) {
            try {
                this.buffer.flush();
                this.buffer.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (null != this.jarStream) {
            try {
                this.jarStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private String getNextTraceFileName() {
        String newName = traceFileName + traceFileCount + "_" + tracepid + traceFileExtension;
        ++traceFileCount;
        return newName;
    }

    protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
        try {
            this.jarStream = new JarOutputStream(out);
            this.jarStream.setComment(jarComment);
            this.jarStream.setLevel(compLevel);
            this.jarStream.putNextEntry(new ZipEntry(this.getNextTraceFileName()));
            this.buffer = new BufferedOutputStream(this.jarStream);
            super.setOutputStream(this.buffer);
        }
        catch (IOException e) {
            super.setOutputStream(out);
        }
    }

    private void setupExitHook() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Runtime.getRuntime().addShutdownHook(new Thread(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            1.access$000(this.this$1).close();
                        }
                    });
                }
                catch (RuntimeException e) {
                    System.err.println("J2SE Common Services unable to add JVM shutdown hook; compressed trace file may not be closed properly. ");
                    e.printStackTrace(System.err);
                }
                return null;
            }

            static /* synthetic */ JarFileHandler access$000(1 x0) {
                return x0.JarFileHandler.this;
            }
        });
    }

    static {
        traceFileCount = 0;
        traceFileName = "mqjms";
        traceFileExtension = ".trc";
        StringBuffer buffer = new StringBuffer();
        buffer.append("IBM JMS Common Client Service Information file\n");
        buffer.append("This archive will contain a number of files containing trace:\n");
        buffer.append(" - Trace information will be contained in the files " + traceFileName + "*" + traceFileExtension + '\n');
        jarComment = buffer.toString();
    }
}

