/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.trace;

import com.ibm.msg.client.commonservices.j2se.trace.DefaultTracer;
import com.ibm.msg.client.commonservices.j2se.trace.TraceUtils;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.FlightRecorder;
import com.ibm.msg.client.commonservices.trace.TableBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.trace.TraceFormatter;
import com.ibm.msg.client.commonservices.trace.TraceHandler;
import com.ibm.msg.client.commonservices.trace.TraceRecord;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class HumanFormatter
extends Formatter
implements TraceFormatter {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/trace/HumanFormatter.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.37.1.4 11/02/10 14:23:04";
    private static final char[] base36chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final Calendar calendar = new GregorianCalendar();
    private static final String spacesBetweenColumns = "  ";
    private static final Integer ONE = new Integer(1);
    private static final Integer ZERO = new Integer(0);
    private static String lineSeparator;
    private boolean firstRecord = true;
    private HashMap messageFormatAdapters;
    private int maxTraceBytes = -1;
    private FastHashMap cachedClassNames = null;
    private int cachedHour;
    private String cachedHourMinuteSecond = null;
    private int cachedMilliSecond;
    private int cachedMinute;
    private int cachedSecond;
    private int subMilliSecsCounter = 0;
    private int tid = 0;
    private String cachedMultiLinePrimitive = null;
    private ThreadLocal localThreadContext = new ThreadLocal(){

        protected Object initialValue() {
            return new ThreadContext();
        }
    };

    private static void writeHeaderInfo(StringBuffer buffer) {
        Date date = new Date();
        buffer.append("Date: ");
        buffer.append(date.toString());
        buffer.append(lineSeparator);
        buffer.append(lineSeparator);
        buffer.append("Process ID:").append(DefaultTracer.PID);
        if (DefaultTracer.PID.startsWith("f")) {
            buffer.append("  (fake process id)");
        }
        buffer.append(lineSeparator);
        buffer.append(lineSeparator);
        Properties properties = System.getProperties();
        Enumeration<?> keys = properties.propertyNames();
        Vector<String> sortedKeys = new Vector<String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            sortedKeys.add(key);
        }
        Collections.sort(sortedKeys);
        TableBuilder table = new TableBuilder();
        buffer.append("System properties:");
        buffer.append(lineSeparator);
        for (int i = 0; i < sortedKeys.size(); ++i) {
            String key = (String)sortedKeys.get(i);
            table.append(key, properties.getProperty(key).toString());
        }
        buffer.append(table.toStringBuffer());
        buffer.append(lineSeparator);
        buffer.append(lineSeparator);
        Runtime runtime = Runtime.getRuntime();
        buffer.append(lineSeparator);
        buffer.append("Runtime properties:");
        buffer.append(lineSeparator);
        buffer.append("  Available processors: ");
        buffer.append(runtime.availableProcessors());
        buffer.append(lineSeparator);
        buffer.append("  Total memory in bytes (now): ");
        buffer.append(runtime.totalMemory());
        buffer.append(lineSeparator);
        buffer.append("  Free memory in bytes (now): ");
        buffer.append(runtime.freeMemory());
        buffer.append(lineSeparator);
        buffer.append("  Max memory in bytes: ");
        buffer.append(runtime.maxMemory());
        buffer.append(lineSeparator);
        buffer.append(lineSeparator);
        buffer.append("Stack trace of initiating call:").append(lineSeparator);
        Exception e = new Exception();
        StackTraceElement[] stacktrace = e.getStackTrace();
        for (int count = 0; count < stacktrace.length; ++count) {
            buffer.append(spacesBetweenColumns).append(stacktrace[count]).append(lineSeparator);
        }
        buffer.append("Version information in main body of trace");
        buffer.append(lineSeparator);
        buffer.append("TimeStamp        TID   ObjectId   Class                                                                                      Data");
        buffer.append(lineSeparator);
        buffer.append("======================================================================================================================================================================");
        buffer.append(lineSeparator);
    }

    public HumanFormatter() {
        if (this.messageFormatAdapters == null) {
            this.messageFormatAdapters = new HashMap();
            this.messageFormatAdapters.put("CATCH_BLOCK", new CatchFormatAdapter());
            this.messageFormatAdapters.put("TRACE_DATA", new DataFormatAdapter());
            this.messageFormatAdapters.put("METHOD_ENTRY", new EntryFormatAdapter());
            this.messageFormatAdapters.put("METHOD_EXIT", new ExitFormatAdapter());
            this.messageFormatAdapters.put("FINALLY_BLOCK", new FinallyFormatAdapter());
            this.messageFormatAdapters.put("THROWING", new ThrowFormatAdapter());
        }
        this.cachedClassNames = new FastHashMap();
        try {
            DefaultTracer cfr_ignored_0 = (DefaultTracer)Trace.getCSPTrace();
            this.maxTraceBytes = DefaultTracer.getMaxTraceBytes();
        }
        catch (ClassCastException cce) {
            this.maxTraceBytes = -1;
        }
    }

    public String format(LogRecord record) {
        FlightRecorder.entry("HumanFormatter.formatRecord");
        StringBuffer output = new StringBuffer(256);
        MessageFormatAdapter adapter = (MessageFormatAdapter)this.messageFormatAdapters.get(record.getMessage());
        if (adapter == null) {
            adapter = (MessageFormatAdapter)this.messageFormatAdapters.get("TRACE_DATA");
        }
        try {
            if (this.firstRecord) {
                this.firstRecord = false;
                HumanFormatter.writeHeaderInfo(output);
            }
            adapter.formatRecord(record, output);
        }
        catch (Throwable t) {
            output.append(lineSeparator);
            output.append(" *** Problem occurred formatting trace line: ");
            try {
                output.append(t);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                pw.flush();
                sw.flush();
                output.append(sw.toString());
                pw.close();
                sw.close();
            }
            catch (Throwable t2) {
                output.append(" Could not retrieve message from Throwable");
            }
            output.append(" ***");
            output.append(lineSeparator);
        }
        String result = output.toString();
        FlightRecorder.exit("HumanFormatter.formatRecord: " + result);
        return result;
    }

    public String format(TraceRecord record) {
        return null;
    }

    public String getHead(TraceHandler h) {
        return null;
    }

    public String getTail(TraceHandler h) {
        return null;
    }

    static {
        String lineSeparatorProperty = "line.separator";
        PropertyStore.register(lineSeparatorProperty, "\n");
        lineSeparator = PropertyStore.getStringProperty(lineSeparatorProperty);
    }

    class ThrowFormatAdapter
    extends SimpleFormatAdapter {
        ThrowFormatAdapter() {
        }

        void formatRecord() {
            this.prefix = this.newStartOfRecord(true);
            this.buffer.append("  !  ");
            this.buffer.append(this.record.getSourceMethodName());
            this.buffer.append(", ");
            Throwable thrown = this.record.getThrown();
            if (thrown == null) {
                thrown = new Throwable("Unknown Throwable");
            }
            this.appendMessage(thrown.getMessage());
            this.buffer.append(" [");
            this.buffer.append(thrown.getClass().getName());
            this.buffer.append("]");
            this.buffer.append(lineSeparator);
        }
    }

    abstract class SimpleFormatAdapter
    extends MessageFormatAdapter {
        private final int majorUnit = 25;
        private final int maxClassNameLength = 80;

        SimpleFormatAdapter() {
            this.majorUnit = 25;
            this.maxClassNameLength = 80;
        }

        private void appendClassName(String classNameP) {
            int atIndex;
            String className = classNameP;
            if (className == null) {
                className = "Unknown Class";
            }
            if ((atIndex = className.indexOf(64)) != -1) {
                this.buffer.append(className.substring(atIndex));
                className = className.substring(0, atIndex);
            } else {
                this.buffer.append("   static");
            }
            this.buffer.append(HumanFormatter.spacesBetweenColumns);
            this.buffer.append(this.compress(className, 71));
            this.buffer.append(HumanFormatter.spacesBetweenColumns);
        }

        private String compress(String classNameP, int maxLength) {
            if (HumanFormatter.this.cachedClassNames.containsKey(classNameP)) {
                return HumanFormatter.this.cachedClassNames.get(classNameP);
            }
            String className = classNameP;
            for (int i = 0; i < this.packageNamesToFold.length; ++i) {
                if (!className.startsWith(this.packageNamesToFold[i])) continue;
                className = this.packageNamesFolded[i] + className.substring(this.packageNamesToFoldLength[i]);
                break;
            }
            int classNameLength = className.length();
            char[] cachedClassNameArray = new char[maxLength];
            System.arraycopy(className.toCharArray(), 0, cachedClassNameArray, 0, Math.min(maxLength, classNameLength));
            Arrays.fill(cachedClassNameArray, Math.min(maxLength, classNameLength), maxLength, ' ');
            String cachedClassName = new String(cachedClassNameArray);
            HumanFormatter.this.cachedClassNames.put(classNameP, cachedClassName);
            return cachedClassName;
        }

        private void appendIndentationString(int depth) {
            ThreadContext threadContext = (ThreadContext)HumanFormatter.this.localThreadContext.get();
            int localCollapseRequests = threadContext.collapseRequests;
            int localCollapsedLevels = threadContext.collapsedLevels;
            localCollapseRequests = depth >= 25 * (localCollapsedLevels + 1) ? ++localCollapseRequests : --localCollapseRequests;
            if (localCollapseRequests < 0) {
                localCollapseRequests = 0;
            }
            if (localCollapseRequests >= 32) {
                localCollapseRequests = 0;
                ++localCollapsedLevels;
            }
            if (localCollapsedLevels * 25 > depth) {
                --localCollapsedLevels;
            }
            for (int localWorkingCopy = localCollapsedLevels; localWorkingCopy > 0 && depth >= 25; --localWorkingCopy, depth -= 25) {
                this.buffer.append(":");
            }
            block8: while (depth > 0) {
                int localDepth = depth <= 5 ? depth : 5;
                switch (localDepth) {
                    case 1: {
                        this.buffer.append("-");
                        --depth;
                        continue block8;
                    }
                    case 2: {
                        this.buffer.append("--");
                        depth -= 2;
                        continue block8;
                    }
                    case 3: {
                        this.buffer.append("---");
                        depth -= 3;
                        continue block8;
                    }
                    case 4: {
                        this.buffer.append("----");
                        depth -= 4;
                        continue block8;
                    }
                    case 5: {
                        this.buffer.append("----+");
                        depth -= 5;
                        continue block8;
                    }
                }
            }
            threadContext.collapseRequests = localCollapseRequests;
            threadContext.collapsedLevels = localCollapsedLevels;
        }

        private void appendThreadFullName(String numericName, Thread thread) {
            String threadName = thread.getName();
            int priority = thread.getPriority();
            String threadGroup = thread.getThreadGroup().getName();
            ClassLoader cl = thread.getContextClassLoader();
            String ccl = "<ContextClassLoader is null>";
            if (cl != null) {
                ccl = cl.toString();
            }
            this.buffer.append(" (thread '");
            this.buffer.append(numericName);
            this.buffer.append("'='");
            this.buffer.append(threadName);
            this.buffer.append("' priority=");
            this.buffer.append(priority);
            this.buffer.append(" group=");
            this.buffer.append(threadGroup);
            this.buffer.append(" ");
            this.buffer.append(ccl);
            this.buffer.append(")");
            this.buffer.append(lineSeparator);
        }

        private void appendThreadNumericName(StringBuffer myBuffer, String threadNumericName) {
            myBuffer.append(threadNumericName);
            myBuffer.append(HumanFormatter.spacesBetweenColumns);
        }

        private void appendTimeStamp(StringBuffer myBuffer) {
            int h = calendar.get(11);
            int m = calendar.get(12);
            int s = calendar.get(13);
            int ms = calendar.get(14);
            if (s == HumanFormatter.this.cachedSecond && m == HumanFormatter.this.cachedMinute && h == HumanFormatter.this.cachedHour && HumanFormatter.this.cachedHourMinuteSecond != null) {
                myBuffer.append(HumanFormatter.this.cachedHourMinuteSecond);
            } else {
                HumanFormatter.this.cachedSecond = s;
                HumanFormatter.this.cachedMinute = m;
                HumanFormatter.this.cachedHour = h;
                StringBuffer sb = new StringBuffer();
                if (h < 10) {
                    sb.append("0");
                    sb.append(h);
                    sb.append(":");
                } else {
                    sb.append(h);
                    sb.append(":");
                }
                if (m < 10) {
                    sb.append("0");
                    sb.append(m);
                    sb.append(":");
                } else {
                    sb.append(m);
                    sb.append(":");
                }
                if (s < 10) {
                    sb.append("0");
                    sb.append(s);
                } else {
                    sb.append(s);
                }
                HumanFormatter.this.cachedHourMinuteSecond = sb.toString();
                myBuffer.append(HumanFormatter.this.cachedHourMinuteSecond);
            }
            if (ms < 10) {
                myBuffer.append(".00" + ms);
            } else if (ms < 100) {
                myBuffer.append(".0" + ms);
            } else {
                myBuffer.append("." + ms);
            }
            if (ms == HumanFormatter.this.cachedMilliSecond) {
                HumanFormatter.this.subMilliSecsCounter++;
                if (HumanFormatter.this.subMilliSecsCounter >= 1296) {
                    HumanFormatter.this.subMilliSecsCounter = 0;
                }
            } else {
                HumanFormatter.this.subMilliSecsCounter = 0;
            }
            char firstSymbol = base36chars[HumanFormatter.this.subMilliSecsCounter / 36];
            char secondSymbol = base36chars[HumanFormatter.this.subMilliSecsCounter % 36];
            myBuffer.append(".");
            myBuffer.append(firstSymbol);
            myBuffer.append(secondSymbol);
            HumanFormatter.this.cachedMilliSecond = ms;
            myBuffer.append(HumanFormatter.spacesBetweenColumns);
        }

        private int updateAndGetDepthCounter(String verb, String signature) {
            ThreadContext threadContext = (ThreadContext)HumanFormatter.this.localThreadContext.get();
            if (!threadContext.seenThread) {
                if ("METHOD_ENTRY".equals(verb)) {
                    threadContext.stack.add(signature);
                }
                threadContext.seenThread = true;
                return 0;
            }
            int depth = 0;
            if (!threadContext.stack.contains(signature)) {
                depth = threadContext.stack.size();
                if ("METHOD_ENTRY".equals(verb)) {
                    threadContext.stack.add(signature);
                }
                return depth;
            }
            if ("METHOD_ENTRY".equals(verb)) {
                depth = threadContext.stack.size();
                threadContext.stack.add(signature);
            } else {
                String signature2;
                for (int idx = threadContext.stack.size() - 1; idx >= 0 && !(signature2 = (String)threadContext.stack.get(idx)).equals(signature); --idx) {
                    threadContext.stack.remove(idx);
                }
                if ("METHOD_EXIT".equals(verb)) {
                    threadContext.stack.remove(threadContext.stack.size() - 1);
                }
                depth = threadContext.stack.size();
            }
            return depth;
        }

        void appendEndOfRecord() {
            ThreadContext threadContext = (ThreadContext)HumanFormatter.this.localThreadContext.get();
            if (threadContext.shownThreadData) {
                this.buffer.append(lineSeparator);
            } else {
                this.appendThreadFullName(threadContext.numericName, Thread.currentThread());
                threadContext.shownThreadData = true;
            }
        }

        void appendStartOfRecord() {
            this.newStartOfRecord(false);
        }

        char[] newStartOfRecord(boolean newBuffer) {
            FlightRecorder.entry("HumanFormatter$SimpleFormatAdapter.newStartOfRecord: " + newBuffer);
            StringBuffer sb = null;
            if (newBuffer) {
                sb = new StringBuffer(32);
            }
            calendar.setTimeInMillis(this.record.getMillis());
            if (newBuffer) {
                StringBuffer timeStamp = new StringBuffer(20);
                this.appendTimeStamp(timeStamp);
                this.buffer.append(timeStamp);
                sb.append(timeStamp);
            } else {
                this.appendTimeStamp(this.buffer);
            }
            String threadNumericName = ((ThreadContext)((HumanFormatter)HumanFormatter.this).localThreadContext.get()).numericName;
            this.appendThreadNumericName(this.buffer, threadNumericName);
            if (newBuffer) {
                this.appendThreadNumericName(sb, threadNumericName);
            }
            String className = TraceUtils.foldPackageName(this.record.getSourceClassName());
            this.appendClassName(className);
            String signature = this.record.getSourceMethodName();
            if (null == signature) {
                signature = new String();
            }
            if (!signature.endsWith(")") && -1 != signature.indexOf(")")) {
                signature = signature.substring(0, signature.indexOf(")") + 1);
            }
            signature = className + signature;
            int depth = this.updateAndGetDepthCounter(this.record.getMessage(), signature);
            this.appendIndentationString(depth);
            if (newBuffer) {
                sb.append(HumanFormatter.spacesBetweenColumns);
            }
            FlightRecorder.exit("HumanFormatter$SimpleFormatAdapter.newStartOfRecord");
            return newBuffer ? sb.toString().toCharArray() : null;
        }
    }

    abstract class MessageFormatAdapter {
        LogRecord record;
        StringBuffer buffer;
        char[] prefix;
        final String catchTag = "  X  ";
        final String warningTag = "  W  ";
        final String infoTag = "  i  ";
        final String dataTag = "  d  ";
        final String entryTag = "  {  ";
        final String exitTag = "  }  ";
        final String finallyTag = "  f  ";
        final String throwTag = "  !  ";
        final String[] packageNamesFolded = new String[]{"c.i.m.c", "c.i"};
        final String[] packageNamesToFold = new String[]{"com.ibm.msg.client", "com.ibm"};
        final int[] packageNamesToFoldLength = new int[]{18, 7};

        MessageFormatAdapter() {
        }

        void appendByteArrayInfo(byte[] parameter) {
            this.buffer.append(" <len=");
            this.buffer.append(parameter.length);
            this.buffer.append(" bytes>");
        }

        void appendIntArrayInfo(int[] parameter) {
            this.buffer.append(" <len=");
            this.buffer.append(parameter.length);
            this.buffer.append(" array=");
            for (int j = 0; j < parameter.length; ++j) {
                this.buffer.append(parameter[j] + ",");
            }
            this.buffer.append(">");
        }

        void appendObjectArrayInfo(Object[] parameter) {
            this.buffer.append(" <len=");
            this.buffer.append(parameter.length);
            this.buffer.append(" array=");
            for (int j = 0; j < parameter.length; ++j) {
                this.buffer.append(", " + parameter[j]);
            }
            this.buffer.append(">");
        }

        void appendPrimitiveInfo(String parameter) {
            if (parameter.indexOf("@") != -1) {
                for (int i = 0; i < this.packageNamesToFold.length; ++i) {
                    if (!parameter.startsWith(this.packageNamesToFold[i])) continue;
                    parameter = this.packageNamesFolded[i] + parameter.substring(this.packageNamesToFoldLength[i]);
                    break;
                }
            }
            if (parameter.indexOf("\n") == -1) {
                this.buffer.append("[");
                this.buffer.append(parameter);
                this.buffer.append("]");
            } else if (HumanFormatter.this.cachedMultiLinePrimitive == null || !HumanFormatter.this.cachedMultiLinePrimitive.equals(parameter)) {
                HumanFormatter.this.cachedMultiLinePrimitive = parameter;
                String replacedText = parameter.replaceAll("\n", lineSeparator + new String(this.prefix));
                this.buffer.append(lineSeparator);
                this.buffer.append(this.prefix);
                this.buffer.append("[");
                this.buffer.append(replacedText);
                this.buffer.append(lineSeparator);
                this.buffer.append(this.prefix);
                this.buffer.append("]");
            } else {
                this.buffer.append("<as-before>");
            }
        }

        void appendMessage(String message) {
            if (null == message) {
                this.buffer.append("<null>");
            } else if (message.indexOf("\n") == -1) {
                this.buffer.append(message);
            } else {
                this.buffer.append(lineSeparator);
                this.buffer.append(this.prefix);
                this.buffer.append("[");
                String replacedText = message.replaceAll("\n", lineSeparator + new String(this.prefix));
                this.buffer.append(replacedText);
                this.buffer.append(lineSeparator);
                this.buffer.append(this.prefix);
                this.buffer.append("]");
            }
        }

        abstract void formatRecord();

        void formatRecord(LogRecord record, StringBuffer buffer) {
            FlightRecorder.entry("HumanFormatter$MessageFormatAdapter.formatRecord");
            this.record = record;
            this.buffer = buffer;
            this.prefix = null;
            this.formatRecord();
            FlightRecorder.exit("HumanFormatter$MessageFormatAdapter.formatRecord");
        }
    }

    class FinallyFormatAdapter
    extends SimpleFormatAdapter {
        FinallyFormatAdapter() {
        }

        void formatRecord() {
            this.appendStartOfRecord();
            this.buffer.append("  f  ");
            this.buffer.append(this.record.getSourceMethodName());
            this.buffer.append(lineSeparator);
        }
    }

    class ThreadContext {
        int collapseRequests = 0;
        int collapsedLevels = 0;
        boolean shownThreadData = false;
        boolean seenThread = false;
        ArrayList stack = new ArrayList();
        String numericName = null;

        ThreadContext() {
            ++HumanFormatter.this.tid;
            this.numericName = HumanFormatter.this.tid < 10 ? "000" + HumanFormatter.this.tid : (HumanFormatter.this.tid < 100 ? "00" + HumanFormatter.this.tid : (HumanFormatter.this.tid < 1000 ? "0" + HumanFormatter.this.tid : "" + HumanFormatter.this.tid));
        }
    }

    static class FastHashMap {
        private String cachedKey = null;
        private String cachedValue = null;
        protected Map map = new WeakHashMap();

        boolean containsKey(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.cachedKey != null && this.cachedKey.equals(key)) {
                return true;
            }
            return this.map.containsKey(key);
        }

        String get(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (this.cachedKey != null && !this.cachedKey.equals(key)) {
                this.cachedKey = key;
                this.cachedValue = this.map.containsKey(key) ? (String)this.map.get(key) : null;
                return this.cachedValue;
            }
            return this.cachedValue;
        }

        void put(String key, String value) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.cachedKey = key;
            this.cachedValue = value;
            this.map.put(this.cachedKey, this.cachedValue);
        }
    }

    class ExitFormatAdapter
    extends SimpleFormatAdapter {
        ExitFormatAdapter() {
        }

        void formatRecord() {
            this.prefix = this.newStartOfRecord(true);
            this.buffer.append("  }  ");
            this.buffer.append(this.record.getSourceMethodName());
            Object[] parameters = this.record.getParameters();
            if (parameters != null && parameters[0] != null) {
                Object parameter = parameters[0];
                StringBuffer value = null;
                if (parameter instanceof byte[]) {
                    this.buffer.append(" returns ");
                    this.appendByteArrayInfo((byte[])parameter);
                } else if (parameter instanceof int[]) {
                    this.buffer.append(" returns ");
                    this.appendIntArrayInfo((int[])parameter);
                } else if (parameter instanceof Object[]) {
                    this.buffer.append(" returns ");
                    this.appendObjectArrayInfo((Object[])parameter);
                } else {
                    value = TraceUtils.formatObject(parameter, HumanFormatter.this.maxTraceBytes);
                    this.buffer.append(" returns ");
                    this.appendPrimitiveInfo(value.toString());
                }
                Class<?> parameterClass = parameter.getClass();
                String name = parameterClass.getName();
                int index = name.indexOf("java.lang.");
                if (index != -1) {
                    name = name.substring(10);
                    this.buffer.append(' ');
                    this.buffer.append(name);
                }
            }
            this.buffer.append(lineSeparator);
        }
    }

    class EntryFormatAdapter
    extends SimpleFormatAdapter {
        EntryFormatAdapter() {
        }

        void formatRecord() {
            this.prefix = this.newStartOfRecord(true);
            this.buffer.append("  {  ");
            this.buffer.append(this.record.getSourceMethodName());
            Object[] parameters = this.record.getParameters();
            if (parameters != null) {
                Object parameter = null;
                StringBuffer value = null;
                for (int i = 0; i < parameters.length; ++i) {
                    parameter = parameters[i];
                    if (parameter != null) {
                        if (parameter instanceof byte[]) {
                            this.appendByteArrayInfo((byte[])parameter);
                            continue;
                        }
                        if (parameter instanceof int[]) {
                            this.appendIntArrayInfo((int[])parameter);
                            continue;
                        }
                        if (parameter instanceof Object[]) {
                            this.appendObjectArrayInfo((Object[])parameter);
                            continue;
                        }
                        value = TraceUtils.formatObject(parameter, HumanFormatter.this.maxTraceBytes);
                        this.buffer.append(' ');
                        this.appendPrimitiveInfo(value.toString());
                        continue;
                    }
                    this.buffer.append(" <null>");
                }
            }
            this.appendEndOfRecord();
        }
    }

    class DataFormatAdapter
    extends SimpleFormatAdapter {
        private byte[] cachedDirectByteBufferBytes = null;
        private int cachedDirectByteBufferBytesLength = 32758;

        DataFormatAdapter() {
        }

        private void dumpBytes(byte[] data, int start, int count, String comment) {
            if (comment == null) {
                this.buffer.append(" <data>");
                this.buffer.append(lineSeparator);
            } else {
                this.buffer.append(" <data>");
                this.buffer.append(" ");
                this.buffer.append(comment);
                this.buffer.append(lineSeparator);
            }
            try {
                if (data != null) {
                    int len = data.length;
                    this.buffer.append(this.prefix);
                    this.buffer.append("Length = 0x");
                    this.buffer.append(Integer.toHexString(len));
                    this.buffer.append(" (");
                    this.buffer.append(len);
                    this.buffer.append(") bytes start=");
                    this.buffer.append(start);
                    this.buffer.append(" count=");
                    this.buffer.append(count);
                    this.buffer.append(lineSeparator);
                    this.buffer.append(this.prefix);
                    this.buffer.append("            offset    : 0 1 2 3  4 5 6 7  8 9 A B  C D E F");
                    this.buffer.append(lineSeparator);
                    int suppress = 0;
                    int end = start + count;
                    String[] c = new String[16];
                    String[] p = new String[16];
                    char[] textBuffer = null;
                    for (int j = 0; j < 16; ++j) {
                        c[j] = null;
                    }
                    for (int i = 0; i < len; i += 16) {
                        int j;
                        boolean skip = true;
                        for (j = 0; j < 16; ++j) {
                            int t = i + j;
                            if (t >= start && t < end && t < len) {
                                c[j] = this.pad(Integer.toHexString(data[t]), 2);
                                skip = false;
                                continue;
                            }
                            c[j] = HumanFormatter.spacesBetweenColumns;
                        }
                        if (skip) {
                            if (suppress > 0) {
                                this.duplicateLinesSuppressed(suppress);
                            }
                            suppress = 0;
                            c[0] = null;
                            continue;
                        }
                        if (c[0].equals(p[0]) && c[1].equals(p[1]) && c[2].equals(p[2]) && c[3].equals(p[3]) && c[4].equals(p[4]) && c[5].equals(p[5]) && c[6].equals(p[6]) && c[7].equals(p[7]) && c[8].equals(p[8]) && c[9].equals(p[9]) && c[10].equals(p[10]) && c[11].equals(p[11]) && c[12].equals(p[12]) && c[13].equals(p[13]) && c[14].equals(p[14]) && c[15].equals(p[15])) {
                            ++suppress;
                            continue;
                        }
                        if (suppress > 0) {
                            this.duplicateLinesSuppressed(suppress);
                        }
                        this.buffer.append(this.prefix);
                        this.buffer.append("0x");
                        this.buffer.append(this.pad(Integer.toHexString(i), 8));
                        this.buffer.append(" (");
                        this.buffer.append(this.pad(Integer.toString(i), 8, " "));
                        this.buffer.append(") : ");
                        this.buffer.append(c[0]);
                        this.buffer.append(c[1]);
                        this.buffer.append(c[2]);
                        this.buffer.append(c[3]);
                        this.buffer.append(" ");
                        this.buffer.append(c[4]);
                        this.buffer.append(c[5]);
                        this.buffer.append(c[6]);
                        this.buffer.append(c[7]);
                        this.buffer.append(" ");
                        this.buffer.append(c[8]);
                        this.buffer.append(c[9]);
                        this.buffer.append(c[10]);
                        this.buffer.append(c[11]);
                        this.buffer.append(" ");
                        this.buffer.append(c[12]);
                        this.buffer.append(c[13]);
                        this.buffer.append(c[14]);
                        this.buffer.append(c[15]);
                        this.buffer.append(" : ");
                        textBuffer = new String(data, i, i + 16 <= len ? 16 : len - i, "US-ASCII").toCharArray();
                        for (int x = i; x < i + 16; ++x) {
                            if (x >= len || x - start >= count) continue;
                            if (x >= start) {
                                byte curByte = data[x];
                                if (curByte >= 32 && curByte <= 126) {
                                    this.buffer.append(textBuffer[x % 16]);
                                    continue;
                                }
                                this.buffer.append(".");
                                continue;
                            }
                            this.buffer.append(" ");
                        }
                        this.buffer.append(lineSeparator);
                        for (j = 0; j < 16; ++j) {
                            p[j] = c[j];
                        }
                        suppress = 0;
                    }
                    if (suppress > 0) {
                        this.duplicateLinesSuppressed(suppress);
                    }
                } else {
                    this.buffer.append(this.prefix);
                    this.buffer.append("data is null");
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        private void duplicateLinesSuppressed(int i) {
            this.buffer.append(this.prefix);
            this.buffer.append("                          ");
            this.buffer.append(Integer.toString(i));
            this.buffer.append(" duplicate line(s) suppressed");
            this.buffer.append(lineSeparator);
        }

        private String pad(String s, int l) {
            return this.pad(s, l, null);
        }

        private String pad(String s, int l, String p) {
            String rc;
            if (p == null) {
                p = "0";
            }
            if (s.length() < l) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < l - s.length(); ++i) {
                    sb.append(p);
                }
                sb.append(s);
                rc = sb.toString();
            } else {
                rc = s.substring(s.length() - l);
            }
            return rc;
        }

        private boolean processByteBuffers(Object parameter) {
            boolean justDumpedBytes = false;
            String dumpComment = null;
            byte[] dumpByteArray = null;
            int dumpLength = 0;
            int dumpOffet = 0;
            if (parameter instanceof byte[]) {
                dumpComment = null;
                dumpByteArray = (byte[])parameter;
                dumpLength = dumpByteArray.length;
                dumpOffet = 0;
            } else if (parameter instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)parameter;
                dumpComment = byteBuffer.toString();
                if (byteBuffer.isDirect()) {
                    ByteBuffer byteBufferCopy = byteBuffer.duplicate();
                    int limit = byteBufferCopy.limit();
                    int offset = byteBufferCopy.position();
                    int length = limit - offset;
                    if (limit == this.cachedDirectByteBufferBytesLength) {
                        if (this.cachedDirectByteBufferBytes == null) {
                            this.cachedDirectByteBufferBytes = new byte[this.cachedDirectByteBufferBytesLength];
                        }
                        dumpByteArray = this.cachedDirectByteBufferBytes;
                    } else {
                        dumpByteArray = new byte[limit];
                    }
                    dumpLength = length;
                    dumpOffet = offset;
                    byteBufferCopy.rewind();
                    byteBufferCopy.get(dumpByteArray, 0, length);
                } else if (byteBuffer.hasArray()) {
                    int limit = byteBuffer.limit();
                    dumpLength = limit < (dumpByteArray = byteBuffer.array()).length ? limit : dumpByteArray.length;
                    dumpOffet = 0;
                }
            }
            if (dumpByteArray != null) {
                int max = HumanFormatter.this.maxTraceBytes == -1 ? dumpLength : HumanFormatter.this.maxTraceBytes;
                this.dumpBytes(dumpByteArray, dumpOffet, max, dumpComment);
                justDumpedBytes = true;
            }
            return justDumpedBytes;
        }

        void formatRecord() {
            FlightRecorder.entry("HumanFormatter$DataFormatAdapter.formatRecord");
            this.prefix = this.newStartOfRecord(true);
            int level = this.record.getLevel().intValue();
            String tag = "";
            tag = level >= 900 ? "  W  " : (level >= 800 ? "  i  " : "  d  ");
            this.buffer.append(tag);
            this.buffer.append(this.record.getSourceMethodName());
            this.buffer.append(" ");
            this.appendMessage(this.record.getMessage());
            boolean justDumpedBytes = false;
            Object[] parameters = this.record.getParameters();
            if (parameters != null) {
                Object parameter = null;
                StringBuffer value = null;
                for (int i = 0; i < parameters.length; ++i) {
                    parameter = parameters[i];
                    justDumpedBytes = false;
                    if (parameter != null) {
                        if (parameter instanceof byte[] || parameter instanceof ByteBuffer) {
                            justDumpedBytes = this.processByteBuffers(parameter);
                            continue;
                        }
                        if (parameter instanceof int[]) {
                            this.appendIntArrayInfo((int[])parameter);
                            continue;
                        }
                        if (parameter instanceof Object[]) {
                            this.appendObjectArrayInfo((Object[])parameter);
                            continue;
                        }
                        value = TraceUtils.formatObject(parameter, HumanFormatter.this.maxTraceBytes);
                        this.buffer.append(' ');
                        this.appendPrimitiveInfo(value.toString());
                        continue;
                    }
                    this.buffer.append(" <null>");
                }
            }
            if (!justDumpedBytes) {
                this.appendEndOfRecord();
            }
            FlightRecorder.exit("HumanFormatter$DataFormatAdapter.formatRecord");
        }
    }

    class CatchFormatAdapter
    extends SimpleFormatAdapter {
        CatchFormatAdapter() {
        }

        private void appendClassLoaderInfo(Object object) {
            try {
                ClassLoader objectClassLoader = object.getClass().getClassLoader();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                String ccl = "<ContextClassLoader is null>";
                if (cl != null) {
                    ccl = cl.toString();
                }
                this.buffer.append(this.prefix);
                this.buffer.append("Object ClassLoader = ");
                this.buffer.append(objectClassLoader);
                this.buffer.append(lineSeparator);
                this.buffer.append(this.prefix);
                this.buffer.append("CurrentThread ClassLoader = ");
                this.buffer.append(ccl);
                this.buffer.append(lineSeparator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void appendStackTrace(Throwable t) {
            StackTraceElement[] stack = t.getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                this.buffer.append(this.prefix);
                this.buffer.append(HumanFormatter.spacesBetweenColumns);
                this.buffer.append(stack[i]);
                this.buffer.append(lineSeparator);
            }
        }

        void formatRecord() {
            this.prefix = this.newStartOfRecord(true);
            this.buffer.append("  X  ");
            this.buffer.append(this.record.getSourceMethodName());
            this.buffer.append(lineSeparator);
            Throwable thrown = this.record.getThrown();
            if (thrown == null) {
                thrown = new Throwable("Unknown Throwable");
            }
            this.buffer.append(this.prefix);
            this.appendMessage(thrown.getMessage());
            this.buffer.append(" [");
            this.buffer.append(thrown.getClass().getName());
            this.buffer.append("] at:");
            this.buffer.append(lineSeparator);
            this.appendStackTrace(thrown);
            this.appendClassLoaderInfo(thrown);
            for (Throwable cause = thrown.getCause(); cause != null; cause = cause.getCause()) {
                this.buffer.append(this.prefix);
                this.buffer.append(" Cause:");
                this.buffer.append(lineSeparator);
                this.buffer.append(this.prefix);
                this.appendMessage(cause.getMessage());
                this.buffer.append(" [");
                this.buffer.append(cause.getClass().getName());
                this.buffer.append("] at:");
                this.buffer.append(lineSeparator);
                this.appendStackTrace(cause);
                this.appendClassLoaderInfo(cause);
            }
        }
    }
}

