/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.trace;

import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.j2se.trace.HumanFormatter;
import com.ibm.msg.client.commonservices.j2se.trace.JarFileHandler;
import com.ibm.msg.client.commonservices.j2se.trace.PackageNode;
import com.ibm.msg.client.commonservices.j2se.trace.TraceFilter;
import com.ibm.msg.client.commonservices.j2se.trace.TraceFormatterWrapper;
import com.ibm.msg.client.commonservices.j2se.trace.TraceHandlerWrapper;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.provider.trace.CSPTrace;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.trace.TraceFormatter;
import com.ibm.msg.client.commonservices.trace.TraceHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;

public class DefaultTracer
implements CSPTrace {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/trace/DefaultTracer.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.56.1.7 11/06/29 10:00:00";
    private boolean tracePropertiesRead = false;
    public static final String METHOD_ENTRY = "METHOD_ENTRY";
    public static final String METHOD_EXIT = "METHOD_EXIT";
    public static final String THROWING = "THROWING";
    public static final String CATCH_BLOCK = "CATCH_BLOCK";
    public static final String FINALLY_BLOCK = "FINALLY_BLOCK";
    public static final String TRACE_DATA = "TRACE_DATA";
    static int maxTraceBytes;
    private LogManager logManager;
    private Logger logger;
    private String loggerName = "com.ibm.msg.client.commonservices.j2se.DefaultTracer";
    private PackageNode packageTree = new PackageNode(null);
    private String outputFileName = "mqjms.trc";
    private int traceFileLimit = 0;
    private int traceFileCount = 1;
    private Handler handler = null;
    private TraceHandler traceHandler = null;
    private Formatter formatter = null;
    private TraceFormatter traceFormatter = null;
    private boolean parameterTrace;
    private boolean compressTrace = false;
    private boolean appendTrace = false;
    private Filter filter = null;
    private int traceLevelint = Integer.MAX_VALUE;
    private Level traceLevelObject = Level.ALL;
    static String PID;
    private Method getStateMethod = null;
    private Method getThreadIdMethod = null;
    private Method midAllStacks = null;
    private boolean checkedJava = false;
    private static int count;
    public Level level950 = new UserLevel(950);
    public Level level867 = new UserLevel(867);
    public Level level833 = new UserLevel(833);
    private static int titleSize;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultTracer() {
        this.logManager = LogManager.getLogManager();
        this.logger = Logger.getLogger(this.loggerName);
    }

    public void methodEntry(int level, Object parentClass, String parentClassName, String methodSignature, Object[] parameters) {
        this.logger.logp(this.getLevelObject(level), this.objectToString(parentClass, parentClassName), methodSignature, METHOD_ENTRY, (Object[])(this.parameterTrace ? parameters : null));
    }

    public void methodExit(int level, Object parentClass, String parentClassName, String methodSignature, Object returnValue, int exitIndex) {
        this.logger.logp(this.getLevelObject(level), this.objectToString(parentClass, parentClassName), exitIndex == -1 ? methodSignature : methodSignature + "<exitIndex " + exitIndex + ">", METHOD_EXIT, this.parameterTrace ? returnValue : null);
    }

    public void traceData(int level, Object parentClass, String parentClassName, String methodSignature, String uniqueDescription, Object data) {
        this.logger.logp(this.getLevelObject(level), this.objectToString(parentClass, parentClassName), methodSignature, uniqueDescription, this.parameterTrace ? data : null);
    }

    public void catchBlock(int level, Object parentClass, String parentClassName, String methodSignature, Throwable thrown, int catchIndex) {
        this.logger.logp(this.getLevelObject(level), this.objectToString(parentClass, parentClassName), catchIndex == -1 ? methodSignature : methodSignature + "<catchIndex " + catchIndex + ">", CATCH_BLOCK, this.parameterTrace ? thrown : null);
    }

    public void throwing(int level, Object parentClass, String parentClassName, String methodSignature, Throwable thrown, int throwIndex) {
        this.logger.logp(this.getLevelObject(level), this.objectToString(parentClass, parentClassName), throwIndex == -1 ? methodSignature : methodSignature + "<throwIndex " + throwIndex + ">", THROWING, this.parameterTrace ? thrown : null);
    }

    public void finallyBlock(int level, Object parentClass, String parentClassName, String methodSignature, int finallyIndex) {
        this.logger.logp(this.getLevelObject(level), this.objectToString(parentClass, parentClassName), finallyIndex == -1 ? methodSignature : methodSignature + "<finallyIndex " + finallyIndex + ">", FINALLY_BLOCK);
    }

    private void getTracerOptionsFromProperties() {
        if (this.tracePropertiesRead) {
            return;
        }
        this.outputFileName = PropertyStore.getStringProperty("com.ibm.msg.client.commonservices.trace.outputName");
        String includedPackages = PropertyStore.getStringProperty("com.ibm.msg.client.commonservices.trace.include");
        String excludedPackages = PropertyStore.getStringProperty("com.ibm.msg.client.commonservices.trace.exclude");
        String searchString = PropertyStore.getStringProperty("com.ibm.msg.client.commonservices.trace.searchString");
        maxTraceBytes = (int)PropertyStore.getLongProperty("com.ibm.msg.client.commonservices.trace.maxBytes");
        this.traceFileLimit = (int)PropertyStore.getLongProperty("com.ibm.msg.client.commonservices.trace.limit");
        this.traceFileCount = (int)PropertyStore.getLongProperty("com.ibm.msg.client.commonservices.trace.count");
        this.parameterTrace = PropertyStore.getBooleanProperty("com.ibm.msg.client.commonservices.trace.parameter");
        this.compressTrace = PropertyStore.getBooleanProperty("com.ibm.msg.client.commonservices.trace.compress");
        this.appendTrace = PropertyStore.getBooleanProperty("com.ibm.msg.client.commonservices.trace.append");
        String traceHandlerName = PropertyStore.getStringProperty("com.ibm.msg.client.commonservices.trace.traceHandler");
        this.traceHandler = null;
        String traceFormatterName = PropertyStore.getStringProperty("com.ibm.msg.client.commonservices.trace.traceFormatter");
        this.traceFormatter = null;
        if (PropertyStore.wasOverridden("com.ibm.msg.client.commonservices.trace.include", null) || PropertyStore.wasOverridden("com.ibm.msg.client.commonservices.trace.exclude", null)) {
            this.packageTree.setIncluded(true);
            this.packageTree = this.addPackageListToTree(this.packageTree, excludedPackages, false);
            this.packageTree = this.addPackageListToTree(this.packageTree, includedPackages, true);
            this.filter = new TraceFilter(this.packageTree);
        }
        if (PropertyStore.wasOverridden("com.ibm.msg.client.commonservices.trace.searchString", null)) {
            if (this.filter == null) {
                this.filter = new TraceFilter();
            }
            try {
                ((TraceFilter)this.filter).setSearchString(searchString);
            }
            catch (PatternSyntaxException pse) {
                System.err.println("Failed to parse trace search string \"" + searchString + "\"");
                System.err.println(pse);
            }
        }
        if (traceHandlerName != null && !traceHandlerName.equals("")) {
            try {
                try {
                    Class cHandler = CSSystem.dynamicLoadClass(traceHandlerName, this.getClass());
                    this.traceHandler = (TraceHandler)cHandler.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
                catch (IllegalAccessException e) {
                    throw e;
                }
                catch (InstantiationException e) {
                    throw e;
                }
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate TraceHandler " + traceHandlerName);
                System.err.println(e);
            }
        }
        if (traceFormatterName != null) {
            try {
                try {
                    Class cFormatter = CSSystem.dynamicLoadClass(traceFormatterName, this.getClass());
                    this.traceFormatter = (TraceFormatter)cFormatter.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
                catch (IllegalAccessException e) {
                    throw e;
                }
                catch (InstantiationException e) {
                    throw e;
                }
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate TraceFormatter " + traceFormatterName);
                System.err.println(e);
            }
        }
        if (null != this.traceHandler) {
            this.setTraceHandler(this.traceHandler);
        }
        if (null != this.traceFormatter) {
            this.setTraceFormatter(this.traceFormatter);
        }
        this.tracePropertiesRead = true;
    }

    private PackageNode addPackageListToTree(PackageNode treeRoot, String packageList, boolean included) {
        if (null == treeRoot) {
            treeRoot = new PackageNode(null);
        }
        if (null == packageList) {
            return treeRoot;
        }
        if (packageList.equals("NONE")) {
            treeRoot.setIncluded(!included);
            return treeRoot;
        }
        if (packageList.equals("ALL")) {
            treeRoot.setIncluded(included);
            return treeRoot;
        }
        StringTokenizer tokens = new StringTokenizer(packageList, ";");
        String thisPackage = null;
        while (tokens.hasMoreTokens()) {
            thisPackage = tokens.nextToken();
            treeRoot.addPackage(thisPackage, included);
        }
        return treeRoot;
    }

    public void setTraceHandler(TraceHandler newHandler) {
        final Handler tempHandler = newHandler instanceof Handler ? (Handler)((Object)newHandler) : new TraceHandlerWrapper(newHandler);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DefaultTracer.this.logger.addHandler(tempHandler);
                if (DefaultTracer.this.handler != null) {
                    DefaultTracer.this.logger.removeHandler(DefaultTracer.this.handler);
                }
                return null;
            }
        });
        this.traceHandler = newHandler;
        this.handler = tempHandler;
    }

    public void setTraceHandler(final Handler newHandler) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DefaultTracer.this.handler != newHandler) {
                    DefaultTracer.this.logger.addHandler(newHandler);
                    DefaultTracer.this.logger.removeHandler(DefaultTracer.this.handler);
                    DefaultTracer.this.handler = newHandler;
                    DefaultTracer.this.traceHandler = null;
                } else {
                    DefaultTracer.this.logger.addHandler(newHandler);
                }
                return null;
            }
        });
    }

    public void setTraceFormatter(TraceFormatter newFormatter) {
        Formatter tempFormatter = null;
        tempFormatter = newFormatter instanceof Formatter ? (Formatter)((Object)newFormatter) : new TraceFormatterWrapper(newFormatter);
        this.traceFormatter = newFormatter;
        this.formatter = tempFormatter;
        if (this.handler != null) {
            this.handler.setFormatter(this.formatter);
        }
    }

    public void setTraceFormatter(Formatter newFormatter) {
        this.formatter = newFormatter;
        this.traceFormatter = null;
        if (this.handler != null) {
            this.handler.setFormatter(this.formatter);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        try {
            this.logger.removeHandler(this.handler);
            this.logManager.reset();
            this.handler.close();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void initialize() {
        try {
            Object o;
            Object ioe;
            final String pid = this.generatePID();
            String defaultTraceFileName_fromProps = (String)Trace.productProps.get("TraceFilename");
            final String defaultTraceFileName = defaultTraceFileName_fromProps.replaceAll("%PID%", pid);
            this.getTracerOptionsFromProperties();
            this.outputFileName = PropertyStore.getStringProperty("com.ibm.msg.client.commonservices.trace.outputName");
            this.outputFileName = this.outputFileName.replaceAll("%PID%", pid);
            if (this.outputFileName != null && (ioe = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    HashMap<String, Object> data;
                    boolean success;
                    File traceFile = new File(DefaultTracer.this.outputFileName);
                    File traceDirectory = null;
                    if (!traceFile.isDirectory()) {
                        String parent = traceFile.getParent();
                        if (parent == null) {
                            parent = ".";
                        }
                        traceDirectory = new File(parent);
                    } else {
                        traceDirectory = traceFile;
                        try {
                            DefaultTracer.this.outputFileName = traceFile.getCanonicalPath() + File.separator + defaultTraceFileName;
                        }
                        catch (IOException ioe) {
                            return ioe;
                        }
                        traceFile = new File(DefaultTracer.this.outputFileName);
                    }
                    if (!(traceDirectory.exists() || (success = traceDirectory.mkdirs()) || (success = traceFile.mkdirs()))) {
                        data = new HashMap();
                        data.put("OutputFileName", DefaultTracer.this.outputFileName);
                        Trace.ffst(this, "initialize()", "XS005001", data, null);
                        DefaultTracer.this.outputFileName = null;
                    }
                    try {
                        if (!traceDirectory.canWrite() || traceFile.exists() && !traceFile.canWrite()) {
                            HashMap<String, String> data2 = new HashMap<String, String>();
                            data2.put("TraceFile", traceFile.toString());
                            data2.put("TraceDirectory", traceDirectory.toString());
                            Trace.ffst(this, "initialize()", "XS005002", data2, null);
                            DefaultTracer.this.outputFileName = null;
                        }
                    }
                    catch (Exception e) {
                        data = new HashMap<String, Object>();
                        data.put("TraceFile", traceFile.toString());
                        data.put("TraceDirectory", traceDirectory.toString());
                        data.put("exception", e);
                        Trace.ffst(this, "initialize()", "XS005003", data, null);
                        DefaultTracer.this.outputFileName = null;
                    }
                    return null;
                }
            })) != null) {
                throw (IOException)ioe;
            }
            if (this.outputFileName == null) {
                this.outputFileName = defaultTraceFileName;
            }
            if ((o = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        if (DefaultTracer.this.compressTrace) {
                            JarFileHandler.setPID(pid);
                            DefaultTracer.this.outputFileName = DefaultTracer.this.outputFileName.replaceAll(".trc", ".trz");
                            DefaultTracer.this.handler = new JarFileHandler(DefaultTracer.this.outputFileName, DefaultTracer.this.traceFileLimit, DefaultTracer.this.traceFileCount, DefaultTracer.this.appendTrace);
                        } else {
                            DefaultTracer.this.handler = new FileHandler(DefaultTracer.this.outputFileName, DefaultTracer.this.traceFileLimit, DefaultTracer.this.traceFileCount, DefaultTracer.this.appendTrace);
                        }
                    }
                    catch (IOException ioe) {
                        return ioe;
                    }
                    return null;
                }
            })) != null) {
                throw (IOException)o;
            }
        }
        catch (IOException ioe) {
            System.err.println("Could not initialize trace file, " + ioe);
            this.handler = new ConsoleHandler();
        }
        this.traceLevelint = Trace.getTraceLevel();
        final Level level = this.getLevelObject(this.traceLevelint);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DefaultTracer.this.logger.setLevel(level);
                DefaultTracer.this.logger.setUseParentHandlers(false);
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DefaultTracer.this.handler.setLevel(Level.ALL);
                return null;
            }
        });
        if (null == this.formatter) {
            this.formatter = new HumanFormatter();
        }
        if (null != this.handler) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DefaultTracer.this.handler.setFormatter(DefaultTracer.this.formatter);
                    return null;
                }
            });
        }
        if (this.filter != null) {
            this.handler.setFilter(this.filter);
        }
        this.setTraceHandler(this.handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generatePID() {
        String pid = null;
        try {
            Class managementFactory = CSSystem.dynamicLoadClass("java.lang.management.ManagementFactory", this.getClass());
            Class runtimeMXBean = CSSystem.dynamicLoadClass("java.lang.management.RuntimeMXBean", this.getClass());
            Method getName = runtimeMXBean.getMethod("getName", new Class[0]);
            Method getRuntimeMXBean = managementFactory.getMethod("getRuntimeMXBean", new Class[0]);
            Object mxBean = getRuntimeMXBean.invoke((Object)managementFactory, null);
            String jvmName = (String)getName.invoke(mxBean, null);
            int sep = jvmName.indexOf(64);
            if (sep > -1) {
                int pidNumeric = Math.abs(Integer.parseInt(jvmName.substring(0, sep)));
                pid = Integer.toString(pidNumeric);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        if (pid == null) {
            Random r = new Random(System.currentTimeMillis());
            pid = "f" + r.nextInt(9999);
        }
        String string = PID;
        synchronized (string) {
            if (PID.equals("none")) {
                PID = pid;
            }
        }
        return PID;
    }

    private String objectToString(Object obj, String parentClassName) {
        if (obj == null) {
            return parentClassName;
        }
        String objectClassName = obj.getClass().getName();
        StringBuffer result = new StringBuffer(objectClassName);
        if (null != parentClassName && !result.toString().equals(parentClassName) && objectClassName.indexOf(36) == -1) {
            int pIndex = parentClassName.lastIndexOf(".");
            result.append("(");
            result.append(parentClassName.substring(pIndex + 1));
            result.append(")");
        }
        result.append("@");
        result.append(Integer.toHexString(System.identityHashCode(obj)));
        return result.toString();
    }

    public static int getMaxTraceBytes() {
        return maxTraceBytes;
    }

    public String ffst(Object sourceClass, String methodSignature, String probeID, HashMap data, final String header) {
        this.getTracerOptionsFromProperties();
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String output = DefaultTracer.this.getFFSTName();
                try {
                    boolean success;
                    StringBuffer ffstInfo = new StringBuffer("----------------------------------START FFST------------------------------------");
                    ffstInfo.append(Trace.lineSeparator);
                    String pid = DefaultTracer.this.generatePID();
                    String filename = DefaultTracer.this.outputFileName.replaceAll("%PID%", pid);
                    File parentFile = new File(filename).getParentFile();
                    File ffdcDir = new File(parentFile, "FFDC");
                    if (!(ffdcDir.exists() || (success = ffdcDir.mkdirs()) || (success = ffdcDir.mkdirs()))) {
                        ffdcDir = new File("FFDC");
                        ffdcDir.mkdirs();
                    }
                    File outputFile = new File(ffdcDir, output);
                    while (!outputFile.createNewFile()) {
                        String newName = DefaultTracer.this.getFFSTName();
                        if (outputFile.getName().equals(newName)) break;
                        outputFile = new File(ffdcDir, newName);
                    }
                    ffstInfo.append(outputFile.getAbsoluteFile()).append(" PID:").append(PID);
                    ffstInfo.append(DefaultTracer.this.updateProductInfo(header));
                    FileWriter stream = new FileWriter(outputFile, true);
                    String threadInfo = DefaultTracer.this.generateThreadInfo();
                    ffstInfo.append(threadInfo);
                    ffstInfo.append(Trace.lineSeparator);
                    ffstInfo.append("First Failure Symptom Report completed at ").append(DefaultTracer.getTimestamp());
                    ffstInfo.append(Trace.lineSeparator);
                    ffstInfo.append("------------------------------------END FFST------------------------------------");
                    ffstInfo.append(Trace.lineSeparator);
                    stream.write(ffstInfo.toString());
                    stream.flush();
                    stream.close();
                    output = outputFile.getCanonicalPath();
                    DefaultTracer.this.writeJavaCore();
                }
                catch (Exception e) {
                    System.err.println(header);
                    output = "System.err";
                }
                return output;
            }
        });
    }

    private static String getTimestamp() {
        long time = System.currentTimeMillis();
        return new Date(time).toString();
    }

    private String generateThreadInfo() {
        StringBuffer threadInfo = new StringBuffer("All Thread Information").append(Trace.lineSeparator);
        Map traces = this.getAllThreads();
        if (traces == null) {
            threadInfo.append("Sorry - not available in this JRE");
            return threadInfo.toString();
        }
        Set entries = traces.entrySet();
        if (!$assertionsDisabled && entries == null) {
            throw new AssertionError();
        }
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Thread t = (Thread)entry.getKey();
            threadInfo.append(Trace.lineSeparator);
            threadInfo.append(DefaultTracer.padTitle("Name")).append(t.getName()).append(Trace.lineSeparator);
            threadInfo.append(DefaultTracer.padTitle("Priority") + t.getPriority()).append(Trace.lineSeparator);
            threadInfo.append(DefaultTracer.padTitle("ThreadGroup") + t.getThreadGroup()).append(Trace.lineSeparator);
            threadInfo.append(DefaultTracer.padTitle("ID") + this.getThreadId(t)).append(Trace.lineSeparator);
            threadInfo.append(DefaultTracer.padTitle("State") + this.getState(t)).append(Trace.lineSeparator);
            StackTraceElement[] stack = (StackTraceElement[])entry.getValue();
            for (int c = 0; c < stack.length; ++c) {
                String prefix = c == 0 ? "Stack" : "";
                String className = stack[c].getClassName();
                String methodName = stack[c].getMethodName();
                String fileName = stack[c].getFileName();
                int line = stack[c].getLineNumber();
                threadInfo.append(DefaultTracer.padTitle(prefix)).append(className).append(".").append(methodName).append("(").append(fileName);
                threadInfo.append(":").append(line).append(")").append(Trace.lineSeparator);
            }
        }
        return threadInfo.toString();
    }

    private String getState(Thread t) {
        String threadId = "Not available";
        if (this.getStateMethod == null) {
            try {
                this.getStateMethod = Thread.class.getDeclaredMethod("getState", null);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        try {
            threadId = this.getStateMethod.invoke((Object)t, null).toString();
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return threadId;
    }

    private String getThreadId(Thread t) {
        String threadId = "Not available";
        if (this.getThreadIdMethod == null) {
            try {
                this.getThreadIdMethod = Thread.class.getDeclaredMethod("getId", null);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        try {
            threadId = ((Long)this.getThreadIdMethod.invoke((Object)t, null)).toString();
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return threadId;
    }

    private Map getAllThreads() {
        Map allThreads = null;
        if (this.midAllStacks == null && !this.checkedJava) {
            try {
                this.midAllStacks = Thread.class.getDeclaredMethod("getAllStackTraces", null);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            this.checkedJava = true;
        } else if (this.midAllStacks == null && this.checkedJava) {
            this.midAllStacks = null;
            allThreads = null;
        }
        if (this.midAllStacks != null) {
            try {
                Object o = this.midAllStacks.invoke((Object)Thread.class, null);
                if (o instanceof Map) {
                    allThreads = (Map)o;
                }
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return allThreads;
    }

    private String updateProductInfo(String header) {
        String updatedHeader = header;
        Enumeration<Object> keys = Trace.productProps.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            updatedHeader = header.replaceAll(key, (String)Trace.productProps.get(key));
        }
        return updatedHeader;
    }

    private void writeJavaCore() {
        PropertyStore.register("com.ibm.msg.client.commonservices.j2se.produceJavaCore", false);
        boolean produceCore = PropertyStore.getBooleanProperty("com.ibm.msg.client.commonservices.j2se.produceJavaCore");
        if (produceCore) {
            try {
                Class dumpClass = CSSystem.dynamicLoadClass("com.ibm.jvm.Dump", Trace.class);
                Method dumpMethod = dumpClass.getMethod("JavaDump", null);
                dumpMethod.invoke(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized String getFFSTName() {
        StringBuffer countString = new StringBuffer();
        ++count;
        for (int j = 1000; j >= 10; j /= 10) {
            if (count >= j) continue;
            countString.append('0');
        }
        countString.append(count);
        String productName = (String)Trace.productProps.get("FDCFilename");
        String ffstName = productName.replaceAll("%COUNT%", countString.toString());
        return ffstName;
    }

    private Level getLevelObject(int level) {
        Level retLevel = Level.OFF;
        switch (level) {
            case 0: {
                retLevel = Level.OFF;
                break;
            }
            case 1: {
                retLevel = Level.SEVERE;
                break;
            }
            case 2: {
                retLevel = this.level950;
                break;
            }
            case 3: {
                retLevel = Level.WARNING;
                break;
            }
            case 4: {
                retLevel = this.level867;
                break;
            }
            case 5: {
                retLevel = this.level833;
                break;
            }
            case 6: {
                retLevel = Level.INFO;
                break;
            }
            case 7: {
                retLevel = Level.CONFIG;
                break;
            }
            case 8: {
                retLevel = Level.FINE;
                break;
            }
            case 9: {
                retLevel = Level.FINER;
                break;
            }
            case 10: {
                retLevel = Level.FINEST;
                break;
            }
            default: {
                retLevel = Level.ALL;
            }
        }
        return retLevel;
    }

    public void setTraceLevel(int traceLevel) {
        this.traceLevelint = traceLevel;
        final Level level = this.traceLevelObject = this.getLevelObject(traceLevel);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    DefaultTracer.this.logger.setLevel(level);
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public int getTraceLevel() {
        return this.traceLevelint;
    }

    private static String padTitle(String text) {
        StringBuffer buffer = new StringBuffer(titleSize);
        int textLength = text.trim().length();
        int padding = titleSize - textLength;
        for (int c = 0; c < padding; ++c) {
            buffer.append(" ");
        }
        buffer.append(text.trim()).append(" : ");
        String traceRet1 = buffer.toString();
        return traceRet1;
    }

    static {
        $assertionsDisabled = !DefaultTracer.class.desiredAssertionStatus();
        maxTraceBytes = -1;
        PID = "none";
        count = 0;
        titleSize = 30;
    }

    public class UserLevel
    extends Level {
        private static final long serialVersionUID = -1908778006198989698L;

        public UserLevel(int level) {
            super("Level: " + level, level);
        }
    }
}

