/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.trace;

import com.ibm.msg.client.commonservices.j2se.trace.DefaultTracer;
import com.ibm.msg.client.commonservices.j2se.trace.TraceUtils;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class DefaultFormatter
extends Formatter {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/trace/DefaultFormatter.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.11.2.1 09/08/17 08:21:40";
    static HashMap indents = new HashMap();
    private HashMap msgFormatAdapters = new HashMap();
    int maxTraceBytes = -1;

    public DefaultFormatter() {
        this.msgFormatAdapters.put("METHOD_ENTRY", new EntryMsgFormatter());
        this.msgFormatAdapters.put("METHOD_EXIT", new ExitMsgFormatter());
        this.msgFormatAdapters.put("THROWING", new ThrowingMsgFormatter());
        this.msgFormatAdapters.put("CATCH_BLOCK", new CatchingMsgFormatter());
        this.msgFormatAdapters.put("FINALLY_BLOCK", new FinallyMsgFormatter());
        this.msgFormatAdapters.put("TRACE_DATA", new DataMsgFormatter());
        try {
            DefaultTracer cfr_ignored_0 = (DefaultTracer)Trace.getCSPTrace();
            this.maxTraceBytes = DefaultTracer.getMaxTraceBytes();
        }
        catch (ClassCastException cce) {
            this.maxTraceBytes = -1;
        }
    }

    public String format(LogRecord record) {
        StringBuffer output = new StringBuffer(256);
        MsgFormatter formatter = (MsgFormatter)this.msgFormatAdapters.get(record.getMessage());
        if (formatter == null) {
            formatter = (MsgFormatter)this.msgFormatAdapters.get("TRACE_DATA");
        }
        try {
            formatter.formatMessage(record, output);
        }
        catch (Throwable t) {
            output.append("\n");
            output.append(" *** Problem occurred formatting trace line: ");
            try {
                output.append(t);
            }
            catch (Throwable t2) {
                output.append(" Could not retrieve message from Throwable");
            }
            output.append(" ***\n");
        }
        String traceRet1 = output.toString();
        return traceRet1;
    }

    class ThrowingMsgFormatter
    extends MsgFormatter {
        ThrowingMsgFormatter() {
        }

        void appendStackTrace(Throwable t, StringBuffer buffer) {
            StackTraceElement[] stack = t.getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                this.indent(buffer);
                buffer.append("\tat " + stack[i] + '\n');
            }
        }

        void formatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            Throwable thrown = record.getThrown();
            buffer.append(' ' + record.getSourceMethodName() + ' ');
            buffer.append(thrown.getClass().getName());
            buffer.append(" exception thrown: " + thrown.getMessage() + "\n");
            this.appendStackTrace(thrown, buffer);
            for (Throwable cause = thrown.getCause(); cause != null; cause = cause.getCause()) {
                this.incrementIndents();
                this.indent(buffer);
                buffer.append("\tCaused by " + cause.getClass().getName());
                buffer.append(" exception thrown: " + thrown.getMessage() + "\n");
                this.appendStackTrace(cause, buffer);
                this.decrementIndents();
            }
        }
    }

    class FinallyMsgFormatter
    extends MsgFormatter {
        FinallyMsgFormatter() {
        }

        void formatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            buffer.append(' ' + record.getSourceMethodName() + " finally\n");
        }
    }

    class ExitMsgFormatter
    extends MsgFormatter {
        ExitMsgFormatter() {
        }

        void formatMessage(LogRecord record, StringBuffer buffer) {
            this.decrementIndents();
            this.appendBaseMessage(record, buffer);
            buffer.append(" <== ");
            buffer.append(record.getSourceMethodName() + " exit\n");
            Object[] returnVal = record.getParameters();
            if (returnVal != null && returnVal[0] != null) {
                Object retValEntry = returnVal[0];
                this.indent(buffer);
                buffer.append(" return = ");
                if (retValEntry instanceof byte[]) {
                    buffer.append(TraceUtils.bytesToHex((byte[])retValEntry, DefaultFormatter.this.maxTraceBytes));
                } else {
                    buffer.append(retValEntry.toString());
                }
                buffer.append('\n');
            }
        }
    }

    class EntryMsgFormatter
    extends MsgFormatter {
        EntryMsgFormatter() {
        }

        void formatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            buffer.append(" ==> ");
            buffer.append(record.getSourceMethodName() + " entry\n");
            this.incrementIndents();
            Object[] parameters = record.getParameters();
            if (parameters != null) {
                this.indent(buffer);
                buffer.append("params: \n");
                Object parameter = null;
                for (int i = 0; i < parameters.length; ++i) {
                    parameter = parameters[i];
                    if (parameter == null) continue;
                    this.indent(buffer);
                    buffer.append('\t');
                    buffer.append(parameter.getClass());
                    buffer.append(" = ");
                    if (parameter instanceof byte[]) {
                        buffer.append(TraceUtils.bytesToHex((byte[])parameter, DefaultFormatter.this.maxTraceBytes));
                    } else {
                        buffer.append(parameter.toString());
                    }
                    buffer.append('\n');
                }
            }
        }
    }

    class DataMsgFormatter
    extends MsgFormatter {
        DataMsgFormatter() {
        }

        void formatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            buffer.append(' ');
            buffer.append(record.getMessage());
            buffer.append('\n');
            Object[] parameters = record.getParameters();
            if (parameters != null) {
                this.indent(buffer);
                buffer.append("Data:\n");
                Object parameter = null;
                for (int i = 0; i < parameters.length; ++i) {
                    parameter = parameters[i];
                    if (parameter == null) continue;
                    this.indent(buffer);
                    buffer.append('\t');
                    if (parameter instanceof byte[]) {
                        buffer.append(TraceUtils.formatObjectDetailed(parameter, DefaultFormatter.this.maxTraceBytes));
                    } else {
                        buffer.append(parameter.toString());
                    }
                    buffer.append('\n');
                }
            }
        }
    }

    class CatchingMsgFormatter
    extends MsgFormatter {
        CatchingMsgFormatter() {
        }

        void formatMessage(LogRecord record, StringBuffer buffer) {
            this.appendBaseMessage(record, buffer);
            Throwable thrown = record.getThrown();
            if (thrown == null) {
                thrown = new Throwable("Unknown thowable");
            }
            buffer.append(' ' + record.getSourceMethodName() + ' ');
            buffer.append(thrown.getClass().getName());
            buffer.append(" exception caught: " + thrown.getMessage() + "\n");
        }
    }

    abstract class MsgFormatter {
        private Calendar calendar;
        private Date date = new Date();

        MsgFormatter() {
            this.calendar = new GregorianCalendar();
        }

        void appendBaseMessage(LogRecord record, StringBuffer output) {
            this.indent(output);
            this.appendTimestamp(output, record.getMillis());
            output.append('[' + Thread.currentThread().getName() + "] ");
            output.append(TraceUtils.foldPackageName(record.getSourceClassName()));
        }

        StringBuffer appendTimestamp(StringBuffer buffer, long millis) {
            this.date.setTime(millis);
            this.calendar.setTime(this.date);
            int h = this.calendar.get(11);
            int m = this.calendar.get(12);
            int s = this.calendar.get(13);
            if (h < 10) {
                buffer.append("0" + h + ":");
            } else {
                buffer.append(h + ":");
            }
            if (m < 10) {
                buffer.append("0" + m + ":");
            } else {
                buffer.append(m + ":");
            }
            if (s < 10) {
                buffer.append("0" + s + ":");
            } else {
                buffer.append(s + " ");
            }
            buffer.append("[" + millis + "] ");
            return buffer;
        }

        final void decrementIndents() {
            int indentLevel = this.getIndentationLevel();
            if (indentLevel > 0) {
                --indentLevel;
            }
            this.setIndentationLevel(indentLevel);
        }

        abstract void formatMessage(LogRecord var1, StringBuffer var2);

        final int getIndentationLevel() {
            int retVal = 0;
            if (indents.containsKey(Thread.currentThread())) {
                Integer indentationLevel = (Integer)indents.get(Thread.currentThread());
                retVal = indentationLevel;
            }
            return retVal;
        }

        final void incrementIndents() {
            int indentLevel = this.getIndentationLevel();
            this.setIndentationLevel(++indentLevel);
        }

        void indent(StringBuffer buffer) {
            int level = this.getIndentationLevel();
            for (int i = 0; i < level; ++i) {
                buffer.append("  ");
            }
        }

        final void setIndentationLevel(int newLevel) {
            indents.put(Thread.currentThread(), new Integer(newLevel));
        }
    }
}

