/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.propertystore;

import com.ibm.msg.client.commonservices.collections.CSHashtable;
import com.ibm.msg.client.commonservices.propertystore.PropertiesFileException;
import com.ibm.msg.client.commonservices.provider.propertystore.CSPPropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertyStoreImpl
implements CSPPropertyStore {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/propertystore/PropertyStoreImpl.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.36.1.5 10/04/13 12:31:01";
    private HashMap currentprops;
    private Map propDefns;
    private boolean successfullyReadAllSystemProperties;

    public PropertyStoreImpl() {
        block7: {
            Properties sysprops;
            this.currentprops = new HashMap();
            this.propDefns = new CSHashtable();
            this.successfullyReadAllSystemProperties = false;
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "<init>()");
            }
            if (null != (sysprops = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (Trace.isOn) {
                        Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "run()");
                    }
                    try {
                        Properties traceRet1 = System.getProperties();
                        PropertyStoreImpl.this.successfullyReadAllSystemProperties = true;
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.null", "run()", traceRet1, 1);
                        }
                        return traceRet1;
                    }
                    catch (AccessControlException ace) {
                        if (Trace.isOn) {
                            Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.propertystore.null", "run()", ace);
                        }
                        if (Trace.isOn) {
                            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.null", "run()", null, 2);
                        }
                        return null;
                    }
                }
            }))) {
                this.load(sysprops, null);
            }
            String configFileURL = null;
            configFileURL = (String)this.currentprops.get("com.ibm.msg.client.config.location");
            if (configFileURL != null) {
                try {
                    InputStream stream = null;
                    URL url = new URL(configFileURL);
                    stream = url.openStream();
                    if (stream != null) {
                        Properties configprops = new Properties();
                        configprops.load(stream);
                        this.load(configprops, null);
                    }
                }
                catch (Exception ex) {
                    if (!Trace.isOn) break block7;
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "<init>()", ex);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "<init>()");
        }
    }

    public HashMap getAll() {
        HashMap traceRet1 = (HashMap)this.currentprops.clone();
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "getAll()", "getter", traceRet1);
        }
        return traceRet1;
    }

    public String getStringProperty(String name) {
        String sysPropValue;
        PropertyDefinition def;
        Object o = this.propDefns.get(name);
        if (o == null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("name", name);
            Trace.ffst(this, "getStringProperty(String)", "XS002001", info, null);
        }
        if (2 != (def = (PropertyDefinition)o).type) {
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("type", new Integer(def.type));
            Trace.ffst(this, "getStringProperty(String)", "XS002002", info, null);
        }
        if (def.controlled) {
            return def.defaultString;
        }
        o = this.currentprops.get(name);
        if (null != o) {
            String traceRet1 = (String)o;
            return traceRet1;
        }
        if (!this.successfullyReadAllSystemProperties && (sysPropValue = this.readSystemProperty(name)) != null) {
            return sysPropValue;
        }
        return def.defaultString;
    }

    private String readSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(name);
                }
                catch (AccessControlException ace) {
                    return null;
                }
            }
        });
    }

    public long getLongProperty(String name) {
        PropertyDefinition def;
        Object o = this.propDefns.get(name);
        if (o == null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("name", name);
            Trace.ffst(this, "getLongProperty(String)", "XS002003", info, null);
        }
        if (1 != (def = (PropertyDefinition)o).type) {
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("type", new Integer(def.type));
            Trace.ffst(this, "getLongProperty(String)", "XS002004", info, null);
        }
        if (def.controlled) {
            return def.defaultLong;
        }
        o = this.currentprops.get(name);
        if (null == o) {
            return def.defaultLong;
        }
        long l = 0L;
        try {
            l = Long.parseLong((String)o);
        }
        catch (NumberFormatException nfe) {
            return def.defaultLong;
        }
        if (null != def.minValid && l < def.minValid) {
            return def.defaultLong;
        }
        if (null != def.maxValid && l > def.maxValid) {
            return def.defaultLong;
        }
        return l;
    }

    public boolean getBooleanProperty(String name) {
        PropertyDefinition def;
        Object o = this.propDefns.get(name);
        if (o == null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("name", name);
            Trace.ffst(this, "getBooleanProperty(String)", "XS002005", info, null);
        }
        if (3 != (def = (PropertyDefinition)o).type) {
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("type", new Integer(def.type));
            Trace.ffst(this, "getBooleanProperty(String)", "XS002006", info, null);
        }
        if (def.controlled) {
            return def.defaultBoolean;
        }
        o = this.currentprops.get(name);
        if (null != o) {
            String s = (String)o;
            if (s.equalsIgnoreCase("true")) {
                return true;
            }
            if (s.equalsIgnoreCase("false")) {
                return false;
            }
        }
        return def.defaultBoolean;
    }

    public Object getObjectProperty(String name) {
        PropertyDefinition def;
        Object o = this.propDefns.get(name);
        if (o == null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("name", name);
            Trace.ffst(this, "getObjectProperty(String)", "XS00200A", info, null);
        }
        if (0 != (def = (PropertyDefinition)o).type) {
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("type", new Integer(def.type));
            Trace.ffst(this, "getObjectProperty(String)", "XS00200B", info, null);
        }
        if (def.controlled) {
            return def.defaultObject;
        }
        Object retVal = def.defaultObject;
        if (this.currentprops.containsKey(name)) {
            retVal = this.currentprops.get(name);
        }
        return retVal;
    }

    public void set(String name, String value) {
        this.currentprops.put(name, value);
    }

    public void set(String name, Object value) {
        this.currentprops.put(name, value);
    }

    public void addPropertiesFile(String filename, String namespace, boolean optional) throws PropertiesFileException {
        Properties props;
        block5: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "addPropertiesFile(String,String,boolean)", new Object[]{filename, namespace, optional});
            }
            props = new Properties();
            try {
                FileInputStream fis = new FileInputStream(filename);
                props.load(fis);
            }
            catch (IOException ioe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "addPropertiesFile(String,String,boolean)", ioe);
                }
                if (optional) break block5;
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("file", filename);
                info.put("namespace", namespace);
                Trace.ffst(this, "addPropertiesFile(String,String,boolean)", "XS002007", info, null);
            }
        }
        this.load(props, namespace);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "addPropertiesFile(String,String,boolean)");
        }
    }

    private void load(Properties newprops, String namespaceArg) {
        String namespace;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "load(Properties,String)", new Object[]{newprops, namespaceArg});
        }
        if (null != (namespace = namespaceArg) && !namespace.endsWith(".")) {
            namespace = namespace + '.';
        }
        Enumeration<Object> keys = newprops.keys();
        while (keys.hasMoreElements()) {
            String oldkey = (String)keys.nextElement();
            String newkey = oldkey;
            if (-1 == newkey.indexOf(46) && null != namespace) {
                newkey = namespace + newkey;
            }
            if (this.isControlledProperty(newkey) || null != this.currentprops.get(newkey)) continue;
            String value = newprops.getProperty(oldkey);
            this.currentprops.put(newkey, value);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "load(Properties,String)");
        }
    }

    public void register(String name, String defaultValue, boolean controlled) {
        if (this.propDefns.containsKey(name)) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "register(String,boolean,boolean)", (Object)new Object[]{name, defaultValue, controlled});
                PropertyDefinition prop = (PropertyDefinition)this.propDefns.get(name);
                Trace.data(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "register(String,boolean,boolean)", "Failed. Property already registered", prop == null ? null : prop.defaultString);
            }
            return;
        }
        PropertyDefinition def = new PropertyDefinition(defaultValue, controlled);
        this.propDefns.put(name, def);
    }

    public void register(String name, boolean defaultValue, boolean controlled) {
        if (this.propDefns.containsKey(name)) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "register(String,boolean,boolean)", (Object)new Object[]{name, defaultValue, controlled});
                PropertyDefinition prop = (PropertyDefinition)this.propDefns.get(name);
                Trace.data(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "register(String,boolean,boolean)", "Failed. Property already registered", prop == null ? null : new Boolean(prop.defaultBoolean));
            }
            return;
        }
        PropertyDefinition def = new PropertyDefinition(defaultValue, controlled);
        this.propDefns.put(name, def);
    }

    public void register(String name, Object defaultValue, boolean controlled) {
        if (this.propDefns.containsKey(name)) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "register(String,boolean,boolean)", (Object)new Object[]{name, defaultValue, controlled});
                PropertyDefinition prop = (PropertyDefinition)this.propDefns.get(name);
                Trace.data(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "register(String,boolean,boolean)", "Failed. Property already registered", prop == null ? null : prop.defaultObject);
            }
            return;
        }
        PropertyDefinition def = new PropertyDefinition(defaultValue, controlled);
        this.propDefns.put(name, def);
    }

    public void register(String name, long defaultValue, Long minValid, Long maxValid, boolean controlled) {
        if (this.propDefns.containsKey(name)) {
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "register(String,boolean,boolean)", (Object)new Object[]{name, new Long(defaultValue), controlled});
                PropertyDefinition prop = (PropertyDefinition)this.propDefns.get(name);
                Trace.data(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "register(String,boolean,boolean)", "Failed. Property already registered", prop == null ? null : new Long(prop.defaultLong));
            }
            return;
        }
        PropertyDefinition def = new PropertyDefinition(defaultValue, minValid, maxValid, controlled);
        this.propDefns.put(name, def);
    }

    public boolean isControlledProperty(String name) {
        boolean controlledProperty = false;
        PropertyDefinition def = (PropertyDefinition)this.propDefns.get(name);
        if (def != null) {
            controlledProperty = def.controlled;
        }
        return controlledProperty;
    }

    public boolean wasOverridden(String name, StringBuffer unparsable) {
        Object o;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "wasOverridden(String,StringBuffer)", new Object[]{name, unparsable});
        }
        if (null == (o = this.currentprops.get(name))) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "wasOverridden(String,StringBuffer)", false, 1);
            }
            return false;
        }
        String value = (String)o;
        if (null == unparsable) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "wasOverridden(String,StringBuffer)", true, 2);
            }
            return true;
        }
        if (unparsable.length() > 0) {
            unparsable.delete(0, unparsable.length());
        }
        if ((o = this.propDefns.get(name)) == null) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("name", name);
            Trace.ffst(this, "wasOverridden(String,StringBuffer)", "XS002008", info, null);
        }
        PropertyDefinition def = (PropertyDefinition)o;
        switch (def.type) {
            case 2: {
                break;
            }
            case 3: {
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) break;
                unparsable.append(value);
                break;
            }
            case 1: {
                long l = 0L;
                try {
                    l = Long.parseLong(value);
                }
                catch (NumberFormatException nfe) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "wasOverridden(String,StringBuffer)", nfe);
                    }
                    unparsable.append(value);
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "wasOverridden(String,StringBuffer)", true, 3);
                    }
                    return true;
                }
                if (null != def.minValid && l < def.minValid) {
                    unparsable.append(value);
                    if (Trace.isOn) {
                        Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "wasOverridden(String,StringBuffer)", true, 4);
                    }
                    return true;
                }
                if (null == def.maxValid || l <= def.maxValid) break;
                unparsable.append(value);
                if (Trace.isOn) {
                    Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "wasOverridden(String,StringBuffer)", true, 5);
                }
                return true;
            }
            default: {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("name", name);
                info.put("type", new Integer(def.type));
                Trace.ffst(this, "wasOverridden(String,StringBuffer)", "XS002009", info, null);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "wasOverridden(String,StringBuffer)", true, 6);
        }
        return true;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.j2se.propertystore.PropertyStoreImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/propertystore/PropertyStoreImpl.java, jmscc.commonservices.j2se, k701, k701-112-140304  1.36.1.5 10/04/13 12:31:01");
        }
    }

    private class PropertyDefinition {
        private static final int TYPE_OBJECT = 0;
        private static final int TYPE_LONG = 1;
        private static final int TYPE_STRING = 2;
        private static final int TYPE_BOOLEAN = 3;
        private int type;
        private String defaultString;
        private long defaultLong;
        private boolean defaultBoolean;
        private Object defaultObject = null;
        private Long minValid;
        private Long maxValid;
        private boolean controlled;

        private PropertyDefinition(String defaultValue, boolean controlled) {
            this.type = 2;
            this.defaultString = defaultValue;
            this.controlled = controlled;
        }

        private PropertyDefinition(boolean defaultValue, boolean controlled) {
            this.type = 3;
            this.defaultBoolean = defaultValue;
            this.controlled = controlled;
        }

        private PropertyDefinition(Object defaultValue, boolean controlled) {
            this.type = 0;
            this.defaultObject = defaultValue;
            this.controlled = controlled;
        }

        private PropertyDefinition(long defaultValue, Long minValid, Long maxValid, boolean controlled) {
            this.type = 1;
            this.defaultLong = defaultValue;
            this.minValid = minValid;
            this.maxValid = maxValid;
            this.controlled = controlled;
        }
    }
}

