/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.log;

import com.ibm.msg.client.commonservices.Log.LogFormatter;
import com.ibm.msg.client.commonservices.Log.LogHandler;
import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.cssystem.WASSupport;
import com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter;
import com.ibm.msg.client.commonservices.j2se.log.LogFormatterWrapper;
import com.ibm.msg.client.commonservices.j2se.log.LogHandlerWrapper;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.provider.log.CSPLog;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class DefaultLogger
implements CSPLog {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/log/DefaultLogger.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.17.1.8 12/02/02 10:35:50";
    public static final String outputFileNameProperty = "com.ibm.msg.client.commonservices.log.outputName";
    public static final String outputFileNameProperty_default = "mqjms.log";
    public static final String outputFileNameProperty_errorStreamFileName = "System.err";
    public static final String outputFileNameProperty_outputStreamFileName = "System.out";
    public static final String maxLogBytesProperty = "com.ibm.msg.client.commonservices.log.maxBytes";
    public static final int maxLogBytesProperty_default = -1;
    public static final String logFileLimitProperty = "com.ibm.msg.client.commonservices.log.limit";
    public static final int logFileLimitProperty_default = 262144;
    public static final String logFileCountProperty = "com.ibm.msg.client.commonservices.log.count";
    public static final int logFileCountProperty_default = 3;
    public static final String logHandlerNameProperty = "com.ibm.msg.client.commonservices.log.LogHandler";
    public static final String logHandlerNameProperty_default = "";
    public static final String logFormatterNameProperty = "com.ibm.msg.client.commonservices.log.LogFormatter";
    public static final String logFormatterNameProperty_default = "";
    public static final String LOG_MSG = "LOG_MSG";
    public static final String LOG_MSG_NLS = "LOG_MSG_NLS";
    static int maxLogBytes;
    private LogManager logManager;
    private Logger logger;
    private String loggerName = "com.ibm.msg.client.commonservices.j2se.DefaultLogger";
    private String outputFileName = "mqjms.log";
    private int logFileLimit = 0;
    private int logFileCount = 1;
    private Handler handler = null;
    private LogHandler LogHandler = null;
    private Formatter formatter = null;
    private LogFormatter LogFormatter = null;

    public static int getMaxLogBytes() {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getMaxLogBytes()", "getter", (Object)new Integer(maxLogBytes));
        }
        return maxLogBytes;
    }

    public DefaultLogger() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "<init>()");
        }
        this.logManager = LogManager.getLogManager();
        this.logger = Logger.getLogger(this.loggerName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "run()");
                }
                try {
                    DefaultLogger.this.logger.setLevel(Level.ALL);
                }
                catch (AccessControlException ace) {
                    System.err.println("AccessControlException while enabling message client logging. No log output will be produced");
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.log.null", "run()", null);
                }
                return null;
            }
        });
        this.getTracerOptionsFromProperties();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "run()");
                }
                try {
                    DefaultLogger.this.logger.setUseParentHandlers(false);
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.log.null", "run()", null);
                }
                return null;
            }
        });
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "<init>()");
        }
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "close()");
        }
        try {
            this.logger.removeHandler(this.handler);
            this.logManager.reset();
            this.handler.close();
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "close()", 1);
            }
            return;
        }
        catch (Throwable t) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "close()", t);
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "close()", 2);
            }
            return;
        }
    }

    protected void finalize() throws Throwable {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "finalize()");
        }
        this.close();
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "finalize()");
        }
    }

    private void getTracerOptionsFromProperties() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()");
        }
        PropertyStore.register(outputFileNameProperty, outputFileNameProperty_default);
        PropertyStore.register(maxLogBytesProperty, -1L, new Long(-1L), new Long(Integer.MAX_VALUE));
        PropertyStore.register(logFileLimitProperty, 262144L, new Long(0L), new Long(Integer.MAX_VALUE));
        PropertyStore.register(logFileCountProperty, 3L, new Long(0L), new Long(Integer.MAX_VALUE));
        PropertyStore.register(logFormatterNameProperty, null);
        PropertyStore.register(logHandlerNameProperty, "");
        this.outputFileName = PropertyStore.getStringProperty(outputFileNameProperty);
        maxLogBytes = (int)PropertyStore.getLongProperty(maxLogBytesProperty);
        this.logFileLimit = (int)PropertyStore.getLongProperty(logFileLimitProperty);
        this.logFileCount = (int)PropertyStore.getLongProperty(logFileCountProperty);
        String traceHandlerName = PropertyStore.getStringProperty(logHandlerNameProperty);
        this.LogHandler = null;
        String traceFormatterName = PropertyStore.getStringProperty(logFormatterNameProperty);
        this.LogFormatter = null;
        if (traceHandlerName != null && !traceHandlerName.equals("")) {
            try {
                try {
                    Class cHandler = CSSystem.dynamicLoadClass(traceHandlerName, this.getClass());
                    this.LogHandler = (LogHandler)cHandler.newInstance();
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 1);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 1);
                    }
                    throw e;
                }
                catch (IllegalAccessException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 2);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 2);
                    }
                    throw e;
                }
                catch (InstantiationException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 3);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 3);
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 4);
                }
                System.err.println("Failed to instantiate LogHandler " + traceHandlerName);
                System.err.println(e);
            }
        }
        if (traceFormatterName != null) {
            try {
                try {
                    Class cFormatter = CSSystem.dynamicLoadClass(traceFormatterName, this.getClass());
                    this.LogFormatter = (LogFormatter)cFormatter.newInstance();
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 5);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 4);
                    }
                    throw e;
                }
                catch (IllegalAccessException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 6);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 5);
                    }
                    throw e;
                }
                catch (InstantiationException e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 7);
                    }
                    if (Trace.isOn) {
                        Trace.throwing(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 6);
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()", e, 8);
                }
                System.err.println("Failed to instantiate LogFormatter " + traceFormatterName);
                System.err.println(e);
            }
        }
        if (null != this.LogHandler) {
            this.setLogHandler(this.LogHandler);
        }
        if (null != this.LogFormatter) {
            this.setLogFormatter(this.LogFormatter);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "getTracerOptionsFromProperties()");
        }
    }

    public void initialize() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "initialize()");
        }
        if (null == this.handler) {
            try {
                if (this.outputFileName == null) {
                    if (WASSupport.getWASSupport().isWASv6Present()) {
                        this.setConsoleHandlerAsHandler();
                    } else {
                        this.setFileHandlerAsHandler(outputFileNameProperty_default);
                    }
                } else if (this.outputFileName.equalsIgnoreCase(outputFileNameProperty_errorStreamFileName)) {
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger.initialize", (Object)("Writing to System.err - Prop overridden: " + PropertyStore.wasOverridden(outputFileNameProperty, null) + " outputFileName: " + this.outputFileName + " errorStreamName: " + outputFileNameProperty_errorStreamFileName));
                    }
                    this.setConsoleHandlerAsHandler();
                } else if (this.outputFileName.equalsIgnoreCase(outputFileNameProperty_outputStreamFileName)) {
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger.initialize", (Object)("Writing to System.out - Prop overridden: " + PropertyStore.wasOverridden(outputFileNameProperty, null) + " outputFileName: " + this.outputFileName + " errorStreamName: " + outputFileNameProperty_outputStreamFileName));
                    }
                    this.setStreamHandlerAsHandler();
                } else if (WASSupport.getWASSupport().isWASv6Present() && !PropertyStore.wasOverridden(outputFileNameProperty, null)) {
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger.initialize", (Object)("Writing to System.err - Prop overridden: " + PropertyStore.wasOverridden(outputFileNameProperty, null) + " outputFileName: " + this.outputFileName + " errorStreamName: " + outputFileNameProperty_errorStreamFileName));
                    }
                    this.setConsoleHandlerAsHandler();
                } else {
                    File traceFile;
                    Object traceFileName;
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger.initialize", (Object)("NOT writing to System.err - Prop overridden: " + PropertyStore.wasOverridden(outputFileNameProperty, null) + " outputFileName: " + this.outputFileName + " errorStreamName: " + outputFileNameProperty_errorStreamFileName));
                    }
                    if ((traceFileName = AccessController.doPrivileged(new PrivilegedAction(traceFile = new File(this.outputFileName)){
                        private final /* synthetic */ File val$traceFile;
                        {
                            this.val$traceFile = val$traceFile;
                        }

                        public Object run() {
                            if (this.val$traceFile.isDirectory()) {
                                try {
                                    return this.val$traceFile.getCanonicalPath() + File.separator + DefaultLogger.outputFileNameProperty_default;
                                }
                                catch (IOException ioe) {
                                    return ioe;
                                }
                            }
                            return DefaultLogger.this.outputFileName;
                        }
                    })) instanceof IOException) {
                        throw (IOException)traceFileName;
                    }
                    this.setFileHandlerAsHandler((String)traceFileName);
                }
            }
            catch (IOException ioe) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "initialize()", ioe);
                }
                System.err.println("Could not initialize log file, " + ioe);
                this.handler = new ConsoleHandler();
            }
            catch (AccessControlException ace) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "initialize()", ace);
                }
                System.err.println("Insufficient permissions for log file, " + ace);
                this.setConsoleHandlerAsHandler();
            }
        }
        if (null == this.formatter) {
            this.formatter = new DefaultFormatter();
        }
        if (null != this.handler) {
            this.handler.setFormatter(this.formatter);
        }
        this.setLogHandler(this.handler);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "initialize()");
        }
    }

    private void setFileHandlerAsHandler(String traceFileName) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setFileHandlerAsHandler(String)", new Object[]{traceFileName});
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger.initialize()", (Object)("Creating a file handler for the log - " + traceFileName));
        }
        this.handler = new FileHandler(traceFileName, this.logFileLimit, this.logFileCount, true);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setFileHandlerAsHandler(String)");
        }
    }

    private void setConsoleHandlerAsHandler() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setConsoleHandlerAsHandler()");
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger.initialize()", (Object)"Creating a console handler for the log");
        }
        this.handler = new ConsoleHandler();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setConsoleHandlerAsHandler()");
        }
    }

    private void setStreamHandlerAsHandler() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setStreamHandlerAsHandler()");
        }
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger.initialize()", (Object)"Creating a stream handler for the log");
        }
        this.handler = new LoggerStreamHandler(System.out);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setStreamHandlerAsHandler()");
        }
    }

    public void log(Object parentClass, String parentClassName, String methodSignature, String key, HashMap inserts) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "log(Object,String,String,String,HashMap)", new Object[]{parentClass, parentClassName, methodSignature, key, inserts});
        }
        this.logger.logp(Level.INFO, this.objectToString(parentClass, parentClassName), methodSignature, key, inserts);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "log(Object,String,String,String,HashMap)");
        }
    }

    public void logNLS(Object parentClass, String parentClassName, String methodSignature, String NLSMessage) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "logNLS(Object,String,String,String)", new Object[]{parentClass, parentClassName, methodSignature, NLSMessage});
        }
        this.logger.logp(Level.INFO, this.objectToString(parentClass, parentClassName), methodSignature, LOG_MSG_NLS, NLSMessage);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "logNLS(Object,String,String,String)");
        }
    }

    private String objectToString(Object obj, String parentClassName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "objectToString(Object,String)", new Object[]{obj, parentClassName});
        }
        if (obj == null) {
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "objectToString(Object,String)", parentClassName, 1);
            }
            return parentClassName;
        }
        String objectClassName = obj.getClass().getName();
        StringBuffer result = new StringBuffer(objectClassName);
        if (null != parentClassName && !result.toString().equals(parentClassName) && objectClassName.indexOf(36) == -1) {
            int pIndex = parentClassName.lastIndexOf(".");
            result.append("(");
            result.append(parentClassName.substring(pIndex + 1));
            result.append(")");
        }
        String traceRet1 = result.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "objectToString(Object,String)", traceRet1, 2);
        }
        return traceRet1;
    }

    public void setLogFormatter(Formatter newFormatter) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setLogFormatter(Formatter)", new Object[]{newFormatter});
        }
        this.formatter = newFormatter;
        this.LogFormatter = null;
        if (this.handler != null) {
            this.handler.setFormatter(this.formatter);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setLogFormatter(Formatter)");
        }
    }

    public void setLogFormatter(LogFormatter newFormatter) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setLogFormatter(LogFormatter)", new Object[]{newFormatter});
        }
        Formatter tempFormatter = null;
        tempFormatter = newFormatter instanceof Formatter ? (Formatter)((Object)newFormatter) : new LogFormatterWrapper(newFormatter);
        this.LogFormatter = newFormatter;
        this.formatter = tempFormatter;
        if (this.handler != null) {
            this.handler.setFormatter(this.formatter);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setLogFormatter(LogFormatter)");
        }
    }

    public void setLogHandler(final Handler newHandler) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setLogHandler(final Handler)", new Object[]{newHandler});
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "run()");
                }
                if (DefaultLogger.this.handler != newHandler) {
                    DefaultLogger.this.logger.addHandler(newHandler);
                    DefaultLogger.this.logger.removeHandler(DefaultLogger.this.handler);
                    DefaultLogger.this.handler = newHandler;
                    DefaultLogger.this.LogHandler = null;
                } else {
                    DefaultLogger.this.logger.addHandler(newHandler);
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.log.null", "run()", null);
                }
                return null;
            }
        });
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setLogHandler(final Handler)");
        }
    }

    public void setLogHandler(LogHandler newHandler) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setLogHandler(LogHandler)", new Object[]{newHandler});
        }
        Handler tempHandler = null;
        tempHandler = newHandler instanceof Handler ? (Handler)((Object)newHandler) : new LogHandlerWrapper(newHandler);
        this.logger.addHandler(tempHandler);
        if (this.handler != null) {
            this.logger.removeHandler(this.handler);
        }
        this.LogHandler = newHandler;
        this.handler = tempHandler;
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "setLogHandler(LogHandler)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.j2se.log.DefaultLogger", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/log/DefaultLogger.java, jmscc.commonservices.j2se, k701, k701-112-140304  1.17.1.8 12/02/02 10:35:50");
        }
        maxLogBytes = -1;
    }

    private class LoggerStreamHandler
    extends StreamHandler {
        public LoggerStreamHandler(OutputStream out) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.LoggerStreamHandler", "<init>(OutputStream)", new Object[]{out});
            }
            this.setOutputStream(out);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.LoggerStreamHandler", "<init>()");
            }
        }

        public void close() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.LoggerStreamHandler", "close()");
            }
            this.flush();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.LoggerStreamHandler", "close()");
            }
        }

        public void publish(LogRecord record) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.LoggerStreamHandler", "publish(LogRecord)", new Object[]{record});
            }
            super.publish(record);
            this.flush();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.LoggerStreamHandler", "publish(LogRecord)");
            }
        }
    }
}

