/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.log;

import com.ibm.msg.client.commonservices.j2se.log.DefaultLogger;
import com.ibm.msg.client.commonservices.nls.NLSServices;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.TableBuilder;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class DefaultFormatter
extends Formatter {
    private static String lineSeparator;
    private static final String LINE;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/log/DefaultFormatter.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.18.1.1 09/08/17 07:36:36";
    private HashMap msgFormatAdapters;
    int maxTraceBytes = -1;
    static /* synthetic */ Class class$com$ibm$msg$client$commonservices$j2se$log$DefaultFormatter;

    public DefaultFormatter() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter", "<init>()");
        }
        this.msgFormatAdapters = new HashMap();
        this.msgFormatAdapters.put("LOG_MSG", new LogMsgFormatter());
        this.msgFormatAdapters.put("LOG_MSG_NLS", new LogMsgNLSFormatter());
        try {
            this.maxTraceBytes = DefaultLogger.getMaxLogBytes();
        }
        catch (ClassCastException cce) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter", "<init>()", cce);
            }
            this.maxTraceBytes = -1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter", "<init>()");
        }
    }

    public String format(LogRecord record) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter", "format(LogRecord)", new Object[]{record});
        }
        StringBuffer output = new StringBuffer(256);
        MsgFormatter formatter = (MsgFormatter)this.msgFormatAdapters.get(record.getMessage());
        if (formatter == null) {
            formatter = (MsgFormatter)this.msgFormatAdapters.get("LOG_MSG");
        }
        try {
            formatter.formatMessage(record, output);
        }
        catch (Throwable t) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter", "format(LogRecord)", t);
            }
            Object[] parameters = record.getParameters();
            HashMap parameter = null;
            if (parameters != null) {
                parameter = (HashMap)parameters[0];
            }
            TableBuilder table = new TableBuilder();
            table.populate(parameter);
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("reason", "Invalid messageID passed to log");
            info.put("messageID", record.getMessage());
            info.put("data", table.toString());
            Trace.ffst(this, "format", "XS003001", info, null);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter", "format(LogRecord)", "", 1);
            }
            return "";
        }
        String traceRet1 = output.toString();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter", "format(LogRecord)", traceRet1, 2);
        }
        return traceRet1;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/log/DefaultFormatter.java, jmscc.commonservices.j2se, k701, k701-112-140304  1.18.1.1 09/08/17 07:36:36");
        }
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter", "static()");
        }
        String lineSeparatorProperty = "line.separator";
        PropertyStore.register(lineSeparatorProperty, "\n");
        lineSeparator = PropertyStore.getStringProperty(lineSeparatorProperty);
        LINE = "--------------------------------------------------------------------" + lineSeparator;
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter", "static()");
        }
    }

    abstract class MsgFormatter {
        private Calendar calendar;
        private Date date;

        MsgFormatter() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.MsgFormatter", "<init>()");
            }
            this.date = new Date();
            this.calendar = new GregorianCalendar();
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.MsgFormatter", "<init>()");
            }
        }

        void appendBaseMessage(LogRecord record, StringBuffer output) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.MsgFormatter", "appendBaseMessage(LogRecord,StringBuffer)", new Object[]{record, output});
            }
            this.appendTimestamp(output, record.getMillis());
            output.append('[' + Thread.currentThread().getName() + "] ");
            output.append(record.getSourceClassName());
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.MsgFormatter", "appendBaseMessage(LogRecord,StringBuffer)");
            }
        }

        StringBuffer appendTimestamp(StringBuffer buffer, long millis) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.MsgFormatter", "appendTimestamp(StringBuffer,long)", new Object[]{buffer, new Long(millis)});
            }
            this.date.setTime(millis);
            this.calendar.setTime(this.date);
            int day = this.calendar.get(5);
            int month = this.calendar.get(2) + 1;
            int year = this.calendar.get(1);
            int h = this.calendar.get(11);
            int m = this.calendar.get(12);
            int s = this.calendar.get(13);
            if (day < 10) {
                buffer.append("0" + day + "/");
            } else {
                buffer.append(day + "/");
            }
            if (month < 10) {
                buffer.append("0" + month + "/");
            } else {
                buffer.append(month + "/");
            }
            buffer.append(year + " ");
            if (h < 10) {
                buffer.append("0" + h + ":");
            } else {
                buffer.append(h + ":");
            }
            if (m < 10) {
                buffer.append("0" + m + ":");
            } else {
                buffer.append(m + ":");
            }
            if (s < 10) {
                buffer.append("0" + s + ":");
            } else {
                buffer.append(s + " ");
            }
            if (Trace.isOn) {
                Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.log.MsgFormatter", "appendTimestamp(StringBuffer,long)", buffer);
            }
            return buffer;
        }

        abstract void formatMessage(LogRecord var1, StringBuffer var2);
    }

    class LogMsgNLSFormatter
    extends MsgFormatter {
        static final /* synthetic */ boolean $assertionsDisabled;

        LogMsgNLSFormatter() {
        }

        void formatMessage(LogRecord record, StringBuffer buffer) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.LogMsgNLSFormatter", "formatMessage(LogRecord,StringBuffer)", new Object[]{record, buffer});
            }
            Object[] parameters = record.getParameters();
            String parameter = null;
            if (parameters != null) {
                if (!$assertionsDisabled && !(parameters[0] instanceof String)) {
                    throw new AssertionError(parameters[0]);
                }
                parameter = (String)parameters[0];
                this.appendBaseMessage(record, buffer);
                buffer.append(lineSeparator);
                buffer.append(parameter);
                buffer.append(lineSeparator);
                buffer.append(LINE);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.LogMsgNLSFormatter", "formatMessage(LogRecord,StringBuffer)");
            }
        }

        static {
            $assertionsDisabled = !(class$com$ibm$msg$client$commonservices$j2se$log$DefaultFormatter == null ? (class$com$ibm$msg$client$commonservices$j2se$log$DefaultFormatter = DefaultFormatter.class$("com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter")) : class$com$ibm$msg$client$commonservices$j2se$log$DefaultFormatter).desiredAssertionStatus();
        }
    }

    class LogMsgFormatter
    extends MsgFormatter {
        static final /* synthetic */ boolean $assertionsDisabled;

        LogMsgFormatter() {
        }

        void formatMessage(LogRecord record, StringBuffer buffer) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.log.LogMsgFormatter", "formatMessage(LogRecord,StringBuffer)", new Object[]{record, buffer});
            }
            String messageID = record.getMessage();
            Object[] parameters = record.getParameters();
            HashMap parameter = null;
            if (parameters != null) {
                if (!$assertionsDisabled && !(parameters[0] instanceof HashMap)) {
                    throw new AssertionError(parameters[0]);
                }
                parameter = (HashMap)parameters[0];
            }
            String message = NLSServices.getMessage(messageID, parameter);
            String explanation = NLSServices.getExplanation(messageID, parameter);
            String action = NLSServices.getUserAction(messageID, parameter);
            this.appendBaseMessage(record, buffer);
            buffer.append(lineSeparator);
            buffer.append(message);
            buffer.append(lineSeparator + lineSeparator);
            buffer.append(NLSServices.getMessage("JMSCS0007"));
            buffer.append(lineSeparator);
            buffer.append(explanation);
            buffer.append(lineSeparator + lineSeparator);
            buffer.append(NLSServices.getMessage("JMSCS0008"));
            buffer.append(lineSeparator);
            buffer.append(action);
            buffer.append(lineSeparator);
            buffer.append(LINE);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.log.LogMsgFormatter", "formatMessage(LogRecord,StringBuffer)");
            }
        }

        static {
            $assertionsDisabled = !(class$com$ibm$msg$client$commonservices$j2se$log$DefaultFormatter == null ? (class$com$ibm$msg$client$commonservices$j2se$log$DefaultFormatter = DefaultFormatter.class$("com.ibm.msg.client.commonservices.j2se.log.DefaultFormatter")) : class$com$ibm$msg$client$commonservices$j2se$log$DefaultFormatter).desiredAssertionStatus();
        }
    }
}

