/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.commandmanager;

import com.ibm.msg.client.commonservices.commandmanager.Command;
import com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork;
import com.ibm.msg.client.commonservices.trace.Trace;

public class RemoteTrace
extends AbstractNetwork {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/commandmanager/RemoteTrace.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.14.2.1 09/08/17 08:36:09";

    public static void main(String[] args) {
        if (Trace.isOn) {
            Trace.entry("c.i.m.c.c.j2se.commandmanager.RemoteTrace", "main(String [ ])", new Object[]{args});
        }
        try {
            if (args[0] == null || args[1] == null || args[2] == null) {
                if (!args[2].equalsIgnoreCase("on") && !args[2].equalsIgnoreCase("off")) {
                    System.out.println("Usage: RemoteTrace [ipAddress] [port] [on|off]");
                }
            } else {
                String ipAddress = args[0];
                int port = Integer.parseInt(args[1]);
                String traceState = args[2];
                System.out.println("Client started");
                System.out.println("Sending command to turn trace " + traceState);
                Command command = Command.createCommand("trc");
                command.parameters.put("trc_st", traceState);
                RemoteTrace client = new RemoteTrace();
                client.initialize(1, port, ipAddress);
                System.out.println("Command created");
                client.sendCommand(command);
                System.out.println("Recieve response");
                Command result = client.receiveResponse();
                if (result.getState() == 4) {
                    System.err.println("Command failed: " + result);
                } else if (result.getState() == 3) {
                    String returnState = (String)result.results.get("trc_rslt");
                    if (returnState.equalsIgnoreCase(traceState)) {
                        System.out.println("Trace was set to " + returnState);
                    } else {
                        System.err.println("Trace was set to " + returnState + " instead of " + traceState);
                    }
                } else {
                    System.err.println("Invalid state of command returned");
                }
                client.terminate();
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock("c.i.m.c.c.j2se.commandmanager.RemoteTrace", "main(String [ ])", e);
            }
            System.out.println("RemoteTrace failed: " + e.getMessage());
        }
        if (Trace.isOn) {
            Trace.exit("c.i.m.c.c.j2se.commandmanager.RemoteTrace", "main(String [ ])");
        }
    }

    public void sendCommand(Command command) {
        if (Trace.isOn) {
            Trace.entry(this, "c.i.m.c.c.j2se.commandmanager.RemoteTrace", "sendCommand(Command)", new Object[]{command});
        }
        byte[] bytes = command.flatten();
        this.sendBytes(bytes);
        if (Trace.isOn) {
            Trace.exit(this, "c.i.m.c.c.j2se.commandmanager.RemoteTrace", "sendCommand(Command)");
        }
    }

    public Command receiveResponse() throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "c.i.m.c.c.j2se.commandmanager.RemoteTrace", "receiveResponse()");
        }
        byte[] bytes = this.receiveBytes();
        Command command = new Command();
        command.unFlatten(bytes);
        if (Trace.isOn) {
            Trace.exit((Object)this, "c.i.m.c.c.j2se.commandmanager.RemoteTrace", "receiveResponse()", command);
        }
        return command;
    }

    static {
        if (Trace.isOn) {
            Trace.data("c.i.m.c.c.j2se.commandmanager.RemoteTrace", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/commandmanager/RemoteTrace.java, jmscc.commonservices.j2se, k701, k701-112-140304  1.14.2.1 09/08/17 08:36:09");
        }
    }
}

