/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.commandmanager;

import com.ibm.msg.client.commonservices.commandmanager.Command;
import com.ibm.msg.client.commonservices.commandmanager.CommandManager;
import com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.provider.commandmanager.CommandInitiator;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueManager;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueToken;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Iterator;

public class NetworkCommandServer
extends AbstractNetwork
implements CommandInitiator,
Runnable {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/commandmanager/NetworkCommandServer.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.18.1.1 09/08/17 08:35:58";
    public static final String CMD_PORT = "jmscc.networkcommandserver.port";
    public static final long CMD_PORT_DEFAULT = 2014L;
    public static final Long CMD_PORT_MIN;
    public static final Long CMD_PORT_MAX;
    private boolean running = true;
    private ArrayList mySessions = new ArrayList();
    private int port;

    public void start() throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "start()");
        }
        this.running = true;
        this.port = (int)PropertyStore.getLongProperty(CMD_PORT);
        this.serverSocket = new ServerSocket(this.port);
        while (this.running) {
            NetworkCommandServer clientServer = new NetworkCommandServer();
            clientServer.serverSocket = this.serverSocket;
            clientServer.initialize(0, this.port, null);
            WorkQueueToken queueToken = WorkQueueManager.enqueue(clientServer, 0, true);
            this.mySessions.add(queueToken);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "start()");
        }
    }

    public void run() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "run()");
        }
        try {
            byte[] bytes = this.receiveBytes();
            Command command = null;
            if (bytes != null) {
                command = new Command();
                command.unFlatten(bytes);
            }
            if (command != null) {
                CommandManager.runCommand(this, command);
            } else {
                this.running = false;
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "run()", e);
            }
            RuntimeException traceRet1 = new RuntimeException(e.getMessage());
            if (Trace.isOn) {
                Trace.throwing(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "run()", traceRet1);
            }
            throw traceRet1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "run()");
        }
    }

    public void stop() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "stop()");
        }
        this.running = false;
        Iterator it = this.mySessions.iterator();
        while (it.hasNext()) {
            WorkQueueToken temp = (WorkQueueToken)it.next();
            temp.end();
        }
        this.terminate();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "stop()");
        }
    }

    public void commandCompleted(Command command) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "commandCompleted(Command)", new Object[]{command});
        }
        this.sendBytes(command.flatten());
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "commandCompleted(Command)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/commandmanager/NetworkCommandServer.java, jmscc.commonservices.j2se, k701, k701-112-140304  1.18.1.1 09/08/17 08:35:58");
        }
        CMD_PORT_MIN = new Long(1L);
        CMD_PORT_MAX = new Long(Integer.MAX_VALUE);
        if (Trace.isOn) {
            Trace.entry("com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "static()");
        }
        PropertyStore.register(CMD_PORT, 2014L, CMD_PORT_MIN, CMD_PORT_MAX);
        if (Trace.isOn) {
            Trace.exit("com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer", "static()");
        }
    }
}

