/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.commandmanager;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.commandmanager.Command;
import com.ibm.msg.client.commonservices.j2se.commandmanager.NetworkCommandServer;
import com.ibm.msg.client.commonservices.provider.commandmanager.CSPCommandManager;
import com.ibm.msg.client.commonservices.provider.commandmanager.CommandHandler;
import com.ibm.msg.client.commonservices.provider.commandmanager.CommandInitiator;
import com.ibm.msg.client.commonservices.trace.Trace;
import com.ibm.msg.client.commonservices.workqueue.WorkQueueManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class CommandManagerImpl
implements CSPCommandManager {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/commandmanager/CommandManagerImpl.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.20.1.1 09/08/17 08:35:29";
    private boolean running = false;
    private HashMap handlers = new HashMap();
    private CommandInitiator server;

    public void addCommandHandler(CommandHandler handler, String commandType) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "addCommandHandler(CommandHandler,String)", new Object[]{handler, commandType});
        }
        this.handlers.put(commandType, handler);
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "addCommandHandler(CommandHandler,String)");
        }
    }

    public void removeCommandHandler(CommandHandler handler) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "removeCommandHandler(CommandHandler)", new Object[]{handler});
        }
        Collection values = this.handlers.values();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            if (!handler.equals(it.next())) continue;
            it.remove();
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "removeCommandHandler(CommandHandler)");
        }
    }

    public void start() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "start()");
        }
        RunServer serverThread = new RunServer();
        try {
            WorkQueueManager.enqueue(serverThread);
        }
        catch (CSIException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "start()", e);
            }
            HashMap<String, CSIException> ffstData = new HashMap<String, CSIException>();
            ffstData.put("Exception", e);
            Trace.ffst(this, "start()", "XS004001", ffstData, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "start()");
        }
    }

    public void stop() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "stop()");
        }
        this.server.stop();
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "stop()");
        }
    }

    public Command runCommand(Command command) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "runCommand(Command)", new Object[]{command});
        }
        Set keys = this.handlers.keySet();
        Iterator it = keys.iterator();
        try {
            command.setState(2);
            String commandType = (String)command.parameters.get(Command.COMMAND);
            while (it.hasNext()) {
                Object key = it.next();
                if (key != null && !key.equals(commandType)) continue;
                CommandHandler handler = (CommandHandler)this.handlers.get(key);
                command = handler.handleCommand(command);
            }
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "runCommand(Command)", e);
            }
            command.setFailed(e);
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "runCommand(Command)", command);
        }
        return command;
    }

    public void runCommand(CommandInitiator initiator, Command command) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "runCommand(CommandInitiator,Command)", new Object[]{initiator, command});
        }
        AsyncCommand runCommand = new AsyncCommand(initiator, command);
        try {
            WorkQueueManager.enqueue(runCommand);
        }
        catch (CSIException e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "runCommand(CommandInitiator,Command)", e);
            }
            HashMap<String, CSIException> ffstData = new HashMap<String, CSIException>();
            ffstData.put("Exception", e);
            Trace.ffst(this, "runCommand(CommandInitiator, Command)", "XS004002", ffstData, null);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "runCommand(CommandInitiator,Command)");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.j2se.commandmanager.CommandManagerImpl", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/commandmanager/CommandManagerImpl.java, jmscc.commonservices.j2se, k701, k701-112-140304  1.20.1.1 09/08/17 08:35:29");
        }
    }

    public class RunServer
    implements Runnable {
        public void run() {
            block5: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.RunServer", "run()");
                }
                try {
                    CommandManagerImpl.this.server = new NetworkCommandServer();
                    CommandManagerImpl.this.server.start();
                }
                catch (Exception e) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.RunServer", "run()", e);
                    }
                    if (!Trace.isOn) break block5;
                    Trace.data(this, "Un-Expected Exception", (Object)e);
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.RunServer", "run()");
            }
        }
    }

    public class AsyncCommand
    implements Runnable {
        private Command command;
        private CommandInitiator initiator;

        public AsyncCommand(CommandInitiator initiator, Command command) {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AsyncCommand", "<init>(CommandInitiator,Command)", new Object[]{initiator, command});
            }
            this.command = command;
            this.initiator = initiator;
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AsyncCommand", "<init>(CommandInitiator,Command)");
            }
        }

        public void run() {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AsyncCommand", "run()");
            }
            Set keys = CommandManagerImpl.this.handlers.keySet();
            Iterator it = keys.iterator();
            try {
                this.command.setState(2);
                String commandType = (String)this.command.parameters.get(Command.COMMAND);
                while (it.hasNext()) {
                    Object key = it.next();
                    if (key != null && !key.equals(commandType)) continue;
                    CommandHandler handler = (CommandHandler)CommandManagerImpl.this.handlers.get(key);
                    this.command = handler.handleCommand(this.command);
                }
            }
            catch (Exception e) {
                if (Trace.isOn) {
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AsyncCommand", "run()", e);
                }
                this.command.setFailed(e);
            }
            this.initiator.commandCompleted(this.command);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AsyncCommand", "run()");
            }
        }
    }
}

