/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se.commandmanager;

import com.ibm.msg.client.commonservices.trace.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class AbstractNetwork {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/commandmanager/AbstractNetwork.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.15.1.1 09/08/17 08:35:17";
    public static final byte VERSION = 0;
    public static final byte NEGOTIATION_PASS = 1;
    public static final byte NEGOTIATION_FAIL = 2;
    public static final int SERVER_CONNECTION = 0;
    public static final int CLIENT_CONNECTION = 1;
    public static final String version = "7.0.0.0";
    protected Socket socket = null;
    protected ServerSocket serverSocket = null;
    protected DataOutputStream dOut;
    protected DataInputStream dIn;
    protected OutputStream out;
    protected InputStream in;

    public void initialize(int connectionType, int port, String ipAddress) throws Exception {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "initialize(int,int,String)", new Object[]{new Integer(connectionType), new Integer(port), ipAddress});
        }
        if (connectionType == 0) {
            this.socket = this.serverSocket.accept();
            this.dOut = new DataOutputStream(this.socket.getOutputStream());
            this.dIn = new DataInputStream(this.socket.getInputStream());
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
            byte versionTag = (byte)this.in.read();
            if (versionTag == 0) {
                int length = this.dIn.readInt();
                byte[] versionBytes = new byte[length];
                this.in.read(versionBytes);
                String version = new String(versionBytes);
                if (version.equals(version)) {
                    this.out.write(1);
                } else {
                    this.out.write(2);
                }
            } else {
                this.out.write(2);
            }
            this.out.flush();
        } else if (connectionType == 1) {
            this.socket = new Socket(ipAddress, port);
            this.dOut = new DataOutputStream(this.socket.getOutputStream());
            this.dIn = new DataInputStream(this.socket.getInputStream());
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
            this.out.write(0);
            byte[] bytes = version.getBytes();
            this.dOut.writeInt(bytes.length);
            this.out.write(bytes);
            this.dOut.flush();
            byte byteIn = (byte)this.in.read();
            if (byteIn != 1) {
                Exception traceRet1 = new Exception("Initialization failed");
                if (Trace.isOn) {
                    Trace.throwing(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "initialize(int,int,String)", traceRet1);
                }
                throw traceRet1;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "initialize(int,int,String)");
        }
    }

    public void terminate() {
        block7: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "terminate()");
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                } else if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception e) {
                if (!Trace.isOn) break block7;
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "terminate()", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "terminate()");
        }
    }

    protected void sendBytes(byte[] bytes) {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "sendBytes(byte [ ])", new Object[]{bytes});
            }
            try {
                this.dOut.writeInt(bytes.length);
                this.out.write(bytes);
                this.dOut.flush();
            }
            catch (Exception e) {
                if (!Trace.isOn) break block4;
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "sendBytes(byte [ ])", e);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "sendBytes(byte [ ])");
        }
    }

    protected byte[] receiveBytes() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "receiveBytes()");
        }
        try {
            int length = this.dIn.readInt();
            byte[] bytes = new byte[length];
            this.in.read(bytes);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "receiveBytes()", bytes, 1);
            }
            return bytes;
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "receiveBytes()", e);
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "receiveBytes()", null, 2);
            }
            return null;
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.j2se.commandmanager.AbstractNetwork", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/commandmanager/AbstractNetwork.java, jmscc.commonservices.j2se, k701, k701-112-140304  1.15.1.1 09/08/17 08:35:17");
        }
    }
}

