/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.j2se;

import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.provider.nls.CSPNLSServices;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NLSServices
implements CSPNLSServices {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/NLSServices.java, jmscc.commonservices.j2se, k701, k701-112-140304 1.50.1.1 09/08/17 08:27:12";
    private HashMap bundles = new HashMap();
    private HashMap englishBundles = new HashMap();
    private boolean initialised = false;
    private Object initLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCatalogue(final String name, String namespace, final Class loadingClass) {
        ResourceBundle english;
        ResourceBundle rb = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceBundle traceRet1 = NLSServices.this.addCatalogue(name, loadingClass, Locale.getDefault());
                return traceRet1;
            }
        });
        if (null != rb) {
            HashMap hashMap = this.bundles;
            synchronized (hashMap) {
                this.bundles.put(namespace, rb);
            }
        }
        if (null != (english = (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ResourceBundle traceRet1 = NLSServices.this.addCatalogue(name, loadingClass, Locale.US);
                return traceRet1;
            }
        }))) {
            HashMap hashMap = this.englishBundles;
            synchronized (hashMap) {
                this.englishBundles.put(namespace, english);
            }
        }
    }

    private ResourceBundle addCatalogue(String name, Class loadingClass, Locale locale) {
        ClassLoader threadClassloader = Thread.currentThread().getContextClassLoader();
        ClassLoader classClassloader = loadingClass.getClassLoader();
        ResourceBundle rb = null;
        MissingResourceException mreStep1 = null;
        MissingResourceException mreStep2 = null;
        if (threadClassloader != null) {
            try {
                rb = ResourceBundle.getBundle(name, locale, threadClassloader);
            }
            catch (MissingResourceException mre) {
                mreStep1 = mre;
            }
        }
        if (rb == null && classClassloader != null) {
            try {
                rb = ResourceBundle.getBundle(name, locale, classClassloader);
            }
            catch (MissingResourceException mre2) {
                mreStep2 = mre2;
            }
        }
        if (rb == null) {
            try {
                rb = ResourceBundle.getBundle(name);
            }
            catch (MissingResourceException mre3) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("Exception", mre3);
                info.put("Exception Step 1", mreStep1);
                info.put("Exception Step 2", mreStep2);
                info.put("ThreadContext Classloader", threadClassloader);
                info.put("Class Classloader", classClassloader);
                Trace.ffst(this, "addCatalogue(String,String)", "XS001001", info, null);
            }
        }
        return rb;
    }

    public String getMessage(String key, Object[] inserts) {
        String msg = this.getOptionalMessage(key);
        if (null == msg) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("key", key);
            if (null != inserts) {
                for (int i = 0; i < inserts.length; ++i) {
                    info.put("insert" + i, inserts[i]);
                }
            }
            Trace.ffst(this, "getMessage(String,Object[])", "XS001002", info, null);
        }
        msg = this.embedInserts(msg, inserts);
        return msg;
    }

    public String getMessage(String key, HashMap inserts) {
        Object[] insertArray = this.insertMapToArray(key, inserts);
        String msg = this.getMessage(key, insertArray);
        return msg;
    }

    public String getExplanation(String key, HashMap inserts) {
        String explanation = this.getOptionalMessage(key + ".explanation");
        if (null != explanation) {
            Object[] insertArray = this.insertMapToArray(key, inserts);
            explanation = this.embedInserts(explanation, insertArray);
        }
        return explanation;
    }

    public String getUserAction(String key, HashMap inserts) {
        String useraction = this.getOptionalMessage(key + ".useraction");
        if (null != useraction) {
            Object[] insertArray = this.insertMapToArray(key, inserts);
            useraction = this.embedInserts(useraction, insertArray);
        }
        return useraction;
    }

    public Exception createException(String messageid, HashMap inserts) {
        HashMap<String, Object> info;
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.j2se.NLSServices", "createException(String,HashMap)", new Object[]{messageid, inserts});
        }
        StringBuffer buff = new StringBuffer(messageid);
        buff.append(": ");
        buff.append(this.getMessage(messageid, inserts));
        String msg = buff.toString();
        String explanation = this.getExplanation(messageid, inserts);
        String useraction = this.getUserAction(messageid, inserts);
        String exception = null;
        String excMsg = this.getOptionalMessage(messageid + ".exception");
        exception = null == excMsg ? "com.ibm.msg.client.jms.DetailedJMSException" : excMsg;
        Exception ex = null;
        Class clazz = null;
        try {
            clazz = CSSystem.dynamicLoadClass(exception, this.getClass());
        }
        catch (ClassNotFoundException e1) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.NLSServices", "createException(String,HashMap)", e1, 1);
            }
            info = new HashMap<String, Object>();
            info.put("exception name", exception);
            info.put("exception caught", e1);
            Trace.ffst(this, "createException(String,HashMap)", "XS001003", info, null);
            clazz = Exception.class;
        }
        try {
            Constructor constructor = null;
            Object[] parameters = null;
            if (exception.startsWith("com.ibm.")) {
                Class[] signature = new Class[]{String.class, String.class, String.class, String.class, Map.class};
                constructor = clazz.getConstructor(signature);
                parameters = new Object[]{msg, messageid, explanation, useraction, inserts};
            } else {
                Class[] signature = new Class[]{String.class};
                constructor = clazz.getConstructor(signature);
                parameters = new Object[]{msg};
            }
            ex = (Exception)constructor.newInstance(parameters);
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.NLSServices", "createException(String,HashMap)", e, 2);
            }
            info = new HashMap();
            info.put("message id", messageid);
            info.put("exception", e);
            info.put("exception name", exception);
            if (null != inserts) {
                info.putAll(inserts);
            }
            Trace.ffst(this, "createException(String,HashMap)", "XS001004", info, null);
        }
        if (ex == null) {
            ex = new Exception("Unable to create exception - check FFDC output for information");
        }
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.j2se.NLSServices", "createException(String,HashMap)", ex);
        }
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise() {
        if (!this.initialised) {
            Object object = this.initLock;
            synchronized (object) {
                if (!this.initialised) {
                    this.addCatalogue("com.ibm.msg.client.commonservices.resources.JMSCS_MessageResourceBundle", "JMSCS", this.getClass());
                    this.initialised = true;
                }
            }
        }
    }

    private String getOptionalMessage(String key) {
        this.initialise();
        String msg = this.getOptionalMessage(key, this.bundles);
        if (msg != null) {
            return msg;
        }
        String traceRet1 = this.getOptionalMessage(key, this.englishBundles);
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOptionalMessage(String key, HashMap searchBundles) {
        String msg = null;
        HashMap hashMap = searchBundles;
        synchronized (hashMap) {
            block8: {
                String namespace = null;
                Iterator it = searchBundles.keySet().iterator();
                while (it.hasNext() && !key.startsWith(namespace = (String)it.next())) {
                }
                if (null == namespace) {
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("Namespace", namespace);
                    Trace.ffst(this, "getOptionalMessage(String)", "XS001005", info, null);
                }
                ResourceBundle bundle = (ResourceBundle)searchBundles.get(namespace);
                try {
                    Enumeration<String> keys = bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        if (!key.equals(keys.nextElement())) continue;
                        msg = bundle.getString(key);
                        break;
                    }
                }
                catch (Exception e) {
                    if (!Trace.isOn) break block8;
                    Trace.catchBlock(this, "com.ibm.msg.client.commonservices.j2se.NLSServices", "getOptionalMessage(String,HashMap)", e);
                }
            }
        }
        return msg;
    }

    private String embedInserts(String message, Object[] inserts) {
        if (null == inserts) {
            return message;
        }
        MessageFormat msgFormatter = new MessageFormat(message);
        StringBuffer msgbuff = new StringBuffer();
        msgbuff = msgFormatter.format(inserts, msgbuff, (FieldPosition)null);
        String result = msgbuff.toString();
        return result;
    }

    private Object[] insertMapToArray(String messageid, HashMap inserts) {
        if (inserts != null && inserts.size() == 0) {
            inserts = null;
        }
        String insertConstants = this.getOptionalMessage(messageid + ".inserts");
        if (null == inserts && null != insertConstants || null != inserts && null == insertConstants) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("message id", messageid);
            if (null != inserts) {
                info.putAll(inserts);
            }
            if (null != insertConstants) {
                info.put("insert constants", insertConstants);
            }
            Trace.ffst(this, "insertMapToArray(String,HashMap)", "XS001006", info, null);
        }
        Object[] insertArray = null;
        if (null != inserts && null != insertConstants) {
            String[] insertStrings = insertConstants.split(",");
            insertArray = new Object[insertStrings.length];
            for (int idx = 0; idx < insertStrings.length; ++idx) {
                String key = insertStrings[idx].trim();
                if (!inserts.containsKey(key)) {
                    HashMap<String, Object> info = new HashMap<String, Object>();
                    info.put("message id", messageid);
                    info.put("index", new Integer(idx));
                    if (null != inserts) {
                        info.putAll(inserts);
                    }
                    if (null != insertConstants) {
                        info.put("insert constants", insertConstants);
                    }
                    Trace.ffst(this, "insertMapToArray(String,HashMap)", "XS001007", info, null);
                }
                insertArray[idx] = inserts.get(key);
            }
            return insertArray;
        }
        return insertArray;
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.j2se.NLSServices", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices.j2se/src/com/ibm/msg/client/commonservices/j2se/NLSServices.java, jmscc.commonservices.j2se, k701, k701-112-140304  1.50.1.1 09/08/17 08:27:12");
        }
    }
}

