/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.msg.client.commonservices.cssystem;

import com.ibm.msg.client.commonservices.CSIException;
import com.ibm.msg.client.commonservices.componentmanager.Component;
import com.ibm.msg.client.commonservices.componentmanager.ComponentManager;
import com.ibm.msg.client.commonservices.cssystem.CSSystem;
import com.ibm.msg.client.commonservices.propertystore.PropertyStore;
import com.ibm.msg.client.commonservices.trace.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class WASSupport {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008, 2009 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/cssystem/WASSupport.java, jmscc.commonservices, k701, k701-112-140304 1.12.1.3 10/05/12 17:21:22";
    private Boolean usingWASCommonServices = null;
    private Boolean usingWASv6 = null;

    private WASSupport() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "<init>()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "<init>()");
        }
    }

    public static synchronized WASSupport getWASSupport() {
        WASSupport traceRet1 = new WASSupport();
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.cssystem.WASSupport", "getWASSupport()", "getter", (Object)traceRet1);
        }
        return traceRet1;
    }

    public synchronized boolean isWASCommonServicesPresent() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "isWASCommonServicesPresent()");
        }
        if (this.usingWASCommonServices == null) {
            String csName;
            block6: {
                csName = null;
                try {
                    Component csComp = ComponentManager.getInstance().getComponent("CSI", null);
                    csName = csComp.getName();
                    if (Trace.isOn) {
                        Trace.data(this, "<init>", "Located CS Component", (Object)csName);
                    }
                }
                catch (CSIException e1) {
                    if (!Trace.isOn) break block6;
                    Trace.data(this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "isWASCommonServicesPresent()", "Caught expected exception", e1);
                }
            }
            this.usingWASCommonServices = csName != null && csName.equalsIgnoreCase("com.ibm.ws.wmqcsi") ? Boolean.TRUE : Boolean.FALSE;
        }
        boolean traceRet1 = this.usingWASCommonServices;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "isWASCommonServicesPresent()", traceRet1);
        }
        return traceRet1;
    }

    public synchronized boolean isWASv6Present() {
        if (this.usingWASv6 == null) {
            this.usingWASv6 = new Boolean(this.readBooleanMQEnvironmentSetting("runningInWS"));
            if (Trace.isOn) {
                Trace.data(this, "<init>", "usingWASv6", (Object)this.usingWASv6);
            }
        }
        boolean traceRet1 = this.usingWASv6;
        if (Trace.isOn) {
            Trace.data(this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "isWASv6Present()", "getter", traceRet1);
        }
        return traceRet1;
    }

    private boolean readBooleanMQEnvironmentSetting(final String methodName) {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "readBooleanMQEnvironmentSetting(final String)", new Object[]{methodName});
        }
        Boolean isEnabled = Boolean.FALSE;
        isEnabled = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "run()");
                }
                Boolean enabled = null;
                try {
                    Class mqenv = CSSystem.dynamicLoadClass("com.ibm.mq.MQEnvironment", this.getClass());
                    if (mqenv == null) {
                        enabled = Boolean.FALSE;
                    } else {
                        Method m;
                        Class c = mqenv;
                        if (Trace.isOn) {
                            Trace.data(this, "<init>", "class", (Object)c);
                        }
                        if ((m = c.getMethod(methodName, null)) != null) {
                            Object returnVal = m.invoke(null, null);
                            if (Trace.isOn) {
                                Trace.data(this, "<init>", "Found method - it returned", returnVal);
                            }
                            enabled = returnVal instanceof Boolean ? (Boolean)returnVal : Boolean.FALSE;
                        } else if (Trace.isOn) {
                            Trace.data(this, "<init>", "failed to find method", null);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.commonservices.cssystem.null", "run()", "Caught expected exception at catch index 1", e);
                    }
                    enabled = Boolean.FALSE;
                }
                catch (Exception ex) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.commonservices.cssystem.null", "run()", ex, 2);
                    }
                    enabled = Boolean.FALSE;
                }
                catch (NoClassDefFoundError error) {
                    if (Trace.isOn) {
                        Trace.catchBlock(this, "com.ibm.msg.client.commonservices.cssystem.null", "run()", error, 3);
                    }
                    enabled = Boolean.FALSE;
                }
                if (Trace.isOn) {
                    Trace.exit((Object)this, "com.ibm.msg.client.commonservices.cssystem.null", "run()", enabled);
                }
                return enabled;
            }
        });
        boolean traceRet1 = isEnabled;
        if (Trace.isOn) {
            Trace.exit((Object)this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "readBooleanMQEnvironmentSetting(final String)", traceRet1);
        }
        return traceRet1;
    }

    public void setupWASv6Helper() {
        if (Trace.isOn) {
            Trace.entry(this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "setupWASv6Helper()");
        }
        WASv6Helper v6RuntimeHelper = null;
        try {
            v6RuntimeHelper = new WASv6Helper();
        }
        catch (Exception e) {
            if (Trace.isOn) {
                Trace.catchBlock(this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "setupWASv6Helper()", e);
            }
            e.printStackTrace();
        }
        if (v6RuntimeHelper != null) {
            PropertyStore.set("com.ibm.mq.connector.JCARuntimeHelper", v6RuntimeHelper);
        }
        if (Trace.isOn) {
            Trace.exit(this, "com.ibm.msg.client.commonservices.cssystem.WASSupport", "setupWASv6Helper()");
        }
    }

    static {
        if (Trace.isOn) {
            Trace.data("com.ibm.msg.client.commonservices.cssystem.WASSupport", "static", "SCCS id", (Object)"@(#) com.ibm.msg.client.commonservices/src/com/ibm/msg/client/commonservices/cssystem/WASSupport.java, jmscc.commonservices, k701, k701-112-140304  1.12.1.3 10/05/12 17:21:22");
        }
    }

    public static interface WASRuntimeHelper {
        public static final String WAS_RUNTIME_HELPER_KEY = "com.ibm.mq.connector.JCARuntimeHelper";
        public static final int OUTSIDE_WAS = 1;
        public static final int APPLICATION_CLIENT = 2;
        public static final int THIN_CLIENT = 4;
        public static final int ZOS_CR = 8;
        public static final int ZOS_CRA = 16;
        public static final int ZOS_SR = 32;
        public static final int DISTRIBUTED_SERVER = 64;

        public int getEnvironment();

        public long getLocalRRSTranId();
    }

    private final class WASv6Helper
    implements WASRuntimeHelper {
        Method isZOS = null;
        Method isServantJvm = null;
        Method isControlJvm = null;
        Object platformHelper = null;

        WASv6Helper() throws Exception {
            if (Trace.isOn) {
                Trace.entry(this, "com.ibm.msg.client.commonservices.cssystem.WASv6Helper", "<init>()");
            }
            Class helperFactoryClass = CSSystem.dynamicLoadClass("com.ibm.ws.util.PlatformHelperFactory", this.getClass());
            Class helperClass = CSSystem.dynamicLoadClass("com.ibm.ws.util.PlatformHelper", this.getClass());
            Method method = helperFactoryClass.getMethod("getPlatformHelper", null);
            this.platformHelper = method.invoke(null, null);
            this.isZOS = helperClass.getMethod("isZOS", null);
            this.isServantJvm = helperClass.getMethod("isServantJvm", null);
            this.isControlJvm = helperClass.getMethod("isControlJvm", null);
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.cssystem.WASv6Helper", "<init>()");
            }
        }

        public int getEnvironment() {
            block13: {
                if (Trace.isOn) {
                    Trace.entry(this, "com.ibm.msg.client.commonservices.cssystem.WASv6Helper", "getEnvironment()");
                }
                try {
                    Object zos;
                    if (this.isZOS != null && this.platformHelper != null && ((Boolean)(zos = this.isZOS.invoke(this.platformHelper, null))).booleanValue()) {
                        Object control;
                        Object servant;
                        if (this.isServantJvm != null && ((Boolean)(servant = this.isServantJvm.invoke(this.platformHelper, null))).booleanValue()) {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.commonservices.cssystem.WASv6Helper", "getEnvironment()", new Integer(32), 1);
                            }
                            return 32;
                        }
                        if (this.isControlJvm != null && ((Boolean)(control = this.isControlJvm.invoke(this.platformHelper, null))).booleanValue()) {
                            if (Trace.isOn) {
                                Trace.exit(this, "com.ibm.msg.client.commonservices.cssystem.WASv6Helper", "getEnvironment()", new Integer(8), 3);
                            }
                            return 8;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.commonservices.cssystem.WASv6Helper", "getEnvironment()", "Caught expected exception at catch index 1", e);
                    }
                }
                catch (IllegalAccessException e) {
                    if (Trace.isOn) {
                        Trace.data(this, "com.ibm.msg.client.commonservices.cssystem.WASv6Helper", "getEnvironment()", "Caught expected exception at catch index 2", e);
                    }
                }
                catch (InvocationTargetException e) {
                    if (!Trace.isOn) break block13;
                    Trace.data(this, "com.ibm.msg.client.commonservices.cssystem.WASv6Helper", "getEnvironment()", "Caught expected exception at catch index 3", e);
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "com.ibm.msg.client.commonservices.cssystem.WASv6Helper", "getEnvironment()", new Integer(1), 2);
            }
            return 1;
        }

        public long getLocalRRSTranId() {
            long traceRet1 = -1L;
            if (Trace.isOn) {
                Trace.data(this, "com.ibm.msg.client.commonservices.cssystem.WASv6Helper", "getLocalRRSTranId()", "getter", new Long(traceRet1));
            }
            return traceRet1;
        }
    }
}

